/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001B!C\u0001\u001dC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011)\u0019!C\u0001M\"AQ\u000f\u0001B\u0001B\u0003%q\r\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011%\t\u0019\u0002\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D!9\u0011q\n\u0001!B\u0013\t\u0007BCA-\u0001\t\u0007I\u0011\u0001\"\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007\u0003\u0006\u0002r\u0001\u0011\r\u0011\"\u0001C\u0003gB\u0001Ba\u0012\u0001A\u0003%\u0011Q\u000f\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011!\u0011i\u0006\u0001C\u0001\u0005\n}\u0003b\u0002B1\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005G\u0002A\u0011AAu\u0011\u001d\u0011)\u0007\u0001C!\u0005OBqAa\u001c\u0001\t\u0003\u0012\t\bC\u0004\u0003~\u0001!\tEa \t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!Q\u0012\u0001\u0005\u0002\t=\u0005\"\u0003BP\u0001E\u0005I\u0011\u0001BQ\u0011\u001d\u00119\f\u0001C\u0001\u0005sCqA!2\u0001\t\u0003\u00119\rC\u0004\u0003N\u0002!\tAa4\t\u000f\te\u0007\u0001\"\u0001\u0003\\\"9!q\u001c\u0001\u0005\u0002\t\u0005\bb\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\n\u0005s\u0004\u0011\u0013!C\u0001\u0005wDqAa@\u0001\t\u0003\u0019\t\u0001\u0003\u0005\u0004\f\u0001!\t\u0001RA \u0011!\u0019i\u0001\u0001C\u0001\u0005\n}caBAC\u0001\u0001\u0011\u0015q\u0011\u0005\u000b\u0003\u001f;#\u0011!Q\u0001\n\u0005E\u0005bBA\u0017O\u0011\u0005\u0011q\u0013\u0005\b\u00037;C\u0011KAO\u0011%\tYk\nb\u0001\n\u0003\ti\u000b\u0003\u0005\u00026\u001e\u0002\u000b\u0011BAX\u0011%\t9l\na\u0001\n\u0003\tI\fC\u0005\u0002B\u001e\u0002\r\u0011\"\u0001\u0002D\"A\u0011qY\u0014!B\u0013\tY\fC\u0005\u0002L\u001e\u0002\r\u0011\"\u0001\u0002N\"I\u0011Q[\u0014A\u0002\u0013\u0005\u0011q\u001b\u0005\t\u00037<\u0003\u0015)\u0003\u0002P\"9\u0011q\\\u0014\u0005\n\u0005\u0005\bbBAtO\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003W<C\u0011BAw\u0011\u001d\t)p\nC\u0005\u0003[DqAa\u0002(\t\u0013\u0011I\u0001C\u0004\u0003\u0016\u001d\"\tAa\u0006\b\u000f\r=!\t#\u0001\u0004\u0012\u00191\u0011I\u0011E\u0001\u0007'Aq!!\f;\t\u0003\u0019)\u0002C\u0005\u0004\u0018i\u0012\r\u0011\"\u0001\u0004\u001a!A1Q\u0004\u001e!\u0002\u0013\u0019Y\u0002C\u0004\u0004 i\"\ta!\t\t\u000f\r\u0015\"\b\"\u0001\u0004(!I1q\b\u001e\u0012\u0002\u0013\u00051\u0011\t\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(BA\"E\u0003\rawn\u001a\u0006\u0002\u000b\u0006)1.\u00194lC\u000e\u00011#\u0002\u0001I\u001dRS\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002P%6\t\u0001K\u0003\u0002R\t\u0006)Q\u000f^5mg&\u00111\u000b\u0015\u0002\b\u0019><w-\u001b8h!\t)\u0006,D\u0001W\u0015\t9F)A\u0004nKR\u0014\u0018nY:\n\u0005e3&!E&bM.\fW*\u001a;sS\u000e\u001cxI]8vaB\u00111LX\u0007\u00029*\u0011Q\fR\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}c&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003E\u000el\u0011AQ\u0005\u0003I\n\u0013Qb\u00117fC:,'oQ8oM&<\u0017a\u00027pO\u0012K'o]\u000b\u0002OB\u0019\u0001n[7\u000e\u0003%T!A\u001b&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\n\u00191+Z9\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\t\u0019KG.Z\u0001\tY><G)\u001b:tA\u0005!An\\4t+\u0005A\b#B(zw\u00065\u0011B\u0001>Q\u0005\u0011\u0001vn\u001c7\u0011\u0007q\fI!D\u0001~\u0015\tqx0\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0006\u0005!\u0002BA\u0002\u0003\u000b\ta!\u00199bG\",'BAA\u0004\u0003\ry'oZ\u0005\u0004\u0003\u0017i(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004E\u0006=\u0011bAA\t\u0005\n\u0019Aj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\tI\u0002E\u0002\\\u00037I1!!\b]\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0002;j[\u0016\u0004B!!\n\u0002*5\u0011\u0011q\u0005\u0006\u0003#vLA!a\u000b\u0002(\t!A+[7f\u0003\u0019a\u0014N\\5u}Qa\u0011\u0011GA\u001a\u0003k\t9$!\u000f\u0002<A\u0011!\r\u0001\u0005\u0006A&\u0001\r!\u0019\u0005\u0006K&\u0001\ra\u001a\u0005\u0006m&\u0001\r\u0001\u001f\u0005\b\u0003+I\u0001\u0019AA\r\u0011%\t\t#\u0003I\u0001\u0002\u0004\t\u0019#\u0001\u0004d_:4\u0017nZ\u000b\u0002C\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0015\u00131\n\t\u0004\u0013\u0006\u001d\u0013bAA%\u0015\n!QK\\5u\u0011!\tieCA\u0001\u0002\u0004\t\u0017a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003f\u0001\u0007\u0002TA\u0019\u0011*!\u0016\n\u0007\u0005]#J\u0001\u0005w_2\fG/\u001b7f\u00039\u0019G.Z1oKJl\u0015M\\1hKJ,\"!!\u0018\u0011\u0007\t\fy&C\u0002\u0002b\t\u0013\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0013!\u0003;ie>$H\u000f\\3s+\t\tI\u0007E\u0002P\u0003WJ1!!\u001cQ\u0005%!\u0006N]8ui2,'/\u0001\u0006uQJ|G\u000f\u001e7fe\u0002\n\u0001b\u00197fC:,'o]\u000b\u0003\u0003k\u0002b!a\u001e\u0002~\u0005\u0005UBAA=\u0015\r\tY([\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty(!\u001f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\u0003\u0007;S\"\u0001\u0001\u0003\u001b\rcW-\u00198feRC'/Z1e'\r9\u0013\u0011\u0012\t\u0004\u001f\u0006-\u0015bAAG!\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003!!\bN]3bI&#\u0007cA%\u0002\u0014&\u0019\u0011Q\u0013&\u0003\u0007%sG\u000f\u0006\u0003\u0002\u0002\u0006e\u0005bBAHS\u0001\u0007\u0011\u0011S\u0001\u000bY><w-\u001a:OC6,WCAAP!\u0011\t\t+a*\u000e\u0005\u0005\r&bAASc\u0006!A.\u00198h\u0013\u0011\tI+a)\u0003\rM#(/\u001b8h\u0003\u001d\u0019G.Z1oKJ,\"!a,\u0011\u0007\t\f\t,C\u0002\u00024\n\u0013qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002<B\u0019!-!0\n\u0007\u0005}&I\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8/A\u0007mCN$8\u000b^1ug~#S-\u001d\u000b\u0005\u0003\u000b\n)\rC\u0005\u0002N9\n\t\u00111\u0001\u0002<\u0006QA.Y:u'R\fGo\u001d\u0011)\u0007=\n\u0019&A\tmCN$\bK]3DY\u0016\fgn\u0015;biN,\"!a4\u0011\u0007\t\f\t.C\u0002\u0002T\n\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0005\u0003\u000b\nI\u000eC\u0005\u0002NE\n\t\u00111\u0001\u0002P\u0006\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\r\u0011\u00141K\u0001\nG\",7m\u001b#p]\u0016$B!!\u0012\u0002d\"1\u0011Q]\u001aA\u0002m\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003\u000b\nA\u0003\u001e:z\u00072,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GCAAx!\rI\u0015\u0011_\u0005\u0004\u0003gT%a\u0002\"p_2,\u0017M\\\u0001\u0012G2,\u0017M\u001c$jYRD\u0017.Z:u\u0019><\u0007&\u0002\u001c\u0002z\n\u0015\u0001#B%\u0002|\u0006}\u0018bAA\u007f\u0015\n1A\u000f\u001b:poN\u00042A\u0019B\u0001\u0013\r\u0011\u0019A\u0011\u0002\u0015\u0019><7\t\\3b]&tw-\u0012=dKB$\u0018n\u001c8$\u0005\u0005}\u0018\u0001C2mK\u0006tGj\\4\u0015\t\u0005\u0015#1\u0002\u0005\b\u0005\u001b9\u0004\u0019\u0001B\b\u0003%\u0019G.Z1oC\ndW\rE\u0002c\u0005#I1Aa\u0005C\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\fe\u0016\u001cwN\u001d3Ti\u0006$8\u000f\u0006\u0007\u0002F\te!Q\u0004B\u001b\u0005\u007f\u0011\u0019\u0005C\u0004\u0003\u001ca\u0002\r!!%\u0002\u0005%$\u0007b\u0002B\u0010q\u0001\u0007!\u0011E\u0001\u0005]\u0006lW\r\u0005\u0003\u0003$\tEb\u0002\u0002B\u0013\u0005[\u00012Aa\nK\u001b\t\u0011ICC\u0002\u0003,\u0019\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\u0018\u0015\u00061\u0001K]3eK\u001aLA!!+\u00034)\u0019!q\u0006&\t\u000f\t]\u0002\b1\u0001\u0003:\u0005!aM]8n!\rI%1H\u0005\u0004\u0005{Q%\u0001\u0002'p]\u001eDqA!\u00119\u0001\u0004\u0011I$\u0001\u0002u_\"9!Q\t\u001dA\u0002\u0005m\u0016!B:uCR\u001c\u0018!C2mK\u0006tWM]:!\u0003Ui\u0017\r_(wKJ\u001cE.Z1oKJ$\u0006N]3bIN$B!!%\u0003N!9!qJ\nA\u0002\tE\u0013!\u00014\u0011\u000f%\u0013\u0019&!!\u0003X%\u0019!Q\u000b&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA%\u0003Z%\u0019!1\f&\u0003\r\u0011{WO\u00197f\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$XCAAI\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011I\u0007E\u0003i\u0005W\u0012\t#C\u0002\u0003n%\u00141aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002F\tM\u0004b\u0002B;1\u0001\u0007!qO\u0001\n]\u0016<8i\u001c8gS\u001e\u00042a\u0017B=\u0013\r\u0011Y\b\u0018\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,GCBA#\u0005\u0003\u0013)\tC\u0004\u0003\u0004f\u0001\rAa\u001e\u0002\u0013=dGmQ8oM&<\u0007b\u0002B;3\u0001\u0007!qO\u0001\u000eC\n|'\u000f^\"mK\u0006t\u0017N\\4\u0015\t\u0005\u0015#1\u0012\u0005\u0007\u0003KT\u0002\u0019A>\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0004\u0002F\tE%Q\u0013\u0005\u0007\u0005'[\u0002\u0019A7\u0002\u000f\u0011\fG/\u0019#je\"I!qS\u000e\u0011\u0002\u0003\u0007!\u0011T\u0001\u0012a\u0006\u0014H/\u001b;j_:$vNU3n_Z,\u0007\u0003B%\u0003\u001cnL1A!(K\u0005\u0019y\u0005\u000f^5p]\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uII*\"Aa)+\t\te%QU\u0016\u0003\u0005O\u0003BA!+\u000346\u0011!1\u0016\u0006\u0005\u0005[\u0013y+A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0017&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00036\n-&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)!\t)Ea/\u0003>\n\u0005\u0007BBAs;\u0001\u00071\u0010\u0003\u0004\u0003@v\u0001\r!\\\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005\u0007l\u0002\u0019A7\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002F\t%\u0007b\u0002Bf=\u0001\u0007!\u0011E\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t)E!5\u0003T\nU\u0007B\u0002BJ?\u0001\u0007Q\u000e\u0003\u0004\u0002f~\u0001\ra\u001f\u0005\b\u0005/|\u0002\u0019\u0001B\u001d\u0003\u0019ygMZ:fi\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA#\u0005;Da!!:!\u0001\u0004Y\u0018A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u000b\u0012\u0019\u000fC\u0004\u0003f\u0006\u0002\rAa:\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004B\u0001\u001bBuw&\u0019!1^5\u0003\u0011%#XM]1cY\u0016\fA\"Y<bSR\u001cE.Z1oK\u0012$\u0002\"a<\u0003r\nM(Q\u001f\u0005\u0007\u0003K\u0014\u0003\u0019A>\t\u000f\t]'\u00051\u0001\u0003:!I!q\u001f\u0012\u0011\u0002\u0003\u0007!\u0011H\u0001\n[\u0006Dx+Y5u\u001bN\fa#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005{TCA!\u000f\u0003&\u00061\u0003/Y;tK\u000ecW-\u00198j]\u001e4uN\u001d(p]\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\r\r\u0001#\u00025\u0003j\u000e\u0015\u0001CB%\u0004\bm\fi!C\u0002\u0004\n)\u0013a\u0001V;qY\u0016\u0014\u0014!D2veJ,g\u000e^\"p]\u001aLw-\u0001\u0007dY\u0016\fg.\u001a:D_VtG/\u0001\u0006M_\u001e\u001cE.Z1oKJ\u0004\"A\u0019\u001e\u0014\u0005iBECAB\t\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"aa\u0007\u0011\u000b!\u0014Y'a(\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQb\u00197fC:,'oQ8oM&<GcA1\u0004$!9\u0011Q\b A\u0002\t]\u0014aF2sK\u0006$XMT3x\u00072,\u0017M\\3e'\u0016<W.\u001a8u)!\u0019Ica\f\u00042\rm\u0002c\u00012\u0004,%\u00191Q\u0006\"\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004\u0003L~\u0002\r!\u001c\u0005\b\u0007gy\u0004\u0019AB\u001b\u0003%awnZ\"p]\u001aLw\rE\u0002c\u0007oI1a!\u000fC\u0005%aunZ\"p]\u001aLw\rC\u0004\u0004>}\u0002\rA!\u000f\u0002\u0015\t\f7/Z(gMN,G/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007\u0007RC!a\t\u0003&\u0002")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)option).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            int n;
            if (x0$1 != null) {
                Log log = (Log)x0$1._2();
                try {
                    n = log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(null);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

