/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004M\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u0019a\u0006\u0001)A\u0005\u001f\"IQ\f\u0001a\u0001\u0002\u0004%IA\u0018\u0005\nE\u0002\u0001\r\u00111A\u0005\n\rD\u0011\u0002\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B0\t\u000b5\u0004A\u0011\t8\t\u000bi\u0004A\u0011\t8\t\u000b}\u0004A\u0011\u00018\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!1\u0011Q\u0006\u0001\u0005\u00029Da!!\r\u0001\t\u0003q\u0007BBA\u001b\u0001\u0011\u0005a\u000e\u0003\u0004\u0002:\u0001!\tA\u001c\u0005\u0007\u0003{\u0001A\u0011\u00018\t\r\u0005\u0005\u0003\u0001\"\u0001o\u0011\u0019\t)\u0005\u0001C\u0001]\"1\u0011\u0011\n\u0001\u0005\u00029Da!!\u0014\u0001\t\u0003q\u0007BBA)\u0001\u0011\u0005a\u000e\u0003\u0004\u0002V\u0001!\tA\u001c\u0005\u0007\u00033\u0002A\u0011\u00018\t\r\u0005u\u0003\u0001\"\u0001o\u0011\u0019\t\t\u0007\u0001C\u0001]\"1\u0011Q\r\u0001\u0005\u00029Da!!\u001b\u0001\t\u0003q\u0007BBA7\u0001\u0011\u0005a\u000e\u0003\u0004\u0002r\u0001!\tA\u001c\u0005\u0007\u0003k\u0002A\u0011\u00018\t\r\u0005e\u0004\u0001\"\u0001o\u0011\u0019\ti\b\u0001C\u0001]\"1\u0011\u0011\u0011\u0001\u0005\u00029Da!!\"\u0001\t\u0003q\u0007BBAE\u0001\u0011\u0005a\u000e\u0003\u0004\u0002\u000e\u0002!\tA\u001c\u0005\u0007\u0003#\u0003A\u0011\u00018\t\r\u0005U\u0005\u0001\"\u0001o\u0011\u0019\tI\n\u0001C\u0001]\"1\u0011Q\u0014\u0001\u0005\u00029Da!!)\u0001\t\u0003q\u0007BBAS\u0001\u0011\u0005a\u000eC\u0004\u0002*\u0002!\t!a+\t\r\u0005M\u0007\u0001\"\u0001o\u0011\u0019\t9\u000e\u0001C\u0001]\"1\u00111\u001c\u0001\u0005\n9Dq!!8\u0001\t\u0013\tyNA\n[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u00024i\u0005I!p\\8lK\u0016\u0004XM\u001d\u0006\u0002k\u0005)1.\u00194lC\u000e\u00011C\u0001\u00019!\tID(D\u0001;\u0015\tYD'\u0001\u0002{W&\u0011QH\u000f\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\u0001\u0005CA!\u0001\u001b\u0005\u0011\u0014\u0001C7pG.\u0004\u0016\r\u001e5\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\t1\fgn\u001a\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0004TiJLgnZ\u0001\n[>\u001c7\u000eU1uQ\u0002\nA\u0001^5nKV\tq\n\u0005\u0002Q56\t\u0011K\u0003\u0002S'\u0006)Q\u000f^5mg*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005U2&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!aW)\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0010u>|7*Z3qKJ\u001cE.[3oiV\tq\f\u0005\u0002BA&\u0011\u0011M\r\u0002\u00105>|7*Z3qKJ\u001cE.[3oi\u0006\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0011AM\u001b\t\u0003K\"l\u0011A\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011N\u001a\u0002\u0005+:LG\u000fC\u0004l\u000f\u0005\u0005\t\u0019A0\u0002\u0007a$\u0013'\u0001\t{_>\\U-\u001a9fe\u000ec\u0017.\u001a8uA\u0005)1/\u001a;VaR\tA\r\u000b\u0002\naB\u0011\u0011\u000f_\u0007\u0002e*\u00111\u000f^\u0001\u0004CBL'BA;w\u0003\u001dQW\u000f]5uKJT!a\u001e-\u0002\u000b),h.\u001b;\n\u0005e\u0014(A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u000byB\u0011\u0011/`\u0005\u0003}J\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002;Q,7\u000f^+oe\u0016\u001cx\u000e\u001c<bE2,7i\u001c8oK\u000e$8\u000b\u001e:j]\u001eD3aCA\u0002!\r\t\u0018QA\u0005\u0004\u0003\u000f\u0011(\u0001\u0002+fgR\fAC];o]&twMW6TK:$G\u000b\u001b:fC\u0012\u001cXCAA\u0007!\u0019\ty!!\u0006\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0004\u0003'1\u0017AC2pY2,7\r^5p]&!\u0011qCA\t\u0005\r\u0019V\r\u001e\t\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u0015\u0002cAA\u0010M6\u0011\u0011\u0011\u0005\u0006\u0004\u0003G1\u0014A\u0002\u001fs_>$h(C\u0002\u0002(\u0019\fa\u0001\u0015:fI\u00164\u0017bA&\u0002,)\u0019\u0011q\u00054\u0002+Q,7\u000f^\"p]:,7\r^5p]RKW.Z8vi\"\u001aQ\"a\u0001\u0002\u001dQ,7\u000f^\"p]:,7\r^5p]\"\u001aa\"a\u0001\u00029Q,7\u000f^\"p]:,7\r^5p]ZK\u0017MT3uif\u001cE.[3oi\"\u001aq\"a\u0001\u00025Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0007A\t\u0019!A\fuKN$H)\u001a7fi\u0016,\u00050[:uS:<'LT8eK\"\u001a\u0011#a\u0001\u00025Q,7\u000f^#ySN$8OT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0007I\t\u0019!A\fuKN$X\t_5tiN,\u00050[:uS:<'LT8eK\"\u001a1#a\u0001\u00027Q,7\u000f^$fi\u0012\u000bG/\u0019(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\r!\u00121A\u0001\u0019i\u0016\u001cHoR3u\t\u0006$\u0018-\u0012=jgRLgn\u001a.O_\u0012,\u0007fA\u000b\u0002\u0004\u0005YB/Z:u'\u0016$H)\u0019;b\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D3AFA\u0002\u0003a!Xm\u001d;TKR$\u0015\r^1Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0004/\u0005\r\u0011A\u0007;fgR<U\r^!dY:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007f\u0001\r\u0002\u0004\u00059B/Z:u\u000f\u0016$\u0018i\u00197Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u00043\u0005\r\u0011A\u0007;fgR\u001cV\r^!dY:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007f\u0001\u000e\u0002\u0004\u0005yB/Z:u\u000f\u0016$8\t[5mIJ,gNT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0007m\t\u0019!\u0001\u000fuKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3)\u0007q\t\u0019!\u0001\u0015uKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3XSRD7\t[5mIJ,g\u000eK\u0002\u001e\u0003\u0007\tA\u0003^3tiBK\u0007/\u001a7j]\u0016$w)\u001a;ECR\f\u0007f\u0001\u0010\u0002\u0004\u0005\tB/Z:u\u001b&DX\r\u001a)ja\u0016d\u0017N\\3)\u0007}\t\u0019!A\u0011uKN$(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u00148I]3bi&|g\u000eK\u0002!\u0003\u0007\t\u0011\u0005^3tijsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0012+G.\u001a;j_:D3!IA\u0002\u0003\r\"Xm\u001d;[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:ECR\f7\t[1oO\u0016D3AIA\u0002\u0003I\"Xm\u001d;CY>\u001c7n\u00148SKF,Xm\u001d;D_6\u0004H.\u001a;j_:4%o\\7Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bfA\u0012\u0002\u0004\u0005AC/Z:u\u000bb\u001cW\r\u001d;j_:LeNQ3g_J,\u0017J\\5uS\u0006d\u0017N_5oON+7o]5p]\"\u001aA%a\u0001\u0002SQ,7\u000f\u001e.O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u00148\t[5mI\u000eC\u0017M\\4fQ\r)\u00131A\u00016i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3IC:$G.\u001a:G_J\u001c\u0005.\u001b7e\u0007\"\fgnZ3O_R$&/[4hKJ,G\rK\u0002'\u0003\u0007\tA\u0005^3tiN#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0006+H\u000f\u001b$bS2,(/\u001a\u0015\u0004O\u0005\r\u0011\u0001\n;fgR\u001cuN\u001c8fGRLwN\u001c'pgN\u0014V-];fgR$VM]7j]\u0006$\u0018n\u001c8)\u0007!\n\u0019!A\tuKN$8+Z:tS>tW\t\u001f9jefD3!KA\u0002\u0003q!Xm\u001d;TKN\u001c\u0018n\u001c8FqBL'/\u001f#ve&twm\u00117pg\u0016D3AKA\u0002\u0003\u0001\"Xm\u001d;SK&t\u0017\u000e^5bY&TX-\u00114uKJ\fU\u000f\u001e5GC&dWO]3)\u0007-\n\u0019!\u0001\u000bjg\u0016C\b/Z2uK\u0012lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u0003[\u000b\u0019,a4\u0011\u0007\u0015\fy+C\u0002\u00022\u001a\u0014qAQ8pY\u0016\fg\u000eC\u0004\u000262\u0002\r!a.\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002:\u0006-WBAA^\u0015\u0011\ti,a0\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0003\f\u0019-A\u0004nKR\u0014\u0018nY:\u000b\t\u0005\u0015\u0017qY\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005%\u0017aA2p[&!\u0011QZA^\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003#d\u0003\u0019AA\r\u0003\u0011q\u0017-\\3\u0002GQ,7\u000f\u001e.p_.+W\r]3s'R\fG/Z\"iC:<WMU1uK6+GO]5dg\"\u001aQ&a\u0001\u0002?Q,7\u000f\u001e.p_.+W\r]3s'\u0016\u001c8/[8o'R\fG/Z'fiJL7\rK\u0002/\u0003\u0007\tAc\u00197fC:lU\r\u001e:jGN\u0014VmZ5tiJL\u0018!\u00022zi\u0016\u001cXCAAq!\u0015)\u00171]At\u0013\r\t)O\u001a\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004K\u0006%\u0018bAAvM\n!!)\u001f;f\u0001")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@BeforeEach");
        this.cleanMetricsRegistry();
        super.setUp();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "testMetricGroup", "testMetricType"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@AfterEach");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            new ZooKeeperClient("some.invalid.hostname.foo.bar.local", this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
            return;
        }
        catch (ZooKeeperClientTimeoutException zooKeeperClientTimeoutException) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.runningZkSendThreads(), (String)"ZooKeeper client threads still running");
            return;
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAlive()))).map((Function1 & Serializable)x$3 -> x$3.getName())).filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        Assertions.assertThrows(ZooKeeperClientTimeoutException.class, () -> new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close());
    }

    @Test
    public void testConnection() {
        try (ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            scala.collection.mutable.Set threads = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$4 -> x$4.getName());
            Assertions.assertTrue((boolean)threads.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains(ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix()))), (String)new StringBuilder(48).append("ZooKeeperClient event thread not found, threads=").append(threads).toString());
        }
    }

    @Test
    public void testConnectionViaNettyClient() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String propKey = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        String propVal = "org.apache.zookeeper.ClientCnxnSocketNetty";
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, propKey, (Object)propVal);
        try (ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", (Option)None$.MODULE$, (Option)new Some((Object)clientConfig));){
            Assertions.assertEquals((Object)new Some((Object)propVal), (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty(client.getClientConfig(), propKey));
            ZKClientConfig badClientConfig = new ZKClientConfig();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(badClientConfig, propKey, (Object)new StringBuilder(12).append(propVal).append("BadClassName").toString());
            Assertions.assertThrows(Exception.class, () -> new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", (Option)None$.MODULE$, (Option)new Some((Object)badClientConfig)));
        }
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode(), (String)"Response code should be NONODE");
        Assertions.assertThrows(KeeperException.NoNodeException.class, () -> deleteResponse.maybeThrow());
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)existsResponse.resultCode(), (String)"Response code for exists should be OK");
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match created znode data");
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match setData's data");
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode(), (String)"Response code for getAcl should be OK");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl(), (String)new StringBuilder(14).append("ACL should be ").append(CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children(), (String)"getChildren should return no children");
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode(), (String)"Response code for create child2 should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)new .colon.colon((Object)child1, (List)new .colon.colon((Object)child2, (List)Nil$.MODULE$)), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$), (String)"getChildren should return two children");
    }

    @Test
    public void testPipelinedGetData() {
        ((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x))).map(arg_0 -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$2(this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient(), arg_0))).foreach((Function1 & Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        IndexedSeq getDataRequests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x)));
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)getDataResponses.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)getDataRequest, (List)new .colon.colon((Object)setDataRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data(), (String)"Data for getData should be empty");
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for setData should be NONODE");
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)existsRequest, (List)new .colon.colon((Object)createRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be NONODE");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive create notification");
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive delete notification");
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive data change notification");
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                try {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread reinitializeThread = new Thread(this){
            private final /* synthetic */ ZooKeeperClientTest $outer;

            public void run() {
                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                this.name = this.getClass().getName();
            }
        };
        AtomicInteger goodCalls = new AtomicInteger(0);
        StateChangeHandler goodHandler = new StateChangeHandler(null, goodCalls){
            private final String name;
            private final AtomicInteger goodCalls$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.goodCalls$1.incrementAndGet();
            }
            {
                this.goodCalls$1 = goodCalls$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(faultyHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(goodHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
        Assertions.assertEquals((int)1, (int)goodCalls.get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertTrue((boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive child change notification");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChangeNotTriggered() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$2;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$2 = zNodeChildChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), false, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertFalse((boolean)zNodeChildChangeHandlerCountDownLatch.await(100L, TimeUnit.MILLISECONDS), (String)"Child change notification received");
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assertions.assertTrue((boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive auth failed notification");
        }
    }

    @Test
    public void testConnectionLossRequestTermination() {
        int batchSize = 10;
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), 2, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");){
            IndexedSeq requests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), batchSize).map((Function1 & Serializable)i -> ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i)));
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, running, zooKeeperClient, requests, unexpectedResponses, countDownLatch){
                private final AtomicBoolean running$1;
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final ArrayBlockingQueue unexpectedResponses$1;
                private final CountDownLatch countDownLatch$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$12 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.running$1 = running$1;
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                    this.countDownLatch$1 = countDownLatch$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$12 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            if (!countDownLatch.await(30L, TimeUnit.SECONDS)) {
                running.set(false);
                requestThread.join(5000L);
                Assertions.fail((String)"Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.");
            } else if (!unexpectedResponses.isEmpty()) {
                Assertions.fail((String)new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString());
            }
        }
    }

    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendCompleteSemaphore, sendSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendCompleteSemaphore$1;
            public final Semaphore sendSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable)response -> {
                    $anon$13.$anonfun$send$1(this, processResponse, response);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$13 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new Runnable($this, processResponse$1, response){
                    private final /* synthetic */ $anon$13 $outer;
                    private final Function1 processResponse$1;
                    private final AsyncResponse response$1;

                    public void run() {
                        this.$outer.sendCompleteSemaphore$1.release();
                        this.$outer.sendSemaphore$1.acquire();
                        this.processResponse$1.apply((Object)this.response$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.processResponse$1 = processResponse$1;
                        this.response$1 = response$1;
                    }
                });
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$13 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, stateChanges, sendSemaphore, sendSize, zooKeeperClient){
                private final String name;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assertions.assertTrue((boolean)threadName.startsWith(this.zooKeeperClient$2.reinitializeScheduler().threadNamePrefix()), (String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString());
                }
                {
                    this.stateChanges$1 = stateChanges$1;
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void run() {
                    IndexedSeq requests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.sendSize$1).map((Function1 & Serializable)i -> $anon$16.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i)));
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable)x$6 -> x$6.resultCode());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4$adapted(java.lang.Object ), $anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                Assertions.fail((String)"Request thread did not complete");
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)"beforeInitializingSession", (List)new .colon.colon((Object)"afterInitializingSession", (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(stateChanges).asScala().toSeq());
            Assertions.assertEquals((int)((Seq)resultCodes.elem).size(), (int)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$7)));
            Assertions.assertTrue((connectionLostCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString());
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$8)));
            Assertions.assertTrue((expiredCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertTrue((connectionLostCount + expiredCount > 0 ? 1 : 0) != 0, (String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Assertions.assertTrue((boolean)((Seq)resultCodes.elem).forall(arg_0 -> ZooKeeperClientTest.$anonfun$testSessionExpiry$3$adapted((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS})), arg_0)), (String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assertions.assertFalse((boolean)zooKeeperClient.reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable)() -> semaphore.acquireUninterruptibly(), 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleReinitialize("session-expired", "Session expired.", 0L);
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assertions.assertFalse((boolean)closeFuture.isDone(), (String)"Close completed without shutting down expiry scheduler gracefully");
            Assertions.assertTrue((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().currentZooKeeper().getState().isAlive());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    @Test
    public void testReinitializeAfterAuthFailure() {
        CountDownLatch sessionInitializedCountDownLatch = new CountDownLatch(1);
        StateChangeHandler changeHandler = new StateChangeHandler(null, sessionInitializedCountDownLatch){
            private final String name;
            private final CountDownLatch sessionInitializedCountDownLatch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.sessionInitializedCountDownLatch$1.countDown();
            }
            {
                this.sessionInitializedCountDownLatch$1 = sessionInitializedCountDownLatch$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(changeHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
        Assertions.assertTrue((boolean)sessionInitializedCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive session initializing notification");
    }

    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(name) : name != null)) {
            String string2 = metricName.getGroup();
            String string3 = "testMetricGroup";
            if (string2 != null && string2.equals(string3)) {
                String string4 = metricName.getType();
                String string5 = "testMetricType";
                if (string4 != null && string4.equals(string5)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assertions.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = KafkaYammerMetrics.defaultRegistry();
        metrics.allMetrics().keySet().forEach(x$1 -> metrics.removeMetric(x$1));
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), Integer.toString(x * 2).getBytes(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ CreateResponse $anonfun$testPipelinedGetData$2(ZooKeeperClient eta$0$1$1, CreateRequest request) {
        return (CreateResponse)eta$0$1$1.handleRequest((AsyncRequest)request);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            GetDataResponse getDataResponse = (GetDataResponse)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
            Assertions.assertEquals((int)((i + 1) * 2), (Integer)Integer.valueOf(new String(getDataResponse.data())), (String)"Data for getData should match");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$7) {
        KeeperException.Code code = x$7;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$8) {
        KeeperException.Code code = x$8;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Meter meter = (Meter)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric meter = (Metric)x1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(31).append("Unable to find meter with name ").append(name).toString()));
        Assertions.assertEquals((long)expected, (long)meter.count(), (String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString());
    }

    private final Option gaugeValue$1(String name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric gauge = (Metric)x1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }

    public static final /* synthetic */ Object $anonfun$testSessionExpiry$3$adapted(scala.collection.immutable.Set eta$0$1$2, KeeperException.Code elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$2.contains((Object)elem));
    }
}

