/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\rvA\u00027n\u0011\u0003y\u0017O\u0002\u0004t[\"\u0005q\u000e\u001e\u0005\u0006w\u0006!\t! \u0005\b}\u0006\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0001Q\u0001\n\u0005\u0005\u0001\u0002CA\n\u0003\t\u0007I\u0011A@\t\u0011\u0005U\u0011\u0001)A\u0005\u0003\u0003A\u0001\"a\u0006\u0002\u0005\u0004%\ta \u0005\t\u00033\t\u0001\u0015!\u0003\u0002\u0002!I\u00111D\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003K\t\u0001\u0015!\u0003\u0002 !I\u0011qE\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0004\u0007g6\u0004q.a\u0010\t\u0015\u0005MCB!b\u0001\n\u0003\ti\u0002\u0003\u0006\u0002V1\u0011\t\u0011)A\u0005\u0003?A!\"a\u0016\r\u0005\u0003\u0005\u000b\u0011BA-\u0011)\t\u0019\b\u0004B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003kb!\u0011!Q\u0001\n\u0005]\u0004BCA?\u0019\t\u0005\t\u0015!\u0003\u0002\u0000!Q\u0011Q\u0011\u0007\u0003\u0002\u0003\u0006I!a\"\t\u0015\u00055EB!A!\u0002\u0013\ty\u0002\u0003\u0006\u0002\u00102\u0011\t\u0011)A\u0005\u0003#C!\"a'\r\u0005\u0003\u0005\u000b\u0011BAO\u0011)\ti\u000b\u0004B\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0003\u001bb!\u0011!Q\u0001\n\u0005m\u0006BCAc\u0019\t\u0005\t\u0015!\u0003\u0002H\"Q\u0011\u0011\u001b\u0007\u0003\u0002\u0003\u0006I!a5\t\u0015\u0005}GB!A!\u0002\u0013\t\t\u000f\u0003\u0006\u0002h2\u0011\t\u0011)A\u0005\u0003?Aaa\u001f\u0007\u0005\u0002\u0005%xa\u0002B\u0006\u0019!%!Q\u0002\u0004\b\u0005#a\u0001\u0012\u0002B\n\u0011\u0019Yx\u0004\"\u0001\u0003\"!9!1E\u0010\u0005\u0002\t\u0015\u0002\"\u0003Bp?\u0005\u0005I\u0011\u0011Bq\u0011%\u0011ioHA\u0001\n\u0003\u0013yOB\u0004\u0003\u00121\u0001UNa\f\t\u0015\t5CE!f\u0001\n\u0003\u0011y\u0005\u0003\u0006\u0003`\u0011\u0012\t\u0012)A\u0005\u0005#B!B!\u0019%\u0005+\u0007I\u0011AA\u000f\u0011)\u0011\u0019\u0007\nB\tB\u0003%\u0011q\u0004\u0005\u000b\u0005K\"#Q3A\u0005\u0002\t=\u0003B\u0003B4I\tE\t\u0015!\u0003\u0003R!Q!\u0011\u000e\u0013\u0003\u0016\u0004%\t!!\b\t\u0015\t-DE!E!\u0002\u0013\ty\u0002\u0003\u0006\u0003n\u0011\u0012)\u001a!C\u0001\u0003;A!Ba\u001c%\u0005#\u0005\u000b\u0011BA\u0010\u0011\u0019YH\u0005\"\u0001\u0003r!9!Q\u0010\u0013\u0005B\t}\u0004\"\u0003BAI\u0005\u0005I\u0011\u0001BB\u0011%\u0011y\tJI\u0001\n\u0003\u0011\t\nC\u0005\u0003\u0016\u0012\n\n\u0011\"\u0001\u0002*!I!q\u0013\u0013\u0012\u0002\u0013\u0005!\u0011\u0013\u0005\n\u00053#\u0013\u0013!C\u0001\u0003SA\u0011Ba'%#\u0003%\t!!\u000b\t\u0011\tuE%!A\u0005B}D\u0011Ba(%\u0003\u0003%\t!!\b\t\u0013\t\u0005F%!A\u0005\u0002\t\r\u0006\"\u0003BXI\u0005\u0005I\u0011\tBY\u0011%\u0011y\fJA\u0001\n\u0003\u0011\t\rC\u0005\u0003L\u0012\n\t\u0011\"\u0011\u0003N\"I!\u0011\u001b\u0013\u0002\u0002\u0013\u0005#1\u001b\u0005\n\u0005+$\u0013\u0011!C!\u0005/D\u0011B!@\r\u0005\u0004%IAa@\t\u0011\r\u0005B\u0002)A\u0005\u0007\u0003A\u0011ba\t\r\u0005\u0004%Ia!\n\t\u0011\r\u0005C\u0002)A\u0005\u0007OA\u0011ba\u0011\r\u0005\u0004%Ia!\u0012\t\u0011\r5C\u0002)A\u0005\u0007\u000fB!ba\u0014\r\u0005\u0004%\ta\\B)\u0011!\u0019I\u0006\u0004Q\u0001\n\rM\u0003\"CB.\u0019\t\u0007I\u0011AB/\u0011!\u0019Y\u0007\u0004Q\u0001\n\r}\u0003\"CB7\u0019\t\u0007I\u0011BB8\u0011!\u0019I\b\u0004Q\u0001\n\rE\u0004\"CB>\u0019\t\u0007I\u0011BB?\u0011!\u0019)\t\u0004Q\u0001\n\r}\u0004\u0002CBD\u0019\u0011EQn!#\t\u0013\rUE\u00021A\u0005\n\u0005u\u0001\"CBL\u0019\u0001\u0007I\u0011BBM\u0011!\u0019\u0019\u000b\u0004Q!\n\u0005}\u0001bBBS\u0019\u0011\u00053q\u0015\u0005\t\u0007ScA\u0011A7\u0004,\"911\u0018\u0007\u0005\n\ru\u0006bBBd\u0019\u0011%1q\u0015\u0005\t\u0007\u0013dA\u0011C7\u0004L\"911\u001c\u0007\u0005\n\r\u001d\u0006bBBo\u0019\u0011E1q\u001c\u0005\b\u0007sdA\u0011BBT\u0011\u001d\u0019Y\u0010\u0004C\u0005\u0007OCqa!@\r\t\u0013\u0019y\u0010C\u0004\u0005\u00041!Iaa*\t\u000f\u0011\u0015A\u0002\"\u0003\u0004(\"9Aq\u0001\u0007\u0005\n\u0011%\u0001b\u0002C\b\u0019\u0011\u0005A\u0011\u0003\u0005\b\tkaA\u0011BBT\u0011\u001d!9\u0004\u0004C\u0005\u0007OC\u0001\u0002\"\u0004\r\t#iG\u0011\b\u0005\t\t\u0017bA\u0011A7\u0005N!9A\u0011\u000b\u0007\u0005\n\u0011M\u0003\u0002\u0003C+\u0019\u0011\u0005Q.!\b\t\u0011\u0011]C\u0002\"\u0001n\u0003;A\u0001\u0002\"\u0017\r\t\u0003iG1\f\u0005\b\tObA\u0011\u0002C5\u0011\u001d!\u0019\n\u0004C\u0005\t+C\u0001\u0002\"'\r\t\u0003iG1\u0014\u0005\b\t?cA\u0011IBT\u0011\u001d!\t\u000b\u0004C!\u0007O\u000b\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u000b\u00059|\u0017a\u00028fi^|'o\u001b\u0006\u0002a\u0006)1.\u00194lCB\u0011!/A\u0007\u0002[\nI\u0001K]8dKN\u001cxN]\n\u0003\u0003U\u0004\"A^=\u000e\u0003]T\u0011\u0001_\u0001\u0006g\u000e\fG.Y\u0005\u0003u^\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003E\fQ#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00027b]\u001eT!!a\u0003\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\t)A\u0001\u0004TiJLgnZ\u0001\u0017\u0013\u0012dW\rU3sG\u0016tG/T3ue&\u001cg*Y7fA\u0005Ib*\u001a;x_J\\\u0007K]8dKN\u001cxN]'fiJL7\rV1h\u0003iqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4!\u0003Ea\u0015n\u001d;f]\u0016\u0014X*\u001a;sS\u000e$\u0016mZ\u0001\u0013\u0019&\u001cH/\u001a8fe6+GO]5d)\u0006<\u0007%A\nD_:tWm\u0019;j_:\fV/Z;f'&TX-\u0006\u0002\u0002 A\u0019a/!\t\n\u0007\u0005\rrOA\u0002J]R\fAcQ8o]\u0016\u001cG/[8o#V,W/Z*ju\u0016\u0004\u0013\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'N\u000b\u0003\u0003WQC!a\b\u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:]\f!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmE\u0003\r\u0003\u0003\n9\u0005E\u0002s\u0003\u0007J1!!\u0012n\u0005Q\t%m\u001d;sC\u000e$8+\u001a:wKJ$\u0006N]3bIB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N=\fq!\\3ue&\u001c7/\u0003\u0003\u0002R\u0005-#!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006\u0011\u0011\u000eZ\u0001\u0004S\u0012\u0004\u0013\u0001\u0002;j[\u0016\u0004B!a\u0017\u0002p5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0003vi&d7O\u0003\u0003\u0002d\u0005\u0015\u0014AB2p[6|gNC\u0002q\u0003ORA!!\u001b\u0002l\u00051\u0011\r]1dQ\u0016T!!!\u001c\u0002\u0007=\u0014x-\u0003\u0003\u0002r\u0005u#\u0001\u0002+j[\u0016\fa\"\\1y%\u0016\fX/Z:u'&TX-\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007I\fI(C\u0002\u0002|5\u0014aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\td_:tWm\u0019;j_:\fVo\u001c;bgB\u0019!/!!\n\u0007\u0005\rUN\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u0006!2m\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D\u0018\n\u001a7f\u001bN\u00042A^AE\u0013\r\tYi\u001e\u0002\u0005\u0019>tw-A\u000egC&dW\rZ!vi\",g\u000e^5dCRLwN\u001c#fY\u0006LXj]\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*\u0019a.!\u0019\n\t\u0005e\u0015Q\u0013\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004B!a(\u0002*6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+\u0001\u0003bkRD'\u0002BAT\u0003C\n\u0001b]3dkJLG/_\u0005\u0005\u0003W\u000b\tK\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u000611m\u001c8gS\u001e\u0004B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k{\u0017AB:feZ,'/\u0003\u0003\u0002:\u0006M&aC&bM.\f7i\u001c8gS\u001e\u0004B!!0\u0002B6\u0011\u0011q\u0018\u0006\u0005\u0003\u001b\n\t'\u0003\u0003\u0002D\u0006}&aB'fiJL7m]\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002J\u00065WBAAf\u0015\r\t9k\\\u0005\u0005\u0003\u001f\fYM\u0001\nDe\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\u0018AC7f[>\u0014\u0018\u0010U8pYB!\u0011Q[An\u001b\t\t9N\u0003\u0003\u0002Z\u0006\u0005\u0014AB7f[>\u0014\u00180\u0003\u0003\u0002^\u0006]'AC'f[>\u0014\u0018\u0010U8pY\u0006QAn\\4D_:$X\r\u001f;\u0011\t\u0005m\u00131]\u0005\u0005\u0003K\fiF\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1cY8o]\u0016\u001cG/[8o#V,W/Z*ju\u0016$\u0002%a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\nA\u0011!\u000f\u0004\u0005\b\u0003'j\u0002\u0019AA\u0010\u0011\u001d\t9&\ba\u0001\u00033Bq!a\u001d\u001e\u0001\u0004\ty\u0002C\u0004\u0002vu\u0001\r!a\u001e\t\u000f\u0005uT\u00041\u0001\u0002\u0000!9\u0011QQ\u000fA\u0002\u0005\u001d\u0005bBAG;\u0001\u0007\u0011q\u0004\u0005\b\u0003\u001fk\u0002\u0019AAI\u0011\u001d\tY*\ba\u0001\u0003;Cq!!,\u001e\u0001\u0004\ty\u000bC\u0004\u0002Nu\u0001\r!a/\t\u000f\u0005\u0015W\u00041\u0001\u0002H\"9\u0011\u0011[\u000fA\u0002\u0005M\u0007bBAp;\u0001\u0007\u0011\u0011\u001d\u0005\n\u0003Ol\u0002\u0013!a\u0001\u0003?\tAbQ8o]\u0016\u001cG/[8o\u0013\u0012\u00042Aa\u0004 \u001b\u0005a!\u0001D\"p]:,7\r^5p]&#7\u0003B\u0010v\u0005+\u0001BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\tI!\u0001\u0002j_&!!q\u0004B\r\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011i!\u0001\u0006ge>l7\u000b\u001e:j]\u001e$BAa\n\u0003\\B)aO!\u000b\u0003.%\u0019!1F<\u0003\r=\u0003H/[8o!\r\u0011y\u0001J\n\u0007IU\u0014\tDa\u000e\u0011\u0007Y\u0014\u0019$C\u0002\u00036]\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003:\t%c\u0002\u0002B\u001e\u0005\u000brAA!\u0010\u0003D5\u0011!q\b\u0006\u0004\u0005\u0003b\u0018A\u0002\u001fs_>$h(C\u0001y\u0013\r\u00119e^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yBa\u0013\u000b\u0007\t\u001ds/A\u0005m_\u000e\fG\u000eS8tiV\u0011!\u0011\u000b\t\u0005\u0005'\u0012YF\u0004\u0003\u0003V\t]\u0003c\u0001B\u001fo&\u0019!\u0011L<\u0002\rA\u0013X\rZ3g\u0013\u0011\tyA!\u0018\u000b\u0007\tes/\u0001\u0006m_\u000e\fG\u000eS8ti\u0002\n\u0011\u0002\\8dC2\u0004vN\u001d;\u0002\u00151|7-\u00197Q_J$\b%\u0001\u0006sK6|G/\u001a%pgR\f1B]3n_R,\u0007j\\:uA\u0005Q!/Z7pi\u0016\u0004vN\u001d;\u0002\u0017I,Wn\u001c;f!>\u0014H\u000fI\u0001\u0006S:$W\r_\u0001\u0007S:$W\r\u001f\u0011\u0015\u0019\t5\"1\u000fB;\u0005o\u0012IHa\u001f\t\u000f\t5s\u00061\u0001\u0003R!9!\u0011M\u0018A\u0002\u0005}\u0001b\u0002B3_\u0001\u0007!\u0011\u000b\u0005\b\u0005Sz\u0003\u0019AA\u0010\u0011\u001d\u0011ig\fa\u0001\u0003?\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005#\nAaY8qsRa!Q\u0006BC\u0005\u000f\u0013IIa#\u0003\u000e\"I!QJ\u0019\u0011\u0002\u0003\u0007!\u0011\u000b\u0005\n\u0005C\n\u0004\u0013!a\u0001\u0003?A\u0011B!\u001a2!\u0003\u0005\rA!\u0015\t\u0013\t%\u0014\u0007%AA\u0002\u0005}\u0001\"\u0003B7cA\u0005\t\u0019AA\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa%+\t\tE\u0013QF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!*\u0003,B\u0019aOa*\n\u0007\t%vOA\u0002B]fD\u0011B!,:\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\f\u0005\u0004\u00036\nm&QU\u0007\u0003\u0005oS1A!/x\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005{\u00139L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Bb\u0005\u0013\u00042A\u001eBc\u0013\r\u00119m\u001e\u0002\b\u0005>|G.Z1o\u0011%\u0011ikOA\u0001\u0002\u0004\u0011)+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0001\u0005\u001fD\u0011B!,=\u0003\u0003\u0005\r!a\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\b\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019M!7\t\u0013\t5f(!AA\u0002\t\u0015\u0006b\u0002BoC\u0001\u0007!\u0011K\u0001\u0002g\u0006)\u0011\r\u001d9msRa!Q\u0006Br\u0005K\u00149O!;\u0003l\"9!Q\n\u0012A\u0002\tE\u0003b\u0002B1E\u0001\u0007\u0011q\u0004\u0005\b\u0005K\u0012\u0003\u0019\u0001B)\u0011\u001d\u0011IG\ta\u0001\u0003?AqA!\u001c#\u0001\u0004\ty\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE(\u0011 \t\u0006m\n%\"1\u001f\t\u000em\nU(\u0011KA\u0010\u0005#\ny\"a\b\n\u0007\t]xO\u0001\u0004UkBdW-\u000e\u0005\n\u0005w\u001c\u0013\u0011!a\u0001\u0005[\t1\u0001\u001f\u00131\u00039qWm^\"p]:,7\r^5p]N,\"a!\u0001\u0011\r\r\r1QBB\t\u001b\t\u0019)A\u0003\u0003\u0004\b\r%\u0011AC2p]\u000e,(O]3oi*!11BA\u0005\u0003\u0011)H/\u001b7\n\t\r=1Q\u0001\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003\u0004\u0014\ruQBAB\u000b\u0015\u0011\u00199b!\u0007\u0002\u0011\rD\u0017M\u001c8fYNTAaa\u0007\u0002\n\u0005\u0019a.[8\n\t\r}1Q\u0003\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002\n\u0011#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3t+\t\u00199\u0003\u0005\u0005\u0004*\r=\"\u0011KB\u001a\u001b\t\u0019YC\u0003\u0003\u0004.\t]\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0007c\u0019YCA\u0002NCB\u0004Ba!\u000e\u0004<9\u0019!oa\u000e\n\u0007\reR.\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\ru2q\b\u0002\t%\u0016\u001c\bo\u001c8tK*\u00191\u0011H7\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000fI\u0001\u000ee\u0016\u001c\bo\u001c8tKF+X-^3\u0016\u0005\r\u001d\u0003CBB\u0002\u0007\u0013\u001a\u0019$\u0003\u0003\u0004L\r\u0015!a\u0005'j].,GM\u00117pG.Lgn\u001a#fcV,\u0017A\u0004:fgB|gn]3Rk\u0016,X\rI\u0001\u000b[\u0016$(/[2UC\u001e\u001cXCAB*!!\u0019)fa\u0016\u0002\u0002\u0005\u0005QBAB\u0005\u0013\u0011\u0019\td!\u0003\u0002\u00175,GO]5d)\u0006<7\u000fI\u0001\u001eKb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oiV\u00111q\f\t\u0005\u0007C\u001a9'\u0004\u0002\u0004d)!1QMA`\u0003\u0015\u0019H/\u0019;t\u0013\u0011\u0019Iga\u0019\u0003\u001b\r+X.\u001e7bi&4XmU;n\u0003y)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$\b%A\u0014fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WCAB9!\u0011\u0019\u0019h!\u001e\u000e\u0005\u0005\u0005\u0014\u0002BB<\u0003C\u0012!\"T3ue&\u001cg*Y7f\u0003!*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003!\u0019X\r\\3di>\u0014XCAB@!\u0011\t\u0019j!!\n\t\r\r\u0015Q\u0013\u0002\t'\u0016dWm\u0019;pe\u0006I1/\u001a7fGR|'\u000fI\u0001\u000fGJ,\u0017\r^3TK2,7\r^8s)\u0011\u0019yha#\t\u000f\r5U\n1\u0001\u0004\u0010\u0006q1\r[1o]\u0016d')^5mI\u0016\u0014\b\u0003BAJ\u0007#KAaa%\u0002\u0016\nq1\t[1o]\u0016d')^5mI\u0016\u0014\u0018a\u00058fqR\u001cuN\u001c8fGRLwN\\%oI\u0016D\u0018a\u00068fqR\u001cuN\u001c8fGRLwN\\%oI\u0016Dx\fJ3r)\u0011\u0019Yj!)\u0011\u0007Y\u001ci*C\u0002\u0004 ^\u0014A!\u00168ji\"I!QV(\u0002\u0002\u0003\u0007\u0011qD\u0001\u0015]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r\u001f\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0004\u001c\u0006\u0001\u0002O]8dKN\u001cX\t_2faRLwN\u001c\u000b\u0007\u00077\u001bik!-\t\u000f\r=&\u000b1\u0001\u0003R\u0005aQM\u001d:pe6+7o]1hK\"911\u0017*A\u0002\rU\u0016!\u0003;ie><\u0018M\u00197f!\u0011\u0011Ida.\n\t\re&1\n\u0002\n)\"\u0014xn^1cY\u0016\fq\u0003\u001d:pG\u0016\u001c8o\u00115b]:,G.\u0012=dKB$\u0018n\u001c8\u0015\u0011\rm5qXBb\u0007\u000bDqa!1T\u0001\u0004\u0011\t&A\u0005dQ\u0006tg.\u001a7JI\"91qV*A\u0002\tE\u0003bBBZ'\u0002\u00071QW\u0001\u0014aJ|7-Z:t\u001d\u0016<(+Z:q_:\u001cXm]\u0001\rg\u0016tGMU3ta>t7/\u001a\u000b\u0007\u00077\u001bim!5\t\u000f\r=W\u000b1\u0001\u00044\u0005A!/Z:q_:\u001cX\rC\u0004\u0004TV\u0003\ra!6\u0002\u0019I,7\u000f]8og\u0016\u001cVM\u001c3\u0011\t\u0005M5q[\u0005\u0005\u00073\f)J\u0001\u0003TK:$\u0017\u0001\u00029pY2\f!\u0003]1sg\u0016\u0014V-];fgRDU-\u00193feR!1\u0011]Bw!\u0011\u0019\u0019o!;\u000e\u0005\r\u0015(\u0002BBt\u0003C\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007W\u001c)OA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0007_<\u0006\u0019ABy\u0003\u0019\u0011WO\u001a4feB!11_B{\u001b\t\u0019I\"\u0003\u0003\u0004x\u000ee!A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006A\u0002O]8dKN\u001c8i\\7qY\u0016$X\r\u001a*fG\u0016Lg/Z:\u0002+A\u0014xnY3tg\u000e{W\u000e\u001d7fi\u0016$7+\u001a8eg\u0006!R\u000f\u001d3bi\u0016\u0014V-];fgRlU\r\u001e:jGN$Baa'\u0005\u0002!91q\u001a.A\u0002\rM\u0012a\u00059s_\u000e,7o\u001d#jg\u000e|gN\\3di\u0016$\u0017AF2m_N,W\t_2fgN\u001cuN\u001c8fGRLwN\\:\u0002\u000b\rdwn]3\u0015\t\rmE1\u0002\u0005\b\t\u001bi\u0006\u0019\u0001B)\u00031\u0019wN\u001c8fGRLwN\\%e\u0003\u0019\t7mY3qiRA!1\u0019C\n\t/!Y\u0002C\u0004\u0005\u0016y\u0003\ra!\u0005\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d!IB\u0018a\u0001\u0005\u0007\f\u0001\"\\1z\u00052|7m\u001b\u0005\b\t;q\u0006\u0019\u0001C\u0010\u0003a\t7mY3qi>\u0014\u0018\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\t\u0005\tC!\t$\u0004\u0002\u0005$)!AQ\u0005C\u0014\u0003\u0011\u0019wN]3\u000b\t\u00055C\u0011\u0006\u0006\u0005\tW!i#\u0001\u0004zC6lWM\u001d\u0006\u0003\t_\t1aY8n\u0013\u0011!\u0019\u0004b\t\u0003\u000b5+G/\u001a:\u0002/\r|gNZ5hkJ,g*Z<D_:tWm\u0019;j_:\u001c\u0018\u0001C2m_N,\u0017\t\u001c7\u0015\t\tEC1\b\u0005\b\t{\t\u0007\u0019\u0001C \u0003\u0019\u0019xnY6fiB!A\u0011\tC$\u001b\t!\u0019E\u0003\u0003\u0005F\u0005%\u0011a\u00018fi&!A\u0011\nC\"\u0005\u0019\u0019vnY6fi\u0006yQM\\9vKV,'+Z:q_:\u001cX\r\u0006\u0003\u0004\u001c\u0012=\u0003bBBhE\u0002\u000711G\u0001\u0010I\u0016\fX/Z;f%\u0016\u001c\bo\u001c8tKR\u001111G\u0001\u0012e\u0016\u001c\bo\u001c8tKF+X-^3TSj,\u0017!F5oM2Lw\r\u001b;SKN\u0004xN\\:f\u0007>,h\u000e^\u0001\u0015_B,gn\u0014:DY>\u001c\u0018N\\4DQ\u0006tg.\u001a7\u0015\t\u0011uCQ\r\t\u0006m\n%Bq\f\t\u0005\u0003'#\t'\u0003\u0003\u0005d\u0005U%\u0001D&bM.\f7\t[1o]\u0016d\u0007b\u0002C\u0007M\u0002\u0007!\u0011K\u0001\u0017Q\u0006tG\r\\3DQ\u0006tg.\u001a7NkR,WI^3oiR111\u0014C6\t[Bq\u0001\"\u0004h\u0001\u0004\u0011\t\u0006C\u0004\u0005p\u001d\u0004\r\u0001\"\u001d\u0002\u000b\u00154XM\u001c;\u0011\t\u0011MDQ\u0012\b\u0005\tk\"II\u0004\u0003\u0005x\u0011\u001de\u0002\u0002C=\t\u000bsA\u0001b\u001f\u0005\u0004:!AQ\u0010CA\u001d\u0011\u0011i\u0004b \n\u0005\u00055\u0014\u0002BA5\u0003WJ1\u0001]A4\u0013\u0011\t\u0019'!\u001a\n\u00079\f\t'\u0003\u0003\u0005\f\u0006U\u0015\u0001D&bM.\f7\t[1o]\u0016d\u0017\u0002\u0002CH\t#\u0013\u0001c\u00115b]:,G.T;uK\u00163XM\u001c;\u000b\t\u0011-\u0015QS\u0001\u0011iJLXK\\7vi\u0016\u001c\u0005.\u00198oK2$Baa'\u0005\u0018\"9AQ\u00025A\u0002\tE\u0013aB2iC:tW\r\u001c\u000b\u0005\t;\"i\nC\u0004\u0005\u000e%\u0004\rA!\u0015\u0002\r]\f7.Z;q\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            void $plus$eq_elem;
            Tuple2 tuple2;
            this.selector().send(responseSend);
            scala.collection.mutable.Map<String, RequestChannel.Response> map = this.inflightResponses();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)connectionId, (Object)response);
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            if (map == null) {
                throw null;
            }
            map.addOne((Object)$plus$eq_elem);
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RequestHeader parseRequestHeader(ByteBuffer buffer) {
        void var2_2;
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        if (!header.apiKey().isEnabled) {
            throw new InvalidRequestException(new StringBuilder(38).append("Received request for disabled api key ").append(header.apiKey()).toString());
        }
        return var2_2;
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = this.parseRequestHeader(receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> $this.time.nanoseconds())) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data.clientSoftwareName(), apiVersionsRequest.data.clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                Option option = this.inflightResponses().remove((Object)send.destination());
                if (option == null) {
                    throw null;
                }
                Option getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processCompletedSends$2(send);
                }
                Object var4_2 = null;
                RequestChannel.Response response = (RequestChannel.Response)getOrElse_this.get();
                this.updateRequestMetrics(response);
                Option<Function1<Send, BoxedUnit>> option2 = response.onComplete();
                if (option2 == null) {
                    throw null;
                }
                Option<Function1<Send, BoxedUnit>> foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    ((Function1)foreach_this.get()).apply(send);
                }
                Object var5_4 = null;
                this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destination());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        Option<KafkaChannel> option = this.openOrClosingChannel(request.context().connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> fold_this = option;
        long l = fold_this.isEmpty() ? 0L : ((KafkaChannel)fold_this.get()).getAndResetNetworkThreadTimeNanos();
        Object var3_3 = null;
        request.updateRequestMetrics(l, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                Option<ConnectionId> option = this.ConnectionId().fromString((String)connectionId);
                if (option == null) {
                    throw null;
                }
                Option<ConnectionId> getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processDisconnected$2(connectionId);
                }
                Object var4_2 = null;
                String remoteHost = ((ConnectionId)getOrElse_this.get()).remoteHost();
                Option option2 = this.inflightResponses().remove(connectionId);
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
                    this.updateRequestMetrics(response);
                }
                Object var5_4 = null;
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$close$4(this, connectionId, kafkaChannel);
        }
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        Object[] objectArray = new Tuple2[1];
        String $minus$greater$extension_y = ((Object)this.id()).toString();
        String $minus$greater$extension_$this = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        Option option = Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)) : orElse_this;
        return option2;
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ((KafkaChannel)foreach_this.get()).handleChannelMuteEvent(event);
        }
    }

    private void tryUnmuteChannel(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$tryUnmuteChannel$1(this, kafkaChannel);
        }
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        Object[] objectArray = new Tuple2[1];
        String $minus$greater$extension_y = ((Object)this.id()).toString();
        String $minus$greater$extension_$this = "networkProcessor";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$2() {
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        Option option = Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags())));
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        double d = fold_this.isEmpty() ? 0.0 : Processor.$anonfun$new$3((KafkaMetric)fold_this.get());
        return d;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processCompletedSends$2(Send send$1) {
        throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send$1.destination()).append(" completed, but not in `inflightResponses`").toString());
    }

    public static final /* synthetic */ long $anonfun$updateRequestMetrics$1() {
        return 0L;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processDisconnected$2(String connectionId$2) {
        throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId$2).toString());
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        Option option = $this.inflightResponses().remove((Object)connectionId$3);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
            $this.updateRequestMetrics(response);
        }
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        Object[] objectArray = new Tuple2[2];
        String string = listenerName.value();
        String $minus$greater$extension_$this = Processor$.MODULE$.ListenerMetricTag();
        Object var17_17 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        String string2 = ((Object)id).toString();
        String $minus$greater$extension_$this2 = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var19_19 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.metricTags = AsJavaExtensions.MutableMapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (scala.collection.mutable.Map)((scala.collection.mutable.Map)MapFactory.apply$((MapFactory)LinkedHashMap$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        Object[] objectArray2 = new Tuple2[1];
        String string3 = ((Object)id).toString();
        String $minus$greater$extension_$this3 = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var21_21 = null;
        string3 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext));
        this.nextConnectionIndex = 0;
    }

    public static final /* synthetic */ Object $anonfun$updateRequestMetrics$2$adapted(KafkaChannel x$19) {
        return BoxesRunTime.boxToLong((long)x$19.getAndResetNetworkThreadTimeNanos());
    }

    public static final /* synthetic */ Object $anonfun$close$4$adapted(Processor $this, String connectionId$3, KafkaChannel channel) {
        Processor.$anonfun$close$4($this, connectionId$3, channel);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleChannelMuteEvent$1$adapted(KafkaChannel.ChannelMuteEvent event$1, KafkaChannel c) {
        c.handleChannelMuteEvent(event$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryUnmuteChannel$1$adapted(Processor $this, KafkaChannel c) {
        Processor.$anonfun$tryUnmuteChannel$1($this, c);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$3$adapted(KafkaMetric m) {
        return BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m));
    }

    public static final /* synthetic */ Object $anonfun$processCompletedSends$3$adapted(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processDisconnected$3$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$close$6$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return this.localPort();
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return this.remotePort();
                }
                case 4: {
                    return this.index();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "localHost";
                }
                case 1: {
                    return "localPort";
                }
                case 2: {
                    return "remoteHost";
                }
                case 3: {
                    return "remotePort";
                }
                case 4: {
                    return "index";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            int finalizeHash_length = 5;
            return Statics.avalanche((int)(n ^ finalizeHash_length));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            if (this.localPort() != connectionId.localPort()) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

