/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.log.LogManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001A\u0002\u0013\u0005\u0011\u0006C\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\t\r]\u0002\u0001\u0015)\u0003+\u0011\u001dA\u0004A1A\u0005\u0002eBaA\u0011\u0001!\u0002\u0013Q\u0004bB\"\u0001\u0005\u0004%\t!\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001e\t\u000f\u0015\u0003!\u0019!C\u0001\r\"1q\n\u0001Q\u0001\n\u001dCq\u0001\u0015\u0001C\u0002\u0013\u0005a\t\u0003\u0004R\u0001\u0001\u0006Ia\u0012\u0005\u0006%\u0002!\te\u0015\u0005\u0006;\u0002!\ta\u0015\u0005\u0006E\u0002!\ta\u0015\u0005\u0006I\u0002!\ta\u0015\u0005\u0006M\u0002!\ta\u0015\u0005\u0006Q\u0002!I!\u001b\u0005\t\u0003'\u0001\u0001\u0015\"\u0003\u0002\u0016!1\u0011q\u0005\u0001\u0005\u0002MCa!!\u000b\u0001\t\u0003\u0019\u0006BBA\u0017\u0001\u0011\u00051K\u0001\nTKJ4XM]*ikR$wn\u001e8UKN$(BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u001b\u0003\tQ8.\u0003\u0002$A\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\r\u0002\r\r|gNZ5h+\u0005Q\u0003CA\u0014,\u0013\ta\u0003DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005+:LG\u000fC\u00047\u0007\u0005\u0005\t\u0019\u0001\u0016\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\t!|7\u000f^\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005Y\u0006twMC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$AB*ue&tw-A\u0003i_N$\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\u0006g\u0016tG/M\u000b\u0002\u000fB\u0019\u0001*\u0014\u001e\u000e\u0003%S!AS&\u0002\u0013%lW.\u001e;bE2,'B\u0001'2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d&\u0013A\u0001T5ti\u000611/\u001a8uc\u0001\nQa]3oiJ\naa]3oiJ\u0002\u0013!B:fiV\u0003H#A\u0018)\u00055)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015QWO\\5u\u0015\u0005Q\u0016aA8sO&\u0011Al\u0016\u0002\u0007\u0005\u00164wN]3\u0002#Q,7\u000f^\"mK\u0006t7\u000b[;uI><h\u000e\u000b\u0002\u000f?B\u0011a\u000bY\u0005\u0003C^\u0013A\u0001V3ti\u00069C/Z:u\u00072,\u0017M\\*ikR$wn\u001e8XSRDG)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3eQ\tyq,A\u0012uKN$8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9)\u0005Ay\u0016a\r;fgR\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f\u001d#vKR{7i\u001c:skB$Hj\\4tQ\t\tr,A\u0013wKJLg-_\"mK\u0006t7\u000b[;uI><h.\u00114uKJ4\u0015-\u001b7fIN#\u0018M\u001d;vaV\u0011!N\u001e\u000b\u0004W\u0006EACA\u0018m\u0011\u0015i'\u0003q\u0001o\u0003E)\u0007pY3qi&|gn\u00117bgN$\u0016m\u001a\t\u0004_J$X\"\u00019\u000b\u0005E\f\u0014a\u0002:fM2,7\r^\u0005\u0003gB\u0014\u0001b\u00117bgN$\u0016m\u001a\t\u0003kZd\u0001\u0001B\u0003x%\t\u0007\u0001PA\u0001F#\tIH\u0010\u0005\u00021u&\u001110\r\u0002\b\u001d>$\b.\u001b8h!\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007a\u0012A\u0002\u001fs_>$h(C\u00013\u0013\r\tI!M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0013\u0015C8-\u001a9uS>t'bAA\u0005c!)\u0001F\u0005a\u0001U\u00051\u0012n\u001d(p]\u0012\u000bW-\\8o\u0017\u000647.\u0019+ie\u0016\fG\r\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\u0019\u0002\u001a%\u0019\u00111D\u0019\u0003\u000f\t{w\u000e\\3b]\"9\u0011qD\nA\u0002\u0005\u0005\u0012!\u0001;\u0011\u0007m\n\u0019#C\u0002\u0002&q\u0012a\u0001\u00165sK\u0006$\u0017\u0001\b<fe&4\u0017PT8o\t\u0006,Wn\u001c8UQJ,\u0017\rZ:Ti\u0006$Xo]\u0001\u0018i\u0016\u001cHoQ8og\u0016\u001cW\u000f^5wKNCW\u000f\u001e3po:D#!F0\u0002AQ,7\u000f^\"p]R\u0014x\u000e\u001c7feNCW\u000f\u001e3po:$UO]5oON+g\u000e\u001a\u0015\u0003-}\u0003")
public class ServerShutdownTest
extends ZooKeeperTestHarness {
    private KafkaConfig config = null;
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testCleanShutdown() {
        Nil$ nil$;
        Nil$ nil$2;
        Nil$ nil$3;
        Time time;
        KafkaConfig x$1 = this.config();
        Option x$22 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        Nil$ nil$4 = nil$3 = Nil$.MODULE$;
        nil$3 = null;
        Nil$ x$42 = nil$4;
        KafkaServer server = new KafkaServer(x$1, x$3, x$22, (Seq)x$42);
        server.startup();
        KafkaProducer kafkaProducer = ServerShutdownTest.createProducer$1(server);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), new Properties());
        List<String> list = this.sent1();
        if (list == null) {
            throw null;
        }
        List<String> map_this = list;
        if (map_this == Nil$.MODULE$) {
            nil$2 = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            String string = (String)map_this.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)kafkaProducer.send(new ProducerRecord(this.topic(), (Object)0, (Object)string)), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                string = (String)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)kafkaProducer.send(new ProducerRecord(this.topic(), (Object)0, (Object)string)), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$2 = map_h;
        }
        Nil$ nil$5 = nil$2;
        Object var11_9 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Object var15_15 = null;
        nil$2 = null;
        Nil$ foreach_these = nil$5;
        while (!foreach_these.isEmpty()) {
            RecordMetadata cfr_ignored_0 = (RecordMetadata)((Future)foreach_these.head()).get();
            foreach_these = (List)foreach_these.tail();
        }
        Object var9_16 = null;
        server.shutdown();
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        kafkaProducer.close();
        server = new KafkaServer(this.config(), Time.SYSTEM, (Option)None$.MODULE$, (Seq)Nil$.MODULE$);
        server.startup();
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), this.topic(), 0, 15000L);
        kafkaProducer = ServerShutdownTest.createProducer$1(server);
        KafkaConsumer consumer = ServerShutdownTest.createConsumer$1(server);
        consumer.subscribe((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})))).asJava());
        List<String> list2 = this.sent1();
        if (list2 == null) {
            throw null;
        }
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, SeqOps.size$(list2), 15000L);
        Assert.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        List<String> list3 = this.sent2();
        if (list3 == null) {
            throw null;
        }
        List<String> map_this2 = list3;
        if (map_this2 == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            String string = (String)map_this2.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)kafkaProducer.send(new ProducerRecord(this.topic(), (Object)0, (Object)string)), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this2.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                string = (String)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)kafkaProducer.send(new ProducerRecord(this.topic(), (Object)0, (Object)string)), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$6 = nil$;
        Object var17_19 = null;
        Object var18_22 = null;
        Object var19_23 = null;
        Object var20_24 = null;
        Object var21_25 = null;
        nil$ = null;
        Nil$ foreach_these2 = nil$6;
        while (!foreach_these2.isEmpty()) {
            RecordMetadata cfr_ignored_1 = (RecordMetadata)((Future)foreach_these2.head()).get();
            foreach_these2 = (List)foreach_these2.tail();
        }
        Object var10_26 = null;
        List<String> list4 = this.sent2();
        if (list4 == null) {
            throw null;
        }
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, SeqOps.size$(list4), 15000L);
        Assert.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        kafkaProducer.close();
        server.shutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownWithDeleteTopicEnabled() {
        Nil$ nil$;
        Time time;
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        newProps.setProperty("delete.topic.enable", "true");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        Nil$ nil$2 = nil$ = Nil$.MODULE$;
        nil$ = null;
        Nil$ x$4 = nil$2;
        KafkaServer server = new KafkaServer(newConfig, x$3, x$2, (Seq)x$4);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        this.verifyCleanShutdownAfterFailedStartup(newConfig, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    @Test
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs() {
        KafkaServer server = new KafkaServer(this.config(), Time.SYSTEM, (Option)None$.MODULE$, (Seq)Nil$.MODULE$);
        server.startup();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), new Properties());
        server.shutdown();
        server.awaitShutdown();
        this.config().logDirs().foreach((Function1 & Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        this.verifyCleanShutdownAfterFailedStartup(this.config(), ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(KafkaConfig config, ClassTag<E> exceptionClassTag) {
        Nil$ nil$;
        Time time;
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        Nil$ nil$2 = nil$ = Nil$.MODULE$;
        nil$ = null;
        Nil$ x$4 = nil$2;
        KafkaServer server = new KafkaServer(config, x$3, x$2, (Seq)x$4);
        try {
            try {
                server.startup();
                Assert.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e).toString(), (boolean)exceptionClassTag.runtimeClass().isInstance(e));
                Assert.assertEquals((long)NotRunning$.MODULE$.state(), (long)server.brokerState().currentState());
            }
        }
        finally {
            if (server.brokerState().currentState() != NotRunning$.MODULE$.state()) {
                server.shutdown();
            }
            server.awaitShutdown();
        }
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    public void verifyNonDaemonThreadsStatus() {
        void var8_10;
        Object var3_3;
        Object[] map$extension_$this = Thread.getAllStackTraces().keySet().toArray();
        int n = map$extension_$this.length;
        Thread[] map$extension_ys = new Thread[n];
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                Thread array_update_value;
                Thread thread;
                Thread thread2 = thread = (Thread)map$extension_$this[map$extension_i];
                thread = null;
                map$extension_ys[map$extension_i] = array_update_value = thread2;
                Object var13_6 = null;
            }
        }
        void v1 = var3_3;
        Object var2_1 = null;
        var3_3 = null;
        Object var1_7 = v1;
        void v2 = var1_7;
        var1_7 = null;
        void count$extension_$this = v2;
        int count$extension_res = 0;
        for (Object var10_12 : count$extension_$this) {
            void v3 = var10_12;
            var10_12 = null;
            void var11_13 = v3;
            if (!this.isNonDaemonKafkaThread((Thread)var11_13)) continue;
            ++count$extension_res;
        }
        Object var6_8 = null;
        Assert.assertEquals((long)0L, (long)((long)var8_10));
    }

    @Test
    public void testConsecutiveShutdown() {
        KafkaServer server = new KafkaServer(this.config(), Time.SYSTEM, (Option)None$.MODULE$, (Seq)Nil$.MODULE$);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerShutdownDuringSend() {
        ObjectRef objectRef;
        ObjectRef objectRef2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef objectRef3 = objectRef2 = new ObjectRef(null);
        objectRef2 = null;
        ObjectRef serverSocket = objectRef3;
        ObjectRef objectRef4 = objectRef = new ObjectRef(null);
        objectRef = null;
        ObjectRef controllerChannelManager = objectRef4;
        try {
            void apply_elems;
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            Map$ map$ = Predef$.MODULE$.Map();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)0L)});
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.empty())).asJava(), (Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$6 -> x$6.node(listenerName))).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private static final KafkaProducer createProducer$1(KafkaServer server) {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), SecurityProtocol.PLAINTEXT);
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        return TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl);
    }

    private static final KafkaConsumer createConsumer$1(KafkaServer server) {
        None$ none$;
        None$ none$2;
        String string;
        String string2;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), SecurityProtocol.PLAINTEXT);
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String string3 = string2 = "group";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$6 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$10 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$11 = none$4;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$10, (Option<Properties>)x$11, x$3, x$4);
    }

    public static final /* synthetic */ Future $anonfun$testCleanShutdown$1(ServerShutdownTest $this, ObjectRef producer$1, String value) {
        return ((KafkaProducer)producer$1.elem).send(new ProducerRecord($this.topic(), (Object)0, (Object)value));
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testCleanShutdown$2(Future x$1) {
        return (RecordMetadata)x$1.get();
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assert.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assert.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Future $anonfun$testCleanShutdown$5(ServerShutdownTest $this, ObjectRef producer$1, String value) {
        return ((KafkaProducer)producer$1.elem).send(new ProducerRecord($this.topic(), (Object)0, (Object)value));
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testCleanShutdown$6(Future x$3) {
        return (RecordMetadata)x$3.get();
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File[] foreach$extension_$this = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString()).listFiles();
        int n = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < n; ++foreach$extension_i) {
            TestUtils$.MODULE$.appendNonsenseToFile(foreach$extension_$this[foreach$extension_i], TestUtils$.MODULE$.random().nextInt(1024) + 1);
        }
    }

    public static final /* synthetic */ Thread $anonfun$verifyNonDaemonThreadsStatus$1(Object x$5) {
        return (Thread)x$5;
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }

    public static final /* synthetic */ Object $anonfun$verifyNonDaemonThreadsStatus$2$adapted(ServerShutdownTest $this, Thread t) {
        return BoxesRunTime.boxToBoolean((boolean)$this.isNonDaemonKafkaThread(t));
    }

    public static final /* synthetic */ Object $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$2$adapted(File f) {
        TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
        return BoxedUnit.UNIT;
    }
}

