/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004u\u0001\u0001\u0007I\u0011A;\t\r]\u0004\u0001\u0015)\u0003<\u0011\u001dA\b\u00011A\u0005\u0002eDqA \u0001A\u0002\u0013\u0005q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u0002>\t\r\u0005\u0015\u0001\u0001\"\u0001p\u0011\u0019\tI\u0002\u0001C\u0001_\"1\u00111\u0005\u0001\u0005\u0002=Da!!\f\u0001\t\u0003y\u0007BBA\u0019\u0001\u0011\u0005q\u000e\u0003\u0004\u00026\u0001!\ta\u001c\u0005\u0007\u0003s\u0001A\u0011A8\t\r\u0005u\u0002\u0001\"\u0001p\u0011\u0019\t\t\u0005\u0001C\u0001_\"1\u0011Q\t\u0001\u0005\u0002=Da!!\u0013\u0001\t\u0003y\u0007BBA'\u0001\u0011\u0005q\u000eC\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0019!\u0001\t\u0001\u0001B\u0011%)eC!A!\u0002\u00131\u0015\n\u0003\u0005K-\t\u0005\t\u0015!\u0003L\u0011!QfC!b\u0001\n\u0003Y\u0006\u0002\u0003/\u0017\u0005\u0003\u0005\u000b\u0011B&\t\u000bU2B\u0011A/\t\u000f\u00054\u0002\u0019!C\u0001E\"9aM\u0006a\u0001\n\u00039\u0007BB7\u0017A\u0003&1\rC\u0003o-\u0011\u0005q\u000eC\u0003q-\u0011\u0005\u0013\u000fC\u0003s-\u0011\u0005s\u000eC\u0003t-\u0011\u0005snB\u0005\u0002\u0010\u0002\t\t\u0011#\u0001\u0002\u0012\u001aA\u0001\tAA\u0001\u0012\u0003\t\u0019\n\u0003\u00046I\u0011\u0005\u0011Q\u0013\u0005\n\u0003/#\u0013\u0013!C\u0001\u00033C\u0011\"a,%#\u0003%\t!!'\u0003)\u0011+G.Y=fI>\u0003XM]1uS>tG+Z:u\u0015\tQ3&\u0001\u0004tKJ4XM\u001d\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\naV\u0014x-\u0019;pef,\u0012a\u000f\t\u0004qqr\u0014BA\u001f*\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0005}2R\"\u0001\u0001\u0003)5{7m\u001b#fY\u0006LX\rZ(qKJ\fG/[8o'\t1\"\t\u0005\u00029\u0007&\u0011A)\u000b\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fq\u0001Z3mCfl5\u000f\u0005\u00021\u000f&\u0011\u0001*\r\u0002\u0005\u0019>tw-\u0003\u0002F\u0007\u00069An\\2l\u001fB$\bc\u0001\u0019M\u001d&\u0011Q*\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016!\u00027pG.\u001c(BA*U\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003+Z\u000bA!\u001e;jY*\tq+\u0001\u0003kCZ\f\u0017BA-Q\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006y!/Z:q_:\u001cX\rT8dW>\u0003H/F\u0001L\u0003A\u0011Xm\u001d9p]N,Gj\\2l\u001fB$\b\u0005\u0006\u0003?=~\u0003\u0007\"B#\u001c\u0001\u00041\u0005b\u0002&\u001c!\u0003\u0005\ra\u0013\u0005\b5n\u0001\n\u00111\u0001L\u0003-\u0019w.\u001c9mKR\f'\r\\3\u0016\u0003\r\u0004\"\u0001\r3\n\u0005\u0015\f$a\u0002\"p_2,\u0017M\\\u0001\u0010G>l\u0007\u000f\\3uC\ndWm\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003a%L!A[\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bYv\t\t\u00111\u0001d\u0003\rAH%M\u0001\rG>l\u0007\u000f\\3uC\ndW\rI\u0001\u0010C^\f\u0017\u000e^#ya&\u0014\u0018\r^5p]R\t\u0001.A\u0006uef\u001cu.\u001c9mKR,G#A2\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\u0002\u0015=t7i\\7qY\u0016$X-A\u0007qkJ<\u0017\r^8ss~#S-\u001d\u000b\u0003QZDq\u0001\\\u0002\u0002\u0002\u0003\u00071(\u0001\u0006qkJ<\u0017\r^8ss\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002uB\u00111\u0010`\u0007\u0002%&\u0011QP\u0015\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019R\r_3dkR|'oU3sm&\u001cWm\u0018\u0013fcR\u0019\u0001.!\u0001\t\u000f14\u0011\u0011!a\u0001u\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0004\u0011\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003'\t1a\u001c:h\u0013\u0011\t9\"!\u0004\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007fA\u0005\u0002\u001eA!\u00111BA\u0010\u0013\u0011\t\t#!\u0004\u0003\u000b\u00053G/\u001a:\u0002/Q,7\u000f\u001e*fcV,7\u000f^*bi&\u001ch-Y2uS>t\u0007f\u0001\u0006\u0002(A!\u00111BA\u0015\u0013\u0011\tY#!\u0004\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cHOU3rk\u0016\u001cH/\u0012=qSJL\bfA\u0006\u0002(\u0005\tB/Z:u\t\u0016d\u0017-_3e\rV$XO]3)\u00071\t9#\u0001\tuKN$(+Z9vKN$\b+\u001e:hK\"\u001aQ\"a\n\u0002]MDw.\u001e7e\u0007\u0006t7-\u001a7G_J\\U-\u001f*fiV\u0014h.\u001b8h\u0007\u0006t7-\u001a7mK\u0012|\u0005/\u001a:bi&|gn\u001d\u0015\u0004\u001d\u0005\u001d\u0012!O:i_VdGMU3ukJtg*\u001b7Pa\u0016\u0014\u0018\r^5p]N|enQ1oG\u0016dgi\u001c:LKf<\u0006.\u001a8LKf$u.Z:oi\u0016C\u0018n\u001d;)\u0007=\t9#A\u000fuKN$HK]=D_6\u0004H.\u001a;f\u0019>\u001c7nQ8oi\u0016tG/[8oQ\r\u0001\u0012qE\u0001#i\u0016\u001cH\u000f\u0016:z\u0007>l\u0007\u000f\\3uK^KG\u000f['vYRL\u0007\u000f\\3UQJ,\u0017\rZ:)\u0007E\t9#\u0001\ruKN$H)\u001a7bs\u0016$w\n]3sCRLwN\u001c'pG.D3AEA\u0014\u0003\u0001\"Xm\u001d;EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]2{7m[(wKJ\u0014\u0018\u000eZ3)\u0007M\t9#\u0001\u000ewKJLg-\u001f#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7\u000eF\u0003i\u0003+\ny\u0006\u0003\u0005\u0002XQ!\t\u0019AA-\u0003QiwnY6EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B!\u0001'a\u0017?\u0013\r\ti&\r\u0002\ty\tLh.Y7f}!1\u0011\u0011\r\u000bA\u0002\r\fq\"\\5t[\u0006$8\r[3e\u0019>\u001c7n]\u0001\u0013eVtwJ\\!o_RDWM\u001d+ie\u0016\fG\r\u0006\u0004\u0002h\u0005\u0015\u00151\u0012\u0019\u0005\u0003S\n\u0019\bE\u0003|\u0003W\ny'C\u0002\u0002nI\u0013aAR;ukJ,\u0007\u0003BA9\u0003gb\u0001\u0001B\u0006\u0002vU\t\t\u0011!A\u0003\u0002\u0005]$aA0%eE!\u0011\u0011PA@!\r\u0001\u00141P\u0005\u0004\u0003{\n$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005\u0005\u0015bAABc\t\u0019\u0011I\\=\t\u0011\u0005\u001dU\u0003\"a\u0001\u0003\u0013\u000b1AZ;o!\u0011\u0001\u00141\f5\t\r\u00055U\u00031\u0001d\u00039\u0019\bn\\;mI\u000e{W\u000e\u001d7fi\u0016\fA#T8dW\u0012+G.Y=fI>\u0003XM]1uS>t\u0007CA %'\t!s\u0006\u0006\u0002\u0002\u0012\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a'+\u0007-\u000bij\u000b\u0002\u0002 B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!C;oG\",7m[3e\u0015\r\tI+M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAW\u0003G\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;
    private ExecutorService executorService = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", 0, 1000, true, true));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
    }

    @Test
    public void testRequestSatisfaction() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString(), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        AtomicInteger result = new AtomicInteger();
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        .colon.colon futures1 = new .colon.colon(CompletableFuture.completedFuture(10), (List)new .colon.colon(CompletableFuture.completedFuture(11), (List)Nil$.MODULE$));
        DelayedFuture r1 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$5((List)futures1, result)));
        Assert.assertTrue((String)"r1 not completed", (boolean)r1.isCompleted());
        Assert.assertEquals((long)21L, (long)result.get());
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures2 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$6((List)futures2, result)));
        Assert.assertFalse((String)"r2 should be incomplete", (boolean)r2.isCompleted());
        ((CompletableFuture)futures2.head()).complete(20);
        Assert.assertFalse((boolean)r2.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        int apply_n = 1;
        ((CompletableFuture)LinearSeqOps.apply$((LinearSeqOps)futures2, (int)apply_n)).complete(21);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!r2.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("r2 not completed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$9(result)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("callback not invoked", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertTrue((String)"Thread not created for executing delayed task", (boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        .colon.colon futures3 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(CompletableFuture.completedFuture(31), (List)Nil$.MODULE$));
        DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$11((List)futures3, result)));
        Assert.assertFalse((String)"r3 should be incomplete", (boolean)r3.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures3.head()).complete(30);
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!r3.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                throw Assertions$.MODULE$.fail("r3 not completed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l5, l6));
        }
        long l7 = 15000L;
        long l8 = 100L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$14(result)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + l7) {
                throw Assertions$.MODULE$.fail("callback not invoked", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l7, l8));
        }
        result.set(-1);
        long start = Time.SYSTEM.hiResClockMs();
        long expirationMs = 2000L;
        .colon.colon futures4 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
        DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.$anonfun$testDelayedFuture$16((List)futures4, result)));
        ((CompletableFuture)futures4.head()).complete(40);
        long l9 = 15000L;
        long l10 = 100L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$17((List)futures4)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + l9) {
                throw Assertions$.MODULE$.fail("r4 futures not expired", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l9, l10));
        }
        Assert.assertTrue((String)"r4 not completed after timeout", (boolean)r4.isCompleted());
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expirationMs).toString(), (elapsed >= expirationMs ? 1 : 0) != 0);
        Assert.assertEquals((Object)40, ((CompletableFuture)futures4.head()).get());
        Assert.assertEquals(TimeoutException.class, ((Throwable)Assertions$.MODULE$.intercept(() -> DelayedOperationTest.$anonfun$testDelayedFuture$19((List)futures4), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("DelayedOperationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141))).getCause().getClass());
        Assert.assertEquals((long)40L, (long)result.get());
    }

    @Test
    public void testRequestPurge() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)2L, (long)this.purgatory().numDelayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString(), (long)1L, (long)this.purgatory().numDelayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        if (cancelledOperations == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)cancelledOperations));
        Assert.assertEquals((long)1L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTryCompleteLockContention() {
        Object var8_7;
        void runOnAnotherThread_shouldComplete;
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        AtomicInteger completionAttemptsRemaining = new AtomicInteger(Integer.MAX_VALUE);
        Semaphore tryCompleteSemaphore = new Semaphore(1);
        String key = "key";
        MockDelayedOperation op = new MockDelayedOperation(this, completionAttemptsRemaining, tryCompleteSemaphore){
            private final AtomicInteger completionAttemptsRemaining$1;
            private final Semaphore tryCompleteSemaphore$1;

            public boolean tryComplete() {
                boolean bl;
                boolean shouldComplete = this.completionAttemptsRemaining$1.decrementAndGet() <= 0;
                this.tryCompleteSemaphore$1.acquire();
                try {
                    bl = shouldComplete ? this.forceComplete() : false;
                }
                finally {
                    this.tryCompleteSemaphore$1.release();
                }
                return bl;
            }
            {
                this.completionAttemptsRemaining$1 = completionAttemptsRemaining$1;
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
                super($outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
            }
        };
        this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})));
        completionAttemptsRemaining.set(2);
        tryCompleteSemaphore.acquire();
        boolean bl = false;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> this.purgatory().checkAndComplete((Object)key);
        Future<?> runOnAnotherThread_future = this.executorService().submit(new Runnable(null, (Function0)runOnAnotherThread_fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future.isDone());
        }
        void v0 = var8_7;
        Object var6_6 = null;
        var8_7 = null;
        void future = v0;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tryCompleteSemaphore.hasQueuedThreads()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Not attempting to complete", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.purgatory().checkAndComplete((Object)key);
        Assert.assertFalse((String)"Operation should not have completed", (boolean)op.isCompleted());
        tryCompleteSemaphore.release();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTryCompleteWithMultipleThreads() {
        IndexedSeq indexedSeq;
        IndexedSeq indexedSeq2;
        public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
        extends MockDelayedOperation {
            private final String key;
            private final AtomicInteger completionAttemptsRemaining;
            private final Random random$1;
            private final int maxDelayMs$1;

            public String key() {
                return this.key;
            }

            public AtomicInteger completionAttemptsRemaining() {
                return this.completionAttemptsRemaining;
            }

            public boolean tryComplete() {
                boolean shouldComplete = this.completable();
                Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                if (shouldComplete) {
                    return this.forceComplete();
                }
                return false;
            }

            public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                this.random$1 = random$1;
                this.maxDelayMs$1 = maxDelayMs$1;
                if ($outer.MockDelayedOperation() == null) {
                    throw null;
                }
                if ($outer.MockDelayedOperation() == null) {
                    throw null;
                }
                super($outer, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
                this.key = new StringBuilder(3).append("key").append(index).toString();
                this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
            }
        }
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 var11_10;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        int n = 0;
        int until$extension_end = 100;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Kafka_server_DelayedOperationTest$TestDelayOperation$1 var20_12;
            Kafka_server_DelayedOperationTest$TestDelayOperation$1 v0 = var20_12 = DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)object));
            var20_12 = null;
            var11_10 = v0;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            var11_10 = null;
        }
        IndexedSeq indexedSeq3 = indexedSeq2 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var8_7 = null;
        Object var9_8 = null;
        Object var10_9 = null;
        var11_10 = null;
        indexedSeq2 = null;
        IndexedSeq ops = indexedSeq3;
        int n2 = 1;
        Range.Inclusive flatMap_this = new Range.Inclusive(n2, completionAttempts, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            IndexedSeq indexedSeq4;
            IndexedSeq indexedSeq5 = indexedSeq4 = DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)object));
            indexedSeq4 = null;
            indexedSeq = indexedSeq5;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            indexedSeq = null;
        }
        Object var15_17 = null;
        Object var16_18 = null;
        indexedSeq = null;
        Object var13_16 = null;
        ((IterableOnceOps)flatMap_strictOptimizedFlatMap_b.result()).foreach((Function1 & Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable)() -> {
            if (this.MockDelayedOperation() == null) {
                throw null;
            }
            if (this.MockDelayedOperation() == null) {
                throw null;
            }
            return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        }, false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable)() -> this.newMockOperation$1(), false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable)() -> new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock())), true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        Object var49_70;
        Object var43_50;
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        Object var37_32;
        Object var31_22;
        ObjectRef objectRef;
        IndexedSeq indexedSeq;
        IndexedSeq indexedSeq2;
        Object var23_10;
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        int createDelayedOperations$1_count = 2;
        int n = 1;
        Range.Inclusive createDelayedOperations$1_map_this = new Range.Inclusive(n, createDelayedOperations$1_count, 1);
        createDelayedOperations$1_map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder createDelayedOperations$1_map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator createDelayedOperations$1_map_strictOptimizedMap_it = createDelayedOperations$1_map_this.iterator();
        while (createDelayedOperations$1_map_strictOptimizedMap_it.hasNext()) {
            void createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem;
            Object var58_11;
            Integer cfr_ignored_0 = (Integer)createDelayedOperations$1_map_strictOptimizedMap_it.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)mockDelayedOperation.apply());
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            Object var53_9 = var58_11 = null;
            void v0 = var53_9;
            var53_9 = null;
            var23_10 = v0;
            if (createDelayedOperations$1_map_strictOptimizedMap_b == null) {
                throw null;
            }
            createDelayedOperations$1_map_strictOptimizedMap_b.addOne((Object)createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem);
            var23_10 = null;
        }
        IndexedSeq indexedSeq3 = indexedSeq2 = (IndexedSeq)createDelayedOperations$1_map_strictOptimizedMap_b.result();
        Object var20_6 = null;
        Object var21_7 = null;
        Object var22_8 = null;
        var23_10 = null;
        indexedSeq2 = null;
        IndexedSeq indexedSeq4 = indexedSeq = indexedSeq3;
        indexedSeq = null;
        IndexedSeq create_e = indexedSeq4;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var50_14 = null;
        objectRef = null;
        ObjectRef ops = objectRef2;
        this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        int createDelayedOperations$1_count2 = 2;
        int n2 = 1;
        Range.Inclusive createDelayedOperations$1_map_this2 = new Range.Inclusive(n2, createDelayedOperations$1_count2, 1);
        createDelayedOperations$1_map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder createDelayedOperations$1_map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        Iterator createDelayedOperations$1_map_strictOptimizedMap_it2 = createDelayedOperations$1_map_this2.iterator();
        while (createDelayedOperations$1_map_strictOptimizedMap_it2.hasNext()) {
            void createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem;
            Object var59_24;
            Integer cfr_ignored_1 = (Integer)createDelayedOperations$1_map_strictOptimizedMap_it2.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)mockDelayedOperation.apply());
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            Object var54_23 = var59_24 = null;
            void v4 = var54_23;
            var54_23 = null;
            var31_22 = v4;
            if (createDelayedOperations$1_map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            createDelayedOperations$1_map_strictOptimizedMap_b2.addOne((Object)createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem);
            var31_22 = null;
        }
        Object var28_19 = null;
        Object var29_20 = null;
        Object var30_21 = null;
        var31_22 = null;
        ops.elem = (IndexedSeq)createDelayedOperations$1_map_strictOptimizedMap_b2.result();
        Lock inLock_lock = ((DelayedOperation)((scala.collection.immutable.Seq)ops.elem).apply(1)).lock();
        inLock_lock.lock();
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var7_25 = null;
        int createDelayedOperations$1_count3 = 2;
        int n3 = 1;
        Range.Inclusive createDelayedOperations$1_map_this3 = new Range.Inclusive(n3, createDelayedOperations$1_count3, 1);
        createDelayedOperations$1_map_this3.scala$collection$immutable$Range$$validateMaxLength();
        Builder createDelayedOperations$1_map_strictOptimizedMap_b3 = IndexedSeq$.MODULE$.newBuilder();
        Iterator createDelayedOperations$1_map_strictOptimizedMap_it3 = createDelayedOperations$1_map_this3.iterator();
        while (createDelayedOperations$1_map_strictOptimizedMap_it3.hasNext()) {
            void createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem;
            Object var60_34;
            Integer cfr_ignored_2 = (Integer)createDelayedOperations$1_map_strictOptimizedMap_it3.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)mockDelayedOperation.apply());
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            Object var55_33 = var60_34 = null;
            void v5 = var55_33;
            var55_33 = null;
            var37_32 = v5;
            if (createDelayedOperations$1_map_strictOptimizedMap_b3 == null) {
                throw null;
            }
            createDelayedOperations$1_map_strictOptimizedMap_b3.addOne((Object)createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem);
            var37_32 = null;
        }
        Object var34_29 = null;
        Object var35_30 = null;
        Object var36_31 = null;
        var37_32 = null;
        ops.elem = (IndexedSeq)createDelayedOperations$1_map_strictOptimizedMap_b3.result();
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().lock();
        Future<?> runOnAnotherThread_future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future.isDone());
        }
        Object var9_36 = null;
        Object var11_37 = null;
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(1))})), key);
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
            Future<?> runOnAnotherThread_future2 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future2.isDone());
            }
            Object var12_40 = null;
            Object var14_41 = null;
            this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
        Future<?> runOnAnotherThread_future3 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future3.isDone());
        }
        Object var15_43 = null;
        Object var17_44 = null;
        this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
        int createDelayedOperations$1_count4 = 2;
        int n4 = 1;
        Range.Inclusive createDelayedOperations$1_map_this4 = new Range.Inclusive(n4, createDelayedOperations$1_count4, 1);
        createDelayedOperations$1_map_this4.scala$collection$immutable$Range$$validateMaxLength();
        Builder createDelayedOperations$1_map_strictOptimizedMap_b4 = IndexedSeq$.MODULE$.newBuilder();
        Iterator createDelayedOperations$1_map_strictOptimizedMap_it4 = createDelayedOperations$1_map_this4.iterator();
        while (createDelayedOperations$1_map_strictOptimizedMap_it4.hasNext()) {
            void createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem;
            Object var61_52;
            Integer cfr_ignored_3 = (Integer)createDelayedOperations$1_map_strictOptimizedMap_it4.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)mockDelayedOperation.apply());
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key})));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            Object var56_51 = var61_52 = null;
            void v6 = var56_51;
            var56_51 = null;
            var43_50 = v6;
            if (createDelayedOperations$1_map_strictOptimizedMap_b4 == null) {
                throw null;
            }
            createDelayedOperations$1_map_strictOptimizedMap_b4.addOne((Object)createDelayedOperations$1_map_strictOptimizedMap_$plus$eq_elem);
            var43_50 = null;
        }
        Object var40_47 = null;
        Object var41_48 = null;
        Object var42_49 = null;
        var43_50 = null;
        ops.elem = (IndexedSeq)createDelayedOperations$1_map_strictOptimizedMap_b4.result();
        Option<ReentrantLock> option = ((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))).responseLockOpt();
        if (option == null) {
            throw null;
        }
        Option<ReentrantLock> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            void $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete;
            void $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete2;
            ReentrantLock reentrantLock = (ReentrantLock)foreach_this.get();
            boolean bl4 = true;
            JFunction0.mcV.sp & Serializable $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> lock.lock();
            Future<?> $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if ($anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete2 != false) {
                $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)$anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future.isDone());
            }
            Object var64_56 = null;
            Object var66_57 = null;
            try {
                try {
                    this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(1))})), key);
                    Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks);
                }
                catch (IllegalStateException illegalStateException) {
                    Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks);
                }
            }
            catch (Throwable throwable) {
                void $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete3;
                boolean bl5 = true;
                JFunction0.mcV.sp & Serializable $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
                Future<?> $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future2 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
                if ($anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete3 != false) {
                    $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future2.get();
                } else {
                    Assert.assertFalse((String)"Should not have completed", (boolean)$anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future2.isDone());
                }
                Object var67_60 = null;
                Object var69_61 = null;
                this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
                throw throwable;
            }
            boolean bl6 = true;
            JFunction0.mcV.sp & Serializable $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
            Future<?> $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future3 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if ($anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_shouldComplete != false) {
                $anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future3.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)$anonfun$verifyDelayedOperationLock$9_runOnAnotherThread_future3.isDone());
            }
            Object var70_63 = null;
            Object var72_64 = null;
            this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
        }
        Object var6_53 = null;
        int createCompletableOperations$1_count = 2;
        int n5 = 1;
        Range.Inclusive createCompletableOperations$1_map_this = new Range.Inclusive(n5, createCompletableOperations$1_count, 1);
        createCompletableOperations$1_map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder createCompletableOperations$1_map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator createCompletableOperations$1_map_strictOptimizedMap_it = createCompletableOperations$1_map_this.iterator();
        while (createCompletableOperations$1_map_strictOptimizedMap_it.hasNext()) {
            void createCompletableOperations$1_map_strictOptimizedMap_$plus$eq_elem;
            Object var62_72;
            Integer cfr_ignored_4 = (Integer)createCompletableOperations$1_map_strictOptimizedMap_it.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$2_op = (MockDelayedOperation)((Object)mockDelayedOperation.apply());
            $anonfun$verifyDelayedOperationLock$2_op.completable_$eq(true);
            Object var57_71 = var62_72 = null;
            void v9 = var57_71;
            var57_71 = null;
            var49_70 = v9;
            if (createCompletableOperations$1_map_strictOptimizedMap_b == null) {
                throw null;
            }
            createCompletableOperations$1_map_strictOptimizedMap_b.addOne((Object)createCompletableOperations$1_map_strictOptimizedMap_$plus$eq_elem);
            var49_70 = null;
        }
        Object var46_67 = null;
        Object var47_68 = null;
        Object var48_69 = null;
        var49_70 = null;
        ops.elem = (IndexedSeq)createCompletableOperations$1_map_strictOptimizedMap_b.result();
        ((scala.collection.immutable.Seq)ops.elem).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Future<?> future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (shouldComplete) {
            future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
        }
        return var3_3;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        synchronized (this) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
            return;
        }
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$1 -> x$1.getName())).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(new StringBuilder(16).append("DelayedExecutor-").append(purgatoryName$1).toString())));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$4) {
        return (Integer)x$4.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        Nil$ nil$;
        Object var3_18;
        Nil$ nil$2;
        Object var8_7;
        Object var7_6;
        List list;
        Object var16_15;
        Object var15_14;
        Object var14_13;
        Object var13_12;
        Object var12_11;
        Object var11_10;
        Object var10_9;
        Object var9_8;
        Nil$ nil$3;
        boolean filterNot_filterCommon_isFlipped = true;
        List filterNot_filterCommon_noneIn$1_l = futures;
        while (true) {
            if (filterNot_filterCommon_noneIn$1_l.isEmpty()) {
                nil$3 = Nil$.MODULE$;
                break;
            }
            Object filterNot_filterCommon_noneIn$1_h = filterNot_filterCommon_noneIn$1_l.head();
            List filterNot_filterCommon_noneIn$1_t = (List)filterNot_filterCommon_noneIn$1_l.tail();
            if (((CompletableFuture)filterNot_filterCommon_noneIn$1_h).isCompletedExceptionally() != filterNot_filterCommon_isFlipped) {
                List list2;
                block13: {
                    List filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next;
                    List filterNot_filterCommon_noneIn$1_allIn$1_remaining = filterNot_filterCommon_noneIn$1_t;
                    while (true) {
                        if (filterNot_filterCommon_noneIn$1_allIn$1_remaining.isEmpty()) {
                            list2 = filterNot_filterCommon_noneIn$1_l;
                            break block13;
                        }
                        Object filterNot_filterCommon_noneIn$1_allIn$1_x = filterNot_filterCommon_noneIn$1_allIn$1_remaining.head();
                        if (((CompletableFuture)filterNot_filterCommon_noneIn$1_allIn$1_x).isCompletedExceptionally() == filterNot_filterCommon_isFlipped) break;
                        filterNot_filterCommon_noneIn$1_allIn$1_remaining = (List)filterNot_filterCommon_noneIn$1_allIn$1_remaining.tail();
                    }
                    .colon.colon filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filterNot_filterCommon_noneIn$1_l.head(), (List)Nil$.MODULE$);
                    .colon.colon filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead;
                    for (List filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filterNot_filterCommon_noneIn$1_l.tail(); filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess != filterNot_filterCommon_noneIn$1_allIn$1_remaining; filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                        .colon.colon filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                        filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                        filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                    }
                    List filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filterNot_filterCommon_noneIn$1_allIn$1_remaining.tail();
                    while (!filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                        Object filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_head = filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next.head();
                        if (((CompletableFuture)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_head).isCompletedExceptionally() != filterNot_filterCommon_isFlipped) {
                            filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                            continue;
                        }
                        while (filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy != filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next) {
                            .colon.colon filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                            filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                            filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                            filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                        }
                        filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                        filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                    }
                    if (!filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                        filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filterNot_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                    }
                    list2 = var9_8;
                    var9_8 = null;
                    var10_9 = null;
                    var11_10 = null;
                    var12_11 = null;
                    var13_12 = null;
                    var14_13 = null;
                    var15_14 = null;
                    var16_15 = null;
                }
                list = list2;
                nil$3 = list;
                var7_6 = null;
                var8_7 = null;
                var9_8 = null;
                var10_9 = null;
                var11_10 = null;
                var12_11 = null;
                var13_12 = null;
                var14_13 = null;
                var15_14 = null;
                var16_15 = null;
                list = null;
                break;
            }
            filterNot_filterCommon_noneIn$1_l = filterNot_filterCommon_noneIn$1_t;
        }
        Nil$ nil$4 = nil$2 = nil$3;
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        var7_6 = null;
        var8_7 = null;
        var9_8 = null;
        var10_9 = null;
        var11_10 = null;
        var12_11 = null;
        var13_12 = null;
        var14_13 = null;
        var15_14 = null;
        var16_15 = null;
        list = null;
        nil$2 = null;
        Nil$ filterNot_filterCommon_result = nil$4;
        Statics.releaseFence();
        void v3 = var3_18;
        var3_18 = null;
        void map_this = v3;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)((Integer)((CompletableFuture)map_this.head()).get()), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)((Integer)((CompletableFuture)map_rest.head()).get()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$5 = nil$;
        Object var19_19 = null;
        Object var20_21 = null;
        Object var21_22 = null;
        Object var22_23 = null;
        Object var23_24 = null;
        nil$ = null;
        result$1.set(BoxesRunTime.unboxToInt((Object)nil$5.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$5(List futures1$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures1$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$6(List futures2$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures2$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$7(DelayedFuture r2$1) {
        return r2$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$8() {
        return "r2 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$9(AtomicInteger result$1) {
        return result$1.get() == 41;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$10() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$11(List futures3$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures3$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$12(DelayedFuture r3$1) {
        return r3$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$13() {
        return "r3 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$14(AtomicInteger result$1) {
        return result$1.get() == 61;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$15() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$16(List futures4$1, AtomicInteger result$1) {
        DelayedOperationTest.updateResult$1(futures4$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        int apply_n = 1;
        return ((CompletableFuture)LinearSeqOps.apply$((LinearSeqOps)futures4$1, (int)apply_n)).isDone();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$18() {
        return "r4 futures not expired";
    }

    public static final /* synthetic */ Integer $anonfun$testDelayedFuture$19(List futures4$1) {
        int apply_n = 1;
        return (Integer)((CompletableFuture)LinearSeqOps.apply$((LinearSeqOps)futures4$1, (int)apply_n)).get();
    }

    public static final /* synthetic */ boolean $anonfun$testTryCompleteLockContention$2(Semaphore tryCompleteSemaphore$1) {
        return tryCompleteSemaphore$1.hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testTryCompleteLockContention$3() {
        return "Not attempting to complete";
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$1;

            public void run() {
                if (this.op$1.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$1.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$1.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = op$1;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$5) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        });
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    private final MockDelayedOperation newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$2, int x$6) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key$2})));
        Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
        return op;
    }

    /*
     * WARNING - void declaration
     */
    private final scala.collection.immutable.Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$2) {
        int n = 1;
        Range.Inclusive map_this = new Range.Inclusive(n, count, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Object var10_10;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$1_op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
            this.purgatory().tryCompleteElseWatch((DelayedOperation)$anonfun$verifyDelayedOperationLock$1_op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key$2})));
            Assert.assertFalse((String)"Not completable", (boolean)$anonfun$verifyDelayedOperationLock$1_op.isCompleted());
            Object var9_9 = var10_10 = null;
            void v0 = var9_9;
            var9_9 = null;
            Object var8_8 = v0;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            var8_8 = null;
        }
        return (IndexedSeq)map_strictOptimizedMap_b.result();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$7) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final scala.collection.immutable.Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        int n = 1;
        Range.Inclusive map_this = new Range.Inclusive(n, count, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Object var8_8;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            MockDelayedOperation $anonfun$verifyDelayedOperationLock$2_op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
            $anonfun$verifyDelayedOperationLock$2_op.completable_$eq(true);
            Object var7_7 = var8_8 = null;
            void v0 = var7_7;
            var7_7 = null;
            Object var6_6 = v0;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            var6_6 = null;
        }
        return (IndexedSeq)map_strictOptimizedMap_b.result();
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
    }

    private final void checkAndComplete$1(scala.collection.immutable.Seq completableOps, scala.collection.immutable.Seq expectedComplete, String key$2) {
        completableOps.foreach((Function1 & Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$2);
        if (expectedComplete == null) {
            throw null;
        }
        Assert.assertEquals((long)expectedComplete.length(), (long)completed);
        expectedComplete.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        Set set = completableOps.toSet();
        if (set == null) {
            throw null;
        }
        ((Set)set.removedAll((IterableOnce)expectedComplete)).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$6(DelayedOperationTest $this, ObjectRef ops$2, String key$2) {
        $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)ops$2.elem, key$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$2, ReentrantLock lock) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> lock.lock();
        Future<?> runOnAnotherThread_future = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future.isDone());
        }
        Object var6_6 = null;
        Object var8_7 = null;
        try {
            try {
                $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(1))})), key$2);
                Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks$1);
            }
            catch (IllegalStateException illegalStateException) {
                Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks$1);
            }
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
            Future<?> runOnAnotherThread_future2 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future2.isDone());
            }
            Object var9_10 = null;
            Object var11_11 = null;
            $this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), key$2);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
        Future<?> runOnAnotherThread_future3 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)runOnAnotherThread_future3.isDone());
        }
        Object var12_13 = null;
        Object var14_14 = null;
        $this.checkAndComplete$1((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), key$2);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$2, MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key$2}))));
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1$adapted(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, Object index) {
        return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1($this, completionAttempts$1, random$1, maxDelayMs$1, BoxesRunTime.unboxToInt((Object)index));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2$adapted(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, Object x$5) {
        return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2($this, ops$1, random$1, maxDelayMs$1, executor$1, BoxesRunTime.unboxToInt((Object)x$5));
    }

    public static final /* synthetic */ Object $anonfun$verifyDelayedOperationLock$9$adapted(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$2, ReentrantLock lock) {
        DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9($this, ops$2, mismatchedLocks$1, key$2, lock);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDelayedFuture$3$adapted(CompletableFuture x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isCompletedExceptionally());
    }

    public static final /* synthetic */ Object $anonfun$testDelayedFuture$4$adapted(CompletableFuture x$4) {
        return BoxesRunTime.boxToInteger((int)DelayedOperationTest.$anonfun$testDelayedFuture$4(x$4));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1$adapted(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$2, Object x$6) {
        return DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1($this, mockDelayedOperation$1, key$2, BoxesRunTime.unboxToInt((Object)x$6));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2$adapted(Function0 mockDelayedOperation$1, Object x$7) {
        return DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation$1, BoxesRunTime.unboxToInt((Object)x$7));
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            if (this.completable()) {
                return this.forceComplete();
            }
            return false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            Option<ReentrantLock> option = this.responseLockOpt();
            if (option == null) {
                throw null;
            }
            Option<ReentrantLock> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                MockDelayedOperation.$anonfun$onComplete$1((ReentrantLock)foreach_this.get());
            }
            Object var1_1 = null;
            synchronized (this) {
                this.notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }

        public static final /* synthetic */ Object $anonfun$onComplete$1$adapted(ReentrantLock lock) {
            MockDelayedOperation.$anonfun$onComplete$1(lock);
            return BoxedUnit.UNIT;
        }
    }
}

