/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t-b\u0001B\u001a5\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004M\u0001\u0001\u0006IA\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0011\u0019\u0011\u0006\u0001)A\u0005\u001f\"91\u000b\u0001b\u0001\n\u0003q\u0005B\u0002+\u0001A\u0003%q\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r}\u0003\u0001\u0015!\u0003X\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\b]\u0002\u0001\r\u0011\"\u0001p\u0011\u0019)\b\u0001)Q\u0005Q\"9a\u000f\u0001a\u0001\n\u00039\bbB>\u0001\u0001\u0004%\t\u0001 \u0005\u0007}\u0002\u0001\u000b\u0015\u0002=\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0001\u0003'A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003?Aq!!\u0010\u0001\t\u0003\ty\u0002C\u0004\u0002H\u0001!\t!a\b\t\u000f\u0005-\u0003\u0001\"\u0001\u0002 !9\u0011q\n\u0001\u0005\u0002\u0005}\u0001bBA*\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003/\u0002A\u0011AA\u0010\u0011\u001d\tY\u0006\u0001C\u0001\u0003?Aq!a\u0018\u0001\t\u0003\ty\u0002C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005}\u0004\u0001\"\u0001\u0002 !9\u00111\u0011\u0001\u0005\u0002\u0005}\u0001bBAD\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003\u0017\u0003A\u0011AA\u0010\u0011\u001d\ty\t\u0001C\u0001\u0003?Aq!a%\u0001\t\u0003\ty\u0002C\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"I\u0011\u0011\u001b\u0001\u0012\u0002\u0013%\u00111\u001b\u0005\b\u0003S\u0004A\u0011AA\u0010\u0011\u001d\ti\u000f\u0001C\u0001\u0003?Aq!!=\u0001\t\u0003\ty\u0002C\u0004\u0002v\u0002!I!a>\t\u0013\tU\u0001!%A\u0005\n\t]\u0001b\u0002B\u000e\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0005?\u0001A\u0011AA\u0010\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003?AqAa\n\u0001\t\u0003\tyB\u0001\bM_\u001el\u0015M\\1hKJ$Vm\u001d;\u000b\u0005U2\u0014a\u00017pO*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0005B\u00111\tA\u0007\u0002i\u0005!A/[7f+\u00051\u0005CA$K\u001b\u0005A%BA%7\u0003\u0015)H/\u001b7t\u0013\tY\u0005J\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003=i\u0017\r\u001f*pY2Le\u000e^3sm\u0006dW#A(\u0011\u0005m\u0002\u0016BA)=\u0005\rIe\u000e^\u0001\u0011[\u0006D(k\u001c7m\u0013:$XM\u001d<bY\u0002\n1\"\\1y\u0019><\u0017iZ3Ng\u0006aQ.\u0019=M_\u001e\fu-Z'tA\u0005AAn\\4Qe>\u00048/F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003vi&d'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\t!\r\u0005\u0002DG&\u0011A\r\u000e\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0019awn\u001a#jeV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l7\u0006\u0011\u0011n\\\u0005\u0003[*\u0014AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005A\u001c\bCA\u001er\u0013\t\u0011HH\u0001\u0003V]&$\bb\u0002;\u000e\u0003\u0003\u0005\r\u0001[\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014X#\u0001=\u0011\u0005\rK\u0018B\u0001>5\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\t\u0001X\u0010C\u0004u!\u0005\u0005\t\u0019\u0001=\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nm\u000bA\u0001\\1oO&!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\u0006)a.Y7fA\u0005Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\t\t)\u0002E\u0002<\u0003/I1!!\u0007=\u0005\u0011auN\\4\u00025Y,'/\u001f'be\u001e,Gj\\4GYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0003AD3AFA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tQA[;oSRT!!!\f\u0002\u0007=\u0014x-\u0003\u0003\u00022\u0005\u001d\"A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\r9\u0012q\u0007\t\u0005\u0003K\tI$\u0003\u0003\u0002<\u0005\u001d\"!B!gi\u0016\u0014\u0018!\u0004;fgR\u001c%/Z1uK2{w\rK\u0002\u0019\u0003\u0003\u0002B!!\n\u0002D%!\u0011QIA\u0014\u0005\u0011!Vm\u001d;\u0002=Q,7\u000f^\"sK\u0006$X\rT8h/&$\b.\u00138wC2LG\rT8h\t&\u0014\bfA\r\u0002B\u0005yB/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5M_\u001e$\u0015N\u001d$bY2\u0014\u0017mY6)\u0007i\t\t%A\u000buKN$x)\u001a;O_:,\u00050[:uK:$Hj\\4)\u0007m\t\t%\u0001\u000euKN$8\t\\3b]V\u0004X\t\u001f9je\u0016$7+Z4nK:$8\u000fK\u0002\u001d\u0003\u0003\n\u0011\u0005^3ti\u000ecW-\u00198vaN+w-\\3oiN$v.T1j]R\f\u0017N\\*ju\u0016D3!HA!\u0003)\"Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t/&$\bnQ8na\u0006\u001cG\u000fR3mKR,\u0007k\u001c7jGfD3AHA!\u0003\u0011\"Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t/&$\bnQ8na\u0006\u001cG\u000fU8mS\u000eL\bfA\u0010\u0002B\u0005\u0019B/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hgR\u0019\u0001/a\u001a\t\u000f\u0005%\u0004\u00051\u0001\u0002l\u00051\u0001o\u001c7jGf\u0004B!!\u001c\u0002|9!\u0011qNA<!\r\t\t\bP\u0007\u0003\u0003gR1!!\u001e9\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0010\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!! \u000b\u0007\u0005eD(\u0001\nuKN$H+[7f\u0005\u0006\u001cX\r\u001a$mkND\u0007fA\u0011\u0002B\u0005IB/Z:u\u0019\u0016\f7\u000f\u001e'pC\u0012,G-Q:tS\u001etW.\u001a8uQ\r\u0011\u0013\u0011I\u0001$i\u0016\u001cH\u000fV<p\u0019><W*\u00198bO\u0016\u00148/V:j]\u001e\u001c\u0016-\\3ESJ4\u0015-\u001b7tQ\r\u0019\u0013\u0011I\u0001\u001di\u0016\u001cHo\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ssB{\u0017N\u001c;tQ\r!\u0013\u0011I\u0001.i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\b\u000e\u0016:bS2LgnZ*mCND\u0007fA\u0013\u0002B\u0005\tD/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i%\u0016d\u0017\r^5wK\u0012K'/Z2u_JL\bf\u0001\u0014\u0002B\u0005Ab/\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=\u0015\u000fA\fY*a1\u0002F\"9\u0011QT\u0014A\u0002\u0005}\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\u0005\u0005\u00161VAY\u001d\u0011\t\u0019+a*\u000f\t\u0005E\u0014QU\u0005\u0002{%\u0019\u0011\u0011\u0016\u001f\u0002\u000fA\f7m[1hK&!\u0011QVAX\u0005\r\u0019V-\u001d\u0006\u0004\u0003Sc\u0004\u0003BAZ\u0003\u007fk!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0007G>lWn\u001c8\u000b\u0007]\nYL\u0003\u0003\u0002>\u0006-\u0012AB1qC\u000eDW-\u0003\u0003\u0002B\u0006U&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006m\u001e\u0002\r\u0001\u001f\u0005\u0006M\u001e\u0002\r\u0001[\u0001\u0011GJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$2\u0001_Af\u0011%\ti\r\u000bI\u0001\u0002\u0004\ty-A\u0004m_\u001e$\u0015N]:\u0011\u000b\u0005\u0005\u00161\u00165\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U'\u0006BAh\u0003/\\#!!7\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gd\u0014AC1o]>$\u0018\r^5p]&!\u0011q]Ao\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001#i\u0016\u001cHOR5mKJ+g-\u001a:f]\u000e,7/\u00114uKJ\f5/\u001f8d\t\u0016dW\r^3)\u0007)\n\t%\u0001\u0012uKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$Xm\u0014<fe2LHj\u001c8h)>\u0004\u0018n\u0019\u0015\u0004W\u0005\u0005\u0013!\t;fgR\u001c\u0005.Z2la>Lg\u000e\u001e$pe>sG._!gM\u0016\u001cG/\u001a3M_\u001e\u001c\bf\u0001\u0017\u0002B\u00059!/Z1e\u0019><G\u0003CA}\u0005\u000b\u0011iA!\u0005\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@7\u0003\u0019\u0019XM\u001d<fe&!!1AA\u007f\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"1Q'\fa\u0001\u0005\u000f\u00012a\u0011B\u0005\u0013\r\u0011Y\u0001\u000e\u0002\u0004\u0019><\u0007b\u0002B\b[\u0001\u0007\u0011QC\u0001\u0007_\u001a47/\u001a;\t\u0011\tMQ\u0006%AA\u0002=\u000b\u0011\"\\1y\u0019\u0016tw\r\u001e5\u0002#I,\u0017\r\u001a'pO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001a)\u001aq*a6\u0002KQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKV\u0003H-\u0019;fg2{wmQ8oM&<\u0007fA\u0018\u0002B\u0005iB/Z:u\u0007>tg-[4DQ\u0006tw-Z$fiN\u001cE.Z1oK\u0012,\u0006\u000fK\u00021\u0003\u0003\n\u0001\u0006^3ti\n\u0013xn[3s\u0007>tg-[4DQ\u0006tw-\u001a#fY&4XM]3e)>\fE\u000e\u001c'pOND3!MA!\u00031\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm],ji\"tu\u000eT8h\u000f\u0016$H/\u001b8h\u0013:LG/[1mSj,G\rK\u00023\u0003\u0003\u0002")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        Seq seq = this.logManager().liveLogDirs();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, true, x$4);
        Assert.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateLogWithLogDirFallback() {
        String string;
        int n = 0;
        int to$extension_end = 4;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            String string2;
            String string3;
            String string4 = string3 = ((Object)BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next())).toString();
            string3 = null;
            String string5 = string2 = string4;
            string2 = null;
            string = string5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var9_3 = null;
        Object var10_4 = null;
        Object var11_5 = null;
        string = null;
        IndexedSeq dirs = (IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs)));
        Set brokenDirs = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$22 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$22, true, x$4);
        Assert.assertEquals((long)(dirs.length() / 2), (long)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$5(this, dir));
        Assert.assertEquals((String)"More than one log file created", (long)1L, (long)dirs.count((Function1)containsLogFile));
        Assert.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        Assert.assertTrue((!new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$42 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$42);
        long l = 0L;
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testCleanupExpiredSegments$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
                l = log.appendAsLeader($anonfun$testCleanupExpiredSegments$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).lastOffset();
                Object var17_12 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_10 = null;
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$3(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 4 + 1), (long)log.dir().list().length);
        int n2 = 1024;
        long readLog_offset = l + 1L;
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(readLog_offset, n2, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes());
        try {
            int n3 = 1024;
            long readLog_offset2 = 0L;
            log.read(readLog_offset2, n3, (FetchIsolation)FetchLogEnd$.MODULE$, true);
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), (Object)(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        long l = 0L;
        int numMessages = 200;
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, numMessages, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testCleanupSegmentsToMaintainSize$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
                l = BoxesRunTime.unboxToLong((Object)log.appendAsLeader($anonfun$testCleanupSegmentsToMaintainSize$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).firstOffset().get());
                Object var20_15 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var12_13 = null;
        log.updateHighWatermark(log.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / BoxesRunTime.unboxToInt((Object)config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3 + 3), (long)log.dir().list().length);
        int n2 = 1024;
        long readLog_offset = l + 1L;
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(readLog_offset, n2, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes());
        try {
            int n3 = 1024;
            long readLog_offset2 = 0L;
            log.read(readLog_offset2, n3, (FetchIsolation)FetchLogEnd$.MODULE$, true);
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testDoesntCleanLogs$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
                log.appendAsLeader($anonfun$testDoesntCleanLogs$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).lastOffset();
                Object var14_13 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var11_11 = null;
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$3(this, x$7)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), (Object)1000);
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        long lastFlush = log.lastFlushTime();
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LogManagerTest.$anonfun$testTimeBasedFlush$2(log, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var12_12 = null;
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Object[] objectArray = new File[3];
        objectArray[0] = TestUtils.tempDirectory(null, null);
        objectArray[1] = TestUtils.tempDirectory(null, null);
        objectArray[2] = TestUtils.tempDirectory(null, null);
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs));
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogManagerTest.$anonfun$testLeastLoadedAssignment$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        Object[] objectArray = new File[1];
        objectArray[0] = new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString());
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), LogConfig$.MODULE$.apply(), TestUtils$.MODULE$.createLogManager$default$3(), new MockTime()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$11 -> logManager.getOrCreateLog(x$11, (Function0 & Serializable)() -> this.logConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4()));
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$3(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$5(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs) {
        LogConfig x$1 = this.logConfig();
        MockTime x$3 = this.time();
        CleanerConfig x$4 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, x$4, x$3);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        Object object;
        File[] fileArray;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] fileArray2 = fileArray = activeSegment.log().file().getParentFile().listFiles();
        fileArray = null;
        File[] filter$extension_$this = fileArray2;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = object;
        Object var23_13 = null;
        object = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            File filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var19_12 = null;
        Object var20_16 = null;
        Object var22_18 = null;
        File[] indexFilesOnDiskBeforeDelete = (File[])filter$extension_res.result();
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        Log removedLog = qual$2.asyncDelete(x$5, x$6);
        LogSegment removedSegment = removedLog.activeSegment();
        scala.collection.immutable.Seq indexFilesAfterDelete = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        for (File file : indexFilesOnDiskBeforeDelete) {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(indexFilesAfterDelete, file);
        }
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        qual$2.asyncDelete(x$5, x$6);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        scala.collection.immutable.Seq tps = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$16 -> {
            LogManager qual$1 = this.logManager();
            Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$16, (Function0)x$2, x$3, x$4);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$3(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshot(this.logDir(), (Seq)allLogs.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$5(x$18))));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$6(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(Log log, long offset, int maxLength) {
        return log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        BooleanRef booleanRef;
        BooleanRef booleanRef2;
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().topicConfigUpdated(testTopicOne);
        boolean create_e = false;
        BooleanRef booleanRef3 = booleanRef2 = new BooleanRef(create_e);
        booleanRef2 = null;
        BooleanRef configUpdated = booleanRef3;
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testTopicConfigChangeUpdatesLogConfig$1(configUpdated, null));
        Assert.assertTrue((boolean)configUpdated.elem);
        boolean create_e2 = true;
        BooleanRef booleanRef4 = booleanRef = new BooleanRef(create_e2);
        booleanRef = null;
        BooleanRef configNotUpdated = booleanRef4;
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testTopicConfigChangeUpdatesLogConfig$2(configNotUpdated, null));
        Assert.assertTrue((boolean)configNotUpdated.elem);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        BooleanRef booleanRef;
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        this.logManager().initializingLog(testTopicPartition);
        boolean create_e = true;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef configUpdateNotCalled = booleanRef2;
        this.logManager().finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$, () -> LogManagerTest.$anonfun$testConfigChangeGetsCleanedUp$1(configUpdateNotCalled, null));
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        Assert.assertTrue((boolean)configUpdateNotCalled.elem);
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        IntRef intRef;
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().brokerConfigUpdated();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef totalChanges = intRef2;
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testBrokerConfigChangeDeliveredToAllLogs$1(totalChanges, null));
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testBrokerConfigChangeDeliveredToAllLogs$2(totalChanges, null));
        Assert.assertEquals((long)2L, (long)totalChanges.elem);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$5(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ void $anonfun$testCleanupExpiredSegments$2(Log log$1, LongRef offset$1, int x$3) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$1.appendAsLeader(set, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        offset$1.elem = info.lastOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$3(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testCleanupSegmentsToMaintainSize$2(Log log$2, LongRef offset$2, int x$5) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$2.appendAsLeader(set, 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
        offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
    }

    public static final /* synthetic */ void $anonfun$testDoesntCleanLogs$2(Log log$3, LongRef offset$3, int x$6) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$3.appendAsLeader(set, 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4());
        offset$3.elem = info.lastOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$3(LogManagerTest $this, LogSegment x$7) {
        return x$7.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$2(Log log$4, int x$8) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }

    public static final /* synthetic */ void $anonfun$testLeastLoadedAssignment$1(LogManagerTest $this, int partition) {
        LogManager qual$1 = $this.logManager();
        TopicPartition x$1 = new TopicPartition("test", partition);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> $this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)$this.logManager().allLogs().size());
        Iterable counts = (Iterable)$this.logManager().allLogs().groupBy((Function1 & Serializable)x$9 -> x$9.dir().getParent()).values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
        Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$3(Log log) {
        int n = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var2_3 = null;
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$5(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
            Assert.assertEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$2(File x$13) {
        return x$13.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$4(File fileBeforeDelete$1, File x$14) {
        String string = x$14.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFileReferencesAfterAsyncDelete$5(File x$15) {
        return x$15.getName();
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$3(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$4(fileBeforeDelete, x$14)));
        if (fileInIndex == null) {
            throw null;
        }
        Object object = fileInIndex.isEmpty() ? None$.MODULE$ : new Some((Object)((File)fileInIndex.get()).getName());
        None$ none$ = object;
        object = null;
        Assert.assertEquals((String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString(), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)none$);
        Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$3(Log log) {
        int n = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var2_3 = null;
        log.flush();
    }

    public static final /* synthetic */ boolean $anonfun$testCheckpointForOnlyAffectedLogs$5(Log x$18) {
        return x$18.dir().getName().contains("test-a");
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$6(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint());
            if (tp.topic().equals("test-a")) {
                Assert.assertEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
                return;
            }
            Assert.assertNotEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ LogConfig $anonfun$testTopicConfigChangeUpdatesLogConfig$1(BooleanRef configUpdated$1, LogConfig logConfig$1) {
        configUpdated$1.elem = true;
        return logConfig$1;
    }

    public static final /* synthetic */ LogConfig $anonfun$testTopicConfigChangeUpdatesLogConfig$2(BooleanRef configNotUpdated$1, LogConfig logConfig$1) {
        configNotUpdated$1.elem = false;
        return logConfig$1;
    }

    public static final /* synthetic */ LogConfig $anonfun$testConfigChangeGetsCleanedUp$1(BooleanRef configUpdateNotCalled$1, LogConfig logConfig$2) {
        configUpdateNotCalled$1.elem = false;
        return logConfig$2;
    }

    public static final /* synthetic */ LogConfig $anonfun$testBrokerConfigChangeDeliveredToAllLogs$1(IntRef totalChanges$1, LogConfig logConfig$3) {
        ++totalChanges$1.elem;
        return logConfig$3;
    }

    public static final /* synthetic */ LogConfig $anonfun$testBrokerConfigChangeDeliveredToAllLogs$2(IntRef totalChanges$1, LogConfig logConfig$3) {
        ++totalChanges$1.elem;
        return logConfig$3;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), (Object)4096);
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), (Object)this.maxLogAgeMs());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)Long.MAX_VALUE).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1$adapted(Object x$1) {
        return LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$2$adapted(Log log$4, Object x$8) {
        return LogManagerTest.$anonfun$testTimeBasedFlush$2(log$4, BoxesRunTime.unboxToInt((Object)x$8));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(File x$13) {
        return BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(x$13));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$3$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$verifyCheckpointRecovery$4$adapted(Log log$5, Object x$12) {
        return log$5.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$5.appendAsLeader$default$3(), log$5.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCheckpointForOnlyAffectedLogs$4$adapted(Log log$6, Object x$17) {
        return log$6.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4());
    }
}

