/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00014A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)q\u0006\u0001C\u0001E!)\u0011\u0007\u0001C\u0001E!)1\u0007\u0001C\u0001E!)Q\u0007\u0001C\u0001E!)q\u0007\u0001C\u0001E!)\u0011\b\u0001C\u0001E!)1\b\u0001C\u0001E!)Q\b\u0001C\u0001E!)q\b\u0001C\u0001E!)\u0011\t\u0001C\u0001E!)1\t\u0001C\u0001E!)Q\t\u0001C\u0005\r\")q\u000b\u0001C\u00051\niAj\\4D_:4\u0017n\u001a+fgRT!AE\n\u0002\u00071|wMC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u0005\u0019\u0003C\u0001\r%\u0013\t)\u0013D\u0001\u0003V]&$\bF\u0001\u0002(!\tAS&D\u0001*\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]%\u0012A\u0001V3ti\u00061B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002\u0004O\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\t!q%\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003\u000b\u001d\na\u0004^3ti&sg/\u00197jI\u000e{W\u000e]1di&|g\u000eT1h\u0007>tg-[4)\u0005\u00199\u0013!J:i_VdGMV1mS\u0012\fG/\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u000e{gNZ5hQ\t9q%A\buKN$Hk\u001c%u[2$\u0016M\u00197fQ\tAq%\u0001\u0006uKN$Hk\u001c%u[2D#!C\u0014\u0002#Q,7\u000f\u001e+p\u000b:\u0014\u0018n\u00195fIJ\u001bH\u000f\u000b\u0002\u000bO\u0005IA/Z:u)>\u00146\u000f\u001e\u0015\u0003\u0017\u001d\n!\u0003^3ti\u001e+GoQ8oM&<g+\u00197vK\"\u0012AbJ\u0001&i\u0016\u001cHo\u0014<feJLG\rZ3o\u0007>tg-[4t\u0003NdunZ4bE2,7\u000b\u001e:j]\u001eD#!D\u0014\u0002\u000f%\u001ch+\u00197jIR\u0011qI\u0013\t\u00031!K!!S\r\u0003\u000f\t{w\u000e\\3b]\")1J\u0004a\u0001\u0019\u0006Y1m\u001c8gS\u001e4\u0016\r\\;f!\tiEK\u0004\u0002O%B\u0011q*G\u0007\u0002!*\u0011\u0011+F\u0001\u0007yI|w\u000e\u001e \n\u0005MK\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\r\u0002+\u0005\u001c8/\u001a:u!J|\u0007/\u001a:us&sg/\u00197jIR\u00191%W.\t\u000bi{\u0001\u0019\u0001'\u0002\t9\fW.\u001a\u0005\u00069>\u0001\r!X\u0001\u0007m\u0006dW/Z:\u0011\u0007aqv#\u0003\u0002`3\tQAH]3qK\u0006$X\r\u001a ")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assert.assertTrue((KafkaConfig$.MODULE$.LogRetentionTimeMillisProp() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)(2L * millisInHour), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)(2L * millisInHour), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)(2L * millisInHour), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> LogConfig$.MODULE$.validate(props), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString(), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml();
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\" href=\"#file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString(), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString(), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString(), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assert.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig), topicOverrides);
        Assert.assertEquals((Object)"{min.insync.replicas=2, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            return;
        }
        String string2 = LogConfig$.MODULE$.RetentionBytesProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string3 = LogConfig$.MODULE$.RetentionMsProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string4 = LogConfig$.MODULE$.CleanupPolicyProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
            return;
        }
        String string5 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
            return;
        }
        String string6 = LogConfig$.MODULE$.MinInSyncReplicasProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
            return;
        }
        String string7 = LogConfig$.MODULE$.MessageFormatVersionProp();
        if (!(string7 != null ? !string7.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{""}));
            return;
        }
        $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
    }
}

