/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import kafka.utils.Logging;
import kafka.utils.LoggingTest;
import org.apache.kafka.server.logger.LoggingController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I2AAB\u0004\u0001\u0019!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017\tYAj\\4hS:<G+Z:u\u0015\tA\u0011\"A\u0003vi&d7OC\u0001\u000b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\u000f%\u0011ac\u0002\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005yB/Z:u\u0019><GG[\"p]R\u0014x\u000e\u001c7fe&\u001b(+Z4jgR,'/\u001a3\u0015\u0003q\u0001\"AD\u000f\n\u0005yy!\u0001B+oSRD#A\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0003&A\u0003kk:LGOC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012A\u0001V3ti\u0006\u0019B/Z:u\u0019><g*Y7f\u001fZ,'O]5eK\"\u00121\u0001I\u0001\fi\u0016\u001cH\u000fT8h\u001d\u0006lW\r\u000b\u0002\u0005A\u0005IB/Z:u\u0019><w-\u001a:MKZ,G.S:SKN|GN^3eQ\t)\u0001\u0005")
public class LoggingTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void testLog4jControllerIsRegistered() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName log4jControllerName = ObjectName.getInstance("kafka:type=kafka.Log4jController");
        Assertions.assertTrue((boolean)mbs.isRegistered(log4jControllerName), (String)"kafka.utils.Log4jController is not registered");
        ObjectInstance log4jInstance = mbs.getObjectInstance(log4jControllerName);
        Assertions.assertEquals((Object)"org.apache.kafka.server.logger.LoggingController", (Object)log4jInstance.getClassName());
    }

    @Test
    public void testLogNameOverride() {
        String overriddenLogName = "OverriddenLogName";
        public class Kafka_utils_LoggingTest$TestLogging$1
        implements Logging {
            private final String overriddenLogName;
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public Logger log() {
                return this.logger();
            }

            public String loggerName() {
                return this.overriddenLogName;
            }

            public Kafka_utils_LoggingTest$TestLogging$1(LoggingTest $outer, String overriddenLogName) {
                this.overriddenLogName = overriddenLogName;
            }
        }
        Kafka_utils_LoggingTest$TestLogging$1 logging = new Kafka_utils_LoggingTest$TestLogging$1(null, overriddenLogName);
        Assertions.assertEquals((Object)overriddenLogName, (Object)logging.logger().underlying().getName());
    }

    @Test
    public void testLogName() {
        public class Kafka_utils_LoggingTest$TestLogging$2
        implements Logging {
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public Logger log() {
                return this.logger();
            }

            public Kafka_utils_LoggingTest$TestLogging$2(LoggingTest $outer) {
            }
        }
        Kafka_utils_LoggingTest$TestLogging$2 logging = new Kafka_utils_LoggingTest$TestLogging$2(null);
        Assertions.assertEquals((Object)logging.getClass().getName(), (Object)logging.logger().underlying().getName());
    }

    @Test
    public void testLoggerLevelIsResolved() {
        LoggingController controller = new LoggingController();
        String previousLevel = controller.getLogLevel("kafka");
        try {
            controller.setLogLevel("kafka", "TRACE");
            LoggerFactory.getLogger((String)"kafka.utils.Log4jControllerTest").trace("test");
            Assertions.assertEquals((Object)"TRACE", (Object)controller.getLogLevel("kafka"));
            Assertions.assertEquals((Object)"TRACE", (Object)controller.getLogLevel("kafka.utils.Log4jControllerTest"));
            Assertions.assertTrue((boolean)controller.getLoggers().contains("kafka=TRACE"));
            Assertions.assertTrue((boolean)controller.getLoggers().contains("kafka.utils.Log4jControllerTest=TRACE"));
        }
        finally {
            controller.setLogLevel("kafka", previousLevel);
        }
    }
}

