/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import kafka.log.LogTestUtils$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.server.KafkaRaftServer$;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.VoterSetTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\tee\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004U\u0001\u0001\u0006I\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0001L\u0011\u00191\u0006\u0001)A\u0005\u0019\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0011\u001d\u0011\u0007A1A\u0005\u0002aCaa\u0019\u0001!\u0002\u0013I\u0006b\u00023\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007K\u0002\u0001\u000b\u0011B-\t\u000f\u0019\u0004!\u0019!C\u00011\"1q\r\u0001Q\u0001\neCq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004x\u0001\u0001\u0006IA\u001b\u0005\nq\u0002\u0001\r\u00111A\u0005\u0002eD1\"a\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\n!Q\u0011Q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002>\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!1\u0011\u0011\u0007\u0001\u0005\neDq!a\r\u0001\t\u0013\t)\u0004C\u0004\u0002T\u0001!\t!!\u0007\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u001a!9\u0011\u0011\r\u0001\u0005\u0002\u0005e\u0001bBA3\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\u001c\u0002!\t!!\u0007\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\u001a!9\u00111\u0015\u0001\u0005\u0002\u0005e\u0001bBAT\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003W\u0003A\u0011AA\r\u0011\u001d\ty\u000b\u0001C\u0001\u00033Aq!a-\u0001\t\u0003\tI\u0002C\u0004\u00028\u0002!\t!!\u0007\t\u000f\u0005m\u0006\u0001\"\u0001\u0002\u001a!9\u0011q\u0018\u0001\u0005\u0002\u0005e\u0001bBAb\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003\u000f\u0004A\u0011AA\r\u0011\u001d\tY\r\u0001C\u0001\u00033Aq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002^\u0002!\t!!\u0007\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9!1\u0003\u0001\u0005\u0002\u0005e\u0001b\u0002B\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!\u0011\u000e\u0001\u0005\n\t-\u0004b\u0002B8\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0005g\u0002A\u0011\u0002B;\u0005M!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\tYD(A\u0003u_>d7OC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\t!(\u0001\u0004u[B$\u0015N]\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0003S>T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\fg\u0016<W.\u001a8u\u001d\u0006lW-F\u0001Z!\tQV,D\u0001\\\u0015\ta\u0006+\u0001\u0003mC:<\u0017B\u00010\\\u0005\u0019\u0019FO]5oO\u0006a1/Z4nK:$h*Y7fA\u0005YAn\\4GS2,\u0007+\u0019;i\u00031awn\u001a$jY\u0016\u0004\u0016\r\u001e5!\u00031\u0019h.\u00199tQ>$\b+\u0019;i\u00035\u0019h.\u00199tQ>$\b+\u0019;iA\u0005i\u0011N\u001c3fq\u001aKG.\u001a)bi\"\fa\"\u001b8eKb4\u0015\u000e\\3QCRD\u0007%A\tuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"\f!\u0003^5nK&sG-\u001a=GS2,\u0007+\u0019;iA\u0005!A/[7f+\u0005Q\u0007CA6v\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0005=\u0004\u0018AB:feZ,'O\u0003\u0002>c*\u0011!o]\u0001\u0007CB\f7\r[3\u000b\u0003Q\f1a\u001c:h\u0013\t1HN\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\rawnZ\u000b\u0002uB\u001910a\u0001\u000e\u0003qT!\u0001_?\u000b\u0005y|\u0018!C5oi\u0016\u0014h.\u00197t\u0015\r\t\t\u0001]\u0001\bgR|'/Y4f\u0013\r\t)\u0001 \u0002\u000b+:Lg-[3e\u0019><\u0017a\u00027pO~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002B\u0003\u001bI1!a\u0004C\u0005\u0011)f.\u001b;\t\u0011\u0005M1#!AA\u0002i\f1\u0001\u001f\u00132\u0003\u0011awn\u001a\u0011\u0002\u0013\u00054G/\u001a:FC\u000eDGCAA\u0006Q\r)\u0012Q\u0004\t\u0005\u0003?\ti#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\r\t\u0007/\u001b\u0006\u0005\u0003O\tI#A\u0004kkBLG/\u001a:\u000b\u0007\u0005-2/A\u0003kk:LG/\u0003\u0003\u00020\u0005\u0005\"!C!gi\u0016\u0014X)Y2i\u00035\u0019'/Z1uKR+7\u000f\u001e'pO\u0006\u0001\u0012\r\u001a3TS6\u0004H.\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003\u0017\t9$!\u000f\t\u000ba<\u0002\u0019\u0001>\t\u000f\u0005mr\u00031\u0001\u0002>\u00059!-\u0019;dQ\u0016\u001c\bCBA \u0003\u0013\ni%\u0004\u0002\u0002B)!\u00111IA#\u0003\u001diW\u000f^1cY\u0016T1!a\u0012C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\n\tEA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA%\u0002P%\u0019\u0011\u0011\u000b\u001e\u0003\u0013\t\u000bGo\u00195J]\u001a|\u0017\u0001\t;fgR\u0014\u0015\r^2i\u0003:$'+Z2pe\u0012lU\r^1eCR\fw*\u001e;qkRD3\u0001GA,!\u0011\ty\"!\u0017\n\t\u0005m\u0013\u0011\u0005\u0002\u0005)\u0016\u001cH/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\u001a\u0011$a\u0016\u0002/Q,7\u000f\u001e#v[BLe\u000eZ3y\u001b&\u001cX.\u0019;dQ\u0016\u001c\bf\u0001\u000e\u0002X\u00059B/Z:u\tVl\u0007\u000fV5nK&sG-\u001a=FeJ|'o\u001d\u0015\u00047\u0005]\u0013AD2pk:$8+\u001e2tiJLgn\u001a\u000b\u0007\u0003[\n\u0019(a#\u0011\u0007\u0005\u000by'C\u0002\u0002r\t\u00131!\u00138u\u0011\u001d\t)\b\ba\u0001\u0003o\n1a\u001d;s!\u0011\tI(a\"\u000f\t\u0005m\u00141\u0011\t\u0004\u0003{\u0012UBAA@\u0015\r\t\tIP\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015%)\u0001\u0004Qe\u0016$WMZ\u0005\u0004=\u0006%%bAAC\u0005\"9\u0011Q\u0012\u000fA\u0002\u0005]\u0014aA:vE\u0006Q!-\u0019;dQ\u000e{WO\u001c;\u0015\t\u00055\u00141\u0013\u0005\b\u0003kj\u0002\u0019AA<\u0003-\u0011XmY8sI\u000e{WO\u001c;\u0015\t\u00055\u0014\u0011\u0014\u0005\b\u0003kr\u0002\u0019AA<\u0003y!Xm\u001d;Ek6\u0004(+Z7pi\u0016dunZ'fi\u0006$\u0017\r^1F[B$\u0018\u0010K\u0002 \u0003/\n!\u0006^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC>sWMU3d_J$wJ\\3CCR\u001c\u0007\u000eK\u0002!\u0003/\n\u0001\u0007^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC6+H\u000e^5qY\u0016\u0014VmY8sIN|e.\u001a\"bi\u000eD\u0007fA\u0011\u0002X\u00059D/Z:u\tVl\u0007OU3n_R,Gj\\4NKR\fG-\u0019;b\u001bVdG/\u001b9mKJ+7m\u001c:eg6+H\u000e^5qY\u0016\u0014\u0015\r^2iKND3AIA,\u00039\"Xm\u001d;Ek6\u0004(+Z7pi\u0016dunZ'fi\u0006$\u0017\r^1O_:TVM]8Ti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;)\u0007\r\n9&A\u0014uKN$H)^7q%\u0016lw\u000e^3M_\u001elU\r^1eCR\fw+\u001b;i\u0007>\u0014(/\u001e9uS>t\u0007f\u0001\u0013\u0002X\u0005!C/Z:u\tVl\u0007OU3n_R,Gj\\4NKR\fG-\u0019;b\u0013>,\u0005pY3qi&|g\u000eK\u0002&\u0003/\nA\u0005^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC:{g)\u001b7fg\u001ac\u0017m\u001a\u0015\u0004M\u0005]\u0013\u0001\f;fgR$U/\u001c9SK6|G/\u001a'pO6+G/\u00193bi\u0006tunU;dQ\u001aKG.Z#yG\u0016\u0004H/[8oQ\r9\u0013qK\u0001\u0018i\u0016\u001cH\u000fR;na6+G/\u00193bi\u0006\u0014VmY8sIND3\u0001KA,\u0003U!Xm\u001d;Ek6\u00048i\u001c8ue>d'+Z2pe\u0012D3!KA,\u0003a!Xm\u001d;Ek6\u0004X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\u0015\u0004U\u0005]\u0013A\u0005;fgR$U/\u001c9F[B$\u00180\u00138eKbD3aKA,\u0003I\u0011XO\u001c#v[BdunZ*fO6,g\u000e^:\u0015\t\u0005]\u00141\u001b\u0005\b\u0003+d\u0003\u0019AAl\u0003\u0011\t'oZ:\u0011\u000b\u0005\u000bI.a\u001e\n\u0007\u0005m'IA\u0003BeJ\f\u00170\u0001\u0010uKN$\bK]5oi\u0012\u000bG/\u0019'pOB\u000b'\u000f^5bY\n\u000bGo\u00195fg\"\u001aQ&a\u0016\u0002!M,'/[1mSj,GMU3d_J$GCBAs\u0003k\u0014)\u0001\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\rI,7m\u001c:e\u0015\r\ty\u000f]\u0001\u0007G>lWn\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0007%\u0016\u001cwN\u001d3\t\u000f\u0005]h\u00061\u0001\u0002z\u0006\u00191.Z=\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{TA!a@\u0002n\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003\u0004\u0005u(AC!qS6+7o]1hK\"9!q\u0001\u0018A\u0002\t%\u0011!\u0002<bYV,\u0007\u0003\u0002B\u0006\u0005\u001fi!A!\u0004\u000b\u0007\u0005=h.\u0003\u0003\u0003\u0012\t5!\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.\u0001\ruKN$xJ\u001a4tKR\u001cX*Z:tC\u001e,\u0007+\u0019:tKJD3aLA,\u0003}!Xm\u001d;Ue\u0006t7/Y2uS>tGj\\4NKN\u001c\u0018mZ3QCJ\u001cXM\u001d\u0015\u0004a\u0005]\u0013!\u0005:fC\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR!!q\u0004B\u0013!\u0015\t%\u0011EA<\u0013\r\u0011\u0019C\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t\u001d\u0012\u00071\u0001\u0003*\u0005)A.\u001b8fgB1!1\u0006B\u0018\u0003oj!A!\f\u000b\u00055\u0004\u0016\u0002\u0002B\u0019\u0005[\u0011A\u0002T5ti&#XM]1u_J\fqC]3bIB\u000b'\u000f^5bY\n\u000bGo\u00195fg\nKH/Z:\u0015\r\u00055$q\u0007B\u001d\u0011\u001d\u00119C\ra\u0001\u0005SAqAa\u000f3\u0001\u0004\ti'A\u0003mS6LG/\u0001\u0007d_VtGOQ1uG\",7\u000f\u0006\u0003\u0002n\t\u0005\u0003b\u0002B\u0014g\u0001\u0007!\u0011F\u0001\u0011e\u0016\fGMQ1uG\"\u0014VmY8sIN$BAa\u0012\u0003ZA1!\u0011\nB*\u0003orAAa\u0013\u0003P9!\u0011Q\u0010B'\u0013\u0005\u0019\u0015b\u0001B)\u0005\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B+\u0005/\u00121aU3r\u0015\r\u0011\tF\u0011\u0005\b\u0005O!\u0004\u0019\u0001B\u0015\u0003M\u0001\u0018M]:f\u001b\u0016$\u0018\rZ1uC\u001aKW\r\u001c3t)\u0011\u0011yF!\u001a\u0011\u0011\u0005e$\u0011MA<\u0003oJAAa\u0019\u0002\n\n\u0019Q*\u00199\t\u000f\t\u001dT\u00071\u0001\u0002x\u0005!A.\u001b8f\u0003m\t7o]3si\u0012+X\u000e\u001d'pOJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uCR!\u00111\u0002B7\u0011\u0015Ah\u00071\u0001{\u0003\u0001\"Xm\u001d;TQ\u0006\u0014Xm\u0012:pkB\u001cF/\u0019;f\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:)\u0007]\n9&A\fde\u0016\fG/Z'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jORQ!q\u000fBB\u0005\u000f\u0013\tJ!&\u0011\t\te$qP\u0007\u0003\u0005wR1A! q\u0003\u0011\u0011\u0018M\u001a;\n\t\t\u0005%1\u0010\u0002\u0012\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<\u0007b\u0002BCq\u0001\u0007\u0011QN\u0001\u0018S:$XM\u001d8bY2{wmU3h[\u0016tGOQ=uKNDqA!#9\u0001\u0004\u0011Y)\u0001\tm_\u001e\u001cVmZ7f]Rl\u0015\u000e\u001c7jgB\u0019\u0011I!$\n\u0007\t=%I\u0001\u0003M_:<\u0007b\u0002BJq\u0001\u0007!1R\u0001\u0012e\u0016$XM\u001c;j_:l\u0015\r\u001f\"zi\u0016\u001c\bb\u0002BLq\u0001\u0007!1R\u0001\u0010e\u0016$XM\u001c;j_:l\u0015\u000e\u001c7jg\u0002")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());
    private final String segmentName;
    private final String logFilePath = this.logDir() + "/" + this.segmentName() + ".log";
    private final String snapshotPath = this.logDir() + "/00000000000000000000-0000000000.checkpoint";
    private final String indexFilePath = this.logDir() + "/" + this.segmentName() + ".index";
    private final String timeIndexFilePath = this.logDir() + "/" + this.segmentName() + ".timeindex";
    private final MockTime time = new MockTime(0L, 0L);
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @AfterEach
    public void afterEach() {
        Option$.MODULE$.apply((Object)this.log()).foreach((Function1 & Serializable)log -> {
            DumpLogSegmentsTest.$anonfun$afterEach$1(log);
            return BoxedUnit.UNIT;
        });
    }

    private UnifiedLog createTestLog() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        props.setProperty("message.timestamp.after.max.ms", Long.toString(Long.MAX_VALUE));
        this.log_$eq(UnifiedLog.create((File)this.logDir(), (LogConfig)new LogConfig((Map)props), (long)0L, (long)0L, (Scheduler)this.time().scheduler, (BrokerTopicStats)new BrokerTopicStats(), (Time)this.time(), (int)300000, (ProducerStateManagerConfig)new ProducerStateManagerConfig(86400000, false), (int)600000, (LogDirFailureChannel)new LogDirFailureChannel(10), (boolean)true, Optional.empty()));
        return this.log();
    }

    private void addSimpleRecords(UnifiedLog log, ArrayBuffer<BatchInfo> batches) {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        batches.foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int withRecords_partitionLeaderEpoch = 0;
            NoCompression withRecords_compression = Compression.NONE;
            Object var2_4 = null;
            simpleRecordArray = null;
            return log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0);
        });
        log.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        this.log_$eq(this.createTestLog());
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        int withRecords_partitionLeaderEpoch3 = 0;
        NoCompression withRecords_compression = Compression.NONE;
        Object var1_3 = null;
        simpleRecordArray = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3), 0);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl = false;
        GzipCompression withRecords_compression2 = new GzipCompression.Builder().build();
        Object var4_6 = null;
        simpleRecordArray2 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 3);
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl2 = false;
        NoCompression withRecords_compression3 = Compression.NONE;
        Object var7_9 = null;
        simpleRecordArray3 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 3);
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        NoCompression withIdempotentRecords_compression = Compression.NONE;
        Object var10_14 = null;
        simpleRecordArray4 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withIdempotentRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records), 3);
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        GzipCompression withTransactionalRecords_compression = new GzipCompression.Builder().build();
        Object var16_19 = null;
        simpleRecordArray5 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 5);
        this.log().appendAsLeader(MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100)), 7, AppendOrigin.COORDINATOR);
        this.assertDumpLogRecordMetadata(this.log());
    }

    @Test
    public void testPrintDataLog() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "org.apache.kafka.tools.api.StringDecoder", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "org.apache.kafka.tools.api.StringDecoder", "--files", this.logFilePath()}, batches);
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()}, batches);
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    public int countSubstring(String str, String sub) {
        String qual$1 = Predef$.MODULE$.augmentString(str);
        int x$1 = sub.length();
        int x$2 = StringOps$.MODULE$.sliding$default$2$extension(qual$1);
        return StringOps$.MODULE$.sliding$extension(qual$1, x$1, x$2).count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$countSubstring$1(sub, x$4)));
    }

    public int batchCount(String str) {
        return this.countSubstring(str, "baseOffset:");
    }

    public int recordCount(String str) {
        return this.countSubstring(str, "payload:");
    }

    @Test
    public void testDumpRemoteLogMetadataEmpty() {
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataOneRecordOneBatch() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var28_19 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 0);
        this.log().flush(false);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsOneBatch() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var32_22 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords), 0);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedUpdatePayload));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsMultipleBatches() {
        void withRecords_timestampType;
        void withRecords_timestampType2;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var32_22 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 0);
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var33_26 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 0);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((this.countSubstring(output, expectedUpdatePayload) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.countSubstring(output, expectedDeletePayload) == 2 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataNonZeroStartingOffset() {
        void withRecords_timestampType;
        void withRecords_timestampType2;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var29_19 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords), 0);
        LogSegment secondSegment = this.log().roll();
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var30_24 = null;
        secondSegment.append(1L, MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords));
        secondSegment.flush();
        this.log().flush(true);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", secondSegment.log().file().getAbsolutePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 1"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataWithCorruption() {
        void withRecords_timestampType;
        SimpleRecord[] metadataRecords = new SimpleRecord[]{new SimpleRecord(null, "corrupted".getBytes())};
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var25_17 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords), 0);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("Could not deserialize metadata record"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataIoException() {
        void withRecords_timestampType;
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)this.time().scheduler, (Time)this.time(), 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var26_19 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])metadataRecords), 0);
        this.log().flush(false);
        Files.setPosixFilePermissions(Paths.get(this.logFilePath(), new String[0]), PosixFilePermissions.fromString("-w-------"));
        Assertions.assertThrows(AccessDeniedException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
    }

    @Test
    public void testDumpRemoteLogMetadataNoFilesFlag() {
        Exit.setExitProcedure((x$5, message) -> {
            throw new IllegalArgumentException(message);
        });
        try {
            Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder"}))).getMessage().equals("Missing required argument \"[files]\""));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testDumpRemoteLogMetadataNoSuchFileException() {
        String noSuchFileLogPath = "/tmp/nosuchfile/00000000000000000000.log";
        Assertions.assertThrows(NoSuchFileException.class, () -> this.runDumpLogSegments(new String[]{"--remote-log-metadata-decoder", "--files", noSuchFileLogPath}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        boolean x$14 = false;
        boolean x$15 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)mockTime.scheduler, (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, new ConcurrentHashMap<String, Integer>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(java.util.List.of(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var28_18 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 1);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var29_26 = null;
        simpleRecordArray = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 2);
        NoCompression withRecords_compression3 = Compression.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var31_30 = null;
        this.log().appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (Compression)withRecords_compression3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 2);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpControlRecord() {
        this.log_$eq(this.createTestLog());
        this.log().appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (short)((short)0), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100)), 0, AppendOrigin.COORDINATOR);
        this.log().appendAsLeader(MemoryRecords.withLeaderChangeMessage((long)0L, (long)0L, (int)0, (ByteBuffer)ByteBuffer.allocate(4), (LeaderChangeMessage)new LeaderChangeMessage()), 0, AppendOrigin.COORDINATOR);
        this.log().appendAsLeader(MemoryRecords.withSnapshotHeaderRecord((long)0L, (long)0L, (int)0, (ByteBuffer)ByteBuffer.allocate(4), (SnapshotHeaderRecord)new SnapshotHeaderRecord()), 0, AppendOrigin.COORDINATOR);
        this.log().appendAsLeader(MemoryRecords.withSnapshotFooterRecord((long)0L, (long)0L, (int)0, (ByteBuffer)ByteBuffer.allocate(4), (SnapshotFooterRecord)new SnapshotFooterRecord().setVersion((short)0)), 0, AppendOrigin.COORDINATOR);
        this.log().appendAsLeader(MemoryRecords.withKRaftVersionRecord((long)0L, (long)0L, (int)0, (ByteBuffer)ByteBuffer.allocate(4), (KRaftVersionRecord)new KRaftVersionRecord()), 0, AppendOrigin.COORDINATOR);
        this.log().appendAsLeader(MemoryRecords.withVotersRecord((long)0L, (long)0L, (int)0, (ByteBuffer)ByteBuffer.allocate(4), (VotersRecord)new VotersRecord()), 0, AppendOrigin.COORDINATOR);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("endTxnMarker"), (String)output);
        Assertions.assertTrue((boolean)output.contains("LeaderChange"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
    }

    @Test
    public void testDumpMetadataSnapshot() {
        java.util.List<ApiMessageAndVersion> metadataRecords = java.util.List.of(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(java.util.List.of(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, this.createMetadataLogConfig(102400, 10000L, 102400L, 60000L), 1);
        int lastContainedLogTimestamp = 10000;
        Using$.MODULE$.resource((Object)new RecordsSnapshotWriter.Builder().setTime((Time)new MockTime()).setLastContainedLogTimestamp((long)lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)).get()).setKraftVersion(KRaftVersion.KRAFT_VERSION_1).setVoterSet(Optional.of(VoterSet.fromMap((Map)VoterSetTest.voterMap((IntStream)IntStream.of(1, 2, 3), (boolean)true)))).build((RecordSerde)MetadataRecordSerde.INSTANCE), (Function1 & Serializable)snapshotWriter -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$1(metadataRecords, snapshotWriter)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertTrue((boolean)output.contains("\"lastContainedLogTimestamp\":" + lastContainedLogTimestamp), (String)output);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertFalse((boolean)output.contains("\"lastContainedLogTimestamp\": " + lastContainedLogTimestamp), (String)output);
    }

    @Test
    public void testDumpEmptyIndex() {
        this.log_$eq(this.createTestLog());
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = indexFile + " is empty.\n";
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        int partialBatches = batches.size() / 2;
        ListIterator<String> lines = java.util.List.of(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = java.util.List.of(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Record serializedRecord(ApiMessage key, ApiMessageAndVersion value) {
        byte[] x$1 = MessageUtil.toCoordinatorTypePrefixedBytes((ApiMessage)key);
        byte[] x$2 = value == null ? null : MessageUtil.toVersionPrefixedBytes((short)value.version(), (Message)value.message());
        NoCompression x$3 = Compression.NONE;
        long x$4 = -1L;
        byte x$5 = 2;
        return (Record)TestUtils$.MODULE$.singletonRecords(x$2, x$1, (Compression)x$3, x$4, x$5).records().iterator().next();
    }

    @Test
    public void testOffsetsMessageParser() {
        DumpLogSegments.OffsetsMessageParser parser = new DumpLogSegments.OffsetsMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using the specified decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            NoCompression x$3 = Compression.NONE;
            long x$4 = -1L;
            byte x$5 = 2;
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, (Compression)x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"epoch\":10}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":{\"topics\":[\"foo\"],\"userData\":null,\"ownedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"generationId\":0,\"rackId\":\"rack\"},\"assignment\":{\"assignedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"userData\":null}}]}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new GroupMetadataKey().setGroup("group"), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, Collections.singletonList(new TopicPartition("foo", 0)), 0, Optional.of("rack")), (short)3))).setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("foo", 0))), (short)3))))), 4))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":\"U3Vic2NyaXB0aW9u\",\"assignment\":\"QXNzaWdubWVudA==\"}]}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new GroupMetadataKey().setGroup("group"), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription("Subscription".getBytes()).setAssignment("Assignment".getBytes()))), 4))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(this.serializedRecord((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), null)));
        byte[] x$6 = ByteBuffer.allocate(2).putShort((short)Short.MAX_VALUE).array();
        byte[] x$7 = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        NoCompression x$8 = Compression.NONE;
        long x$9 = -1L;
        byte x$10 = 2;
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse((Record)TestUtils$.MODULE$.singletonRecords(x$7, x$6, (Compression)x$8, x$9, x$10).records().iterator().next()));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: Error reading byte array of 536870911 byte(s): only 1 byte(s) available."), (Object)None$.MODULE$), (Object)parser.parse(this.serializedRecord((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue(), (short)0))));
    }

    @Test
    public void testTransactionLogMessageParser() {
        DumpLogSegments.TransactionLogMessageParser parser = new DumpLogSegments.TransactionLogMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using the specified decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            NoCompression x$3 = Compression.NONE;
            long x$4 = -1L;
            byte x$5 = 2;
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, (Compression)x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"0\",\"data\":{\"transactionalId\":\"txnId\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"producerId\":123,\"producerEpoch\":0,\"transactionTimeoutMs\":0,\"transactionStatus\":0,\"transactionPartitions\":[],\"transactionLastUpdateTimestampMs\":0,\"transactionStartTimestampMs\":0}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new TransactionLogKey().setTransactionalId("txnId"), new ApiMessageAndVersion((ApiMessage)new TransactionLogValue().setProducerId(123L), (short)0))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"0\",\"data\":{\"transactionalId\":\"txnId\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(this.serializedRecord((ApiMessage)new TransactionLogKey().setTransactionalId("txnId"), null)));
        byte[] x$6 = ByteBuffer.allocate(2).putShort((short)Short.MAX_VALUE).array();
        byte[] x$7 = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        NoCompression x$8 = Compression.NONE;
        long x$9 = -1L;
        byte x$10 = 2;
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse((Record)TestUtils$.MODULE$.singletonRecords(x$7, x$6, (Compression)x$8, x$9, x$10).records().iterator().next()));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"0\",\"data\":{\"transactionalId\":\"txnId\"}}"), (Object)new Some((Object)"{\"version\":\"1\",\"data\":{\"producerId\":12,\"previousProducerId\":11,\"nextProducerId\":10,\"producerEpoch\":2,\"transactionTimeoutMs\":14,\"transactionStatus\":0,\"transactionPartitions\":[{\"topic\":\"topic1\",\"partitionIds\":[0,1,2]},{\"topic\":\"topic2\",\"partitionIds\":[3,4,5]}],\"transactionLastUpdateTimestampMs\":123,\"transactionStartTimestampMs\":13}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new TransactionLogKey().setTransactionalId("txnId"), new ApiMessageAndVersion((ApiMessage)new TransactionLogValue().setClientTransactionVersion((short)0).setNextProducerId(10L).setPreviousProducerId(11L).setProducerEpoch((short)2).setProducerId(12L).setTransactionLastUpdateTimestampMs(123L).setTransactionPartitions(java.util.List.of(new TransactionLogValue.PartitionsSchema().setTopic("topic1").setPartitionIds(java.util.List.of(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), new TransactionLogValue.PartitionsSchema().setTopic("topic2").setPartitionIds(java.util.List.of(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))))).setTransactionStartTimestampMs(13L).setTransactionStatus((byte)0).setTransactionTimeoutMs(14), (short)1))));
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException("Failed to parse and find size value for batch line: " + line);
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException("Unexpected non-field token " + token);
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException("Failed to parse value for " + field);
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata(UnifiedLog log) {
        FetchDataInfo logReadInfo = log.read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<String> lines = java.util.List.of(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testShareGroupStateMessageParser() {
        DumpLogSegments.ShareGroupStateMessageParser parser = new DumpLogSegments.ShareGroupStateMessageParser();
        long timestamp = System.currentTimeMillis();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using the specified decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            NoCompression x$3 = Compression.NONE;
            long x$4 = -1L;
            byte x$5 = 2;
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, (Compression)x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"0\",\"data\":{\"groupId\":\"gs1\",\"topicId\":\"Uj5wn_FqTXirEASvVZRY1w\",\"partition\":0}}"), (Object)new Some((Object)("{\"version\":\"0\",\"data\":{\"snapshotEpoch\":0,\"stateEpoch\":0,\"leaderEpoch\":0,\"startOffset\":0,\"createTimestamp\":" + timestamp + ",\"writeTimestamp\":" + timestamp + ",\"stateBatches\":[{\"firstOffset\":0,\"lastOffset\":4,\"deliveryState\":2,\"deliveryCount\":1}]}}"))), (Object)parser.parse(this.serializedRecord((ApiMessage)new ShareSnapshotKey().setGroupId("gs1").setTopicId(Uuid.fromString((String)"Uj5wn_FqTXirEASvVZRY1w")).setPartition(0), new ApiMessageAndVersion((ApiMessage)new ShareSnapshotValue().setSnapshotEpoch(0).setStateEpoch(0).setLeaderEpoch(0).setStartOffset(0L).setCreateTimestamp(timestamp).setWriteTimestamp(timestamp).setStateBatches(java.util.List.of(new ShareSnapshotValue.StateBatch().setFirstOffset(0L).setLastOffset(4L).setDeliveryState((byte)2).setDeliveryCount((short)1))), (short)0))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"1\",\"data\":{\"groupId\":\"gs1\",\"topicId\":\"Uj5wn_FqTXirEASvVZRY1w\",\"partition\":0}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"snapshotEpoch\":0,\"leaderEpoch\":0,\"startOffset\":0,\"stateBatches\":[{\"firstOffset\":0,\"lastOffset\":4,\"deliveryState\":2,\"deliveryCount\":1}]}}")), (Object)parser.parse(this.serializedRecord((ApiMessage)new ShareUpdateKey().setGroupId("gs1").setTopicId(Uuid.fromString((String)"Uj5wn_FqTXirEASvVZRY1w")).setPartition(0), new ApiMessageAndVersion((ApiMessage)new ShareUpdateValue().setSnapshotEpoch(0).setLeaderEpoch(0).setStartOffset(0L).setStateBatches(java.util.List.of(new ShareUpdateValue.StateBatch().setFirstOffset(0L).setLastOffset(4L).setDeliveryState((byte)2).setDeliveryCount((short)1))), (short)0))));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"0\",\"data\":{\"groupId\":\"gs1\",\"topicId\":\"Uj5wn_FqTXirEASvVZRY1w\",\"partition\":0}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(this.serializedRecord((ApiMessage)new ShareSnapshotKey().setGroupId("gs1").setTopicId(Uuid.fromString((String)"Uj5wn_FqTXirEASvVZRY1w")).setPartition(0), null)));
        byte[] x$6 = ByteBuffer.allocate(2).putShort((short)Short.MAX_VALUE).array();
        byte[] x$7 = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
        NoCompression x$8 = Compression.NONE;
        long x$9 = -1L;
        byte x$10 = 2;
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse((Record)TestUtils$.MODULE$.singletonRecords(x$7, x$6, (Compression)x$8, x$9, x$10).records().iterator().next()));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: non-nullable field stateBatches was serialized as null."), (Object)None$.MODULE$), (Object)parser.parse(this.serializedRecord((ApiMessage)new ShareUpdateKey().setGroupId("group").setTopicId(Uuid.fromString((String)"Uj5wn_FqTXirEASvVZRY1w")).setPartition(0), new ApiMessageAndVersion((ApiMessage)new ShareSnapshotValue(), (short)0))));
    }

    private MetadataLogConfig createMetadataLogConfig(int internalLogSegmentBytes, long logSegmentMillis, long retentionMaxBytes, long retentionMillis) {
        Map<String, Long> config = Map.of("internal.metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)internalLogSegmentBytes), "metadata.log.segment.ms", BoxesRunTime.boxToLong((long)logSegmentMillis), "metadata.max.retention.bytes", BoxesRunTime.boxToLong((long)retentionMaxBytes), "metadata.max.retention.ms", BoxesRunTime.boxToLong((long)retentionMillis));
        return new MetadataLogConfig(new AbstractConfig(MetadataLogConfig.CONFIG_DEF, config, false));
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(UnifiedLog log) {
        Utils.closeQuietly((AutoCloseable)log, (String)"UnifiedLog");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), ("message key " + i).getBytes(), ("message value " + i).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), ("message key " + i).getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, ("message value " + i).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private static final boolean isBatch$1(int index, ArrayBuffer batches$1) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)batches$1.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)("No match for index " + index));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args, ArrayBuffer batches$1) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)("Data not printed: " + output));
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches$1.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = batches$1.iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + batches$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - batches$1.size() + index];
            if (DumpLogSegmentsTest.isBatch$1(index, batches$1)) {
                Assertions.assertTrue((boolean)line.startsWith("baseOffset: " + offset$1.elem + " lastOffset: "), (String)("Not a valid batch-level message record: " + line));
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(DumpLogSegments$.MODULE$.RecordIndent() + " offset: " + offset$1.elem), (String)("Not a valid message record: " + line));
            if (checkKeysAndValues) {
                Object suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = (String)suffix + " key: message key " + offset$1.elem;
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = (String)suffix + " payload: message value " + offset$1.elem;
                }
                Assertions.assertTrue((boolean)line.endsWith((String)suffix), (String)("Message record missing key or value: " + line));
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)("Data should not have been printed: " + output));
    }

    public static final /* synthetic */ boolean $anonfun$countSubstring$1(String sub$1, String x$4) {
        String string = x$4;
        return !(string != null ? !string.equals(sub$1) : sub$1 != null);
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$1(java.util.List metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        snapshotWriter.append(metadataRecords$1);
        return snapshotWriter.freeze();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

