/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.Set;
import kafka.server.share.SharePartition;
import kafka.server.share.SharePartitionCache;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.share.SharePartitionKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SharePartitionCacheTest {
    private static final String GROUP_ID = "test-group";
    private static final Uuid TOPIC_ID = Uuid.randomUuid();
    private static final TopicIdPartition TOPIC_ID_PARTITION = new TopicIdPartition(TOPIC_ID, new TopicPartition("test-topic", 1));
    private static final SharePartitionKey SHARE_PARTITION_KEY = new SharePartitionKey("test-group", TOPIC_ID_PARTITION);
    private SharePartitionCache cache;

    @BeforeEach
    public void setUp() {
        this.cache = new SharePartitionCache();
    }

    @Test
    public void testComputeIfAbsent() {
        SharePartition sharePartition = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition newPartition = this.cache.computeIfAbsent(SHARE_PARTITION_KEY, key -> sharePartition);
        Assertions.assertEquals((Object)sharePartition, (Object)newPartition);
        Assertions.assertEquals((Object)sharePartition, (Object)this.cache.get(SHARE_PARTITION_KEY));
        Assertions.assertEquals((int)1, (int)this.cache.groups().size());
        SharePartition anotherPartition = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition existingPartition = this.cache.computeIfAbsent(SHARE_PARTITION_KEY, key -> anotherPartition);
        Assertions.assertEquals((Object)sharePartition, (Object)existingPartition);
        Assertions.assertEquals((Object)sharePartition, (Object)this.cache.get(SHARE_PARTITION_KEY));
        Assertions.assertEquals((int)1, (int)this.cache.groups().size());
    }

    @Test
    public void testRemoveGroup() {
        String group1 = "group1";
        String group2 = "group2";
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test-topic1", 1));
        TopicIdPartition tp2 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test-topic2", 2));
        TopicIdPartition tp3 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test-topic3", 3));
        SharePartitionKey key1 = new SharePartitionKey(group1, tp1);
        SharePartitionKey key2 = new SharePartitionKey(group1, tp2);
        SharePartitionKey key3 = new SharePartitionKey(group2, tp3);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp2 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp3 = (SharePartition)Mockito.mock(SharePartition.class);
        this.cache.computeIfAbsent(key1, k -> sp1);
        this.cache.computeIfAbsent(key2, k -> sp2);
        this.cache.computeIfAbsent(key3, k -> sp3);
        Assertions.assertEquals((int)3, (int)this.cache.size());
        Assertions.assertTrue((boolean)this.cache.containsKey(key1));
        Assertions.assertTrue((boolean)this.cache.containsKey(key2));
        Assertions.assertTrue((boolean)this.cache.containsKey(key3));
        Assertions.assertEquals((int)2, (int)this.cache.groups().size());
        Assertions.assertTrue((boolean)this.cache.groups().containsKey(group1));
        Assertions.assertTrue((boolean)this.cache.groups().containsKey(group2));
        Assertions.assertEquals((int)2, (int)((Set)this.cache.groups().get(group1)).size());
        Assertions.assertEquals((int)1, (int)((Set)this.cache.groups().get(group2)).size());
        Assertions.assertEquals((long)1L, (long)((Set)this.cache.groups().get(group1)).stream().filter(tp -> tp.equals((Object)tp1)).count());
        Assertions.assertEquals((long)1L, (long)((Set)this.cache.groups().get(group1)).stream().filter(tp -> tp.equals((Object)tp2)).count());
        Assertions.assertEquals((long)1L, (long)((Set)this.cache.groups().get(group2)).stream().filter(tp -> tp.equals((Object)tp3)).count());
        this.cache.topicIdPartitionsForGroup(group1).forEach(topicIdPartition -> this.cache.remove(new SharePartitionKey(group1, topicIdPartition)));
        Assertions.assertEquals((int)1, (int)this.cache.size());
        Assertions.assertTrue((boolean)this.cache.containsKey(key3));
        Assertions.assertEquals((int)1, (int)this.cache.groups().size());
        Assertions.assertTrue((boolean)this.cache.groups().containsKey(group2));
    }
}

