/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import kafka.server.ReplicaManager;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.share.fetch.ShareFetchPartitionData;
import org.apache.kafka.server.share.fetch.ShareFetchTestUtils;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class ShareFetchUtilsTest {
    private static final FetchParams FETCH_PARAMS = new FetchParams(-1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty(), true);
    private static final int BATCH_SIZE = 500;
    private static final BiConsumer<SharePartitionKey, Throwable> EXCEPTION_HANDLER = (key, exception) -> {};
    private static final BrokerTopicStats BROKER_TOPIC_STATS = new BrokerTopicStats();

    @Test
    public void testProcessFetchResponse() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)));
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, memberId, new CompletableFuture(), List.of(tp0, tp1), 500, 100, BROKER_TOPIC_STATS);
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        MemoryRecords records1 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        List<ShareFetchPartitionData> responseData = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), new ShareFetchPartitionData(tp1, 0L, new FetchPartitionData(Errors.NONE, 0L, 100L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    @Test
    public void testProcessFetchResponseWithEmptyRecords() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.empty());
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.empty());
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, memberId, new CompletableFuture(), List.of(tp0, tp1), 500, 100, BROKER_TOPIC_STATS);
        List<ShareFetchPartitionData> responseData = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), new ShareFetchPartitionData(tp1, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(List.of(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(List.of(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    @Test
    public void testProcessFetchResponseWithLsoMovementForTopicPartition() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), List.of(tp0, tp1), 500, 100, BROKER_TOPIC_STATS);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 1L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)0L, (Object[])new Long[]{5L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{4L});
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.empty(), (Object[])new ShareAcquiredRecords[]{ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1))});
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)), (Object[])new ShareAcquiredRecords[]{ShareAcquiredRecords.empty()});
        MemoryRecords records1 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        List<ShareFetchPartitionData> responseData1 = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), new ShareFetchPartitionData(tp1, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        Map resultData1 = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData1, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData1.size());
        Assertions.assertTrue((boolean)resultData1.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData1.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        MemoryRecords records2 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        List<ShareFetchPartitionData> responseData2 = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), new ShareFetchPartitionData(tp1, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        Map resultData2 = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData2, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData2.size());
        Assertions.assertTrue((boolean)resultData2.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData2.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(1L);
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }

    @Test
    public void testProcessFetchResponseWhenNoRecordsAreAcquired() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), List.of(tp0), 500, 100, BROKER_TOPIC_STATS);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 1L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.empty());
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        List<ShareFetchPartitionData> responseData = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)1, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((Object)MemoryRecords.EMPTY, (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).records());
        Assertions.assertTrue((boolean)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        responseData = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)1, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((Object)MemoryRecords.EMPTY, (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).records());
        Assertions.assertTrue((boolean)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(1L);
    }

    @Test
    public void testProcessFetchResponseWithMaxFetchRecords() throws IOException {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)0L, (Object[])new Long[]{5L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{4L});
        Uuid memberId = Uuid.randomUuid();
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, memberId.toString(), new CompletableFuture(), List.of(tp0, tp1), 500, 10, BROKER_TOPIC_STATS);
        LinkedHashMap<Long, Integer> recordsPerOffset = new LinkedHashMap<Long, Integer>();
        recordsPerOffset.put(0L, 1);
        recordsPerOffset.put(1L, 1);
        recordsPerOffset.put(2L, 1);
        recordsPerOffset.put(3L, 1);
        FileRecords records1 = ShareFetchTestUtils.createFileRecords(recordsPerOffset);
        recordsPerOffset.clear();
        recordsPerOffset.put(100L, 4);
        FileRecords records2 = ShareFetchTestUtils.createFileRecords(recordsPerOffset);
        FetchPartitionData fetchPartitionData1 = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        FetchPartitionData fetchPartitionData2 = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        Mockito.when((Object)sp0.acquire(memberId.toString(), 500, 10, 0L, fetchPartitionData1, FetchIsolation.HIGH_WATERMARK)).thenReturn((Object)ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(1L).setDeliveryCount((short)1)));
        Mockito.when((Object)sp1.acquire(memberId.toString(), 500, 8, 0L, fetchPartitionData2, FetchIsolation.HIGH_WATERMARK)).thenReturn((Object)ShareFetchTestUtils.createShareAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)));
        List<ShareFetchPartitionData> responseData = List.of(new ShareFetchPartitionData(tp0, 0L, fetchPartitionData1), new ShareFetchPartitionData(tp1, 0L, fetchPartitionData2));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().size());
        Assertions.assertEquals((long)0L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords().size());
        Assertions.assertEquals((long)100L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords().get(0)).firstOffset());
        Assertions.assertEquals((long)103L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords().get(0)).lastOffset());
        Assertions.assertTrue((records1.sizeInBytes() > ((ShareFetchResponseData.PartitionData)resultData.get(tp0)).records().sizeInBytes() ? 1 : 0) != 0);
        Assertions.assertEquals((int)records2.sizeInBytes(), (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).records().sizeInBytes());
    }

    @Test
    public void testProcessFetchResponseWithOffsetFetchException() {
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.leaderEpoch()).thenReturn((Object)1);
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = (ShareFetch)Mockito.mock(ShareFetch.class);
        Mockito.when((Object)shareFetch.groupId()).thenReturn((Object)"grp");
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FencedLeaderEpochException exception = new FencedLeaderEpochException("Fenced exception");
        ((ReplicaManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class), (FetchIsolation)ArgumentMatchers.any())).thenReturn((Object)ShareAcquiredRecords.empty());
        List<ShareFetchPartitionData> responseData = List.of(new ShareFetchPartitionData(tp0, 0L, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)));
        BiConsumer exceptionHandler = (BiConsumer)Mockito.mock(BiConsumer.class);
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, (BiConsumer)exceptionHandler);
        Assertions.assertTrue((boolean)resultData.isEmpty());
        ((ShareFetch)Mockito.verify((Object)shareFetch, (VerificationMode)Mockito.times((int)1))).addErroneous(tp0, (Throwable)exception);
        ((BiConsumer)Mockito.verify((Object)exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept(new SharePartitionKey("grp", tp0), exception);
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }

    @ParameterizedTest(name="{0}")
    @ArgumentsSource(value=RecordsArgumentsProvider.class)
    public void testMaybeSliceFetchRecordsSingleBatch(String name, Records records) {
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(5L).setLastOffset(14L).setDeliveryCount((short)1));
        Records slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 10));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(2L).setLastOffset(14L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 10));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(5L).setLastOffset(20L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 5));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(5L).setLastOffset(8L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(8L).setLastOffset(14L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(8L).setLastOffset(10L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
    }

    @ParameterizedTest(name="{0}")
    @ArgumentsSource(value=MultipleBatchesRecordsArgumentsProvider.class)
    public void testMaybeSliceFetchRecordsMultipleBatches(String name, Records records) {
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(10L).setDeliveryCount((short)1));
        Records slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 11));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(7L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 5));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(2L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 5));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        List recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(3L).setLastOffset(4L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 5));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)3L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(7L).setLastOffset(10L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)7L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(1L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(4L).setLastOffset(4L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)3L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(8L).setLastOffset(8L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)7L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(4L).setLastOffset(8L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)2, (int)recordBatches.size());
        Assertions.assertEquals((long)3L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        Assertions.assertEquals((long)7L, (long)((RecordBatch)recordBatches.get(1)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)recordBatches.get(1)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(2L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(3L).setLastOffset(4L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)2, (int)recordBatches.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        Assertions.assertEquals((long)3L, (long)((RecordBatch)recordBatches.get(1)).baseOffset());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)recordBatches.get(1)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(8L).setLastOffset(8L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(9L).setLastOffset(9L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertTrue((records.sizeInBytes() > slicedRecords.sizeInBytes() ? 1 : 0) != 0);
        recordBatches = TestUtils.toList((Iterable)slicedRecords.batches());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)7L, (long)((RecordBatch)recordBatches.get(0)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)recordBatches.get(0)).lastOffset());
        acquiredRecords = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(1L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(9L).setLastOffset(9L).setDeliveryCount((short)1));
        slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(acquiredRecords, 1));
        Assertions.assertEquals((int)records.sizeInBytes(), (int)slicedRecords.sizeInBytes());
    }

    @ParameterizedTest(name="{0}")
    @ArgumentsSource(value=MultipleBatchesRecordsArgumentsProvider.class)
    public void testMaybeSliceFetchRecordsException(String name, Records records) {
        Records slicedRecords = ShareFetchUtils.maybeSliceFetchRecords((Records)records, (ShareAcquiredRecords)new ShareAcquiredRecords(List.of(), 3));
        Assertions.assertEquals((Object)records, (Object)slicedRecords);
    }

    private static class MultipleBatchesRecordsArgumentsProvider
    implements ArgumentsProvider {
        private MultipleBatchesRecordsArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            LinkedHashMap<Long, Integer> recordsPerOffset = new LinkedHashMap<Long, Integer>();
            recordsPerOffset.put(0L, 3);
            recordsPerOffset.put(3L, 2);
            recordsPerOffset.put(7L, 4);
            return Stream.of(Arguments.of((Object[])new Object[]{"FileRecords", ShareFetchTestUtils.createFileRecords(recordsPerOffset)}), Arguments.of((Object[])new Object[]{"MemoryRecords", this.createMemoryRecords(recordsPerOffset)}));
        }

        private MemoryRecords createMemoryRecords(Map<Long, Integer> recordsPerOffset) {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            recordsPerOffset.forEach((offset, numOfRecords) -> ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)numOfRecords, (long)offset).close());
            buffer.flip();
            return MemoryRecords.readableRecords((ByteBuffer)buffer);
        }
    }

    private static class RecordsArgumentsProvider
    implements ArgumentsProvider {
        private RecordsArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{"FileRecords", ShareFetchTestUtils.createFileRecords(Map.of(5L, 10))}), Arguments.of((Object[])new Object[]{"MemoryRecords", this.createMemoryRecords(5L, 10)}));
        }

        private MemoryRecords createMemoryRecords(long baseOffset, int numRecords) {
            try (MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)numRecords, (long)baseOffset);){
                MemoryRecords memoryRecords = recordsBuilder.build();
                return memoryRecords;
            }
        }
    }
}

