/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaManager;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ReplicaState;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.Mockito;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004>\u0001\u0001\u0006IA\r\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019\u0019\u0005\u0001)A\u0005\u0001\"9A\t\u0001b\u0001\n\u0003y\u0004BB#\u0001A\u0003%\u0001\tC\u0004G\u0001\t\u0007I\u0011A \t\r\u001d\u0003\u0001\u0015!\u0003A\u0011\u001dA\u0005A1A\u0005\u0002}Ba!\u0013\u0001!\u0002\u0013\u0001\u0005b\u0002&\u0001\u0005\u0004%\ta\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002'\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0003\t\u0006\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0001\\\u0011%\t\u0007\u00011A\u0001B\u0003&!\u000bC\u0005c\u0001\u0001\u0007\t\u0019!C\u0001G\"I\u0011\u000e\u0001a\u0001\u0002\u0004%\tA\u001b\u0005\nY\u0002\u0001\r\u0011!Q!\n\u0011Dq!\u001c\u0001A\u0002\u0013\u0005a\u000eC\u0004s\u0001\u0001\u0007I\u0011A:\t\rU\u0004\u0001\u0015)\u0003p\u0011\u00151\b\u0001\"\u0001x\u0011\u0019\t9\u0001\u0001C\u0001o\"1\u0011\u0011\u0003\u0001\u0005\u0002]Da!!\u0006\u0001\t\u00039\bBBA\r\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u001e\u0001!\ta\u001e\u0005\u0007\u0003C\u0001A\u0011A<\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\tA\"+Z7pi\u0016dU-\u00193fe\u0016sG\rU8j]R$Vm\u001d;\u000b\u0005\u0005\u0012\u0013AB:feZ,'OC\u0001$\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t\u0001%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003I\u0002\"aM\u001e\u000e\u0003QR!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\t\u0019sG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f5\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.F\u0001A!\t9\u0013)\u0003\u0002CQ\t\u0019\u0011J\u001c;\u0002'\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u001d1|wm\u0015;beR|eMZ:fi\u0006yAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b%A\nm_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G/\u0001\u000bm_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G\u000fI\u0001\rY><WI\u001c3PM\u001a\u001cX\r^\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tA\n\u0005\u00020\u001b&\u0011a\n\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u00042m_\u000e\\\u0017N\\4TK:$W#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001B;uS2T!a\u0016\u0011\u0002\u000b\u0015\u0004xn\u00195\n\u0005e#&AE'pG.\u0014En\\2lS:<7+\u001a8eKJ\f\u0001C\u00197pG.LgnZ*f]\u0012|F%Z9\u0015\u0005q{\u0006CA\u0014^\u0013\tq\u0006F\u0001\u0003V]&$\bb\u00021\u0010\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014!\u00042m_\u000e\\\u0017N\\4TK:$\u0007%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005!\u0007CA3h\u001b\u00051'BA\u00117\u0013\tAgM\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019\u0015tG\rU8j]R|F%Z9\u0015\u0005q[\u0007b\u00021\u0013\u0003\u0003\u0005\r\u0001Z\u0001\nK:$\u0007k\\5oi\u0002\n!cY;se\u0016tGO\u0011:pW\u0016\u0014X\t]8dQV\tq\u000e\u0005\u0002(a&\u0011\u0011\u000f\u000b\u0002\u0005\u0019>tw-\u0001\fdkJ\u0014XM\u001c;Ce>\\WM]#q_\u000eDw\fJ3r)\taF\u000fC\u0004a+\u0005\u0005\t\u0019A8\u0002'\r,(O]3oi\n\u0013xn[3s\u000bB|7\r\u001b\u0011\u0002\u000bM,G/\u00169\u0015\u0003qC#aF=\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0A\u0002ba&T!A`@\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011A\u001d\u0002\u000b),h.\u001b;\n\u0007\u0005\u00151P\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3ti\u001a+Go\u00195MCR,7\u000f^(gMN,G\u000fK\u0002\u0019\u0003\u0017\u00012A_A\u0007\u0013\r\tya\u001f\u0002\u0005)\u0016\u001cH/A\fuKN$h)\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\"\u001a\u0011$a\u0003\u00029Q,7\u000f\u001e$fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fi\"\u001a!$a\u0003\u00021Q,7\u000f\u001e$fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000fK\u0002\u001c\u0003\u0017\tA\u0005^3tiRC'o\\<t\r\u0016t7-\u001a3MK\u0006$WM]#q_\u000eDW\t_2faRLwN\u001c\u0015\u00049\u0005-\u0011!\n;fgR$\u0006N]8xgVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[#yG\u0016\u0004H/[8oQ\ri\u00121B\u0001\u0018i\u0016\u001cHO\u0011:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ$2\u0001XA\u0015\u0011\u001d\tYC\ba\u0001\u0003[\tqA^3sg&|g\u000eE\u0002(\u0003_I1!!\r)\u0005\u0015\u0019\u0006n\u001c:uQ\rq\u0012Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H?\u0002\rA\f'/Y7t\u0013\u0011\ty$!\u000f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004\u001f\u0003\u0007\n\u0019&!\u0016\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0007\u00055C'A\u0003vi&d7/\u0003\u0003\u0002R\u0005\u001d#\u0001F!qS.+\u0017PV3sg&|gn]*pkJ\u001cW-\u0001\u0004ba&\\U-\u001f\u0013\u0003\u0003/JA!!\u0017\u0002\\\u0005)a)\u0012+D\u0011*!\u0011QLA0\u0003\u001d\t\u0005/[&fsNT1!!\u00195\u0003!\u0001(o\u001c;pG>d\u0007")
public class RemoteLeaderEndPointTest {
    private final TopicPartition topicPartition = new TopicPartition("test", 0);
    private final int currentLeaderEpoch;
    private final int logStartOffset;
    private final int localLogStartOffset;
    private final int logEndOffset;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private MockBlockingSender blockingSend;
    private LeaderEndPoint endPoint;
    private long currentBrokerEpoch = 1L;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public int logStartOffset() {
        return this.logStartOffset;
    }

    public int localLogStartOffset() {
        return this.localLogStartOffset;
    }

    public int logEndOffset() {
        return this.logEndOffset;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public MockBlockingSender blockingSend() {
        return this.blockingSend;
    }

    public void blockingSend_$eq(MockBlockingSender x$1) {
        this.blockingSend = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public long currentBrokerEpoch() {
        return this.currentBrokerEpoch;
    }

    public void currentBrokerEpoch_$eq(long x$1) {
        this.currentBrokerEpoch = x$1;
    }

    @BeforeEach
    public void setUp() {
        MockTime time = new MockTime();
        String logPrefix = "remote-leader-endpoint";
        BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
        int x$1 = sourceBroker.id();
        int x$2 = sourceBroker.port();
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_13 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_16 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_19 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$3, x$4, x$2, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(new LogContext(logPrefix), sourceBroker.id());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.blockingSend_$eq(new MockBlockingSender(new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>(), sourceBroker, (Time)time));
        this.endPoint_$eq((LeaderEndPoint)new RemoteLeaderEndPoint(logPrefix, (BlockingSend)this.blockingSend(), fetchSessionHandler, config, this.replicaManager(), QuotaFactory.UNBOUNDED_QUOTA, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.currentBrokerEpoch()));
    }

    @Test
    public void testFetchLatestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(7).setOffset((long)this.logEndOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logEndOffset(), 7), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(5).setOffset((long)this.logStartOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logStartOffset(), 5), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(6).setOffset((long)this.localLogStartOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.localLogStartOffset(), 6), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> expected = java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset((long)this.logEndOffset()));
        this.blockingSend().setOffsetsForNextResponse(expected);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(this.endPoint().fetchEpochEndOffsets(java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(this.currentLeaderEpoch())))).asScala();
        Assertions.assertEquals(expected, (Object)CollectionConverters$.MODULE$.MutableMapHasAsJava(result).asJava());
    }

    @Test
    public void testThrowsFencedLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.FENCED_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
    }

    @Test
    public void testThrowsUnknownLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.UNKNOWN_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testBrokerEpochSupplier(short version) {
        TopicPartition tp = new TopicPartition("topic1", 0);
        Uuid topicId1 = Uuid.randomUuid();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        java.util.Map<TopicPartition, PartitionFetchState> partitionMap = java.util.Map.of(tp, new PartitionFetchState(Optional.of(topicId1), 150L, Optional.empty(), 0, Optional.empty(), ReplicaState.FETCHING, Optional.empty()));
        Mockito.when((Object)this.replicaManager().localLogOrException(tp)).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)1L));
        ResultWithPartitions result1 = this.endPoint().buildFetch(partitionMap);
        Assertions.assertTrue((boolean)result1.partitionsWithError().isEmpty());
        Assertions.assertEquals((long)(version < 15 ? -1L : 1L), (long)((ReplicaFetch)((Optional)result1.result()).get()).fetchRequest().build(version).replicaEpoch());
        this.currentBrokerEpoch_$eq(2L);
        ResultWithPartitions result2 = this.endPoint().buildFetch(partitionMap);
        Assertions.assertTrue((boolean)result2.partitionsWithError().isEmpty());
        Assertions.assertEquals((long)(version < 15 ? -1L : 2L), (long)((ReplicaFetch)((Optional)result2.result()).get()).fetchRequest().build(version).replicaEpoch());
    }

    public RemoteLeaderEndPointTest() {
        this.currentLeaderEpoch = 10;
        this.logStartOffset = 20;
        this.localLogStartOffset = 100;
        this.logEndOffset = 300;
    }
}

