/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.test.KafkaClusterTestKit;
import org.apache.kafka.common.test.TestKitNode;
import org.apache.kafka.common.test.TestKitNodes;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReconfigurableQuorumIntegrationTest {
    static void checkKRaftVersions(Admin admin, short finalized) throws Exception {
        FeatureMetadata featureMetadata = (FeatureMetadata)admin.describeFeatures().featureMetadata().get();
        if (finalized > 0) {
            Assertions.assertTrue((boolean)featureMetadata.finalizedFeatures().containsKey("kraft.version"), (String)("finalizedFeatures does not contain kraft.version, finalizedFeatures: " + String.valueOf(featureMetadata.finalizedFeatures())));
            Assertions.assertEquals((short)finalized, (short)((FinalizedVersionRange)featureMetadata.finalizedFeatures().get("kraft.version")).minVersionLevel());
            Assertions.assertEquals((short)finalized, (short)((FinalizedVersionRange)featureMetadata.finalizedFeatures().get("kraft.version")).maxVersionLevel());
        } else {
            Assertions.assertFalse((boolean)featureMetadata.finalizedFeatures().containsKey("kraft.version"));
        }
        Assertions.assertEquals((short)0, (short)((SupportedVersionRange)featureMetadata.supportedFeatures().get("kraft.version")).minVersion());
        Assertions.assertEquals((short)1, (short)((SupportedVersionRange)featureMetadata.supportedFeatures().get("kraft.version")).maxVersion());
    }

    @Test
    public void testCreateAndDestroyNonReconfigurableCluster() throws Exception {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> ReconfigurableQuorumIntegrationTest.checkKRaftVersions(admin, KRaftVersion.KRAFT_VERSION_0.featureLevel()));
            }
        }
    }

    @Test
    public void testCreateAndDestroyReconfigurableCluster() throws Exception {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setFeature("kraft.version", KRaftVersion.KRAFT_VERSION_1.featureLevel()).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> ReconfigurableQuorumIntegrationTest.checkKRaftVersions(admin, KRaftVersion.KRAFT_VERSION_1.featureLevel()));
            }
        }
    }

    static Map<Integer, Uuid> findVoterDirs(Admin admin) throws Exception {
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        TreeMap<Integer, Uuid> result = new TreeMap<Integer, Uuid>();
        quorumInfo.voters().forEach(v -> result.put(v.replicaId(), v.replicaDirectoryId()));
        return result;
    }

    @Test
    public void testRemoveController() throws Exception {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).setFeature("kraft.version", KRaftVersion.KRAFT_VERSION_1.featureLevel()).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)10L, () -> {
                    Map<Integer, Uuid> voters = ReconfigurableQuorumIntegrationTest.findVoterDirs(admin);
                    Assertions.assertEquals(new HashSet<Integer>(List.of(Integer.valueOf(3000), Integer.valueOf(3001), Integer.valueOf(3002))), voters.keySet());
                    for (int replicaId : new int[]{3000, 3001, 3002}) {
                        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)voters.get(replicaId));
                    }
                });
                admin.removeRaftVoter(3000, ((TestKitNode)cluster.nodes().controllerNodes().get(3000)).metadataDirectoryId()).all().get();
            }
        }
    }

    @Test
    public void testRemoveAndAddSameController() throws Exception {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(4).setFeature("kraft.version", KRaftVersion.KRAFT_VERSION_1.featureLevel()).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)10L, () -> {
                    Map<Integer, Uuid> voters = ReconfigurableQuorumIntegrationTest.findVoterDirs(admin);
                    Assertions.assertEquals(new HashSet<Integer>(List.of(Integer.valueOf(3000), Integer.valueOf(3001), Integer.valueOf(3002), Integer.valueOf(3003))), voters.keySet());
                    for (int replicaId : new int[]{3000, 3001, 3002, 3003}) {
                        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)voters.get(replicaId));
                    }
                });
                Uuid dirId = ((TestKitNode)cluster.nodes().controllerNodes().get(3000)).metadataDirectoryId();
                admin.removeRaftVoter(3000, dirId).all().get();
                TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)10L, () -> {
                    Map<Integer, Uuid> voters = ReconfigurableQuorumIntegrationTest.findVoterDirs(admin);
                    Assertions.assertEquals(new HashSet<Integer>(List.of(Integer.valueOf(3001), Integer.valueOf(3002), Integer.valueOf(3003))), voters.keySet());
                    for (int replicaId : new int[]{3001, 3002, 3003}) {
                        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)voters.get(replicaId));
                    }
                });
                admin.addRaftVoter(3000, dirId, Set.of(new RaftVoterEndpoint("CONTROLLER", "example.com", 8080))).all().get();
            }
        }
    }
}

