/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tEd!B\u0015+\u0003\u0003y\u0003\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002!\u0001\u0005\u0004%\t\"\u0011\u0005\u0007#\u0002\u0001\u000b\u0011\u0002\"\t\u000bI\u0003A\u0011C*\t\u000b9\u0004A\u0011C8\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u00131\b\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0011%q\b\u00011A\u0001B\u0003&A\r\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\t\u0003\u0003A1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\f!Y\u0011q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0002\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003\"CA%\u0001\t\u0007I\u0011AA&\u0011!\t\u0019\u0006\u0001Q\u0001\n\u00055\u0003\"CA+\u0001\t\u0007I\u0011AA,\u0011!\t)\u0007\u0001Q\u0001\n\u0005e\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003k\u0002A\u0011AA<\u0011%\ti\fAI\u0001\n\u0003\ty\fC\u0005\u0002V\u0002\t\n\u0011\"\u0001\u0002X\"I\u00111\u001c\u0001\u0012\u0002\u0013\u0005\u0011Q\u001c\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u0004\u0001!\tB!\u0002\t\u000f\u0005u\b\u0001\"\u0005\u0003\n!9!\u0011\u0003\u0001\u0005\u0002\u0005\rxa\u0002B\u0015U!\u0005!1\u0006\u0004\u0007S)B\tA!\f\t\rq\nC\u0011\u0001B\u0018\u0011\u001d\u0011\t$\tC\u0001\u0003GDqAa\u000f\"\t\u0003\t\u0019\u000fC\u0004\u0003F\u0005\"\tAa\u0012\t\u000f\t5\u0013\u0005\"\u0001\u0003P!9!QN\u0011\u0005\u0002\t=\u0003b\u0002B8C\u0011\u0005!q\n\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c(BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s1\nQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003\u007f\u0001i\u0011AK\u0001#G>tGO]8mY\u0016\u0014H*[:uK:,'oU3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0003\t\u0003\"aQ(\u000e\u0003\u0011S!!\u0012$\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000f\"\u000b\u0001b]3dkJLG/\u001f\u0006\u0003\u0013*\u000baaY8n[>t'BA\u0017L\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005A#%\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003\r\u001awN\u001c;s_2dWM\u001d'jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pY\u0002\nac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003)\n\u00042!\u0016-[\u001b\u00051&BA,3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033Z\u00131aU3r!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003vi&d'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015\u0019G\u00011\u0001e\u0003!!Xm\u001d;J]\u001a|\u0007CA3m\u001b\u00051'BA4i\u0003\r\t\u0007/\u001b\u0006\u0003S*\fqA[;qSR,'O\u0003\u0002l\u001b\u0006)!.\u001e8ji&\u0011QN\u001a\u0002\t)\u0016\u001cH/\u00138g_\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g.F\u0001q!\t\tH/D\u0001s\u0015\tI5O\u0003\u0002,\u0015&\u0011QO\u001d\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]V\tA-\u0001\u0007uKN$\u0018J\u001c4p?\u0012*\u0017\u000f\u0006\u0002zyB\u0011\u0011G_\u0005\u0003wJ\u0012A!\u00168ji\"9QpBA\u0001\u0002\u0004!\u0017a\u0001=%c\u0005IA/Z:u\u0013:4w\u000eI\u0001\u000fS6\u0004H.Z7f]R\fG/[8o+\t\t\u0019\u0001E\u0002@\u0003\u000bI1!a\u0002+\u0005Q\tVo\u001c:v[&k\u0007\u000f\\3nK:$\u0018\r^5p]\u0006\u0011\u0012.\u001c9mK6,g\u000e^1uS>tw\fJ3r)\rI\u0018Q\u0002\u0005\t{*\t\t\u00111\u0001\u0002\u0004\u0005y\u0011.\u001c9mK6,g\u000e^1uS>t\u0007%A\u000enCf\u0014Wm\u0012:pkB\u0004&o\u001c;pG>d7\u000b]3dS\u001aLW\r\u001a\u000b\u0003\u0003+\u0001R!MA\f\u00037I1!!\u00073\u0005\u0019y\u0005\u000f^5p]B!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001C2p]N,X.\u001a:\u000b\u0007\u0005\u0015\"*A\u0004dY&,g\u000e^:\n\t\u0005%\u0012q\u0004\u0002\u000e\u000fJ|W\u000f\u001d)s_R|7m\u001c7\u0002?\u001d\u0014x.\u001e9Qe>$xnY8m\rJ|W\u000eV3tiB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u001c\u00059\u0011m]&SC\u001a$HCAA\u001a!\ry\u0014QG\u0005\u0004\u0003oQ#!G&SC\u001a$\u0018+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\f\u0001cY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0016\u0005\u0005u\u0002cA \u0002@%\u0019\u0011\u0011\t\u0016\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018!E2p]R\u0014x\u000e\u001c7feN+'O^3sgV\u0011\u0011q\t\t\u0005+b\u000bi$A\ngCVdG\u000fS1oI2,'OR1di>\u0014\u00180\u0006\u0002\u0002NA\u0019q(a\u0014\n\u0007\u0005E#F\u0001\u0013Rk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN4\u0015-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z\u0003Q1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:zA\u0005aa-Y;mi\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011qL:\u0002\u000b\u0019\fW\u000f\u001c;\n\t\u0005\r\u0014Q\f\u0002\u0011\u001b>\u001c7NR1vYRD\u0015M\u001c3mKJ\fQBZ1vYRD\u0015M\u001c3mKJ\u0004\u0013!B:fiV\u0003HcA=\u0002l!)1-\u0006a\u0001I\"\u001aQ#a\u001c\u0011\u0007\u0015\f\t(C\u0002\u0002t\u0019\u0014!BQ3g_J,W)Y2i\u00031\u0019'/Z1uK\n\u0013xn[3s))\tI(a \u0002\n\u0006]\u0015\u0011\u0015\t\u0004\u007f\u0005m\u0014bAA?U\tY1*\u00194lC\n\u0013xn[3s\u0011\u001d\t\tI\u0006a\u0001\u0003\u0007\u000baaY8oM&<\u0007cA \u0002\u0006&\u0019\u0011q\u0011\u0016\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0003\u00173\u0002\u0013!a\u0001\u0003\u001b\u000bA\u0001^5nKB!\u0011qRAJ\u001b\t\t\tJ\u0003\u0002:\u0011&!\u0011QSAI\u0005\u0011!\u0016.\\3\t\u0013\u0005ee\u0003%AA\u0002\u0005m\u0015aB:uCJ$X\u000f\u001d\t\u0004c\u0005u\u0015bAAPe\t9!i\\8mK\u0006t\u0007\"CAR-A\u0005\t\u0019AAS\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u00032\u0003/\t9\u000b\u0005\u0003\u0002*\u0006]f\u0002BAV\u0003g\u00032!!,3\u001b\t\tyKC\u0002\u00022:\na\u0001\u0010:p_Rt\u0014bAA[e\u00051\u0001K]3eK\u001aLA!!/\u0002<\n11\u000b\u001e:j]\u001eT1!!.3\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012TCAAaU\u0011\ti)a1,\u0005\u0005\u0015\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a43\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\fIMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HeM\u000b\u0003\u00033TC!a'\u0002D\u000612M]3bi\u0016\u0014%o\\6fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002`*\"\u0011QUAb\u0003]\u0019\b.\u001e;e_^t7JU1gi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001z\u0003Q\tG\r\u001a$pe6\fG\u000f^3s'\u0016$H/\u001b8hgR\u0019\u00110!;\t\u000f\u0005-8\u00041\u0001\u0002n\u0006Iam\u001c:nCR$XM\u001d\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\u001d\u0019Ho\u001c:bO\u0016T1!a>K\u0003!iW\r^1eCR\f\u0017\u0002BA~\u0003c\u0014\u0011BR8s[\u0006$H/\u001a:\u0002\u001d9,wo\u0013*bMR\fVo\u001c:v[R!\u00111\u0007B\u0001\u0011\u0015\u0019G\u00041\u0001e\u0003\u0001*\u0007\u0010\u001e:b\u0007>tGO]8mY\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\:\u0015\u0005\t\u001d\u0001cA+Y\u0005R1\u00111\u0007B\u0006\u0005\u001bAQa\u0019\u0010A\u0002\u0011DaAa\u0004\u001f\u0001\u0004Q\u0016aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0002\u0011Q,\u0017M\u001d#po:D3a\bB\u000b!\r)'qC\u0005\u0004\u000531'!C!gi\u0016\u0014X)Y2iQ\u001d\u0001!Q\u0004B\u0012\u0005K\u00012!\u001aB\u0010\u0013\r\u0011\tC\u001a\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017E\u0001B\u0014\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0002#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002@CM\u0011\u0011\u0005\r\u000b\u0003\u0005W\t!b]3u+B\u001cE.Y:tQ\r\u0019#Q\u0007\t\u0004K\n]\u0012b\u0001B\u001dM\nI!)\u001a4pe\u0016\fE\u000e\\\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\u0007\u0011\u0012y\u0004E\u0002f\u0005\u0003J1Aa\u0011g\u0005!\te\r^3s\u00032d\u0017!\u0007<fe&4\u0017PT8V]\u0016D\b/Z2uK\u0012$\u0006N]3bIN$2!\u001fB%\u0011\u001d\u0011Y%\na\u0001\u0003O\u000bqaY8oi\u0016DH/A\u0011hKR$Vm\u001d;He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.\u0006\u0002\u0003RA1!1\u000bB-\u0005;j!A!\u0016\u000b\u0007\t]C,\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u00057\u0012)F\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0005?\u0012I'\u0004\u0002\u0003b)!!1\rB3\u0003!\u0001(o\u001c<jI\u0016\u0014(b\u0001B4Q\u00061\u0001/\u0019:b[NLAAa\u001b\u0003b\tI\u0011I]4v[\u0016tGo]\u00017O\u0016$H+Z:u\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\u001cE.Y:tS\u000e<%o\\;q!J|Go\\2pY>sG._\u00018O\u0016$H+Z:u\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\u001cuN\\:v[\u0016\u0014xI]8vaB\u0013x\u000e^8d_2|e\u000e\\=")
public abstract class QuorumTestHarness
implements Logging {
    private final SecurityProtocol controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Stream<Arguments> getTestGroupProtocolParametersConsumerGroupProtocolOnly() {
        return QuorumTestHarness$.MODULE$.getTestGroupProtocolParametersConsumerGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestGroupProtocolParametersClassicGroupProtocolOnly() {
        return QuorumTestHarness$.MODULE$.getTestGroupProtocolParametersClassicGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestGroupProtocolParametersAll() {
        return QuorumTestHarness$.MODULE$.getTestGroupProtocolParametersAll();
    }

    public static void verifyNoUnexpectedThreads(String context) {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads(context);
    }

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public QuorumImplementation implementation() {
        return this.implementation;
    }

    public void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified() {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(this.testInfo());
    }

    public GroupProtocol groupProtocolFromTestParameters() {
        Option<GroupProtocol> gp = this.maybeGroupProtocolSpecified();
        if (gp.isEmpty()) {
            throw new IllegalStateException("Please specify the \"groupProtocol\" parameter when writing the test");
        }
        return (GroupProtocol)gp.get();
    }

    private KRaftQuorumImplementation asKRaft() {
        return (KRaftQuorumImplementation)this.implementation();
    }

    public ControllerServer controllerServer() {
        return ((KRaftQuorumImplementation)this.implementation()).controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        return new .colon.colon((Object)((KRaftQuorumImplementation)this.implementation()).controllerServer(), (List)Nil$.MODULE$);
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException("exit(" + code + ", " + message + ") called!");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException("halt(" + code + ", " + message + ") called!");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(testInfo.getTestMethod())).map((Function1 & Serializable)x$5 -> x$5.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        this.info((Function0<String>)(Function0 & Serializable)() -> "Running KRAFT test " + name);
        this.implementation_$eq(this.newKRaftQuorum(testInfo));
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = (KRaftQuorumImplementation)this.implementation();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    public void addFormatterSettings(Formatter formatter) {
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        return this.newKRaftQuorum(testInfo, new Properties());
    }

    public Seq<SecurityProtocol> extraControllerSecurityProtocols() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo, Properties overridingProps) {
        Seq<Properties> propsList = this.kraftControllerConfigs(testInfo);
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.head();
        props.putAll((Map<?, ?>)overridingProps);
        props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty("process.roles", "controller");
        props.setProperty("unstable.feature.versions.enable", "true");
        if (props.getProperty("node.id") == null) {
            props.setProperty("node.id", "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty("node.id"));
        File metadataDir = TestUtils.tempDirectory(null, null);
        props.setProperty("metadata.log.dir", metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        String securityProtocolMaps = ((IterableOnceOps)this.extraControllerSecurityProtocols().map((Function1 & Serializable)sc -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(sc), ":") + sc)).mkString(",");
        String listeners = ((IterableOnceOps)this.extraControllerSecurityProtocols().map((Function1 & Serializable)sc -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(sc), "://localhost:0"))).mkString(",");
        String listenerNames = this.extraControllerSecurityProtocols().mkString(",");
        props.setProperty("listener.security.protocol.map", "CONTROLLER:" + proto + "," + securityProtocolMaps);
        props.setProperty("listeners", "CONTROLLER://localhost:0," + listeners);
        props.setProperty("controller.listener.names", "CONTROLLER," + listenerNames);
        props.setProperty("controller.quorum.voters", nodeId + "@localhost:0");
        props.setProperty(ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        Formatter formatter = new Formatter().setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId);
        formatter.addDirectory(metadataDir.getAbsolutePath());
        formatter.setReleaseVersion(this.metadataVersion());
        formatter.setUnstableFeatureVersionsEnabled(true);
        formatter.setControllerListenerName((String)config.controllerListenerNames().get(0));
        formatter.setMetadataLogDirectory(config.metadataLogDir());
        short transactionVersion = TestInfoUtils$.MODULE$.isTransactionV2Enabled(testInfo) ? TransactionVersion.TV_2.featureLevel() : TransactionVersion.TV_1.featureLevel();
        formatter.setFeatureLevel("transaction.version", Predef$.MODULE$.short2Short(transactionVersion));
        this.addFormatterSettings(formatter);
        formatter.run();
        BootstrapMetadata bootstrapMetadata = formatter.bootstrapMetadata();
        CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, InetSocketAddress>>();
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(formatter.clusterId()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, java.util.List.of(), (FaultHandlerFactory)this.faultHandlerFactory(), ServerSocketFactory.INSTANCE);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Map.of(Predef$.MODULE$.int2Integer(nodeId), new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, formatter.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    @AfterEach
    public void tearDown() {
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }
}

