/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerQueueItem;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011A(\t\u0011Y\u0003!\u0011!Q\u0001\nAC\u0001b\u0016\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t1\u0002\u0011\t\u0011)A\u0005!\")\u0011\f\u0001C\u00015\"9!\r\u0001b\u0001\n\u0003\u0019\u0007B\u00028\u0001A\u0003%A\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003u\u0001\u0011\u0005\u0003\u000fC\u0003v\u0001\u0011\u0005c\u000f\u0003\u0004K\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011!\ty\u0004\u0001C\u00017\u0005\u0005\u0003BBA)\u0001\u0011\u0005\u0001oB\u0005\u0002Tm\t\t\u0011#\u0001\u0002V\u0019A!dGA\u0001\u0012\u0003\t9\u0006\u0003\u0004Z+\u0011\u0005\u0011q\f\u0005\n\u0003C*\u0012\u0013!C\u0001\u0003GB\u0011\"!\u001f\u0016#\u0003%\t!a\u001f\t\u0013\u0005}T#%A\u0005\u0002\u0005m$AI'pG.tu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'O\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011%\u000b\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA\u0001\\1oO*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u0019y%M[3diB\u0011!fM\u0007\u0002W)\u0011A&L\u0001\u0007G>lWn\u001c8\u000b\u0005qq#B\u0001\u00100\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005QZ#A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019G.[3oiV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;]\u000591\r\\5f]R\u001c\u0018B\u0001\u001f:\u0005)iunY6DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003\u0011!\u0018.\\3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tk\u0013\u0001B;uS2L!\u0001R!\u0003\u00115{7m\u001b+j[\u0016\facY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\t\u0003\u000f\"k\u0011aG\u0005\u0003\u0013n\u0011acQ8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM]\u0001\u0016G>tGO]8mY\u0016\u0014\u0018\t]5WKJ\u001c\u0018n\u001c8t!\tAD*\u0003\u0002Ns\tyaj\u001c3f\u0003BLg+\u001a:tS>t7/\u0001\bsKR\u0014\u0018\u0010V5nK>,H/T:\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u00131!\u00138u\u0003=\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fmcVLX0aCB\u0011q\t\u0001\u0005\u0006k)\u0001\ra\u000e\u0005\u0006})\u0001\ra\u0010\u0005\u0006\u000b*\u0001\rA\u0012\u0005\b\u0015*\u0001\n\u00111\u0001L\u0011\u001dq%\u0002%AA\u0002ACqa\u0016\u0006\u0011\u0002\u0003\u0007\u0001+A\u0006v]N,g\u000e^)vKV,W#\u00013\u0011\u0007\u0015L7.D\u0001g\u0015\t9\u0007.\u0001\u0006d_:\u001cWO\u001d:f]RT!AQ\u0013\n\u0005)4'!F\"p]\u000e,(O]3oi2Kgn[3e\t\u0016\fX/\u001a\t\u0003\u000f2L!!\\\u000e\u000339{G-\u001a+p\u0007>tGO]8mY\u0016\u0014\u0018+^3vK&#X-\\\u0001\rk:\u001cXM\u001c;Rk\u0016,X\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002cB\u0011\u0011K]\u0005\u0003gJ\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0006tK:$'+Z9vKN$H\u0003B9x\u0003CAQ\u0001_\bA\u0002e\fqA]3rk\u0016\u001cH\u000fM\u0002{\u0003\u001f\u0001Ra_A\u0003\u0003\u0017q1\u0001`A\u0001\u001b\u0005i(B\u0001@\u0000\u0003!\u0011X-];fgR\u001c(B\u0001\u0017/\u0013\r\t\u0019!`\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!\u0011qAA\u0005\u0005\u001d\u0011U/\u001b7eKJT1!a\u0001~!\u0011\ti!a\u0004\r\u0001\u0011Y\u0011\u0011C<\u0002\u0002\u0003\u0005)\u0011AA\n\u0005\ryF%M\t\u0005\u0003+\tY\u0002E\u0002R\u0003/I1!!\u0007S\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001`A\u000f\u0013\r\ty\" \u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"9\u00111E\bA\u0002\u0005\u0015\u0012\u0001C2bY2\u0014\u0017mY6\u0011\u0007)\n9#C\u0002\u0002*-\u0012!eQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014HCAA\u0017!\u0015\ty#!\rL\u001b\u0005A\u0017bAA\u001aQ\nAq\n\u001d;j_:\fG.\u0001\u0007hKR$\u0016.\\3pkRl5\u000f\u0006\u0002\u0002:A\u0019\u0011+a\u000f\n\u0007\u0005u\"K\u0001\u0003M_:<\u0017A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0005\u0003\u0007\ny\u0005F\u0002r\u0003\u000bBq!a\u0012\u0013\u0001\u0004\tI%\u0001\u0005sKN\u0004xN\\:f!\rA\u00141J\u0005\u0004\u0003\u001bJ$AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\u0006qJ\u0001\ra[\u0001\u0005a>dG.\u0001\u0012N_\u000e\\gj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003\u000fV\u00192!FA-!\r\t\u00161L\u0005\u0004\u0003;\u0012&AB!osJ+g\r\u0006\u0002\u0002V\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!!\u001a+\u0007-\u000b9g\u000b\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C;oG\",7m[3e\u0015\r\t\u0019HU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA<\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0010\u0016\u0004!\u0006\u001d\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c\u0007")
public class MockNodeToControllerChannelManager
implements NodeToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return 30000;
    }

    public static int $lessinit$greater$default$5() {
        return 60000;
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return NodeApiVersions.create();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return Optional.of(this.controllerApiVersions);
    }

    public long getTimeoutMs() {
        return this.retryTimeoutMs();
    }

    public void handleResponse(NodeToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<NodeToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            NodeToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public MockNodeToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ConcurrentLinkedDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

