/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.KafkaConfig;
import kafka.server.MetadataVersionConfigValidator;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MetadataVersionConfigValidatorTest {
    private static final LogDeltaManifest TEST_MANIFEST = LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(90L).numBytes(88L).build();
    public static final MetadataProvenance TEST_PROVENANCE = new MetadataProvenance(50L, 3, 8000L, true);

    void testWith(MetadataVersion metadataVersion, KafkaConfig config, FaultHandler faultHandler) throws Exception {
        try (MetadataVersionConfigValidator validator = new MetadataVersionConfigValidator(config, faultHandler);){
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            if (metadataVersion != null) {
                delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
            }
            MetadataImage image = delta.apply(TEST_PROVENANCE);
            validator.onMetadataUpdate(delta, image, (LoaderManifest)TEST_MANIFEST);
        }
    }

    @Test
    void testValidatesConfigOnMetadataChange() throws Exception {
        MetadataVersion metadataVersion = MetadataVersion.IBP_3_7_IV2;
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        FaultHandler faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        Mockito.when((Object)config.brokerId()).thenReturn((Object)8);
        this.testWith(metadataVersion, config, faultHandler);
        ((KafkaConfig)Mockito.verify((Object)config, (VerificationMode)Mockito.times((int)1))).validateWithMetadataVersion((MetadataVersion)ArgumentMatchers.eq((Object)metadataVersion));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{faultHandler});
    }

    @Test
    void testInvokesFaultHandlerOnException() throws Exception {
        MetadataVersion metadataVersion = MetadataVersion.IBP_3_7_IV2;
        Exception exception = new Exception();
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        FaultHandler faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        Mockito.when((Object)faultHandler.handleFault((String)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenReturn((Object)new RuntimeException("returned exception"));
        Mockito.when((Object)config.brokerId()).thenReturn((Object)8);
        ((KafkaConfig)BDDMockito.willAnswer(invocation -> {
            throw exception;
        }).given((Object)config)).validateWithMetadataVersion((MetadataVersion)ArgumentMatchers.eq((Object)metadataVersion));
        this.testWith(metadataVersion, config, faultHandler);
        ((KafkaConfig)Mockito.verify((Object)config, (VerificationMode)Mockito.times((int)1))).validateWithMetadataVersion((MetadataVersion)ArgumentMatchers.eq((Object)metadataVersion));
        ((FaultHandler)Mockito.verify((Object)faultHandler, (VerificationMode)Mockito.times((int)1))).handleFault((String)ArgumentMatchers.eq((Object)"Broker configuration does not support the cluster MetadataVersion"), (Throwable)ArgumentMatchers.eq((Object)exception));
    }
}

