/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001E\t\u0001-!)1\u0004\u0001C\u00019!)a\u0004\u0001C!?!)\u0001\b\u0001C\u0001s!)a\b\u0001C\u0001s!)\u0001\t\u0001C\u0001s!)!\t\u0001C\u0001s!)A\t\u0001C\u0001s!)a\t\u0001C\u0001s!)\u0001\n\u0001C\u0001s!)!\n\u0001C\u0001s!)A\n\u0001C\u0001s!)a\n\u0001C\u0001s!)\u0001\u000b\u0001C\u0001s!)!\u000b\u0001C\u0001s!)A\u000b\u0001C\u0001s\t\u0019R*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fV3ti*\u0011!cE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002#%\u0011!$\u0005\u0002\u001c\u0003\n\u001cHO]1di6+G/\u00193bi\u0006\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\r\u0001\u0003\u0015\u0019X\r^+q)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\b\"B\u0014\u0003\u0001\u0004A\u0013\u0001\u0003;fgRLeNZ8\u0011\u0005%\u0012T\"\u0001\u0016\u000b\u0005-b\u0013aA1qS*\u0011QFL\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0003'A\u0003kk:LGOC\u00012\u0003\ry'oZ\u0005\u0003g)\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u0005U\u0002\"!\u000b\u001c\n\u0005]R#A\u0003\"fM>\u0014X-R1dQ\u0006\u0001C/Z:u\u00072,8\u000f^3s\u0013\u0012<\u0016\u000e\u001e5SKF,Xm\u001d;WKJ\u001c\u0018n\u001c82)\u0005\u0001\u0003FA\u0002<!\tIC(\u0003\u0002>U\t!A+Z:u\u0003Q!Xm\u001d;DYV\u001cH/\u001a:JI&\u001bh+\u00197jI\"\u0012AaO\u0001\ti\u0016\u001cHOU1dW\"\u0012QaO\u0001\u000fi\u0016\u001cH/S:J]R,'O\\1mQ\t11(A\nuKN$hj\u001c+pa&\u001c7OU3rk\u0016\u001cH\u000f\u000b\u0002\bw\u0005)B/Z:u\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>t\u0007F\u0001\u0005<\u0003=\"Xm\u001d;BkR|7I]3bi\u0016$v\u000e]5d/&$\b.\u00138wC2LGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\tI1(\u0001\u000buKN$\u0018\t\u001c7U_BL7m\u001d*fcV,7\u000f\u001e\u0015\u0003\u0015m\na\u0003^3tiR{\u0007/[2JINLeNU3ta>t7/\u001a\u0015\u0003\u0017m\nA\u0003^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007F\u0001\u0007<\u0003]!Xm\u001d;SKBd\u0017nY1E_^t'+Z:q_:\u001cX\r\u000b\u0002\u000ew\u00051C/Z:u\u0013N\u0014\u0018I\u001a;fe\n\u0013xn[3s'\",H\u000fR8x]\u0006sGMS8j]N\u0014\u0015mY6)\u00059Y\u0014\u0001\b;fgR\fE.\u001b<f\u0005J|7.\u001a:t/&$\bNT8U_BL7m\u001d\u0015\u0003\u001fm\u0002")
public class MetadataRequestTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        Assertions.assertNull((Object)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId(), (String)"v1 clusterId should be null");
    }

    @Test
    public void testClusterIdIsValid() {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2()).clusterId());
    }

    @Test
    public void testRack() {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assertions.assertEquals((Object)("rack/" + broker.id()), (Object)broker.rack(), (String)"Rack information should match config"));
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)4), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Iterable topicMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$1))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$2))).get();
        Assertions.assertTrue((boolean)internalTopicMetadata.isInternal(), (String)"internalTopic should show isInternal");
        Assertions.assertFalse((boolean)notInternalTopicMetadata.isInternal(), (String)"notInternalTopic topic not should show isInternal");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.buildCluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), true, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertTrue((boolean)metadataResponse.topicMetadata().isEmpty(), (String)"Response should have no topics");
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$4 -> {
            x$4.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV0.errors().isEmpty(), (String)"V0 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV0.topicMetadata().size(), (String)"V0 Response should have 2 (all) topics");
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV1.errors().isEmpty(), (String)"V1 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV1.topicMetadata().size(), (String)"V1 Response should have 2 (all) topics");
    }

    @Test
    public void testTopicIdsInResponse() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(topic2, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        MetadataResponse resp1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 0, 9).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp1.topicMetadata().size());
        resp1.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
        MetadataResponse resp2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp2.topicMetadata().size());
        resp2.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
            Assertions.assertNotNull((Object)topicMetadata.topicId());
        });
    }

    @Test
    public void testPreferredReplica() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopicWithAssignment("t1", (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        ((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)index -> this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)((KafkaBroker)this.brokers().apply(BoxesRunTime.unboxToInt((Object)index))).socketServer())))).foreach((Function1 & Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$2(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        KafkaBroker downNode = (KafkaBroker)this.brokers().find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, broker))).get();
        downNode.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 50000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replica was not found down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$), true), (short)0), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v0BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()))).toSeq();
        Assertions.assertTrue((boolean)v0MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v0BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertTrue((v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0, (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assertions.assertTrue((!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0, (String)"PartitionMetadata should have an error");
        Assertions.assertTrue((v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0, (String)("Response should have " + (replicaCount - 1) + " replicas"));
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v1BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSeq();
        Assertions.assertTrue((boolean)v1MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v1BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertEquals((int)1, (int)v1MetadataResponse.topicMetadata().size(), (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)v1PartitionMetadata.error, (String)"PartitionMetadata should have no errors");
        Assertions.assertEquals((int)replicaCount, (int)v1PartitionMetadata.replicaIds.size(), (String)("Response should have " + replicaCount + " replicas"));
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ((KafkaBroker)this.brokers().last()).shutdown();
        ((KafkaBroker)this.brokers().last()).awaitShutdown();
        ((KafkaBroker)this.brokers().last()).startup();
        this.checkIsr$1((Seq)this.brokers(), topic);
    }

    @Test
    public void testAliveBrokersWithNoTopics() {
        KafkaBroker brokerToShutdown = (KafkaBroker)this.brokers().last();
        brokerToShutdown.shutdown();
        brokerToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size() - 1);
        brokerToShutdown.startup();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size());
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$1) {
        String string = x$1.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$2) {
        String string = x$2.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$2(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()))).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaIds).asScala());
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala());
            Assertions.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaBroker broker) {
        int serverId = broker.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaBroker downNode$1, Node x$6) {
        return x$6.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaBroker downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic$1, (List)Nil$.MODULE$)).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !CollectionConverters$.MODULE$.CollectionHasAsScala(response.brokers()).asScala().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$6)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaBroker x$9) {
        BrokerState brokerState = x$9.brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return brokerState == null ? brokerState2 != null : !brokerState.equals(brokerState2);
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaBroker x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaBroker broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option firstPartitionMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.partitionMetadata()).asScala().headOption());
        actualIsr$1.elem = (scala.collection.immutable.Set)firstPartitionMetadata.map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaBroker broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return "Topic metadata not updated correctly in broker " + broker$1 + "\nExpected ISR: " + expectedIsr$1 + " \nActual ISR : " + (scala.collection.immutable.Set)actualIsr$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaBroker broker) {
        Predef$.MODULE$.Set().empty();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.CollectionHasAsScala($anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.partitionMetadata()).asScala().headOption()).map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            scala.collection.immutable.Set set2 = expectedIsr$1;
            Object var10_7 = null;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Topic metadata not updated correctly in broker " + broker + "\nExpected ISR: " + expectedIsr$1 + " \nActual ISR : " + set));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void checkIsr$1(Seq brokers, String topic) {
        Seq activeBrokers = (Seq)brokers.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$9)));
        scala.collection.immutable.Set expectedIsr = ((IterableOnceOps)activeBrokers.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$10)))).toSet();
        activeBrokers.foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef response$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.anySocketServer()));
        response$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef response$1) {
        return "Expected " + expectedBrokersCount$1 + " brokers, but there are " + ((MetadataResponse)((Option)response$1.elem).get()).brokers().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaBroker x$13) {
        BrokerState brokerState = x$13.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaBroker broker$2, scala.collection.immutable.Seq brokersSorted$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq topicMetadata = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$15 -> x$15.topic(), (Ordering)Ordering.String$.MODULE$);
        scala.collection.immutable.Seq seq = brokersSorted$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$16 -> x$16.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, scala.collection.immutable.Seq brokersSorted$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersSorted$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic metadata not updated correctly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMetadata$1(Seq brokers, int expectedBrokersCount) {
        Some some;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testAliveBrokersWithNoTopics$1_metadataResponse = this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
            some = new Some((Object)$anonfun$testAliveBrokersWithNoTopics$1_metadataResponse);
            Object var10_6 = null;
            if ($anonfun$testAliveBrokersWithNoTopics$1_metadataResponse.brokers().size() == expectedBrokersCount) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Expected " + expectedBrokersCount + " brokers, but there are " + ((MetadataResponse)some.get()).brokers().size()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Seq brokersSorted = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)some.get()).brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableOnceOps)brokers.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$13)))).foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersSorted, broker);
            return BoxedUnit.UNIT;
        });
    }
}

