/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.MetadataCacheTest;
import kafka.server.MetadataCacheTest$;
import kafka.server.MetadataCacheTest$Broker$2$;
import kafka.server.MetadataCacheTest$Partition$2$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.KRaftVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmv!\u0002\"D\u0011\u0003Ae!\u0002&D\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)\u0006\"B6\u0002\t\u0003ag!\u0002&D\u0001\u0005\u0015\u0001B\u0002*\u0006\t\u0003\t9\u0001C\u0005\u0002\f\u0015\u0011\r\u0011\"\u0001\u0002\u000e!A\u0011QC\u0003!\u0002\u0013\ty\u0001C\u0004\u0002\u0018\u0015!\t!!\u0007\t\u000f\u0005\u001dS\u0001\"\u0001\u0002J!9\u00111K\u0003\u0005\u0002\u0005U\u0003bBA0\u000b\u0011\u0005\u0011\u0011\r\u0005\b\u0003W*A\u0011BA7\u0011\u001d\ty+\u0002C\u0001\u0003cCq!a/\u0006\t\u0003\ti\fC\u0004\u0002H\u0016!\t!!3\t\u000f\u0005MW\u0001\"\u0001\u0002V\"9\u0011q\\\u0003\u0005\u0002\u0005\u0005\bbBAv\u000b\u0011%\u0011Q\u001e\u0005\b\u0005#)A\u0011\u0001B\n\u0011\u001d\u0011\u0019#\u0002C\u0001\u0005'AqAa\n\u0006\t\u0003\u0011\u0019\u0002C\u0004\u0003,\u0015!\tAa\u0005\t\u000f\t=R\u0001\"\u0001\u00032!9!1H\u0003\u0005\u0002\tM\u0001\"\u0003B \u000b\t\u0007I\u0011\u0001B!\u0011!\u0011\u0019%\u0002Q\u0001\n\u0005U\u0005\"\u0003B#\u000b\t\u0007I\u0011\u0001B!\u0011!\u00119%\u0002Q\u0001\n\u0005U\u0005\"\u0003B%\u000b\t\u0007I\u0011\u0001B&\u0011!\u0011\u0019'\u0002Q\u0001\n\t5\u0003\"\u0003B3\u000b\t\u0007I\u0011\u0001B4\u0011!\u0011\t(\u0002Q\u0001\n\t%\u0004\"\u0003B:\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011i(\u0002Q\u0001\n\t]\u0004\"\u0003B@\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011\t)\u0002Q\u0001\n\t]\u0004\"\u0003BB\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011))\u0002Q\u0001\n\t]\u0004\"\u0003BD\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011I)\u0002Q\u0001\n\t]\u0004\"\u0003BF\u000b\t\u0007I\u0011\u0001B&\u0011!\u0011i)\u0002Q\u0001\n\t5\u0003\"\u0003BH\u000b\t\u0007I\u0011\u0001B4\u0011!\u0011\t*\u0002Q\u0001\n\t%\u0004\"\u0003BJ\u000b\t\u0007I\u0011\u0001B4\u0011!\u0011)*\u0002Q\u0001\n\t%\u0004\"\u0003BL\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011I*\u0002Q\u0001\n\t]\u0004\"\u0003BN\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011i*\u0002Q\u0001\n\t]\u0004\"\u0003BP\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011\t+\u0002Q\u0001\n\t]\u0004\"\u0003BR\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011)+\u0002Q\u0001\n\t]\u0004\"\u0003BT\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011I+\u0002Q\u0001\n\t]\u0004\"\u0003BV\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011i+\u0002Q\u0001\n\t]\u0004\"\u0003BX\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011\t,\u0002Q\u0001\n\t]\u0004\"\u0003BZ\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011),\u0002Q\u0001\n\t]\u0004\"\u0003B\\\u000b\t\u0007I\u0011\u0001B;\u0011!\u0011I,\u0002Q\u0001\n\t]\u0014!E'fi\u0006$\u0017\r^1DC\u000eDW\rV3ti*\u0011A)R\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002J\u00035\t1IA\tNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a+fgR\u001c\"!\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001*A\u0007dC\u000eDW\r\u0015:pm&$WM\u001d\u000b\u0002-B\u0019qK\u00181\u000e\u0003aS!!\u0017.\u0002\rM$(/Z1n\u0015\tYF,\u0001\u0003vi&d'\"A/\u0002\t)\fg/Y\u0005\u0003?b\u0013aa\u0015;sK\u0006l\u0007CA1j\u001b\u0005\u0011'BA2e\u0003!iW\r^1eCR\f'B\u0001$f\u0015\t1w-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0006\u0019qN]4\n\u0005)\u0014'!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0006va\u0012\fG/Z\"bG\",GcA7qeB\u0011QJ\\\u0005\u0003_:\u0013A!\u00168ji\")\u0011\u000f\u0002a\u0001A\u0006)1-Y2iK\")1\u000f\u0002a\u0001i\u00069!/Z2pe\u0012\u001c\bcA;yu6\taO\u0003\u0002x\u001d\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e4(aA*fcB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0011A\u0014x\u000e^8d_2T!a 3\u0002\r\r|W.\\8o\u0013\r\t\u0019\u0001 \u0002\u000b\u0003BLW*Z:tC\u001e,7CA\u0003M)\t\tI\u0001\u0005\u0002J\u000b\u0005Y!M]8lKJ,\u0005o\\2i+\t\ty\u0001E\u0002N\u0003#I1!a\u0005O\u0005\u0011auN\\4\u0002\u0019\t\u0014xn[3s\u000bB|7\r\u001b\u0011\u0002C\u001d,G\u000fV8qS\u000elU\r^1eCR\fgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\u00075\fY\u0002C\u0003r\u0013\u0001\u0007\u0001\rK\u0002\n\u0003?\u0001B!!\t\u000205\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0004qCJ\fWn\u001d\u0006\u0005\u0003S\tY#A\u0004kkBLG/\u001a:\u000b\u0007\u00055r-A\u0003kk:LG/\u0003\u0003\u00022\u0005\r\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":\u0011\"!\u000e\u0002B\u0005\r\u0003\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u00121E\u0001\taJ|g/\u001b3fe&!\u0011qHA\u001d\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\t)%I\u0001U\u0003A9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rF\u0002n\u0003\u0017BQ!\u001d\u0006A\u0002\u0001D3ACA\u0010Q\u001dQ\u0011QGA!\u0003#b#!!\u0012\u0002W\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016$2!\\A,\u0011\u0015\t8\u00021\u0001aQ\rY\u0011q\u0004\u0015\b\u0017\u0005U\u0012\u0011IA/Y\t\t)%A\u001bhKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*[:uK:,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016|e\u000eT3bI\u0016\u0014HcA7\u0002d!)\u0011\u000f\u0004a\u0001A\"\u001aA\"a\b)\u000f1\t)$!\u0011\u0002j1\u0012\u0011QI\u00019m\u0016\u0014\u0018NZ=U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:Pe\u0016sG\r]8j]Rtu\u000e^!wC&d\u0017M\u00197f)5i\u0017qNA9\u0003\u0003\u000b\t*a'\u0002&\")\u0011/\u0004a\u0001A\"9\u00111O\u0007A\u0002\u0005U\u0014a\u00022s_.,'o\u001d\t\u0005kb\f9\b\u0005\u0003\u0002z\u0005uTBAA>\u0015\t\u0019g0\u0003\u0003\u0002\u0000\u0005m$\u0001\u0006*fO&\u001cH/\u001a:Ce>\\WM\u001d*fG>\u0014H\rC\u0004\u0002\u00046\u0001\r!!\"\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#\u007f\u0003\u001dqW\r^<pe.LA!a$\u0002\n\naA*[:uK:,'OT1nK\"9\u00111S\u0007A\u0002\u0005U\u0015A\u00027fC\u0012,'\u000fE\u0002N\u0003/K1!!'O\u0005\rIe\u000e\u001e\u0005\b\u0003;k\u0001\u0019AAP\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB\u001910!)\n\u0007\u0005\rFP\u0001\u0004FeJ|'o\u001d\u0005\b\u0003Ok\u0001\u0019AAU\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0011\u00075\u000bY+C\u0002\u0002.:\u0013qAQ8pY\u0016\fg.A\u0012hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0007\u000f\\5dC:{G/\u0011<bS2\f'\r\\3\u0015\u00075\f\u0019\fC\u0003r\u001d\u0001\u0007\u0001\rK\u0002\u000f\u0003?AsADA\u001b\u0003\u0003\nI\f\f\u0002\u0002F\u0005yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3\u0015\u00075\fy\fC\u0003r\u001f\u0001\u0007\u0001\rK\u0002\u0010\u0003?AsaDA\u001b\u0003\u0003\n)\r\f\u0002\u0002F\u0005\u0001t-\u001a;U_BL7-T3uC\u0012\fG/Y,ji\"tuN\\*vaB|'\u000f^3e'\u0016\u001cWO]5usB\u0013x\u000e^8d_2$2!\\Af\u0011\u0015\t\b\u00031\u0001aQ\r\u0001\u0012q\u0004\u0015\b!\u0005U\u0012\u0011IAiY\t\t)%\u0001\u0018hKR\fE.\u001b<f\u0005J|7.\u001a:t'\"|W\u000f\u001c3O_R\u0014U-T;uCR,GMQ=Va\u0012\fG/Z\"bG\",GcA7\u0002X\")\u0011/\u0005a\u0001A\"\u001a\u0011#a\b)\u000fE\t)$!\u0011\u0002^2\u0012\u0011QI\u0001!i\u0016\u001cHoR3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000fF\u0002n\u0003GDQ!\u001d\nA\u0002\u0001D3AEA\u0010Q\u001d\u0011\u0012QGA!\u0003Sd#!!\u0012\u0002#\u001d,G/\u00117m%\u0016\u0004H.[2b'\u0016$8\u000f\u0006\u0004\u0002p\n%!Q\u0002\t\u0006\u001b\u0006E\u0018Q_\u0005\u0004\u0003gt%!B!se\u0006L\bCBA|\u0003s\fi0D\u0001[\u0013\r\tYP\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019\u0001X\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\b\t\u0005!aB%oi\u0016<WM\u001d\u0005\b\u0005\u0017\u0019\u0002\u0019AAK\u0003)qW/\u001c\"s_.,'o\u001d\u0005\b\u0005\u001f\u0019\u0002\u0019AAK\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u0001\u0013i\u0016\u001cH/S:Ce>\\WM\u001d$f]\u000e,G\rF\u0001nQ\r!\"q\u0003\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)!!QDA\u0014\u0003\r\t\u0007/[\u0005\u0005\u0005C\u0011YB\u0001\u0003UKN$\u0018\u0001\t;fgRL5O\u0011:pW\u0016\u0014\u0018J\\\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D3!\u0006B\f\u0003Y!Xm\u001d;HKRd\u0015N^3Ce>\\WM]#q_\u000eD\u0007f\u0001\f\u0003\u0018\u0005IB/Z:u\t\u0016\u001c8M]5cKR{\u0007/[2SKN\u0004xN\\:fQ\r9\"qC\u0001\u0014i\u0016\u001cHoR3u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u000b\u0004[\nM\u0002\"B9\u0019\u0001\u0004\u0001\u0007f\u0001\r\u0002 !:\u0001$!\u000e\u0002B\teBFAA#\u00031\"Xm\u001d;HKR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001c8i\u001c8tS\u0012,'o\u001d#je\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u001a\u0005/\t\u0011d\u001c7e%\u0016\fX/Z:u\u0007>tGO]8mY\u0016\u0014X\t]8dQV\u0011\u0011QS\u0001\u001b_2$'+Z9vKN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eI\u0001\u001a]\u0016<(+Z9vKN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0001\u000eoK^\u0014V-];fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007%\u0001\u0007g_>$v\u000e]5d\u001d\u0006lW-\u0006\u0002\u0003NA!!q\nB/\u001d\u0011\u0011\tF!\u0017\u0011\u0007\tMc*\u0004\u0002\u0003V)\u0019!qK$\u0002\rq\u0012xn\u001c;?\u0013\r\u0011YFT\u0001\u0007!J,G-\u001a4\n\t\t}#\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tmc*A\u0007g_>$v\u000e]5d\u001d\u0006lW\rI\u0001\u000bM>|Gk\u001c9jG&#WC\u0001B5!\u0011\u0011YG!\u001c\u000e\u0003yL1Aa\u001c\u007f\u0005\u0011)V/\u001b3\u0002\u0017\u0019|w\u000eV8qS\u000eLE\rI\u0001\f_2$gi\\8QCJ$\b'\u0006\u0002\u0003xA!\u0011\u0011\u0010B=\u0013\u0011\u0011Y(a\u001f\u0003\u001fA\u000b'\u000f^5uS>t'+Z2pe\u0012\fAb\u001c7e\r>|\u0007+\u0019:ua\u0001\n1B\\3x\r>|\u0007+\u0019:ua\u0005aa.Z<G_>\u0004\u0016M\u001d;1A\u0005Yq\u000e\u001c3G_>\u0004\u0016M\u001d;2\u00031yG\u000e\u001a$p_B\u000b'\u000f^\u0019!\u0003-qWm\u001e$p_B\u000b'\u000f^\u0019\u0002\u00199,wOR8p!\u0006\u0014H/\r\u0011\u0002\u0019\t\f'\u000fV8qS\u000et\u0015-\\3\u0002\u001b\t\f'\u000fV8qS\u000et\u0015-\\3!\u0003)\u0011\u0017M\u001d+pa&\u001c\u0017\nZ\u0001\fE\u0006\u0014Hk\u001c9jG&#\u0007%A\nsK\u000e\u0014X-\u0019;fI\n\u000b'\u000fV8qS\u000eLE-\u0001\u000bsK\u000e\u0014X-\u0019;fI\n\u000b'\u000fV8qS\u000eLE\rI\u0001\f_2$')\u0019:QCJ$\b'\u0001\u0007pY\u0012\u0014\u0015M\u001d)beR\u0004\u0004%A\u0006oK^\u0014\u0015M\u001d)beR\u0004\u0014\u0001\u00048fo\n\u000b'\u000fU1siB\u0002\u0013a\u00043fY\u0016$X\r\u001a\"beB\u000b'\u000f\u001e\u0019\u0002!\u0011,G.\u001a;fI\n\u000b'\u000fU1siB\u0002\u0013aC8mI\n\u000b'\u000fU1siF\nAb\u001c7e\u0005\u0006\u0014\b+\u0019:uc\u0001\n1B\\3x\u0005\u0006\u0014\b+\u0019:uc\u0005aa.Z<CCJ\u0004\u0016M\u001d;2A\u0005yA-\u001a7fi\u0016$')\u0019:QCJ$\u0018'\u0001\teK2,G/\u001a3CCJ\u0004\u0016M\u001d;2A\u0005Yq\u000e\u001c3CCJ\u0004\u0016M\u001d;3\u00031yG\u000e\u001a\"beB\u000b'\u000f\u001e\u001a!\u0003-qWm\u001e\"beB\u000b'\u000f\u001e\u001a\u0002\u00199,wOQ1s!\u0006\u0014HO\r\u0011\u0002\u001f\u0011,G.\u001a;fI\n\u000b'\u000fU1siJ\n\u0001\u0003Z3mKR,GMQ1s!\u0006\u0014HO\r\u0011")
public class MetadataCacheTest {
    private final long brokerEpoch;
    private final int oldRequestControllerEpoch;
    private final int newRequestControllerEpoch;
    private final String fooTopicName;
    private final Uuid fooTopicId = Uuid.fromString((String)"HDceyWK0Ry-j3XLR8DvvGA");
    private final PartitionRecord oldFooPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(4).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newFooPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord oldFooPart1 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newFooPart1 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final String barTopicName;
    private final Uuid barTopicId = Uuid.fromString((String)"97FBD1g4QyyNNZNY94bkRA");
    private final Uuid recreatedBarTopicId = Uuid.fromString((String)"lZokxuaPRty7c5P4dNdTYA");
    private final PartitionRecord oldBarPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord newBarPart0 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(0).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord deletedBarPart0 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(0).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord oldBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord deletedBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord oldBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(9).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord newBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(8).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord deletedBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));

    public static void updateCache(MetadataCache cache, Seq<ApiMessage> records) {
        MetadataCacheTest$.MODULE$.updateCache(cache, records);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata(java.util.Set.of(topic), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), false, false).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        TopicRecord topic0Record = new TopicRecord().setName(topic0).setTopicId((Uuid)topicIds.get(topic0));
        TopicRecord topic1Record = new TopicRecord().setName(topic1).setTopicId((Uuid)topicIds.get(topic1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(0).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(1).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic1)).setPartitionId(0).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)new .colon.colon((Object)topic0Record, (List)new .colon.colon((Object)topic1Record, (List)Nil$.MODULE$)))).$plus$plus((IterableOnce)partitionStates)));
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        RegisterBrokerRecord.BrokerEndpointCollection broker0Endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(plaintextListenerName.value()), (List)new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setName(sslListenerName.value()), (List)Nil$.MODULE$)).iterator()).asJava());
        RegisterBrokerRecord.BrokerEndpointCollection broker1Endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(plaintextListenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(broker0Endpoints), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(broker1Endpoints), (List)Nil$.MODULE$));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, Seq<RegisterBrokerRecord> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leaderEpoch = 1;
        int partitionEpoch = 3;
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setPartitionEpoch(partitionEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Buffer topicMetadatas = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), listenerName, false, errorUnavailableListeners)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        int partitionEpoch = 3;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        RegisterBrokerRecord.BrokerEndpointCollection endPoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endPoints), (List)Nil$.MODULE$);
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setPartitionEpoch(partitionEpoch).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Buffer topicMetadatas = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), listenerName, false, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Buffer topicMetadatasWithError = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), listenerName, true, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setRack("rack1").setFenced(false).setEndPoints(endpoints), (List)Nil$.MODULE$);
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Buffer topicMetadatas = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), listenerName, false, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Buffer topicMetadatasWithError = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), listenerName, true, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        RegisterBrokerRecord brokers = new RegisterBrokerRecord().setBrokerId(0).setRack("").setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$).iterator()).asJava()));
        TopicRecord topicRecord = new TopicRecord().setName(topic).setTopicId(topicId);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)new .colon.colon((Object)brokers, (List)new .colon.colon((Object)topicRecord, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)partitionStates)));
        Buffer topicMetadata = CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of(topic), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), false, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topicId, cache, (Seq)topicRecords);
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topicId, cache, (Seq)topicRecords);
        initialBrokerIds.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((boolean)cache.hasAliveBroker(brokerId)));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionReplicaEndpoints(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int numBrokers = 10;
        int fencedBrokerId = numBrokers / 3;
        IndexedSeq brokerRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$testGetPartitionReplicaEndpoints$1(fencedBrokerId, securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        String topic = "many-partitions-topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int replicationFactor = 3;
        java.util.List[] replicaSets = this.getAllReplicaSets(numBrokers, replicationFactor);
        int numPartitions = replicaSets.length;
        IndexedSeq partitionRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)partitionId -> MetadataCacheTest.$anonfun$testGetPartitionReplicaEndpoints$2(replicaSets, fencedBrokerId, topicId, BoxesRunTime.unboxToInt((Object)partitionId)));
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokerRecords.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionRecords)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
            TopicPartition tp = new TopicPartition(topic, partitionId);
            Map brokerIdToNodeMap = CollectionConverters$.MODULE$.MapHasAsScala(cache.getPartitionReplicaEndpoints(tp, listenerName)).asScala();
            Set replicaSet = brokerIdToNodeMap.keySet();
            scala.collection.immutable.Set expectedReplicaSet = CollectionConverters$.MODULE$.ListHasAsScala(((PartitionRecord)partitionRecords.apply(partitionId)).replicas()).asScala().toSet();
            if (expectedReplicaSet.contains((Object)Predef$.MODULE$.int2Integer(fencedBrokerId))) {
                Assertions.assertEquals((Object)expectedReplicaSet, (Object)replicaSet.$plus((Object)Predef$.MODULE$.int2Integer(fencedBrokerId)), (String)("Unexpected partial replica set for partition " + partitionId));
            } else {
                Assertions.assertEquals((Object)expectedReplicaSet, (Object)replicaSet, (String)("Unexpected replica set for partition " + partitionId));
            }
            replicaSet.foreach((Function1 & Serializable)brokerId -> {
                MetadataCacheTest.$anonfun$testGetPartitionReplicaEndpoints$5(brokerIdToNodeMap, partitionId, brokerRecords, listenerName, brokerId);
                return BoxedUnit.UNIT;
            });
        });
        TopicPartition tp = new TopicPartition(topic, numPartitions);
        Assertions.assertTrue((boolean)cache.getPartitionReplicaEndpoints(tp, listenerName).isEmpty());
    }

    private java.util.List<Integer>[] getAllReplicaSets(int numBrokers, int replicationFactor) {
        return (java.util.List[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).combinations(replicationFactor).map((Function1 & Serializable)replicaSet -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)replicaSet.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toList()).asJava()).toArray(ClassTag$.MODULE$.apply(java.util.List.class));
    }

    @Test
    public void testIsBrokerFenced() {
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (Long)metadataCache.getAliveBrokerEpoch(0).orElse(Predef$.MODULE$.long2Long(-1L)));
        Assertions.assertEquals((long)-1L, (Long)metadataCache.getAliveBrokerEpoch(1).orElse(Predef$.MODULE$.long2Long(-1L)));
    }

    @Test
    public void testDescribeTopicResponse() {
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        String topic0 = "test0";
        String topic1 = "test1";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        scala.collection.immutable.Map partitionMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setLeader(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)2))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(2).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3))).setLeader(3).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(3))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setLeaderEpoch(1).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)1))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setLeader(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(3))).setLeaderEpoch(0).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic1, (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic1)).setPartitionId(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setLeader(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setLeaderEpoch(10).setPartitionEpoch(11).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()))}));
        new RegisterBrokerRecord.BrokerEndpointCollection();
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(0).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo0").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(1).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo1").setPort(9093).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(2).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo2").setPort(9094).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(3).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo3").setPort(9095).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$))));
        .colon.colon recordSeq = new .colon.colon((Object)new TopicRecord().setName(topic0).setTopicId((Uuid)topicIds.get(topic0)), (List)new .colon.colon((Object)new TopicRecord().setName(topic1).setTopicId((Uuid)topicIds.get(topic1)), (List)Nil$.MODULE$));
        recordSeq = (Seq)recordSeq.$plus$plus((IterableOnce)partitionMap.values().toSeq());
        MetadataCacheTest$.MODULE$.updateCache((MetadataCache)metadataCache, (Seq<ApiMessage>)((Seq)brokers.$plus$plus((IterableOnce)recordSeq)));
        List result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.describeTopicResponse(java.util.List.of(topic0, topic1).iterator(), listenerName, x$3 -> Predef$.MODULE$.int2Integer(0), 10, false).topics()).asScala().toList();
        Assertions.assertEquals((int)2, (int)result.size());
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)3, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(1);
        Assertions.assertEquals((Object)topic1, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic1), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        DescribeTopicPartitionsResponseData response = metadataCache.describeTopicResponse(java.util.List.of(topic0, topic1).iterator(), listenerName, x$4 -> Predef$.MODULE$.int2Integer(0), 2, false);
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)2, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        Assertions.assertEquals((Object)topic0, (Object)response.nextCursor().topicName());
        Assertions.assertEquals((int)2, (int)response.nextCursor().partitionIndex());
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.describeTopicResponse(java.util.List.of(topic0).iterator(), listenerName, t -> {
            if (t.equals(topic0)) {
                return Predef$.MODULE$.int2Integer(1);
            }
            return Predef$.MODULE$.int2Integer(0);
        }, 10, false).topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)2, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        response = metadataCache.describeTopicResponse(java.util.List.of(topic0, topic1).iterator(), listenerName, t -> {
            if (t.equals(topic0)) {
                return Predef$.MODULE$.int2Integer(2);
            }
            return Predef$.MODULE$.int2Integer(0);
        }, 1, false);
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        Assertions.assertEquals((Object)topic1, (Object)response.nextCursor().topicName());
        Assertions.assertEquals((int)0, (int)response.nextCursor().partitionIndex());
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.describeTopicResponse(java.util.List.of("Non-exist", topic0).iterator(), listenerName, t -> {
            if (t.equals("Non-exist")) {
                return Predef$.MODULE$.int2Integer(1);
            }
            return Predef$.MODULE$.int2Integer(0);
        }, 1, false).topics()).asScala().toList();
        Assertions.assertEquals((int)2, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)"Non-exist", (Object)resultTopic.name());
        Assertions.assertEquals((int)3, (int)resultTopic.errorCode());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(1);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetLeaderAndIsr(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        int partitionIndex = 0;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(partitionIndex).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(this.brokerEpoch()).setRack("rack1").setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Optional leaderAndIsr = cache.getLeaderAndIsr(topic, partitionIndex);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leader)), leaderAndIsr.map(x$5 -> BoxesRunTime.boxToInteger((int)x$5.leader())));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), leaderAndIsr.map(x$6 -> BoxesRunTime.boxToInteger((int)x$6.leaderEpoch())));
        Assertions.assertEquals(Optional.of(isr), leaderAndIsr.map(x$7 -> x$7.isr()));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)-1)), leaderAndIsr.map(x$8 -> BoxesRunTime.boxToInteger((int)x$8.partitionEpoch())));
        Assertions.assertEquals(Optional.of(LeaderRecoveryState.RECOVERED), leaderAndIsr.map(x$9 -> x$9.leaderRecoveryState()));
    }

    @Test
    public void testGetOfflineReplicasConsidersDirAssignment() {
        new LazyRef();
        new LazyRef();
        public class Kafka_server_MetadataCacheTest$Broker$1
        implements Product,
        Serializable {
            private final int id;
            private final java.util.List<Uuid> dirs;
            private final /* synthetic */ MetadataCacheTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int id() {
                return this.id;
            }

            public java.util.List<Uuid> dirs() {
                return this.dirs;
            }

            public Kafka_server_MetadataCacheTest$Broker$1 copy(int id, java.util.List<Uuid> dirs) {
                return new Kafka_server_MetadataCacheTest$Broker$1(this.$outer, id, dirs);
            }

            public int copy$default$1() {
                return this.id();
            }

            public java.util.List<Uuid> copy$default$2() {
                return this.dirs();
            }

            public String productPrefix() {
                return "Broker";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.id());
                    }
                    case 1: {
                        return this.dirs();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_server_MetadataCacheTest$Broker$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "id";
                    }
                    case 1: {
                        return "dirs";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"Broker".hashCode()), (int)this.id()), (int)Statics.anyHash(this.dirs())), (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        if (!(x$1 instanceof Kafka_server_MetadataCacheTest$Broker$1)) break block3;
                        Kafka_server_MetadataCacheTest$Broker$1 var2_2 = (Kafka_server_MetadataCacheTest$Broker$1)x$1;
                        if (this.id() != var2_2.id()) break block3;
                        java.util.List<Uuid> list = this.dirs();
                        java.util.List<Uuid> list2 = var2_2.dirs();
                        if (list != null ? !((Object)list).equals(list2) : list2 != null) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_server_MetadataCacheTest$Broker$1(MetadataCacheTest $outer, int id, java.util.List<Uuid> dirs) {
                this.id = id;
                this.dirs = dirs;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        .colon.colon brokers = new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Broker$1(this, 0, Arrays.asList(Uuid.fromString((String)"broker1logdirjEo71BG0w"))), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Broker$1(this, 1, Arrays.asList(Uuid.fromString((String)"broker2logdirRmQQgLxgw"))), (List)Nil$.MODULE$));
        public class Kafka_server_MetadataCacheTest$Partition$1
        implements Product,
        Serializable {
            private final int id;
            private final java.util.List<Integer> replicas;
            private final java.util.List<Uuid> dirs;
            private final /* synthetic */ MetadataCacheTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int id() {
                return this.id;
            }

            public java.util.List<Integer> replicas() {
                return this.replicas;
            }

            public java.util.List<Uuid> dirs() {
                return this.dirs;
            }

            public Kafka_server_MetadataCacheTest$Partition$1 copy(int id, java.util.List<Integer> replicas, java.util.List<Uuid> dirs) {
                return new Kafka_server_MetadataCacheTest$Partition$1(this.$outer, id, replicas, dirs);
            }

            public int copy$default$1() {
                return this.id();
            }

            public java.util.List<Integer> copy$default$2() {
                return this.replicas();
            }

            public java.util.List<Uuid> copy$default$3() {
                return this.dirs();
            }

            public String productPrefix() {
                return "Partition";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.id());
                    }
                    case 1: {
                        return this.replicas();
                    }
                    case 2: {
                        return this.dirs();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_server_MetadataCacheTest$Partition$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "id";
                    }
                    case 1: {
                        return "replicas";
                    }
                    case 2: {
                        return "dirs";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"Partition".hashCode()), (int)this.id()), (int)Statics.anyHash(this.replicas())), (int)Statics.anyHash(this.dirs())), (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        if (!(x$1 instanceof Kafka_server_MetadataCacheTest$Partition$1)) break block3;
                        Kafka_server_MetadataCacheTest$Partition$1 var2_2 = (Kafka_server_MetadataCacheTest$Partition$1)x$1;
                        if (this.id() != var2_2.id()) break block3;
                        java.util.List<Integer> list = this.replicas();
                        java.util.List<Integer> list2 = var2_2.replicas();
                        if (list != null ? !((Object)list).equals(list2) : list2 != null) break block3;
                        java.util.List<Uuid> list3 = this.dirs();
                        java.util.List<Uuid> list4 = var2_2.dirs();
                        if (list3 != null ? !((Object)list3).equals(list4) : list4 != null) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_server_MetadataCacheTest$Partition$1(MetadataCacheTest $outer, int id, java.util.List<Integer> replicas, java.util.List<Uuid> dirs) {
                this.id = id;
                this.replicas = replicas;
                this.dirs = dirs;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        .colon.colon partitions = new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 0, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Uuid.fromString((String)"broker1logdirjEo71BG0w"), DirectoryId.LOST)), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 1, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Uuid.fromString((String)"unknownlogdirjEo71BG0w"), DirectoryId.UNASSIGNED)), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 2, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(DirectoryId.MIGRATING, Uuid.fromString((String)"broker2logdirRmQQgLxgw"))), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Arrays.asList(new Nothing$[0]))})), (Object)MetadataCacheTest.offlinePartitions$1((Seq)brokers, (Seq)partitions));
    }

    public int oldRequestControllerEpoch() {
        return this.oldRequestControllerEpoch;
    }

    public int newRequestControllerEpoch() {
        return this.newRequestControllerEpoch;
    }

    public String fooTopicName() {
        return this.fooTopicName;
    }

    public Uuid fooTopicId() {
        return this.fooTopicId;
    }

    public PartitionRecord oldFooPart0() {
        return this.oldFooPart0;
    }

    public PartitionRecord newFooPart0() {
        return this.newFooPart0;
    }

    public PartitionRecord oldFooPart1() {
        return this.oldFooPart1;
    }

    public PartitionRecord newFooPart1() {
        return this.newFooPart1;
    }

    public String barTopicName() {
        return this.barTopicName;
    }

    public Uuid barTopicId() {
        return this.barTopicId;
    }

    public Uuid recreatedBarTopicId() {
        return this.recreatedBarTopicId;
    }

    public PartitionRecord oldBarPart0() {
        return this.oldBarPart0;
    }

    public PartitionRecord newBarPart0() {
        return this.newBarPart0;
    }

    public PartitionRecord deletedBarPart0() {
        return this.deletedBarPart0;
    }

    public PartitionRecord oldBarPart1() {
        return this.oldBarPart1;
    }

    public PartitionRecord newBarPart1() {
        return this.newBarPart1;
    }

    public PartitionRecord deletedBarPart1() {
        return this.deletedBarPart1;
    }

    public PartitionRecord oldBarPart2() {
        return this.oldBarPart2;
    }

    public PartitionRecord newBarPart2() {
        return this.newBarPart2;
    }

    public PartitionRecord deletedBarPart2() {
        return this.deletedBarPart2;
    }

    private static final RegisterBrokerRecord.BrokerEndpointCollection endpoints$1(int brokerId) {
        String host = "foo-" + brokerId;
        return new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$)).iterator()).asJava());
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$getTopicMetadata$1(int brokerId) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setEndPoints(MetadataCacheTest.endpoints$1(brokerId)).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(HashMap topicIds$1, String topic$1, PartitionRecord ps) {
        Uuid uuid = ps.topicId();
        Object v = topicIds$1.get(topic$1);
        return !(uuid != null ? !uuid.equals(v) : v != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, PartitionRecord x$2) {
        return x$2.partitionId() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            PartitionRecord partitionState = (PartitionRecord)topicPartitionStates$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$2))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("Unable to find partition state for partition " + partitionId)));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Buffer topicMetadatas = CollectionConverters$.MODULE$.ListHasAsScala(cache$1.getTopicMetadata(java.util.Set.of(topic), listenerName$1, false, false)).asScala();
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topicIds$1, topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)("Unexpected partition count for topic " + topic));
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(MetadataCacheTest $this, int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new RegisterBrokerRecord().setBrokerId(brokerId).setRack("").setFenced(false).setBrokerEpoch($this.brokerEpoch()).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    private final void updateCache$1(Seq brokerIds, Uuid topicId$1, MetadataCache cache$2, Seq topicRecords$1) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId$1).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache$2, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords$1)).$plus$plus((IterableOnce)partitionStates)));
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$testGetPartitionReplicaEndpoints$1(int fencedBrokerId$1, SecurityProtocol securityProtocol$1, ListenerName listenerName$2, int brokerId) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setFenced(brokerId == fencedBrokerId$1).setRack("rack" + brokerId % 3).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo" + brokerId).setPort(9092).setSecurityProtocol(securityProtocol$1.id).setName(listenerName$2.value()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    public static final /* synthetic */ PartitionRecord $anonfun$testGetPartitionReplicaEndpoints$2(java.util.List[] replicaSets$1, int fencedBrokerId$1, Uuid topicId$2, int partitionId) {
        java.util.List replicas = replicaSets$1[partitionId];
        java.util.List nonFencedReplicas = replicas.stream().filter(id -> !BoxesRunTime.equalsNumObject((Number)id, (Object)BoxesRunTime.boxToInteger((int)fencedBrokerId$1))).collect(Collectors.toList());
        return new PartitionRecord().setTopicId(topicId$2).setPartitionId(partitionId).setReplicas(replicas).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setIsr(nonFencedReplicas).setEligibleLeaderReplicas(nonFencedReplicas);
    }

    public static final /* synthetic */ void $anonfun$testGetPartitionReplicaEndpoints$5(Map brokerIdToNodeMap$1, int partitionId$2, IndexedSeq brokerRecords$1, ListenerName listenerName$2, Integer brokerId) {
        Node brokerNode = (Node)brokerIdToNodeMap$1.getOrElse((Object)brokerId, (Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("No brokerNode for broker " + brokerId + " and partition " + partitionId$2)));
        RegisterBrokerRecord expectedBroker = (RegisterBrokerRecord)brokerRecords$1.apply(Predef$.MODULE$.Integer2int(brokerId));
        RegisterBrokerRecord.BrokerEndpoint expectedEndpoint = expectedBroker.endPoints().find(listenerName$2.value());
        Assertions.assertEquals((Object)expectedEndpoint.host(), (Object)brokerNode.host(), (String)("Unexpected host for broker " + brokerId + " and partition " + partitionId$2));
        Assertions.assertEquals((int)expectedEndpoint.port(), (int)brokerNode.port(), (String)("Unexpected port for broker " + brokerId + " and partition " + partitionId$2));
        Assertions.assertEquals((Object)expectedBroker.rack(), (Object)brokerNode.rack(), (String)("Unexpected rack for broker " + brokerId + " and partition " + partitionId$2));
    }

    public static final /* synthetic */ void $anonfun$testDescribeTopicResponse$2(scala.collection.immutable.Set partitionIds$1, scala.collection.immutable.Map partitionMap$1, String topic$3, DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition partition) {
        int partitionId = partition.partitionIndex();
        Assertions.assertTrue((boolean)partitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)partitionId)));
        PartitionRecord expectedPartition = (PartitionRecord)partitionMap$1.get((Object)new Tuple2((Object)topic$3, (Object)BoxesRunTime.boxToInteger((int)partitionId))).get();
        Assertions.assertEquals((int)0, (int)partition.errorCode());
        Assertions.assertEquals((int)expectedPartition.leaderEpoch(), (int)partition.leaderEpoch());
        Assertions.assertEquals((int)expectedPartition.partitionId(), (int)partition.partitionIndex());
        Assertions.assertEquals((Object)expectedPartition.eligibleLeaderReplicas(), (Object)partition.eligibleLeaderReplicas());
        Assertions.assertEquals((Object)expectedPartition.isr(), (Object)partition.isrNodes());
        Assertions.assertEquals((Object)expectedPartition.lastKnownElr(), (Object)partition.lastKnownElr());
        Assertions.assertEquals((int)expectedPartition.leader(), (int)partition.leaderId());
    }

    private static final void checkTopicMetadata$2(String topic, scala.collection.immutable.Set partitionIds, Buffer partitions, scala.collection.immutable.Map partitionMap$1) {
        partitions.foreach((Function1 & Serializable)partition -> {
            MetadataCacheTest.$anonfun$testDescribeTopicResponse$2(partitionIds, partitionMap$1, topic, partition);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ MetadataCacheTest$Broker$2$ Broker$lzycompute$1(LazyRef Broker$module$1) {
        synchronized (Broker$module$1) {
            MetadataCacheTest$Broker$2$ metadataCacheTest$Broker$2$ = Broker$module$1.initialized() ? (MetadataCacheTest$Broker$2$)Broker$module$1.value() : (MetadataCacheTest$Broker$2$)Broker$module$1.initialize((Object)new MetadataCacheTest$Broker$2$(this));
            return metadataCacheTest$Broker$2$;
        }
    }

    private final MetadataCacheTest$Broker$2$ Broker$3(LazyRef Broker$module$1) {
        if (Broker$module$1.initialized()) {
            return (MetadataCacheTest$Broker$2$)Broker$module$1.value();
        }
        return this.Broker$lzycompute$1(Broker$module$1);
    }

    private final /* synthetic */ MetadataCacheTest$Partition$2$ Partition$lzycompute$1(LazyRef Partition$module$1) {
        synchronized (Partition$module$1) {
            MetadataCacheTest$Partition$2$ metadataCacheTest$Partition$2$ = Partition$module$1.initialized() ? (MetadataCacheTest$Partition$2$)Partition$module$1.value() : (MetadataCacheTest$Partition$2$)Partition$module$1.initialize((Object)new MetadataCacheTest$Partition$2$(this));
            return metadataCacheTest$Partition$2$;
        }
    }

    private final MetadataCacheTest$Partition$2$ Partition$3(LazyRef Partition$module$1) {
        if (Partition$module$1.initialized()) {
            return (MetadataCacheTest$Partition$2$)Partition$module$1.value();
        }
        return this.Partition$lzycompute$1(Partition$module$1);
    }

    public static final /* synthetic */ void $anonfun$testGetOfflineReplicasConsidersDirAssignment$1(MetadataDelta delta$2, Broker.1 broker) {
        delta$2.replay(new RegisterBrokerRecord().setFenced(false).setBrokerId(broker.id()).setLogDirs(broker.dirs()).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort((int)((short)9093)).setName("PLAINTEXT").setHost("broker-" + broker.id())).iterator())));
    }

    public static final /* synthetic */ void $anonfun$testGetOfflineReplicasConsidersDirAssignment$2(MetadataDelta delta$2, Uuid topicId$3, Partition.1 partition) {
        delta$2.replay(new PartitionRecord().setTopicId(topicId$3).setPartitionId(partition.id()).setReplicas(partition.replicas()).setDirectories(partition.dirs()).setLeader(Predef$.MODULE$.Integer2int(partition.replicas().get(0))).setIsr(partition.replicas()));
    }

    private static final scala.collection.immutable.Map offlinePartitions$1(Seq brokers, Seq partitions) {
        MetadataDelta delta = new MetadataDelta.Builder().build();
        brokers.foreach((Function1 & Serializable)broker -> {
            MetadataCacheTest.$anonfun$testGetOfflineReplicasConsidersDirAssignment$1(delta, broker);
            return BoxedUnit.UNIT;
        });
        Uuid topicId = Uuid.fromString((String)"95OVr1IPRYGrcNCLlpImCA");
        delta.replay(new TopicRecord().setTopicId(topicId).setName("foo"));
        partitions.foreach((Function1 & Serializable)partition -> {
            MetadataCacheTest.$anonfun$testGetOfflineReplicasConsidersDirAssignment$2(delta, topicId, partition);
            return BoxedUnit.UNIT;
        });
        KRaftMetadataCache cache = new KRaftMetadataCache(1, () -> KRaftVersion.KRAFT_VERSION_0);
        cache.setImage(delta.apply(MetadataProvenance.EMPTY));
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)CollectionConverters$.MODULE$.ListHasAsScala(cache.getTopicMetadata(java.util.Set.of("foo"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4())).asScala().head();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)p.partitionIndex()), (Object)p.offlineReplicas()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
        this.oldRequestControllerEpoch = 122;
        this.newRequestControllerEpoch = 123;
        this.fooTopicName = "foo";
        this.barTopicName = "bar";
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

