/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.ConfigRepository;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.metadata.MockConfigRepository;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.DelayedActionQueue;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u001a4\u0001aBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004X\u0001\u0001\u0006Ia\u0013\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019\u0001\u0007\u0001)A\u00055\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007BB6\u0001A\u0003%1\rC\u0004m\u0001\t\u0007I\u0011A7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\u0002MDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0001\u007f\"A\u0011Q\u0002\u0001!\u0002\u0013\t\t\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037A1\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0016\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%\t!a\u000e\t\u0017\u0005m\u0002\u00011A\u0001B\u0003&\u0011Q\u0006\u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0004C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003B1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002h!Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011AA;\u0011-\tI\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011Q\u0013\u0001\u0005\u0002\u0005u\u0004bBAP\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003S\u0003A\u0011AA?\u0011\u001d\ti\u000b\u0001C\u0001\u0003{Bq!!-\u0001\t\u0003\tiH\u0002\u0004\u00026\u0002!\u0011q\u0017\u0005\u0007\u000b\n\"\t!a/\t\u0013\u0005]'\u00051A\u0005\n\u0005e\u0007\"CAqE\u0001\u0007I\u0011BAr\u0011!\t9O\tQ!\n\u0005m\u0007\"CAuE\u0001\u0007I\u0011BAv\u0011%\t)P\ta\u0001\n\u0013\t9\u0010\u0003\u0005\u0002|\n\u0002\u000b\u0015BAw\u0011\u001d\tiP\tC\u0005\u0003\u007fDqAa\u0002#\t\u0003\u0011I\u0001C\u0004\u0003\u000e\t\"\tAa\u0004\t\u000f\tM\u0001\u0001\"\u0003\u0002~!9!Q\u0003\u0001\u0005\n\t]\u0001\"\u0003B<\u0001E\u0005I\u0011\u0002B=\u0011%\u0011y\tAI\u0001\n\u0013\u0011\t\nC\u0004\u0003H\u0001!IA!&\u0003/1{7-\u00197MK\u0006$WM]#oIB{\u0017N\u001c;UKN$(B\u0001\u001b6\u0003\u0019\u0019XM\u001d<fe*\ta'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001It\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005V\nQ!\u001e;jYNL!\u0001R!\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011aM\u0001\u0005i&lW-F\u0001L!\taU+D\u0001N\u0015\tqu*\u0001\u0003vi&d'B\u0001\u001bQ\u0015\t1\u0014K\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,N\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u00025B\u00111LX\u0007\u00029*\u0011Q\fU\u0001\u0007G>lWn\u001c8\n\u0005}c&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002GB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0005Y\u0006twMC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012A\u001c\t\u0003u=L!\u0001]\u001e\u0003\u0007%sG/\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\n\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003Q\u0004\"aW;\n\u0005Yd&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005Q\bCA.|\u0013\taHL\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nAb]8ve\u000e,'I]8lKJ,\"!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002P\u0003\u001dqW\r^<pe.LA!a\u0003\u0002\u0006\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018!D:pkJ\u001cWM\u0011:pW\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005M\u0001c\u0001%\u0002\u0016%\u0019\u0011qC\u001a\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\ti\"a\t\u0011\u0007i\ny\"C\u0002\u0002\"m\u0012A!\u00168ji\"I\u0011QE\t\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0014a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0011\u0015tG\rU8j]R,\"!!\f\u0011\t\u0005=\u0012\u0011G\u0007\u0002\u001f&\u0019\u00111G(\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi\u0006aQM\u001c3Q_&tGo\u0018\u0013fcR!\u0011QDA\u001d\u0011%\t)\u0003FA\u0001\u0002\u0004\ti#A\u0005f]\u0012\u0004v.\u001b8uA\u0005a\u0011/^8uC6\u000bg.Y4feV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\n9F\u0004\u0003\u0002F\u0005Mc\u0002BA$\u0003#rA!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b:\u0014A\u0002\u001fs_>$h(C\u00017\u0013\t!T'C\u0002\u0002VM\nA\"U;pi\u00064\u0015m\u0019;pefLA!!\u0017\u0002\\\ti\u0011+^8uC6\u000bg.Y4feNT1!!\u00164\u0003A\tXo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005\u0005\u0004\"CA\u0013/\u0005\u0005\t\u0019AA!\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005)\u0011.\\1hKV\u0011\u0011\u0011\u000e\t\u0005\u0003W\ny'\u0004\u0002\u0002n)\u0019\u0011Q\r)\n\t\u0005E\u0014Q\u000e\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002\u0013%l\u0017mZ3`I\u0015\fH\u0003BA\u000f\u0003oB\u0011\"!\n\u001b\u0003\u0003\u0005\r!!\u001b\u0002\r%l\u0017mZ3!\u0003\u0015\u0019X\r^+q)\t\ti\u0002K\u0002\u001d\u0003\u0003\u0003B!a!\u0002\u00126\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0002ba&TA!a#\u0002\u000e\u00069!.\u001e9ji\u0016\u0014(bAAH'\u0006)!.\u001e8ji&!\u00111SAC\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aQ$!'\u0011\t\u0005\r\u00151T\u0005\u0005\u0003;\u000b)IA\u0005BMR,'/R1dQ\u0006)B/Z:u\r\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$\bf\u0001\u0010\u0002$B!\u00111QAS\u0013\u0011\t9+!\"\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cHOR3uG\",\u0015M\u001d7jKN$xJ\u001a4tKRD3aHAR\u0003q!Xm\u001d;GKR\u001c\u0007.R1sY&,7\u000f\u001e'pG\u0006dwJ\u001a4tKRD3\u0001IAR\u0003a!Xm\u001d;GKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u0015\u0004C\u0005\r&AD\"bY2\u0014\u0017mY6SKN,H\u000e^\u000b\u0005\u0003s\u000b)m\u0005\u0002#sQ\u0011\u0011Q\u0018\t\u0006\u0003\u007f\u0013\u0013\u0011Y\u0007\u0002\u0001A!\u00111YAc\u0019\u0001!q!a2#\u0005\u0004\tIMA\u0001U#\u0011\tY-!5\u0011\u0007i\ni-C\u0002\u0002Pn\u0012qAT8uQ&tw\rE\u0002;\u0003'L1!!6<\u0005\r\te._\u0001\u0006m\u0006dW/Z\u000b\u0003\u00037\u0004RAOAo\u0003\u0003L1!a8<\u0005\u0019y\u0005\u000f^5p]\u0006Ia/\u00197vK~#S-\u001d\u000b\u0005\u0003;\t)\u000fC\u0005\u0002&\u0015\n\t\u00111\u0001\u0002\\\u00061a/\u00197vK\u0002\n1AZ;o+\t\ti\u000fE\u0003;\u0003;\fy\u000fE\u0004;\u0003c\f\t-!\b\n\u0007\u0005M8HA\u0005Gk:\u001cG/[8oc\u00059a-\u001e8`I\u0015\fH\u0003BA\u000f\u0003sD\u0011\"!\n)\u0003\u0003\u0005\r!!<\u0002\t\u0019,h\u000eI\u0001\tQ\u0006\u001ch)\u001b:fIV\u0011!\u0011\u0001\t\u0004u\t\r\u0011b\u0001B\u0003w\t9!i\\8mK\u0006t\u0017\u0001\u00024je\u0016$B!!\b\u0003\f!9\u0011q[\u0016A\u0002\u0005\u0005\u0017AB8o\r&\u0014X\r\u0006\u0003\u0002>\nE\u0001bBAuY\u0001\u0007\u0011q^\u0001\u0010EVl\u0007\u000fT3bI\u0016\u0014X\t]8dQ\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$BB!\u0007\u0003B\t\r#Q\tB+\u0005[\u0002R!a0#\u00057\u0001BA!\b\u0003<9!!q\u0004B\u001b\u001d\u0011\u0011\tC!\r\u000f\t\t\r\"q\u0006\b\u0005\u0005K\u0011iC\u0004\u0003\u0003(\t-b\u0002BA%\u0005SI\u0011\u0001V\u0005\u0003%NK!AN)\n\u0005u\u0003\u0016b\u0001B\u001a9\u0006A!/Z9vKN$8/\u0003\u0003\u00038\te\u0012a\u0004)s_\u0012,8-\u001a*fgB|gn]3\u000b\u0007\tMB,\u0003\u0003\u0003>\t}\"!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!!q\u0007B\u001d\u0011\u001d\tyA\fa\u0001\u0003'AQ\u0001\u001c\u0018A\u0002QDqAa\u0012/\u0001\u0004\u0011I%A\u0004sK\u000e|'\u000fZ:\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014]\u0003\u0019\u0011XmY8sI&!!1\u000bB'\u00055iU-\\8ssJ+7m\u001c:eg\"I!q\u000b\u0018\u0011\u0002\u0003\u0007!\u0011L\u0001\u0007_JLw-\u001b8\u0011\t\tm#\u0011N\u0007\u0003\u0005;RAAa\u0018\u0003b\u0005\u0019An\\4\u000b\t\t\r$QM\u0001\nS:$XM\u001d8bYNT1Aa\u001aQ\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa\u001b\u0003^\ta\u0011\t\u001d9f]\u0012|%/[4j]\"I!q\u000e\u0018\u0011\u0002\u0003\u0007!\u0011O\u0001\re\u0016\fX/\u001b:fI\u0006\u001b7n\u001d\t\u0004u\tM\u0014b\u0001B;w\t)1\u000b[8si\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005wRCA!\u0017\u0003~-\u0012!q\u0010\t\u0005\u0005\u0003\u0013Y)\u0004\u0002\u0003\u0004*!!Q\u0011BD\u0003%)hn\u00195fG.,GMC\u0002\u0003\nn\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iIa!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u0013\u0016\u0005\u0005c\u0012i(\u0006\u0002\u0003J\u0001")
public class LocalLeaderEndPointTest
implements Logging {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final int partition;
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(this.topicId(), this.partition(), this.topic());
    private final TopicPartition topicPartition = this.topicIdPartition().topicPartition();
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;
    private QuotaFactory.QuotaManagers quotaManager;
    private MetadataImage image;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public MetadataImage image() {
        return this.image;
    }

    public void image_$eq(MetadataImage x$1) {
        this.image = x$1;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = this.sourceBroker().id();
        int x$2 = this.sourceBroker().port();
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$52 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var46_10 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var47_13 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var48_16 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$3, x$4, x$2, (Option<SecurityProtocol>)x$52, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.logDirs()).asScala().map((Function1 & Serializable)x$5 -> new File((String)x$5))), TestUtils$.MODULE$.createLogManager$default$2(), (ConfigRepository)new MockConfigRepository(), new CleanerConfig(false), new MockTime(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false, 30000L);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        this.quotaManager_$eq(QuotaFactory.instantiate((KafkaConfig)config, (Metrics)metrics, (Time)this.time(), (String)"", (String)""));
        MockTime x$23 = this.time();
        MockScheduler x$24 = new MockScheduler((Time)this.time());
        QuotaFactory.QuotaManagers x$26 = this.quotaManager();
        KRaftMetadataCache x$27 = new KRaftMetadataCache(config.brokerId(), () -> KRaftVersion.KRAFT_VERSION_0);
        LogDirFailureChannel x$28 = new LogDirFailureChannel(config.logDirs().size());
        None$ x$30 = None$.MODULE$;
        BrokerTopicStats x$31 = new BrokerTopicStats();
        AtomicBoolean x$32 = new AtomicBoolean(false);
        None$ x$33 = None$.MODULE$;
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        Function0 x$40 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$41 = None$.MODULE$;
        DirectoryEventHandler x$42 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$43 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$23, (Scheduler)x$24, mockLogMgr, (Option)x$30, x$26, (MetadataCache)x$27, x$28, alterPartitionManager, x$31, x$32, (Option)x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, x$40, (Option)x$41, x$42, (ActionQueue)x$43));
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.MINIMUM_VERSION.featureLevel()));
        delta.replay(new TopicRecord().setName(this.topic()).setTopicId(this.topicId()));
        delta.replay(new PartitionRecord().setPartitionId(this.partition()).setTopicId(this.topicId()).setReplicas(List.of(Predef$.MODULE$.int2Integer(this.sourceBroker().id()))).setIsr(List.of(Predef$.MODULE$.int2Integer(this.sourceBroker().id()))).setLeader(this.sourceBroker().id()).setLeaderEpoch(0).setPartitionEpoch(0));
        this.image_$eq(delta.apply(MetadataProvenance.EMPTY));
        this.replicaManager().applyDelta(delta.topicsDelta(), this.image());
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), QuotaFactory.UNBOUNDED_QUOTA));
    }

    @AfterEach
    public void tearDown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replicaManager().shutdown(false), (Logging)this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.quotaManager().shutdown(), (Logging)this, Level.WARN);
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 1), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(response);
            return BoxedUnit.UNIT;
        });
        ReplicaManager qual$1 = this.replicaManager();
        Map x$2 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))}));
        Function1 & Serializable x$3 = (Function1 & Serializable)x$6 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(x$6);
            return BoxedUnit.UNIT;
        };
        boolean x$4 = qual$1.deleteRecords$default$4();
        qual$1.deleteRecords(1000L, x$2, (Function1)x$3, x$4);
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 1), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 0));
        this.bumpLeaderEpoch();
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$2(response);
            return BoxedUnit.UNIT;
        });
        LogManager qual$1 = this.replicaManager().logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        qual$1.getLog(x$1, x$2).foreach((Function1 & Serializable)log -> {
            log.updateLocalLogStartOffset(3L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 1), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(this.endPoint().fetchEpochEndOffsets(java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0)))).asScala();
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        this.bumpLeaderEpoch();
        this.bumpLeaderEpoch();
        Assertions.assertEquals((int)2, (int)this.replicaManager().getPartitionOrException(this.topicPartition()).getLeaderEpoch());
        this.appendRecords(this.replicaManager(), this.topicIdPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(response);
            return BoxedUnit.UNIT;
        });
        result = CollectionConverters$.MODULE$.MapHasAsScala(this.endPoint().fetchEpochEndOffsets(java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(2)))).asScala();
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(2).setEndOffset(6L))}))), (Object)result);
        result = CollectionConverters$.MODULE$.MapHasAsScala(this.endPoint().fetchEpochEndOffsets(java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(1)))).asScala();
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = CollectionConverters$.MODULE$.MapHasAsScala(this.endPoint().fetchEpochEndOffsets(java.util.Map.of(this.topicPartition(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5)))).asScala();
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private void bumpLeaderEpoch() {
        MetadataDelta delta = new MetadataDelta(this.image());
        delta.replay(new PartitionChangeRecord().setTopicId(this.topicId()).setPartitionId(this.partition()).setLeader(this.sourceBroker().id()));
        this.image_$eq(delta.apply(MetadataProvenance.EMPTY));
        this.replicaManager().applyDelta(delta.topicsDelta(), this.image());
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicIdPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(Map x$6) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicIdPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
        this.partition = 5;
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        private boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

