/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004T\u0001\u0001\u0006I\u0001\u0012\u0005\b)\u0002\u0011\r\u0011\"\u0001V\u0011\u0019q\u0006\u0001)A\u0005-\"9q\f\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r\u0019\u0004\u0001\u0015!\u0003d\u0011\u001d9\u0007A1A\u0005\u0002\tDa\u0001\u001b\u0001!\u0002\u0013\u0019\u0007\"B5\u0001\t\u0003Q\u0007\"B=\u0001\t\u0003Q\u0007\"B>\u0001\t\u0003Q\u0007\"B?\u0001\t\u0003Q\u0007BB@\u0001\t\u0003\t\t\u0001C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u00111\u000f\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u0019\t)\n\u0001C\u0001U\"1\u0011\u0011\u0014\u0001\u0005\u0002)Da!!(\u0001\t\u0003Q\u0007BBAQ\u0001\u0011\u0005!\u000e\u0003\u0004\u0002&\u0002!\tA\u001b\u0005\u0007\u0003S\u0003A\u0011\u00016\t\r\u00055\u0006\u0001\"\u0001k\u0011\u0019\t\t\f\u0001C\u0001U\"1\u0011Q\u0017\u0001\u0005\u0002)Da!!/\u0001\t\u0003Q\u0007BBA_\u0001\u0011\u0005!\u000e\u0003\u0004\u0002B\u0002!\tA\u001b\u0005\u0007\u0003\u000b\u0004A\u0011\u00016\t\r\u0005%\u0007\u0001\"\u0001k\u0011\u0019\ti\r\u0001C\u0001U\"1\u0011\u0011\u001b\u0001\u0005\u0002)Da!!6\u0001\t\u0003Q\u0007BBAm\u0001\u0011\u0005!\u000e\u0003\u0004\u0002^\u0002!\tA\u001b\u0005\u0007\u0003C\u0004A\u0011\u00016\t\r\u0005\u0015\b\u0001\"\u0001k\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDa!!>\u0001\t\u0003Q\u0007BBA}\u0001\u0011\u0005!\u000e\u0003\u0004\u0002~\u0002!\tA\u001b\u0005\u0007\u0005\u0003\u0001A\u0011\u00016\t\r\t\u0015\u0001\u0001\"\u0001k\u0011\u0019\u0011I\u0001\u0001C\u0001U\n92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feR+7\u000f\u001e\u0006\u0003gQ\naa]3sm\u0016\u0014(\"A\u001b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0005CA!\u0001\u001b\u0005\u0011\u0014\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\u0005!\u0005CA#R\u001b\u00051%BA$I\u0003\u001diW\r\u001e:jGNT!!\u0013&\u0002\u00071|wM\u0003\u0002L\u0019\u000691\u000f^8sC\u001e,'BA\u001bN\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\n\u0005I3%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005Y\u0006twMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005\u0011\"M]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+\u0005\u0019\u0007CA#e\u0013\t)gI\u0001\nCe>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c\u0018a\u00052s_.,'\u000fV8qS\u000elU\r\u001e:jGN\u0004\u0013aD1mYR{\u0007/[2NKR\u0014\u0018nY:\u0002!\u0005dG\u000eV8qS\u000elU\r\u001e:jGN\u0004\u0013A\u0005;fgR\u001c\u0015\r\u001c7cC\u000e\\G+[7j]\u001e$\u0012a\u001b\t\u0003s1L!!\u001c\u001e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0019=\u0004\"\u0001]<\u000e\u0003ET!A]:\u0002\u0007\u0005\u0004\u0018N\u0003\u0002uk\u00069!.\u001e9ji\u0016\u0014(B\u0001<P\u0003\u0015QWO\\5u\u0013\tA\u0018O\u0001\u0003UKN$\u0018A\b;fgR\u001c\u0015\r\u001c7cC\u000e\\GK]=D_6\u0004H.\u001a;f\u0003\u000e$\u0018n\u001c8tQ\tiq.A\u0010uKN$\b*\u00198eY&twmQ1mY\n\f7m[(o\u001d\u0016<H\u000b\u001b:fC\u0012D#AD8\u00021Q,7\u000f^\"bY2\u0014\u0017mY6P]N\u000bW.\u001a+ie\u0016\fG\r\u000b\u0002\u0010_\u0006qA/Z:u)>\u0004\u0018nY*uCR\u001cHcA6\u0002\u0004!9\u0011Q\u0001\tA\u0002\u0005\u001d\u0011AG:zgR,WNU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$\u0007cA\u001d\u0002\n%\u0019\u00111\u0002\u001e\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001#a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006t\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011DA\n\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b!\u0005u\u0011\u0011FA\u0016!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003'\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003O\t\tCA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u00055\u0012qF\r\u0002\u0003e\t\u0001!A\u0006nC.,'+Z9vKN$HCBA\u001b\u0003\u0013\ni\u0006\u0005\u0003\u00028\u0005\rc\u0002BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uB'A\u0004oKR<xN]6\n\t\u0005\u0005\u00131H\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t)%a\u0012\u0003\u000fI+\u0017/^3ti*!\u0011\u0011IA\u001e\u0011\u001d\tY%\u0005a\u0001\u0003\u001b\nA\u0001^5nKB!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013!B;uS2\u001c(bAA,\u0019\u000611m\\7n_:LA!a\u0017\u0002R\t!A+[7f\u0011\u00199\u0015\u00031\u0001\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002H\u0003KR1!!\u0010M\u0013\u0011\tI'a\u0019\u0003+I+\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u000692/\u001a;va\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m\u001d\u000b\u0004G\u0006=\u0004\"CA\u0003%A\u0005\t\u0019AA\u0004\u0003\u0005\u001aX\r^;q\u0005J|7.\u001a:U_BL7-T3ue&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t)H\u000b\u0003\u0002\b\u0005]4FAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r%(\u0001\u0006b]:|G/\u0019;j_:LA!a\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=Q,7\u000f^*j]\u001e,H.\u0019:D_BLH*Y4CsR,7/T3ue&\u001cGcA6\u0002\u000e\"9\u0011Q\u0001\u000bA\u0002\u0005\u001d\u0001f\u0001\u000b\u0002\u0010!:A#!\b\u0002*\u0005ME\u0006BA\u0017\u0003_\tq\u0004^3ti6+H\u000e^5qY\u0016\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t\u001b\u0016$(/[2tQ\t)r.\u0001\u0017uKN$8i\u001c9z\u0019\u0006<')\u001f;fg6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8FqB\fgn]5p]\"\u0012ac\\\u0001-i\u0016\u001cHoQ8qs2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD#aF8\u0002oQ,7\u000f^\"pafd\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e<\u0016\u000e\u001e5SK6|g/\u001b8h\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8tQ\tAr.A\u000euKN$8i\u001c9z\u0019\u0006<')\u001f;fg6+GO]5d\u00072,\u0017M\u001d\u0015\u00033=\f!\u0005^3ti6+H\u000e^5qY\u0016\u001cu\u000e]=MC\u001e\u001cVmZ7f]R\u001cX*\u001a;sS\u000e\u001c\bF\u0001\u000ep\u0003=\"Xm\u001d;D_BLH*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\tYr.A\u0018uKN$8i\u001c9z\u0019\u0006<7+Z4nK:$8/T3ue&\u001cw+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\u0006N]5oW&tw\r\u000b\u0002\u001d_\u0006QD/Z:u\u0007>\u0004\u0018\u0010T1h'\u0016<W.\u001a8ug6+GO]5d/&$\bNU3n_ZLgn\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003;=\fa\u0004^3ti\u000e{\u0007/\u001f'bON+w-\\3oiNlU\r\u001e:jG\u000ecW-\u0019:)\u0005yy\u0017!\t;fgRlU\u000f\u001c;ja2,G)\u001a7fi\u0016d\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e\u001c\bFA\u0010p\u00039\"Xm\u001d;EK2,G/\u001a'bO\nKH/Z:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8)\u0005\u0001z\u0017A\f;fgR$U\r\\3uK2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD#!I8\u0002sQ,7\u000f\u001e#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND#AI8\u0002;Q,7\u000f\u001e#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7m\u00117fCJD#aI8\u0002IQ,7\u000f^'vYRL\u0007\u000f\\3EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jGND#\u0001J8\u0002cQ,7\u000f\u001e#fY\u0016$X\rT1h'\u0016<W.\u001a8ug6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8FqB\fgn]5p]\"\u0012Qe\\\u00012i\u0016\u001cH\u000fR3mKR,G*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\*ie&t7.\u001b8hQ\t1s.\u0001\u001fuKN$H)\u001a7fi\u0016d\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY,ji\"\u0014V-\\8wS:<gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0014p\u0003\u0001\"Xm\u001d;EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jG\u000ecW-\u0019:)\u0005!z\u0017A\u0007;fgR\u0014V-\\8uK2{w-T3uC\u0012\fG/Y\"pk:$\bFA\u0015p\u0003y!Xm\u001d;TS:<W\u000f\\1s\u0019><7+\u001b>f\u0005f$Xm]'fiJL7\rF\u0002l\u0003[Dq!!\u0002+\u0001\u0004\t9\u0001K\u0002+\u0003\u001fAsAKA\u000f\u0003S\t\u0019\u0010\f\u0003\u0002.\u0005=\u0012a\b;fgRlU\u000f\u001c;ja2,Gj\\4TSj,')\u001f;fg6+GO]5dg\"\u00121f\\\u0001-i\u0016\u001cH\u000fT8h'&TXMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o\u000bb\u0004\u0018M\\:j_:D#\u0001L8\u0002YQ,7\u000f\u001e'pONK'0\u001a\"zi\u0016\u001cX*\u001a;sS\u000e<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NC'/\u001b8lS:<\u0007FA\u0017p\u0003]\"Xm\u001d;M_\u001e\u001c\u0016N_3CsR,7/T3ue&\u001cw+\u001b;i%\u0016lwN^5oO:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8og\"\u0012af\\\u0001\u001ci\u0016\u001cH\u000fT8h'&TXMQ=uKNlU\r\u001e:jG\u000ecW-\u0019:)\u0005=z\u0017A\u0004;fgR<\u0015-^4f\u00072|7/\u001a\u0015\u0003a=\u0004")
public class KafkaRequestHandlerTest {
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats(true);
    private final String topic;
    private final String topic2;
    private final BrokerTopicMetrics brokerTopicMetrics = this.brokerTopicStats().topicStats(this.topic());
    private final BrokerTopicMetrics allTopicMetrics = this.brokerTopicStats().allTopicsStats();

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public String topic() {
        return this.topic;
    }

    public String topic2() {
        return this.topic2;
    }

    public BrokerTopicMetrics brokerTopicMetrics() {
        return this.brokerTopicMetrics;
    }

    public BrokerTopicMetrics allTopicMetrics() {
        return this.allTopicMetrics;
    }

    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannelMetrics metrics = new RequestChannelMetrics(Set.of());
        RequestChannel requestChannel = new RequestChannel(10, (Time)time, metrics);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, handler, request, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testCallbackTryCompleteActions() {
        MockTime time = new MockTime();
        RequestChannelMetrics metrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ++handledCount$1.elem;
            return CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(x$4, x$5) -> {
                handler.stop();
                return BoxedUnit.UNIT;
            }, RequestLocal.noCaching())));
        });
        apiHandler.tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$4(tryCompleteActionCount, x$6);
            return BoxedUnit.UNIT;
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @Test
    public void testHandlingCallbackOnNewThread() {
        MockTime time = new MockTime();
        RequestChannelMetrics metrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$7 -> CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, x$8) -> {
            KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$2(handledCount, handler, reqLocal, BoxesRunTime.unboxToInt((Object)x$8));
            return BoxedUnit.UNIT;
        }, originalRequestLocal))));
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)0))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @Test
    public void testCallbackOnSameThread() {
        MockTime time = new MockTime();
        RequestChannelMetrics metrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        Mockito.when((Object)originalRequestLocal.bufferSupplier()).thenReturn((Object)BufferSupplier.create());
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$9 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$1(handledCount, handler, originalRequestLocal, x$9);
            return BoxedUnit.UNIT;
        });
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)1))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        BrokerTopicMetrics brokerTopicMetrics = new BrokerTopicStats(systemRemoteStorageEnabled).topicStats(this.topic());
        scala.collection.immutable.Set gaugeMetrics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                if (!gaugeMetrics.contains((Object)metric.getName())) {
                    Assertions.assertTrue((boolean)brokerTopicMetrics.metricMapKeySet().contains(metric.getName()), (String)("the metric is missing: " + metric.getName()));
                    return;
                }
                Assertions.assertFalse((boolean)brokerTopicMetrics.metricMapKeySet().contains(metric.getName()), (String)("the metric should not appear: " + metric.getName()));
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicMetrics.metricMapKeySet().contains(metric.getName()));
        });
        gaugeMetrics.foreach((Function1 & Serializable)metricName -> {
            KafkaRequestHandlerTest.$anonfun$testTopicStats$2(systemRemoteStorageEnabled, brokerTopicMetrics, metricName);
            return BoxedUnit.UNIT;
        });
    }

    public RequestChannel.Request makeRequest(Time time, RequestChannelMetrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, (Option)None$.MODULE$);
    }

    public BrokerTopicMetrics setupBrokerTopicMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        return new BrokerTopicMetrics(topic, systemRemoteStorageEnabled);
    }

    public boolean setupBrokerTopicMetrics$default$1() {
        return true;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularCopyLagBytesMetric(boolean systemRemoteStorageEnabled) {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(systemRemoteStorageEnabled);
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteCopyLagBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            return;
        }
        Assertions.assertEquals(null, brokerTopicMetrics.metricGaugeMap().get(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
        Assertions.assertEquals(null, brokerTopicStats.allTopicsStats().metricGaugeMap().get(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleCopyLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 2, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)7L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)2L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testMultipleCopyLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testMultipleDeleteLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testMultipleDeleteLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic2(), 1, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testRemoteLogMetadataCount() {
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularLogSizeBytesMetric(boolean systemRemoteStorageEnabled) {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(systemRemoteStorageEnabled);
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteLogSizeBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            return;
        }
        Assertions.assertEquals(null, brokerTopicMetrics.metricGaugeMap().get(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleLogSizeBytesMetrics() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricClear() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testGaugeClose() {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(true);
        String topic = "close-test-topic";
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(topic);
        Assertions.assertEquals((int)7, (int)KafkaYammerMetrics.defaultRegistry().allMetrics().keySet().stream().filter(metricName -> metricName.getMBeanName().contains("topic=" + topic)).collect(Collectors.toList()).size());
        brokerTopicMetrics.close();
        Assertions.assertEquals((int)0, (int)KafkaYammerMetrics.defaultRegistry().allMetrics().keySet().stream().filter(metricName -> metricName.getMBeanName().contains("topic=" + topic)).collect(Collectors.toList()).size());
        brokerTopicStats.recordRemoteCopyLagBytes(topic, 0, 1L);
        brokerTopicStats.recordRemoteCopyLagSegments(topic, 0, 1L);
        brokerTopicStats.recordRemoteDeleteLagBytes(topic, 0, 1L);
        brokerTopicStats.recordRemoteDeleteLagSegments(topic, 0, 1L);
        brokerTopicStats.recordRemoteLogMetadataCount(topic, 0, 1L);
        brokerTopicStats.recordRemoteLogSizeComputationTime(topic, 0, 1L);
        brokerTopicStats.recordRemoteLogSizeBytes(topic, 0, 1L);
        Assertions.assertEquals((int)7, (int)KafkaYammerMetrics.defaultRegistry().allMetrics().keySet().stream().filter(metricName -> metricName.getMBeanName().contains("topic=" + topic)).collect(Collectors.toList()).size());
        brokerTopicStats.close();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$2(MockTime time$1, KafkaRequestHandler handler$1, RequestLocal x$2, int ms) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$3(Function1 callback$1) {
        callback$1.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, KafkaRequestHandler handler$1, RequestChannel.Request request$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTiming$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(x$2, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTiming$2(time$1, handler$1, x$2, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, RequestLocal.noCaching())));
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(Function1 callback$2) {
        callback$2.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$4(IntRef tryCompleteActionCount$1, InvocationOnMock x$6) {
        ++tryCompleteActionCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$2(IntRef handledCount$2, KafkaRequestHandler handler$3, RequestLocal reqLocal, int x$8) {
        reqLocal.bufferSupplier().close();
        ++handledCount$2.elem;
        handler$3.stop();
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$3(Function1 callback$3) {
        callback$3.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$2(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal reqLocal, int x$10) {
        reqLocal.bufferSupplier().close();
        ++handledCount$3.elem;
        handler$4.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$1(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal originalRequestLocal$2, InvocationOnMock x$9) {
        KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, x$10) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$2(handledCount$3, handler$4, reqLocal, BoxesRunTime.unboxToInt((Object)x$10));
            return BoxedUnit.UNIT;
        }, originalRequestLocal$2).apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testTopicStats$2(boolean systemRemoteStorageEnabled$1, BrokerTopicMetrics brokerTopicMetrics$1, String metricName) {
        if (systemRemoteStorageEnabled$1) {
            Assertions.assertTrue((boolean)brokerTopicMetrics$1.metricGaugeMap().containsKey(metricName), (String)("The metric is missing:" + metricName));
            return;
        }
        Assertions.assertFalse((boolean)brokerTopicMetrics$1.metricGaugeMap().containsKey(metricName), (String)("The metric should appear:" + metricName));
    }

    public KafkaRequestHandlerTest() {
        this.topic = "topic";
        this.topic2 = "topic2";
    }
}

