/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0004\t\u00015A\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\u0005\u0005\u0006A\u0001!\t!\t\u0005\u0006I\u0001!\t!\n\u0005\u0006g\u0001!I\u0001\u000e\u0005\u0006#\u0002!IA\u0015\u0005\u00067\u0002!I\u0001\u0018\u0002\u0015\u0015>Lgn\u0012:pkB\u0014V-];fgR$Vm\u001d;\u000b\u0005%Q\u0011AB:feZ,'OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0005\n\u0005EA!aH$s_V\u00048i\\8sI&t\u0017\r^8s\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bC\u0001\u000b\u001f\u001b\u0005)\"B\u0001\f\u0018\u0003\u0011!Xm\u001d;\u000b\u0005aI\u0012AB2p[6|gN\u0003\u0002\f5)\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0013\tyRCA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011!e\t\t\u0003\u001f\u0001AQA\u0005\u0002A\u0002M\t\u0011\u0006^3ti*{\u0017N\\$s_V\u0004x+\u001b;i\u001f2$7i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>dG#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00075\u0002\"AL\u0019\u000e\u0003=R!\u0001M\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u00023_\tY1\t\\;ti\u0016\u0014H+Z:u\u0003U!Xm\u001d;GK:\u001cW\rZ*uCRL7m\u0012:pkB$R!\u000e!C\t2\u0003\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d)\u001b\u0005I$B\u0001\u001e\r\u0003\u0019a$o\\8u}%\u0011A\bK\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=Q!)\u0011\t\u0002a\u0001k\u0005qA.Z1eKJlU-\u001c2fe&#\u0007\"B\"\u0005\u0001\u0004)\u0014\u0001\u00054pY2|w/\u001a:NK6\u0014WM]%e\u0011\u0015)E\u00011\u0001G\u0003!iW\r^1eCR\f\u0007cA\u0014H\u0013&\u0011\u0001\n\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003O)K!a\u0013\u0015\u0003\t\tKH/\u001a\u0005\u0006\u001b\u0012\u0001\rAT\u0001\bm\u0016\u00148/[8o!\t9s*\u0003\u0002QQ\t\u0019\u0011J\u001c;\u0002\u00139|'/\\1mSj,GCA*Z!\t!v+D\u0001V\u0015\t1v#A\u0004nKN\u001c\u0018mZ3\n\u0005a+&!\u0006&pS:<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u00065\u0016\u0001\raU\u0001\re\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0001\"m\u0016\u0014\u0018NZ=K_&twI]8vaJ+7\u000f]8og\u0016$\u0015\r^1FcV\fGn\u001d\u000b\u0004Mu{\u0006\"\u00020\u0007\u0001\u0004\u0019\u0016\u0001C3ya\u0016\u001cG/\u001a3\t\u000b\u00014\u0001\u0019A*\u0002\r\u0005\u001cG/^1mQ\u0019\u0001!-\u001a4m[B\u0011afY\u0005\u0003I>\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miN\fQ\u0001^=qKNd\u0013a\u001a\u0013\u0002Q&\u0011\u0011N[\u0001\u0006\u0017J\u000be\t\u0016\u0006\u0003W>\nA\u0001V=qK\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0004]b\\8&B8sgV4\bC\u0001\u0018q\u0013\t\txFA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001u\u0003qygMZ:fiNtCo\u001c9jG:rW/\u001c\u0018qCJ$\u0018\u000e^5p]N\fQA^1mk\u0016\f\u0013a^\u0001\u0002c-*qN]=vm\u0006\n!0\u0001\u0011pM\u001a\u001cX\r^:/i>\u0004\u0018n\u0019\u0018sKBd\u0017nY1uS>tgFZ1di>\u00148&B8syVt\u0018%A?\u0002A\u001d\u0014x.\u001e9/S:LG/[1m]I,'-\u00197b]\u000e,g\u0006Z3mCftSn]\u0011\u0002\u007f\u0006!\u0011\u0007\r\u00191\u0001")
public class JoinGroupRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest
    public void testJoinGroupWithOldConsumerGroupProtocol() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.JOIN_GROUP.oldestVersion()), (int)ApiKeys.JOIN_GROUP.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            byte[] metadata = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
            short x$3 = (short)version;
            String x$4 = this.sendJoinRequest$default$2();
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            JoinGroupResponseData joinLeaderResponseData = this.sendJoinRequest("grp", x$4, x$5, x$6, x$7, metadata, x$3);
            String leaderMemberId = joinLeaderResponseData.memberId();
            if (version >= 4) {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.MEMBER_ID_REQUIRED.code()).setMemberId(leaderMemberId).setProtocolName(version >= 7 ? null : ""), joinLeaderResponseData);
            } else {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setLeader(leaderMemberId).setMemberId(leaderMemberId).setProtocolName("consumer-range").setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), joinLeaderResponseData);
            }
            if (version >= 4) {
                short x$11 = (short)version;
                String x$12 = this.sendJoinRequest$default$3();
                String x$13 = this.sendJoinRequest$default$4();
                String x$14 = this.sendJoinRequest$default$5();
                JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest("grp", leaderMemberId, x$12, x$13, x$14, metadata, x$11);
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setMemberId(leaderMemberId).setProtocolName("consumer-range").setProtocolType(version >= 7 ? "consumer" : null).setLeader(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), rejoinLeaderResponseData);
            }
            .colon.colon x$18 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment(new byte[]{1}), (List)Nil$.MODULE$);
            byte[] x$19 = new byte[]{1};
            String x$20 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$21 = this.verifySyncGroupWithOldProtocol$default$5();
            String x$22 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$23 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$24 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$25 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", leaderMemberId, 1, x$20, x$21, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$18, x$22, x$23, x$19, x$24, x$25);
            short x$28 = (short)version;
            String x$29 = this.sendJoinRequest$default$3();
            String x$30 = this.sendJoinRequest$default$4();
            String x$31 = this.sendJoinRequest$default$5();
            byte[] x$32 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setMemberId("member-id-unknown").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest("grp", "member-id-unknown", x$29, x$30, x$31, x$32, x$28));
            short x$34 = (short)version;
            String x$35 = this.sendJoinRequest$default$2();
            String x$36 = this.sendJoinRequest$default$3();
            String x$37 = this.sendJoinRequest$default$4();
            String x$38 = this.sendJoinRequest$default$5();
            byte[] x$39 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest("", x$35, x$36, x$37, x$38, x$39, x$34));
            short x$42 = (short)version;
            String x$43 = this.sendJoinRequest$default$2();
            String x$44 = this.sendJoinRequest$default$3();
            String x$45 = this.sendJoinRequest$default$5();
            byte[] x$46 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest("grp", x$43, x$44, "connect", x$45, x$46, x$42));
            ObjectRef joinFollowerResponseData = ObjectRef.create(null);
            if (version == 4) {
                short x$49 = (short)version;
                String x$50 = this.sendJoinRequest$default$2();
                String x$51 = this.sendJoinRequest$default$3();
                String x$52 = this.sendJoinRequest$default$4();
                String x$53 = this.sendJoinRequest$default$5();
                joinFollowerResponseData.elem = this.sendJoinRequest("grp", x$50, x$51, x$52, x$53, metadata, x$49);
            }
            Future joinFollowerFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                String x$55 = version != 4 ? "" : ((JoinGroupResponseData)joinFollowerResponseData$1.elem).memberId();
                String x$56 = version >= 5 ? "group-instance-id" : null;
                short x$58 = (short)version;
                String x$59 = this.sendJoinRequest$default$4();
                String x$60 = this.sendJoinRequest$default$5();
                return this.sendJoinRequest("grp", x$55, x$56, x$59, x$60, metadata, x$58);
            }, ExecutionContext.Implicits$.MODULE$.global());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!JoinGroupRequestTest.$anonfun$testJoinGroupWithOldConsumerGroupProtocol$3(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"The group is not in PREPARING_REBALANCE state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            short x$64 = (short)version;
            String x$65 = this.sendJoinRequest$default$3();
            String x$66 = this.sendJoinRequest$default$4();
            String x$67 = this.sendJoinRequest$default$5();
            JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest("grp", leaderMemberId, x$65, x$66, x$67, metadata, x$64);
            JoinGroupResponseData joinFollowerFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)joinFollowerFuture, (Duration)Duration$.MODULE$.Inf());
            String followerMemberId = joinFollowerFutureResponseData.memberId();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), joinFollowerFutureResponseData);
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(followerMemberId).setGroupInstanceId(version >= 5 ? "group-instance-id" : null).setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderResponseData);
            int x$70 = rejoinLeaderResponseData.generationId();
            .colon.colon x$71 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment(new byte[]{1}), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerMemberId).setAssignment(new byte[]{2}), (List)Nil$.MODULE$));
            byte[] x$72 = new byte[]{1};
            String x$73 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$74 = this.verifySyncGroupWithOldProtocol$default$5();
            String x$75 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$76 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$77 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$78 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", leaderMemberId, x$70, x$73, x$74, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$71, x$75, x$76, x$72, x$77, x$78);
            int x$81 = joinFollowerFutureResponseData.generationId();
            byte[] x$82 = new byte[]{2};
            String x$83 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$84 = this.verifySyncGroupWithOldProtocol$default$5();
            List<SyncGroupRequestData.SyncGroupRequestAssignment> x$85 = this.verifySyncGroupWithOldProtocol$default$6();
            String x$86 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$87 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$88 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$89 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", followerMemberId, x$81, x$83, x$84, x$85, x$86, x$87, x$82, x$88, x$89);
            String x$91 = version >= 5 ? "group-instance-id" : null;
            short x$94 = (short)version;
            String x$95 = this.sendJoinRequest$default$4();
            String x$96 = this.sendJoinRequest$default$5();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), this.sendJoinRequest("grp", followerMemberId, x$91, x$95, x$96, metadata, x$94));
            if (version >= 5) {
                followerMemberId = this.testFencedStaticGroup(leaderMemberId, followerMemberId, metadata, version);
            }
            this.leaveGroup("grp", leaderMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp", followerMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.deleteGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), (List<Errors>)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
        });
    }

    /*
     * WARNING - void declaration
     */
    private String testFencedStaticGroup(String leaderMemberId, String followerMemberId, byte[] metadata, int version) {
        Future rejoinLeaderFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            short x$4 = (short)version;
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            return this.sendJoinRequest("grp", leaderMemberId, x$5, x$6, x$7, metadata, x$4);
        }, ExecutionContext.Implicits$.MODULE$.global());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group is not in PREPARING_REBALANCE state.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        short x$11 = (short)version;
        String x$12 = this.sendJoinRequest$default$2();
        String x$13 = this.sendJoinRequest$default$4();
        String x$14 = this.sendJoinRequest$default$5();
        JoinGroupResponseData joinNewFollowerResponseData = this.sendJoinRequest("grp", x$12, "group-instance-id", x$13, x$14, metadata, x$11);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group is not in COMPLETING_REBALANCE state.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        short x$19 = (short)version;
        String x$20 = this.sendJoinRequest$default$4();
        String x$21 = this.sendJoinRequest$default$5();
        JoinGroupResponseData rejoinFollowerResponseData = this.sendJoinRequest("grp", followerMemberId, "group-instance-id", x$20, x$21, metadata, x$19);
        JoinGroupResponseData rejoinLeaderFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)rejoinLeaderFuture, (Duration)Duration$.MODULE$.Inf());
        String newFollowerMemberId = joinNewFollowerResponseData.memberId();
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(newFollowerMemberId).setGroupInstanceId("group-instance-id").setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderFutureResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(newFollowerMemberId), joinNewFollowerResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setProtocolName(version >= 7 ? null : "").setMemberId(followerMemberId).setErrorCode(Errors.FENCED_INSTANCE_ID.code()), rejoinFollowerResponseData);
        return newFollowerMemberId;
    }

    private JoinGroupResponseData normalize(JoinGroupResponseData responseData) {
        JoinGroupResponseData newResponseData = responseData.duplicate();
        Collections.sort(newResponseData.members(), (m1, m2) -> m1.memberId().compareTo(m2.memberId()));
        return newResponseData;
    }

    private void verifyJoinGroupResponseDataEquals(JoinGroupResponseData expected, JoinGroupResponseData actual) {
        Assertions.assertEquals((Object)this.normalize(expected), (Object)this.normalize(actual));
    }

    public static final /* synthetic */ boolean $anonfun$testJoinGroupWithOldConsumerGroupProtocol$3(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testJoinGroupWithOldConsumerGroupProtocol$4() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$2(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$3() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$4(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.COMPLETING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$5() {
        return "The group is not in COMPLETING_REBALANCE state.";
    }

    public JoinGroupRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

