/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseFetchRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005\u0002\u0011BQ\u0001\u000f\u0001\u0005\u0002\u0011BQA\u000f\u0001\u0005\u0002\u0011BQ\u0001\u0010\u0001\u0005\u0002\u0011BQA\u0010\u0001\u0005\u0002\u0011BQ\u0001\u0011\u0001\u0005\n\u0005CQa\u0012\u0001\u0005\u0002\u0011BQ!\u0013\u0001\u0005\u0002\u0011BQa\u0013\u0001\u0005\n1CQA\u0014\u0001\u0005\u0002\u0011BQ\u0001\u0015\u0001\u0005\u0002\u0011BQA\u0015\u0001\u0005\nMCQ!\u0016\u0001\u0005\nYCQA\u001b\u0001\u0005\u0002\u0011BQ\u0001\u001c\u0001\u0005\u0002\u0011BQA\u001c\u0001\u0005\u0002\u0011BQ\u0001\u001d\u0001\u0005\u0002\u0011BQA\u001d\u0001\u0005\nMD\u0011\"!\u0007\u0001#\u0003%I!a\u0007\u0003!\u0019+Go\u00195SKF,Xm\u001d;UKN$(BA\f\u0019\u0003\u0019\u0019XM\u001d<fe*\t\u0011$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f\u001f\u001b\u00051\u0012BA\u0010\u0017\u0005Q\u0011\u0015m]3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\t\t\u0003;\u0001\ta\u0006^3ti\n\u0013xn[3s%\u0016\u001c\b/Z2ugB\u000b'\u000f^5uS>t7o\u0014:eKJ\fe\u000eZ*ju\u0016d\u0015.\\5ugR\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bF\u0001\u0002-!\tic'D\u0001/\u0015\ty\u0003'A\u0002ba&T!!\r\u001a\u0002\u000f),\b/\u001b;fe*\u00111\u0007N\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002k\u0005\u0019qN]4\n\u0005]r#\u0001\u0002+fgR\f1\u0005^3ti\u001a+Go\u00195SKF,Xm\u001d;Wi]KG\u000f\u001b*fC\u0012\u001cu.\\7jiR,G\r\u000b\u0002\u0004Y\u0005aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\f\u0007F\u0001\u0003-\u0003y!Xm\u001d;MCN$h)\u001a;dQ\u0016$W\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u0006Y\u0005\tC/Z:u\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"4\u0016\r\\5eCRLwN\u001c,2e!\u0012a\u0001L\u0001 G\",7m\u001b'bgR4U\r^2iK\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tGCA\u0013C\u0011\u0015\u0019u\u00011\u0001E\u0003\u001d1XM]:j_:\u0004\"AJ#\n\u0005\u0019;#!B*i_J$\u0018A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0005-\u0003u!Xm\u001d;DkJ\u0014XM\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o-F\u0012\u0004FA\u0005-\u0003m\u0019\u0007.Z2l\u0007V\u0014(/\u001a8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]R\u0011Q%\u0014\u0005\u0006\u0007*\u0001\r\u0001R\u0001&i\u0016\u001cH/\u00129pG\"4\u0016\r\\5eCRLwN\\,ji\"LgNR3uG\"\u001cVm]:j_:D#a\u0003\u0017\u0002QQ,7\u000f^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8XSRD\u0017N\u001c$fi\u000eD7+Z:tS>tg+\r\u001a)\u00051a\u0013AJ2iK\u000e\\W\t]8dQZ\u000bG.\u001b3bi&|gnV5uQ&tg)\u001a;dQN+7o]5p]R\u0011Q\u0005\u0016\u0005\u0006\u00076\u0001\r\u0001R\u0001\u0019m\u0016\u0014\u0018NZ=GKR\u001c\u0007nU3tg&|g.\u0012:s_J\u001cH#B\u0013XE\u001eL\u0007\"\u0002-\u000f\u0001\u0004I\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u00035\u0002l\u0011a\u0017\u0006\u00039v\u000baaY8n[>t'BA\r_\u0015\tyF'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Cn\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003d\u001d\u0001\u0007A-A\u0006mK\u0006$WM]#q_\u000eD\u0007C\u0001\u0014f\u0013\t1wEA\u0002J]RDQ\u0001\u001b\bA\u0002\u0011\f1\u0003Z3ti&t\u0017\r^5p]\n\u0013xn[3s\u0013\u0012DQa\u0011\bA\u0002\u0011\u000b!\u0007^3ti\u000e\u0013X-\u0019;f\u0013:\u001c'/Z7f]R\fGNR3uG\"<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NLe.\u0012:s_J4\u0016G\r\u0015\u0003\u001f1\n!\u0005^3ti\u001a+Go\u00195XSRD\u0007+\u0019:uSRLwN\\:XSRD\u0017\nZ#se>\u0014\bF\u0001\t-\u0003]!Xm\u001d;['R$7i\\7qe\u0016\u001c8/\u001a3U_BL7\r\u000b\u0002\u0012Y\u0005IB/Z:u5N#HmQ8naJ,7o]3e%\u0016\u001cwN\u001d3tQ\t\u0011B&\u0001\ndQ\u0016\u001c7NR3uG\"\u0014Vm\u001d9p]N,GcC\u0013uy\u0006%\u0011QBA\t\u0003+AQ!^\nA\u0002Y\f!#\u001a=qK\u000e$X\r\u001a)beRLG/[8ogB\u0019qO_-\u000e\u0003aT!!_\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|q\n\u00191+Z9\t\u000bu\u001c\u0002\u0019\u0001@\u0002\u001b\u0019,Go\u00195SKN\u0004xN\\:f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\\\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0004\u0003\u0003\u0011QBR3uG\"\u0014Vm\u001d9p]N,\u0007BBA\u0006'\u0001\u0007A-A\tnCb\u0004\u0016M\u001d;ji&|gNQ=uKNDa!a\u0004\u0014\u0001\u0004!\u0017\u0001E7bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3t\u0011\u0019\t\u0019b\u0005a\u0001I\u00069b.^7NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u0005\t\u0003/\u0019\u0002\u0013!a\u0001\t\u0006y!/Z:q_:\u001cXMV3sg&|g.\u0001\u000fdQ\u0016\u001c7NR3uG\"\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u!f\u0001#\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,\u001d\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class FetchRequestTest
extends BaseFetchRequestTest {
    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$1 -> x$1.swap())).asJava();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(null, leaderId){
            private static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        return (B1)tp;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                return x1 != null && x1._2$mcI$sp() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        });
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest1 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createConsumerFetchRequest$default$2$1(), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$3 = FetchRequestTest.createConsumerFetchRequest$default$2$1();
        FetchRequest fetchRequest1V12 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions1, x$3, (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1V12 = this.sendFetchRequest(leaderId, fetchRequest1V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Vector shuffledTopicPartitions2 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest2 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createConsumerFetchRequest$default$2$1(), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$6 = FetchRequestTest.createConsumerFetchRequest$default$2$1();
        FetchRequest fetchRequest2V12 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions2, x$6, (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2V12 = this.sendFetchRequest(leaderId, fetchRequest2V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Seq shuffledTopicPartitions3 = (Seq)new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        FetchRequest fetchRequest3 = this.createConsumerFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        FetchRequest fetchRequest3V12 = this.createConsumerFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3V12 = this.sendFetchRequest(leaderId, fetchRequest3V12);
        this.evaluateResponse3$1(fetchResponse3, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        this.evaluateResponse3$1(fetchResponse3V12, (short)12, topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        Seq shuffledTopicPartitions4 = (Seq)new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        FetchRequest fetchRequest4 = this.createConsumerFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        FetchRequest fetchRequest4V12 = this.createConsumerFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4V12 = this.sendFetchRequest(leaderId, fetchRequest4V12);
        this.evaluateResponse4$1(fetchResponse4, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
        this.evaluateResponse4$1(fetchResponse4V12, (short)12, topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestV4WithReadCommitted() {
        void var3_3;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$7 -> x$7.swap())).asJava();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)4, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData(topicNames, (short)4).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$9 -> x$9.swap())).asJava();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$2(leader, x$10)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
        FetchRequest oldFetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponseData.PartitionData oldPartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, oldFetchRequest).responseData(topicNames, (short)12).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)oldPartitionData.errorCode());
    }

    @Test
    public void testLastFetchedEpochValidation() {
        this.checkLastFetchedEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testLastFetchedEpochValidationV12() {
        this.checkLastFetchedEpochValidation((short)12);
    }

    private void checkLastFetchedEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(topic, x$3, 3, x$4, x$5, x$6);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), topicPartition, 15000L);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$11 -> x$11.swap())).asJava();
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topic, Uuid.ZERO_UUID), fetchOffset, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), Optional.of(Predef$.MODULE$.int2Integer(firstLeaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData(topicNames, version).get(topicPartition);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)0L, (long)FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData));
        Assertions.assertTrue((boolean)FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData));
        FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
        Assertions.assertEquals((int)firstLeaderEpoch, (int)divergingEpoch.epoch());
        Assertions.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @Test
    public void testCurrentEpochValidation() {
        this.checkCurrentEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testCurrentEpochValidationV12() {
        this.checkCurrentEpochValidation((short)12);
    }

    private void checkCurrentEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, 3, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        this.checkEpochValidationWithinFetchSession(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testEpochValidationWithinFetchSessionV12() {
        this.checkEpochValidationWithinFetchSession((short)12);
    }

    private void checkEpochValidationWithinFetchSession(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, 3, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId, version);
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId, short version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$13 -> x$13.swap())).asJava();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topicPartition.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInErrorV12() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo0, 15000L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo1, 15000L);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createConsumerFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() > 0 ? 1 : 0) != 0, (String)"Expected the broker to create a new incremental fetch session");
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Test created an incremental fetch session " + resp1.sessionId());
        LinkedHashMap responseData1 = resp1.responseData(topicNames, (short)12);
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
        FetchRequest req2 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse resp2 = this.sendFetchRequest(0, req2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId(), (String)"Expected the broker to continue the incremental fetch session");
        LinkedHashMap responseData2 = resp2.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData2.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData2.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData2.containsKey(bar0));
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData2.get(bar0)).errorCode());
        this.createTopicWithAssignment("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), bar0, 15000L);
        FetchRequest req3 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse resp3 = this.sendFetchRequest(0, req3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        LinkedHashMap responseData3 = resp3.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData3.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData3.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData3.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData3.get(bar0)).errorCode());
        FetchRequest req4 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse resp4 = this.sendFetchRequest(0, req4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        LinkedHashMap responseData4 = resp4.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData4.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData4.containsKey(foo1));
        Assertions.assertFalse((boolean)responseData4.containsKey(bar0));
    }

    @Test
    public void testFetchWithPartitionsWithIdError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo0, 15000L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo1, 15000L);
        scala.collection.immutable.Map topicIdsWithUnknown = (scala.collection.immutable.Map)this.getTopicIds().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())})));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = FetchRequestTest.createConsumerFetchRequest$3(FetchRequestTest.createPartitionMap$1(Integer.MAX_VALUE, (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), Predef$.MODULE$.Map().empty(), topicIdsWithUnknown), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        java.util.Map topicNames1 = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIdsWithUnknown.map((Function1 & Serializable)x$14 -> x$14.swap())).asJava();
        LinkedHashMap responseData1 = resp1.responseData(topicNames1, ApiKeys.FETCH.latestVersion());
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedTopic() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)BrokerCompressionType.ZSTD.name)}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$16 -> x$16.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$162 = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$162));
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)9).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data0.errorCode());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)10).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data1.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data1).size());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(ApiKeys.FETCH.latestVersion(), ApiKeys.FETCH.latestVersion(), -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data2).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedRecords() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)BrokerCompressionType.PRODUCER.name)}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$18 -> x$18.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$2 = CompressionType.GZIP.name;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = -1;
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 30000;
        int x$10 = 0;
        int x$11 = 16384;
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, x$16);
        producer1.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$182 = CompressionType.ZSTD.name;
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int x$21 = -1;
        long x$22 = 60000L;
        long x$23 = 0x100000L;
        int x$24 = Integer.MAX_VALUE;
        int x$25 = 30000;
        int x$26 = 0;
        int x$27 = 16384;
        int x$28 = 20000;
        SecurityProtocol x$29 = SecurityProtocol.PLAINTEXT;
        None$ x$30 = None$.MODULE$;
        None$ x$31 = None$.MODULE$;
        boolean x$32 = false;
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$182, x$28, x$29, (Option<File>)x$30, (Option<Properties>)x$31, x$19, x$20, x$32);
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 4, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)10).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data0.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)10).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data1.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data1).size());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(0, ApiKeys.FETCH.latestVersion(), -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data2).size());
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition, short responseVersion) {
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.getTopicIds().map((Function1 & Serializable)x$19 -> x$19.swap())).asJava();
        LinkedHashMap responseData = fetchResponse.responseData(topicNames, responseVersion);
        Assertions.assertEquals(expectedPartitions, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$2(responseData, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (int)responseBufferSize.elem);
        Assertions.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private short checkFetchResponse$default$6() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final FetchRequest createConsumerFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, short version, int maxResponseBytes$1, int maxPartitionBytes$1) {
        return this.createConsumerFetchRequest(maxResponseBytes$1, maxPartitionBytes$1, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, this.createConsumerFetchRequest$default$6(), this.createConsumerFetchRequest$default$7(), this.createConsumerFetchRequest$default$8());
    }

    private static final scala.collection.immutable.Map createConsumerFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final short createConsumerFetchRequest$default$3$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(FetchRequestTest $this, FetchResponseData.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)$this.records(partitionData).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final void evaluateResponse3$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions3$1, int maxResponseBytes$1, TopicPartition partitionWithLargeMessage1$1, int maxPartitionBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions3$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().values().map((Function1 & Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(this, partitionData)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes$1 ? 1 : 0) != 0);
        FetchResponseData.PartitionData partitionData2 = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage1$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertTrue((partitionData2.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData2).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size3 <= maxResponseBytes$1 ? 1 : 0) != 0, (String)("Expected " + size3 + " to be smaller than " + maxResponseBytes$1));
        Assertions.assertTrue((size3 > maxPartitionBytes$1 ? 1 : 0) != 0, (String)("Expected " + size3 + " to be larger than " + maxPartitionBytes$1));
        Assertions.assertTrue((maxPartitionBytes$1 < partitionData2.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse3$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final void evaluateResponse4$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions4$1, TopicPartition partitionWithLargeMessage2$1, int maxResponseBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions4$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        scala.collection.immutable.Seq nonEmptyPartitions = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().toSeq().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final <A1 extends Tuple2<TopicPartition, FetchResponseData.PartitionData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)x1._2();
                    if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        return (B1)tp;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponseData.PartitionData> x1) {
                FetchResponseData.PartitionData partitionData;
                return x1 != null && BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData = (FetchResponseData.PartitionData)x1._2()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$4) {
                return x$4.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$4) {
                return x$4.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        });
        Assertions.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2$1, (List)Nil$.MODULE$), (Object)nonEmptyPartitions);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage2$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size4 > maxResponseBytes$1 ? 1 : 0) != 0, (String)("Expected " + size4 + " to be larger than " + maxResponseBytes$1));
        Assertions.assertTrue((maxResponseBytes$1 < partitionData.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse4$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$2(int leader$1, KafkaBroker x$10) {
        return x$10.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1, String topic$1, short version$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$12 -> x$12.swap())).asJava();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(topicIds.getOrDefault(topic$1, Uuid.ZERO_UUID), 0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$1, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData(topicNames, version$1).get(topicPartition$1);
        Assertions.assertEquals((short)error.code(), (short)partitionData.errorCode());
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, java.util.Map topicIds$1, short version$2, int sessionId$1, int destinationBrokerId$1, java.util.Map topicNames$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(topicIds$1.getOrDefault(topicPartition$2.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$2, (int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData(topicNames$2, version$2).get(topicPartition$2);
        Assertions.assertEquals((short)expectedError.code(), (short)partitionData.errorCode());
    }

    private final FetchRequest createConsumerFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final FetchRequest createConsumerFetchRequest$3(LinkedHashMap fetchData, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, (java.util.Map)fetchData).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final LinkedHashMap createPartitionMap$1(int maxPartitionBytes, Seq topicPartitions, scala.collection.immutable.Map offsetMap, scala.collection.immutable.Map topicIdsWithUnknown$1) {
        LinkedHashMap partitionMap = new LinkedHashMap();
        topicPartitions.foreach((Function1 & Serializable)tp -> partitionMap.put(tp, new FetchRequest.PartitionData((Uuid)topicIdsWithUnknown$1.getOrElse((Object)tp.topic(), (Function0 & Serializable)() -> Uuid.ZERO_UUID), BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$2(LinkedHashMap responseData$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData$1.get(tp);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Records records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData);
        responseBufferSize$1.elem += records.sizeInBytes();
        Buffer batches = CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().toBuffer();
        Assertions.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches.map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertEquals((int)0, (int)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assertions.assertEquals((int)maxPartitionBytes$3, (int)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)("Expected partition with size 0, but found " + tp + " with size " + batchesSize));
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)("Expected partition buffer with size 0, but found " + tp + " with size " + records.sizeInBytes()));
            return;
        }
    }
}

