/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rmd\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029CQ!\u0015\u0001\u0005\u0002ICQa\u0019\u0001\u0005\u0002ICQ!\u001a\u0001\u0005\u0002ICQa\u001a\u0001\u0005\u0002ICQ!\u001b\u0001\u0005\u0002ICQa\u001b\u0001\u0005\u0002ICQ!\u001c\u0001\u0005\u0002ICQa\u001c\u0001\u0005\u0002ICQ!\u001d\u0001\u0005\u0002ICQa\u001d\u0001\u0005\u0002ICQ!\u001e\u0001\u0005\nYDq!a\u000b\u0001\t\u0013\ti\u0003\u0003\u0004\u0002X\u0001!\tA\u0015\u0004\u0007\u00037\u0002\u0001!!\u0018\t\r5{A\u0011AA@\u0011%\t)i\u0004a\u0001\n\u0003\t9\tC\u0005\u0002\u000e>\u0001\r\u0011\"\u0001\u0002\u0010\"A\u0011QS\b!B\u0013\tI\tC\u0004\u0002 >!\t%!)\t\u000f\u0005mw\u0002\"\u0011\u0002^\"9!\u0011A\b\u0005B\t\r\u0001b\u0002B\u0017\u001f\u0011\u0005#q\u0006\u0005\b\u0005'zA\u0011\tB+\u0011\u0019\u0011\tg\u0004C!%\"9!1M\b\u0005B\t\u0015\u0004b\u0002B?\u001f\u0011\u0005#q\u0010\u0005\b\u0005\u000f{A\u0011\tBE\u0011\u001d\u00119j\u0004C!\u00053CaAa*\u0001\t\u0003\u0011\u0006b\u0002BV\u0001\u0011%!Q\u0016\u0005\u0007\u0005{\u0003A\u0011\u0001*\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\"1!\u0011\u001a\u0001\u0005\u0002ICaA!4\u0001\t\u0003\u0011\u0006B\u0002Bi\u0001\u0011\u0005!\u000b\u0003\u0004\u0003V\u0002!\tA\u0015\u0005\u0007\u00053\u0004A\u0011\u0001*\t\r\tu\u0007\u0001\"\u0001S\u0011\u0019\u0011\t\u000f\u0001C\u0001%\"1!Q\u001d\u0001\u0005\u0002ICaA!;\u0001\t\u0003\u0011\u0006B\u0002Bw\u0001\u0011\u0005!\u000b\u0003\u0004\u0003r\u0002!\tA\u0015\u0005\u0007\u0005k\u0004A\u0011\u0001*\t\r\te\b\u0001\"\u0001S\u0011\u0019\u0011i\u0010\u0001C\u0001%\"11\u0011\u0001\u0001\u0005\u0002ICqa!\u0002\u0001\t\u0003\u00199A\u0002\u0004\u0004 \u0001\u00011\u0011\u0005\u0005\u000b\u0003w\u0011$\u0011!Q\u0001\n\u0005u\u0002BB'3\t\u0003\u0019\u0019\u0003C\u0005\u00022I\u0012\r\u0011\"\u0001\u0004*!A11\u0006\u001a!\u0002\u0013\t\u0019\u0004C\u0005\u0004.I\u0012\r\u0011\"\u0001\u00040!A1q\u0007\u001a!\u0002\u0013\u0019\t\u0004C\u0005\u0004:I\u0012\r\u0011\"\u0001\u0004<!A1\u0011\n\u001a!\u0002\u0013\u0019i\u0004C\u0005\u0004LI\u0012\r\u0011\"\u0001\u0004N!A1Q\u000e\u001a!\u0002\u0013\u0019y\u0005\u0003\u0004\u0004p\u0001!\tA\u0015\u0005\u0007\u0007g\u0002A\u0011\u0001*\t\r\r]\u0004\u0001\"\u0001S\u0005]!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h)\u0016\u001cHO\u0003\u0002C\u0007\u000611/\u001a:wKJT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0003\"\u0001\u0015\u0001\u000e\u0003\u0005\u000b\u0001\u0003^3ti\u000e{gNZ5h+B$\u0017\r^3\u0015\u0003M\u0003\"\u0001\u0013+\n\u0005UK%\u0001B+oSRD#AA,\u0011\u0005a\u000bW\"A-\u000b\u0005i[\u0016aA1qS*\u0011A,X\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqv,A\u0003kk:LGOC\u0001a\u0003\ry'oZ\u0005\u0003Ef\u0013A\u0001V3ti\u0006YB/Z:u+B$\u0017\r^3Es:\fW.[2UQJ,\u0017\r\u001a)p_2D#aA,\u0002WQ,7\u000f^+qI\u0006$XMU3n_R,Gj\\4NC:\fw-\u001a:Es:\fW.[2UQJ,\u0017\r\u001a)p_2D#\u0001B,\u0002_Q,7\u000f\u001e*f[>$X\rT8h\tft\u0017-\\5d)\"\u0014X-\u00193Q_>dw+\u001b;i\u0013:4\u0018\r\\5e-\u0006dW/Z:)\u0005\u00159\u0016A\n;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bnU8nK&sg/\u00197jI\u000e{gNZ5hg\"\u0012aaV\u00014i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016D#aB,\u00029Q,7\u000f\u001e*fG>tg-[4ve\u0006\u0014G.\u001a,bY&$\u0017\r^5p]\"\u0012\u0001bV\u0001\u0014i\u0016\u001cHoU3dkJLG/_\"p]\u001aLwm\u001d\u0015\u0003\u0013]\u000b1\u0003^3ti\u000e{gN\\3di&|g.U;pi\u0006D#AC,\u0002/Q,7\u000f^\"p]:,7\r^5p]J\u000bG/Z)v_R\f\u0007FA\u0006X\u0003I1XM]5gs\u000e{gNZ5h+B$\u0017\r^3\u0015\u0011M;\u0018\u0011BA\u000f\u0003OAQ\u0001\u001f\u0007A\u0002e\fAA\\1nKB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?J\u001b\u0005i(B\u0001@F\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A%\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\t!\u0013\u0005\b\u0003\u0017a\u0001\u0019AA\u0007\u0003\u00151\u0018\r\\;f!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!AB(cU\u0016\u001cG\u000fC\u0004\u0002 1\u0001\r!!\t\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u00042\u0001SA\u0012\u0013\r\t)#\u0013\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\u0003\u0004a\u0001\u0003C\tQ\"\u001a=qK\u000e$h)Y5mkJ,\u0017a\t<fe&4\u0017pQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3D_:4\u0017n\u001a\u000b\n'\u0006=\u0012\u0011HA%\u0003'Bq!!\r\u000e\u0001\u0004\t\u0019$\u0001\u0004d_:4\u0017n\u001a\t\u0004!\u0006U\u0012bAA\u001c\u0003\nY1*\u00194lC\u000e{gNZ5h\u0011\u001d\tY$\u0004a\u0001\u0003{\t\u0011b\u001c:jOB\u0013x\u000e]:\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003RA!a\u0011\u0002\u0016\u0005!Q\u000f^5m\u0013\u0011\t9%!\u0011\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002L5\u0001\r!!\u0014\u0002\u0015Y\fG.\u001b3Qe>\u00048\u000fE\u0003{\u0003\u001fJ\u00180\u0003\u0003\u0002R\u0005\u001d!aA'ba\"9\u0011QK\u0007A\u0002\u00055\u0013\u0001D5om\u0006d\u0017\u000e\u001a)s_B\u001c\u0018!\u0007;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001eD#AD,\u0003\u001dQ+7\u000f^!vi\"|'/\u001b>feN9q\"!\u0004\u0002`\u0005M\u0004\u0003BA1\u0003_j!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(b\u0001\"\u0002j)\u0019A)a\u001b\u000b\u0007\u00055t,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003c\n\u0019G\u0001\u0006BkRDwN]5{KJ\u0004B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0005\u0003s\nI'\u0001\u0004d_6lwN\\\u0005\u0005\u0003{\n9H\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0005\u0005\u0005\u0005cAAB\u001f5\t\u0001!\u0001\u0006tkB,'/V:feN,\"!!#\u0011\t\u0005=\u00111R\u0005\u0005\u0003\u000b\t\t\"\u0001\btkB,'/V:feN|F%Z9\u0015\u0007M\u000b\t\nC\u0005\u0002\u0014J\t\t\u00111\u0001\u0002\n\u0006\u0019\u0001\u0010J\u0019\u0002\u0017M,\b/\u001a:Vg\u0016\u00148\u000f\t\u0015\u0004'\u0005e\u0005c\u0001%\u0002\u001c&\u0019\u0011QT%\u0003\u0011Y|G.\u0019;jY\u0016\fQa\u001d;beR$B!a)\u0002RB\"\u0011QUAZ!!\ty$a*\u0002*\u0006=\u0016\u0002BA)\u0003\u0003\u0002B!!\u001e\u0002,&!\u0011QVA<\u0005!)e\u000e\u001a9pS:$\b\u0003BAY\u0003gc\u0001\u0001B\u0006\u00026R\t\t\u0011!A\u0003\u0002\u0005]&aA0%qE!\u0011\u0011XA`!\rA\u00151X\u0005\u0004\u0003{K%a\u0002(pi\"Lgn\u001a\t\u0007\u0003\u0003\f9-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u0003\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI-a1\u0003\u001f\r{W\u000e\u001d7fi&|gn\u0015;bO\u0016\u0004B!a\u0004\u0002N&!\u0011qZA\t\u0005\u00111v.\u001b3\t\u000f\u0005MG\u00031\u0001\u0002V\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005\u0005\u0014q[\u0005\u0005\u00033\f\u0019G\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\nCV$\bn\u001c:ju\u0016$b!a8\u0002l\u0006U\bCBA \u0003C\f)/\u0003\u0003\u0002d\u0006\u0005#\u0001\u0002'jgR\u0004B!!\u0019\u0002h&!\u0011\u0011^A2\u0005M\tU\u000f\u001e5pe&T\u0018\r^5p]J+7/\u001e7u\u0011\u001d\ti/\u0006a\u0001\u0003_\faB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0002b\u0005E\u0018\u0002BAz\u0003G\u0012!$Q;uQ>\u0014\u0018N_1cY\u0016\u0014V-];fgR\u001cuN\u001c;fqRDq!a>\u0016\u0001\u0004\tI0A\u0004bGRLwN\\:\u0011\r\u0005}\u0012\u0011]A~!\u0011\t\t'!@\n\t\u0005}\u00181\r\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0002\u0015\r\u0014X-\u0019;f\u0003\u000ed7\u000f\u0006\u0004\u0003\u0006\te!1\u0004\u0019\u0005\u0005\u000f\u0011Y\u0001\u0005\u0004\u0002@\u0005\u0005(\u0011\u0002\t\u0005\u0003c\u0013Y\u0001B\u0006\u0003\u000eY\t\t\u0011!A\u0003\u0002\t=!aA0%sE!\u0011\u0011\u0018B\t!\u0019\t\t-a2\u0003\u0014A!\u0011\u0011\rB\u000b\u0013\u0011\u00119\"a\u0019\u0003\u001f\u0005\u001bGn\u0011:fCR,'+Z:vYRDq!!<\u0017\u0001\u0004\ty\u000fC\u0004\u0003\u001eY\u0001\rAa\b\u0002\u0017\u0005\u001cGNQ5oI&twm\u001d\t\u0007\u0003\u007f\t\tO!\t\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQAAa\n\u0002x\u0005\u0019\u0011m\u00197\n\t\t-\"Q\u0005\u0002\u000b\u0003\u000ed')\u001b8eS:<\u0017A\u00033fY\u0016$X-Q2mgR1!\u0011\u0007B#\u0005\u000f\u0002DAa\r\u00038A1\u0011qHAq\u0005k\u0001B!!-\u00038\u0011Y!\u0011H\f\u0002\u0002\u0003\u0005)\u0011\u0001B\u001e\u0005\u0011yF%\r\u0019\u0012\t\u0005e&Q\b\t\u0007\u0003\u0003\f9Ma\u0010\u0011\t\u0005\u0005$\u0011I\u0005\u0005\u0005\u0007\n\u0019GA\bBG2$U\r\\3uKJ+7/\u001e7u\u0011\u001d\tio\u0006a\u0001\u0003_DqA!\u0013\u0018\u0001\u0004\u0011Y%A\tbG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feN\u0004b!a\u0010\u0002b\n5\u0003\u0003\u0002B\u0012\u0005\u001fJAA!\u0015\u0003&\t\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\u0005C\u000ed7\u000f\u0006\u0003\u0003X\tu\u0003CBA\b\u00053\u0012\t#\u0003\u0003\u0003\\\u0005E!\u0001C%uKJ\f'\r\\3\t\u000f\t}\u0003\u00041\u0001\u0003N\u00051a-\u001b7uKJ\fQa\u00197pg\u0016\f\u0011bY8oM&<WO]3\u0015\u0007M\u00139\u0007C\u0004\u0003ji\u0001\rAa\u001b\u0002\u000f\r|gNZ5hgB\"!Q\u000eB9!\u001d\ty$a*z\u0005_\u0002B!!-\u0003r\u0011a!1\u000fB4\u0003\u0003\u0005\tQ!\u0001\u0003v\t!q\fJ\u00192#\u0011\tILa\u001e\u0011\u0007!\u0013I(C\u0002\u0003|%\u00131!\u00118z\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON$\"A!!\u0011\u000b\u0005}\"1Q=\n\t\t\u0015\u0015\u0011\t\u0002\u0004'\u0016$\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\r\u0019&1\u0012\u0005\b\u0005Sb\u0002\u0019\u0001BGa\u0011\u0011yIa%\u0011\u000f\u0005}\u0012qU=\u0003\u0012B!\u0011\u0011\u0017BJ\t1\u0011)Ja#\u0002\u0002\u0003\u0005)\u0011\u0001B;\u0005\u0011yF%\r\u001a\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0004'\nm\u0005b\u0002B5;\u0001\u0007!Q\u0014\u0019\u0005\u0005?\u0013\u0019\u000bE\u0004\u0002@\u0005\u001d\u0016P!)\u0011\t\u0005E&1\u0015\u0003\r\u0005K\u0013Y*!A\u0001\u0002\u000b\u0005!Q\u000f\u0002\u0005?\u0012\n4'\u0001\u000buKN$\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003=]\u000bad\u0019:fCR,7i\\7cS:,GmQ8oiJ|G\u000e\\3s\u0007>tg-[4\u0015\r\u0005u\"q\u0016B]\u0011\u001d\u0011\tl\ba\u0001\u0005g\u000baA\\8eK&#\u0007c\u0001%\u00036&\u0019!qW%\u0003\u0007%sG\u000fC\u0004\u0003<~\u0001\rAa-\u0002\tA|'\u000f^\u0001'i\u0016\u001cHoQ8nE&tW\rZ\"p]R\u0014x\u000e\u001c7fe\u0006+H\u000f[8sSj,'oQ8oM&<\u0007F\u0001\u0011X\u0003y\u0019'/Z1uK&\u001bx\u000e\\1uK\u0012\u001cuN\u001c;s_2dWM]\"p]\u001aLw\r\u0006\u0004\u0002>\t\u0015'q\u0019\u0005\b\u0005c\u000b\u0003\u0019\u0001BZ\u0011\u001d\u0011Y,\ta\u0001\u0005g\u000ba\u0005^3ti&\u001bx\u000e\\1uK\u0012\u001cuN\u001c;s_2dWM]!vi\"|'/\u001b>fe\u000e{gNZ5hQ\t\u0011s+\u0001\u0007uKN$8+\u001f8p]fl7\u000f\u000b\u0002$/\u0006iB/Z:u\u00136\u0004(o\u001c9fe\u000e{gNZ5hg\u0006\u0013XMU3n_Z,G\r\u000b\u0002%/\u0006IB/Z:u+B$\u0017\r^3NKR\u0014\u0018n\u0019*fa>\u0014H/\u001a:tQ\t)s+\u0001\u0014uKN$X\u000b\u001d3bi\u0016lU\r\u001e:jGJ+\u0007o\u001c:uKJ\u001chj\u001c&nqJ+\u0007o\u001c:uKJD#AJ,\u0002IQ,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO2{7-\u00197SKR,g\u000e^5p]6\u001b8i\u001c8gS\u001eD#aJ,\u0002MQ,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO2{7-\u00197SKR,g\u000e^5p]NK'0Z\"p]\u001aLw\r\u000b\u0002)/\u0006\u0001D/Z:u\tft\u0017-\\5d\u0019><Gj\\2bYJ+G/\u001a8uS>t7k[5qg>s\u0017J\u001c<bY&$7i\u001c8gS\u001eD#!K,\u0002gQ,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO2{7-\u00197SKR,g\u000e^5p]RC'o\\<t\u001f:LenY8se\u0016\u001cGoQ8oM&<\u0007F\u0001\u0016X\u0003\u0015\"Xm\u001d;Es:\fW.[2SK6|G/\u001a$fi\u000eDW*\u0019=XC&$Xj]\"p]\u001aLw\r\u000b\u0002,/\u0006\u0011D/Z:u\tft\u0017-\\5d%\u0016lw\u000e^3MSN$xJ\u001a4tKR\u001c(+Z9vKN$H+[7f_V$Xj]\"p]\u001aLw\r\u000b\u0002-/\u00069C/Z:u+B$\u0017\r^3Es:\fW.[2SK6|G/\u001a'pO6\u000bg.Y4fe\u000e{gNZ5hQ\tis+\u0001\u0013uKN$(+Z7pi\u0016dunZ'b]\u0006<WM]\"paf\fVo\u001c;b+B$\u0017\r^3tQ\tqs+A\u0013uKN$(+Z7pi\u0016dunZ'b]\u0006<WM\u001d$fi\u000eD\u0017+^8uCV\u0003H-\u0019;fg\"\u0012qfV\u0001*i\u0016\u001cHOU3n_R,Gj\\4NC:\fw-\u001a:Nk2$\u0018\u000e\u001d7f\u0007>tg-[4Va\u0012\fG/Z:)\u0005A:\u0016!\n<fe&4\u00170\u00138d_J\u0014Xm\u0019;M_\u001edunY1m%\u0016$XM\u001c;j_:\u0004&o\u001c9t)%\u00196\u0011BB\n\u0007/\u0019Y\u0002C\u0004\u0004\fE\u0002\ra!\u0004\u0002'1|w\rT8dC2\u0014V\r^3oi&|g.T:\u0011\u0007!\u001by!C\u0002\u0004\u0012%\u0013A\u0001T8oO\"91QC\u0019A\u0002\r5\u0011a\u0003:fi\u0016tG/[8o\u001bNDqa!\u00072\u0001\u0004\u0019i!\u0001\fm_\u001edunY1m%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0011\u001d\u0019i\"\ra\u0001\u0007\u001b\taB]3uK:$\u0018n\u001c8CsR,7OA\fEs:\fW.[2M_\u001e\u001cuN\u001c4jO\u000e{g\u000e^3yiN\u0011!g\u0012\u000b\u0005\u0007K\u00199\u0003E\u0002\u0002\u0004JBq!a\u000f5\u0001\u0004\ti$\u0006\u0002\u00024\u000591m\u001c8gS\u001e\u0004\u0013AC:feZ,'/T8dWV\u00111\u0011\u0007\t\u0004!\u000eM\u0012bAB\u001b\u0003\na!I]8lKJ\u001cVM\u001d<fe\u0006Y1/\u001a:wKJlunY6!\u00039awnZ'b]\u0006<WM]'pG.,\"a!\u0010\u0011\t\r}2QI\u0007\u0003\u0007\u0003R1aa\u0011D\u0003\rawnZ\u0005\u0005\u0007\u000f\u001a\tE\u0001\u0006M_\u001el\u0015M\\1hKJ\fq\u0002\\8h\u001b\u0006t\u0017mZ3s\u001b>\u001c7\u000eI\u0001\u0018GV\u0014(/\u001a8u\t\u00164\u0017-\u001e7u\u0019><7i\u001c8gS\u001e,\"aa\u0014\u0011\r\rE3qKB.\u001b\t\u0019\u0019F\u0003\u0003\u0004V\u0005\r\u0017AB1u_6L7-\u0003\u0003\u0004Z\rM#aD!u_6L7MU3gKJ,gnY3\u0011\t\ru3\u0011N\u0007\u0003\u0007?RAaa\u0011\u0004b)!11MB3\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0004h\u0005%\u0014aB:u_J\fw-Z\u0005\u0005\u0007W\u001ayFA\u0005M_\u001e\u001cuN\u001c4jO\u0006A2-\u001e:sK:$H)\u001a4bk2$Hj\\4D_:4\u0017n\u001a\u0011\u0002YQ,7\u000f\u001e#z]\u0006l\u0017n\u0019'pO\u000e{gNZ5h\u0011\u0006tG\r\\3t'ftwN\\=ng\u000e{'O]3di2L\bFA\u001fX\u0003e\"Xm\u001d;M_\u001e\u0014V\r^3oi&|g\u000eV5nK6Kg.\u001e;fg&\u001bhj\u001c;Es:\fW.[2bY2L(+Z2p]\u001aLw-\u001e:bE2,\u0007F\u0001 X\u0003U\"Xm\u001d;BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148/S:O_R$\u0015P\\1nS\u000e\fG\u000e\\=SK\u000e|gNZ5hkJ\f'\r\\3)\u0005}:\u0006")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = "ks" + i + ".jks";
            props1.put("listener.name.external.ssl.keystore.location", newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var31_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var32_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var33_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("num.io.threads", "4");
        origProps.put("num.network.threads", "2");
        origProps.put("num.replica.fetchers", "1");
        origProps.put("num.recovery.threads.per.data.dir", "1");
        origProps.put("background.threads", "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put("num.io.threads", "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (int)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put("num.network.threads", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey("num.network.threads"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get("num.network.threads"));
        props.put("num.replica.fetchers", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put("num.recovery.threads.per.data.dir", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put("background.threads", "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (int)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testUpdateRemoteLogManagerDynamicThreadPool() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogManagerCopierThreadPoolSize());
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogManagerExpirationThreadPoolSize());
        Assertions.assertEquals((int)10, (int)config.remoteLogManagerConfig().remoteLogReaderThreads());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.manager.copier.thread.pool.size", "8");
        config.dynamicConfig().validate(props, true);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (int)config.remoteLogManagerConfig().remoteLogManagerCopierThreadPoolSize());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCopierThreadPool(8);
        props.put("remote.log.manager.expiration.thread.pool.size", "7");
        config.dynamicConfig().validate(props, false);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)7, (int)config.remoteLogManagerConfig().remoteLogManagerExpirationThreadPoolSize());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeExpirationThreadPool(7);
        props.put("remote.log.reader.threads", "6");
        config.dynamicConfig().validate(props, true);
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (int)config.remoteLogManagerConfig().remoteLogReaderThreads());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeReaderThreadPool(6);
        props.clear();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogDynamicThreadPoolWithInvalidValues() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.manager.copier.thread.pool.size", "0");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true))).getMessage().contains("Value must be at least 1"));
        Properties props1 = new Properties();
        props1.put("remote.log.manager.expiration.thread.pool.size", "-1");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props1, false))).getMessage().contains("Value must be at least 1"));
        Properties props2 = new Properties();
        props2.put("remote.log.reader.threads", "2");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props2, false))).getMessage().contains("value should be at least half the current value"));
        new Properties().put("remote.log.reader.threads", "-1");
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true))).getMessage().contains("Value must be at least 1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node.id"), (Object)"123")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.cleaner.dedupe.buffer.size", "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "broker.id", "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "log.cleaner.dedupe.buffer.size", "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate("max.connections.per.ip", "100", true, false);
        this.verifyConfigUpdate("max.connections.per.ip", "100", false, false);
        this.verifyConfigUpdate("max.connections.per.ip", "0", false, true);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName#:100", true, true);
        this.verifyConfigUpdate("max.connections", "100", true, false);
        this.verifyConfigUpdate("max.connections", "100", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connections";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate("max.connection.creation.rate", "110", true, false);
        this.verifyConfigUpdate("max.connection.creation.rate", "120", false, false);
        String listenerMaxConnectionsProp = "listener.name.external.max.connection.creation.rate";
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var30_18 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDynamicListenerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("listeners", "PLAINTEXT://hostname:9092");
        boolean apply_doLog = true;
        new DynamicListenerConfig(kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var31_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var32_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var33_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallbackPlugin()).thenReturn(Optional.empty());
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)authorizer, null, (String)"authorizer.class.name");
        Mockito.when((Object)kafkaServer.authorizerPlugin()).thenReturn((Object)new Some((Object)authorizerPlugin));
        kafkaServer.config().dynamicConfig().addReconfigurables(kafkaServer);
        props.put("super.users", "User:admin");
        DynamicBrokerConfig qual$1 = kafkaServer.config().dynamicConfig();
        boolean x$23 = qual$1.updateBrokerConfig$default$3();
        qual$1.updateBrokerConfig(0, props, x$23);
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "broker,controller");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", retval.get("listeners") + ",CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", nodeId + "@localhost:0");
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallbackPlugin()).thenReturn(Optional.empty());
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)authorizer, null, (String)"authorizer.class.name");
        Mockito.when((Object)controllerServer.authorizerPlugin()).thenReturn((Object)new Some((Object)authorizerPlugin));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put("process.roles", "controller");
        retval.remove("advertised.listeners");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", "CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", nodeId + "@localhost:0");
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallbackPlugin()).thenReturn(Optional.empty());
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)authorizer, null, (String)"authorizer.class.name");
        Mockito.when((Object)controllerServer.authorizerPlugin()).thenReturn((Object)new Some((Object)authorizerPlugin));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, true));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put("max.connections", "9999");
        newProps.put("message.max.bytes", "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put("max.connections", "INVALID_INT");
        newProps.put("message.max.bytes", "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put("metric.reporters", JmxReporter.class.getName() + "," + MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("metric.reporters", "");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove("metric.reporters");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2592000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var24_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var25_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var26_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "4294967296");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    @Test
    public void testDynamicRemoteFetchMaxWaitMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Mockito.when((Object)kafkaBroker.remoteLogManagerOpt()).thenReturn((Object)None$.MODULE$);
        Assertions.assertEquals((int)500, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.fetch.max.wait.ms", "30000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)30000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        newProps.put("remote.fetch.max.wait.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((int)10000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, 0})).foreach((Function1 & Serializable)maxWaitMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)maxWaitMs)));
    }

    @Test
    public void testDynamicRemoteListOffsetsRequestTimeoutMsConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Mockito.when((Object)kafkaBroker.remoteLogManagerOpt()).thenReturn((Object)None$.MODULE$);
        Assertions.assertEquals((long)30000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.list.offsets.request.timeout.ms", "60000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)60000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        newProps.put("remote.list.offsets.request.timeout.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)10000L, (long)config.remoteLogManagerConfig().remoteListOffsetsRequestTimeoutMs());
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, 0})).foreach((Function1 & Serializable)timeoutMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteListOffsetsRequestTimeoutMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)timeoutMs)));
    }

    @Test
    public void testUpdateDynamicRemoteLogManagerConfig() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var25_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("remote.log.index.file.cache.total.size.bytes", "2");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.index.file.cache.total.size.bytes", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerCopyQuotaUpdates() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var23_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var24_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var25_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        props.put("remote.log.manager.copy.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        props.put("remote.log.manager.copy.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerFetchQuotaUpdates() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var23_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var24_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var25_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put("remote.log.manager.fetch.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(100L);
        props.put("remote.log.manager.fetch.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerMultipleConfigUpdates() {
        String indexFileCacheSizeProp = "remote.log.index.file.cache.total.size.bytes";
        String copyQuotaProp = "remote.log.manager.copy.max.bytes.per.second";
        String fetchQuotaProp = "remote.log.manager.fetch.max.bytes.per.second";
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var26_11 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var27_14 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var28_17 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 9092, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((long)0x40000000L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put(indexFileCacheSizeProp, "4");
        props.put(copyQuotaProp, "100");
        props.put(fetchQuotaProp, "200");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        props.put(indexFileCacheSizeProp, "8");
        props.put(copyQuotaProp, "200");
        props.put(fetchQuotaProp, "400");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)8L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)400L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(8L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(400L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var34_18 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, Long.toString(retentionMs));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, Long.toString(retentionBytes));
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    @Test
    public void testDynamicLogConfigHandlesSynonymsCorrectly() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.retention.minutes", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("message.max.bytes", "12345678");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.currentDefaultLogConfig().get().retentionMs);
    }

    @Test
    public void testLogRetentionTimeMinutesIsNotDynamicallyReconfigurable() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("log.retention.hours", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("log.retention.minutes", "3");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Assertions.assertFalse((boolean)((AbstractConfig)ctx.currentDefaultLogConfig().get()).originals().containsKey("log.retention.minutes"));
    }

    @Test
    public void testAdvertisedListenersIsNotDynamicallyReconfigurable() {
        boolean x$3 = true;
        boolean x$4 = true;
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_8 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, 8181, (Option<SecurityProtocol>)x$5, (Option<File>)x$6, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Properties props = new Properties();
        props.put("advertised.listeners", "SASL_PLAINTEXT://localhost:8181");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        ctx.config().effectiveAdvertisedBrokerListeners().foreach((Function1 & Serializable)e -> {
            DynamicBrokerConfigTest.$anonfun$testAdvertisedListenersIsNotDynamicallyReconfigurable$1(e);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)((AbstractConfig)ctx.currentDefaultLogConfig().get()).originals().containsKey("advertised.listeners"));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get("log.cleaner.threads").toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException("Invalid cleaner threads " + cleanerThreads);
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate("listener.name.external." + name, value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate("listener.name.external." + name, value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$4, Properties props$2) {
        if (perBrokerConfig$1) {
            config$4.dynamicConfig().updateBrokerConfig(0, props$2, config$4.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$4.dynamicConfig().updateDefaultConfig(props$2, config$4.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$5, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$5.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$5, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$5.originals().get(name));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(Properties newProps$1, KafkaConfig config$6, int maxWaitMs) {
        newProps$1.put("remote.fetch.max.wait.ms", Integer.toString(maxWaitMs));
        Assertions.assertThrows(ConfigException.class, () -> config$6.dynamicConfig().validate(newProps$1, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$6.dynamicConfig().validate(newProps$1, false));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteListOffsetsRequestTimeoutMsConfig$1(Properties newProps$2, KafkaConfig config$7, int timeoutMs) {
        newProps$2.put("remote.list.offsets.request.timeout.ms", Integer.toString(timeoutMs));
        Assertions.assertThrows(ConfigException.class, () -> config$7.dynamicConfig().validate(newProps$2, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$7.dynamicConfig().validate(newProps$2, false));
    }

    public static final /* synthetic */ void $anonfun$testAdvertisedListenersIsNotDynamicallyReconfigurable$1(Endpoint e) {
        Assertions.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)e.listener());
    }

    public class DynamicLogConfigContext {
        private final KafkaConfig config;
        private final BrokerServer serverMock;
        private final LogManager logManagerMock;
        private final AtomicReference<LogConfig> currentDefaultLogConfig;

        public KafkaConfig config() {
            return this.config;
        }

        public BrokerServer serverMock() {
            return this.serverMock;
        }

        public LogManager logManagerMock() {
            return this.logManagerMock;
        }

        public AtomicReference<LogConfig> currentDefaultLogConfig() {
            return this.currentDefaultLogConfig;
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$DynamicLogConfigContext$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public static final /* synthetic */ void $anonfun$new$2(DynamicLogConfigContext $this, InvocationOnMock invocation) {
            $this.currentDefaultLogConfig().set((LogConfig)invocation.getArgument(0));
        }

        public DynamicLogConfigContext(Properties origProps) {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            boolean apply_doLog = true;
            this.config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
            this.serverMock = (BrokerServer)Mockito.mock(BrokerServer.class);
            this.logManagerMock = (LogManager)Mockito.mock(LogManager.class);
            Mockito.when((Object)this.serverMock().config()).thenReturn((Object)this.config());
            Mockito.when((Object)this.serverMock().logManager()).thenReturn((Object)this.logManagerMock());
            Mockito.when((Object)this.logManagerMock().allLogs()).thenReturn(package$.MODULE$.Iterable().empty());
            this.currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
            Mockito.when((Object)this.logManagerMock().currentDefaultConfig()).thenAnswer(x$1 -> this.currentDefaultLogConfig().get());
            this.logManagerMock().reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
                DynamicLogConfigContext.$anonfun$new$2(this, invocation);
                return BoxedUnit.UNIT;
            });
            this.config().dynamicConfig().initialize((Option)None$.MODULE$);
            this.config().dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(this.logManagerMock()));
        }
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

