/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003\u001f\u0011\u00199\u0003\u0001)A\u0005?!)\u0001\u0006\u0001C\u0001S!)!\b\u0001C\u0001S!)A\b\u0001C\u0001S!)a\b\u0001C\u0005\u007f!)A\n\u0001C\u0005\u001b\")\u0001\f\u0001C\u00053\")\u0001\f\u0001C\u0005?\")1\r\u0001C\u0005I\"9\u0011q\u0001\u0001\u0005\n\u0005%!\u0001\u0007#fY\u0016$XMU3d_J$7OU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011CE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002!%\u0011\u0011\u0004\u0005\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003/\u0001\t!\u0002V%N\u000b>+FkX'T+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#aA%oi\u0006YA+S'F\u001fV#v,T*!\u0003}iUiU*B\u000f\u0016\u001bv\f\u0015*P\tV\u001bU\tR0Q\u000bJ{\u0006+\u0011*U\u0013RKuJT\u0001!\u001b\u0016\u001b6+Q$F'~\u0003&k\u0014#V\u0007\u0016#u\fU#S?B\u000b%\u000bV%U\u0013>s\u0005%\u0001\u000euKN$H)\u001a7fi\u0016\u0014VmY8sIND\u0015\r\u001d9z\u0007\u0006\u001cX\rF\u0001+!\t\u00013&\u0003\u0002-C\t!QK\\5uQ\t1a\u0006\u0005\u00020q5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003kY\nQA[;oSRT\u0011aN\u0001\u0004_J<\u0017BA\u001d1\u0005\u0011!Vm\u001d;\u0002[Q,7\u000f^#se>\u0014x\u000b[3o\t\u0016dW\r^5oOJ+7m\u001c:eg^KG\u000f[%om\u0006d\u0017\u000eZ(gMN,G\u000f\u000b\u0002\b]\u0005aC/Z:u\u000bJ\u0014xN],iK:$U\r\\3uS:<'+Z2pe\u0012\u001cx+\u001b;i\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u0015\u0003\u00119\n\u0011d\u0019:fCR,Gk\u001c9jG\u0006sGmU3oIJ+7m\u001c:egV\t\u0001\t\u0005\u0003!\u0003\u000e{\u0012B\u0001\"\"\u0005\u0019!V\u000f\u001d7feA\u0011AIS\u0007\u0002\u000b*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005MA%BA%7\u0003\u0019\t\u0007/Y2iK&\u00111*\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003-\u001a'/Z1uK\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\fX/Z:u\r>\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tGc\u0001(U-B\u0011qJU\u0007\u0002!*\u0011\u0011+R\u0001\te\u0016\fX/Z:ug&\u00111\u000b\u0015\u0002\u0015\t\u0016dW\r^3SK\u000e|'\u000fZ:SKF,Xm\u001d;\t\u000bUS\u0001\u0019A\"\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\")qK\u0003a\u0001?\u0005qqN\u001a4tKR$v\u000eR3mKR,\u0017\u0001G:f]\u0012$U\r\\3uKJ+7m\u001c:egJ+\u0017/^3tiR\u0011!,\u0018\t\u0003\u001fnK!\u0001\u0018)\u0003+\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\u001c\bo\u001c8tK\")al\u0003a\u0001\u001d\u00069!/Z9vKN$Hc\u0001.aC\")a\f\u0004a\u0001\u001d\")!\r\u0004a\u0001?\u0005AA.Z1eKJLE-A\u0006qe>$WoY3ECR\fG\u0003B3t\u0003\u0007\u00012AZ5l\u001b\u00059'B\u00015\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u001e\u00141aU3r!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0005qe>$WoY3s\u0015\t\u0001x)A\u0004dY&,g\u000e^:\n\u0005Il'A\u0004*fG>\u0014H-T3uC\u0012\fG/\u0019\u0005\u0006i6\u0001\r!^\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u0019aO`\"\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>\u0015\u0003\u0019a$o\\8u}%\t!%\u0003\u0002~C\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\tA\u0011\n^3sC\ndWM\u0003\u0002~C!1\u0011QA\u0007A\u0002}\tqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\u0002=Y\fG.\u001b3bi\u0016dunZ*uCJ$xJ\u001a4tKR4uN\u001d+pa&\u001cG#\u0002\u0016\u0002\f\u00055\u0001\"B+\u000f\u0001\u0004\u0019\u0005bBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u0014Kb\u0004Xm\u0019;fIN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004A\u0005M\u0011bAA\u000bC\t!Aj\u001c8h\u0001")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final int TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private int TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteRecordsHappyCase() {
        void var3_3;
        void var2_2;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var2_2, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var3_3).data().topics().find(var2_2.topic()).partitions().find(var2_2.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)("Unexpected lowWatermark received: " + partitionResult.lowWatermark()));
        this.validateLogStartOffsetForTopic((TopicPartition)var2_2, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testErrorWhenDeletingRecordsWithInvalidOffset() {
        void var3_3;
        void var2_2;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var2_2, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var3_3).data().topics().find(var2_2.topic()).partitions().find(var2_2.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var2_2, 0L);
    }

    @Test
    public void testErrorWhenDeletingRecordsWithInvalidTopic() {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs(this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        scala.collection.immutable.Seq sendfutureList = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable)tp -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex))))).map((Function1 & Serializable)x$1 -> producer.send(x$1));
        producer.flush();
        scala.collection.immutable.Seq recordMetadataList = (scala.collection.immutable.Seq)sendfutureList.map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
        recordMetadataList.foreach((Function1 & Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((IterableOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return qual$1.getLog(topicPartition, x$2);
        })).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((UnifiedLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = tp$1 + "-" + messageIndex;
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)("key " + suffix), (Object)("value " + suffix));
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)("Invalid offset " + recordMetadata));
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 1000;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

