/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.cluster.Partition;
import kafka.server.DelayedFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.LogReadResult;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004'\u0001\u0001\u0006Ia\t\u0005\bO\u0001\u0011\r\u0011\"\u0003)\u0011\u0019a\u0003\u0001)A\u0005S!9Q\u0006\u0001b\u0001\n\u0013q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003F\u0001\u0011\u0005A\u0007C\u0003H\u0001\u0011\u0005A\u0007C\u0003J\u0001\u0011\u0005!\nC\u0003f\u0001\u0011%a\rC\u0004z\u0001E\u0005I\u0011\u0002>\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u00111\n\u0001\u0005\n\u00055#\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011!E\u0001\t[\u0006D()\u001f;fgV\t1\u0005\u0005\u0002\u0019I%\u0011Q%\u0007\u0002\u0004\u0013:$\u0018!C7bq\nKH/Z:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u000b\t\u0003A)J!aK\t\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0007sKBd\u0017nY1Rk>$\u0018-F\u00010!\t\u0001\u0003'\u0003\u00022#\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006i!/\u001a9mS\u000e\f\u0017+^8uC\u0002\n\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2i)\u0005)\u0004C\u0001\r7\u0013\t9\u0014D\u0001\u0003V]&$\bF\u0001\u0005:!\tQ4)D\u0001<\u0015\taT(A\u0002ba&T!AP \u0002\u000f),\b/\u001b;fe*\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$\u0001\u0002+fgR\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0005%I\u0014A\u0005;fgR$\u0015N^3sO&tw-\u00129pG\"D#AC\u001d\u0002YQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eDw+\u001b;i\u001b\u0016\u001c8/Y4f\u001f:d\u0017\u0010S5hQ^\u000bG/\u001a:nCJ\\GCA\u001bL\u0011\u0015a5\u00021\u0001N\u0003%)g\u000eZ(gMN,G\u000f\u0005\u0002\u0019\u001d&\u0011q*\u0007\u0002\u0005\u0019>tw\r\u000b\u0003\f#^C\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+>\u0003\u0019\u0001\u0018M]1ng&\u0011ak\u0015\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!W\u0001;i\u0016\u001cH\u000fR3mCf,GMR3uG\"<\u0016\u000e\u001e5NKN\u001c\u0018mZ3P]2L\b*[4i/\u0006$XM]7be.\u0004SM\u001c3PM\u001a\u001cX\r^\u001f|auDCaC.bEB\u0011AlX\u0007\u0002;*\u0011alU\u0001\taJ|g/\u001b3fe&\u0011\u0001-\u0018\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0003m_:<7\u000f\f\u0002dIz\t\u0001A\b\u0002\u0002i\bA\"-^5mI\u001a{G\u000e\\8xKJ4U\r^2i!\u0006\u0014\u0018-\\:\u0015\t\u001d\u001cXo\u001e\t\u0003QFl\u0011!\u001b\u0006\u0003U.\f1\u0001\\8h\u0015\taW.A\u0004ti>\u0014\u0018mZ3\u000b\u0005Iq'B\u0001\u000bp\u0015\t\u0001\u0018)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003e&\u00141BR3uG\"\u0004\u0016M]1ng\")A\u000f\u0004a\u0001G\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\u0006m2\u0001\raI\u0001\n[\u0006Dx+Y5u\u001bNDq\u0001\u001f\u0007\u0011\u0002\u0003\u00071%\u0001\u0005nS:\u0014\u0015\u0010^3t\u0003\t\u0012W/\u001b7e\r>dGn\\<fe\u001a+Go\u00195QCJ\fWn\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t1P\u000b\u0002$y.\nQ\u0010E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0005v]\u000eDWmY6fI*\u0019\u0011QA\r\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\n}\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U)\u0007\u0010]3diJ+\u0017\r\u001a$s_6\u0014V\r\u001d7jG\u0006$\u0012\"NA\b\u0003'\t\u0019#a\u000f\t\r\u0005Ea\u00021\u0001h\u0003-1W\r^2i!\u0006\u0014\u0018-\\:\t\u000f\u0005Ua\u00021\u0001\u0002\u0018\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u00048\u0002\r\r|W.\\8o\u0013\u0011\t\t#a\u0007\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA\u0013\u001d\u0001\u0007\u0011qE\u0001\u0013M\u0016$8\r\u001b)beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002*\u0005Ub\u0002BA\u0016\u0003ci!!!\f\u000b\t\u0005=\u00121D\u0001\te\u0016\fX/Z:ug&!\u00111GA\u0017\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\t9$!\u000f\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\t\u0019$!\f\t\u000f\u0005ub\u00021\u0001\u0002@\u0005)QM\u001d:peB!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005m\u0011\u0001\u00039s_R|7m\u001c7\n\t\u0005%\u00131\t\u0002\u0007\u000bJ\u0014xN]:\u0002\u001f\t,\u0018\u000e\u001c3SK\u0006$'+Z:vYR$B!a\u0014\u0002XA!\u0011\u0011KA*\u001b\u0005i\u0017bAA+[\niAj\\4SK\u0006$'+Z:vYRDq!!\u0010\u0010\u0001\u0004\ty\u0004")
public class DelayedFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, 1);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error);
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, 1);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException("Replica for " + topicIdPartition + " not available")});
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)fetchResult.error);
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, 1);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
    }

    @ParameterizedTest(name="testDelayedFetchWithMessageOnlyHighWatermark endOffset={0}")
    @ValueSource(longs={0L, 500L})
    public void testDelayedFetchWithMessageOnlyHighWatermark(long endOffset) {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 450L;
        long logStartOffset = 5L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, 1);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$4(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(endOffset, -1L, -1);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        boolean expected = endOffset == 0L;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)delayedFetch.tryComplete()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)delayedFetch.isCompleted()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)((Option)fetchResultOpt.elem).isDefined()));
        if (((Option)fetchResultOpt.elem).isDefined()) {
            Assertions.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)((Option)fetchResultOpt.elem).get()).error);
            return;
        }
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs, int minBytes) {
        return new FetchParams(replicaId, 1L, (long)maxWaitMs, minBytes, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private int buildFollowerFetchParams$default$3() {
        return 1;
    }

    private void expectReadFromReplica(FetchParams fetchParams, TopicIdPartition topicIdPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        Mockito.when((Object)this.replicaManager().readFromLog(fetchParams, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        return new LogReadResult(new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY), Optional.empty(), -1L, -1L, -1L, -1L, -1L, OptionalLong.empty(), (errors == null ? errors2 != null : !errors.equals(errors2)) ? Optional.of(error.exception()) : Optional.empty());
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef fetchResultOpt$4) {
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

