/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collection;
import java.util.Properties;
import kafka.server.ControllerServer;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterFeature;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.server.common.Feature;
import org.junit.jupiter.api.Assertions;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\b\u0011\u0001UA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006Y\u0001!\t!\f\u0005\u0006\u000f\u0002!\t!\f\u0005\u00063\u0002!\t!\f\u0005\u00067\u0002!\t!\f\u0005\u0006;\u0002!\t!\f\u0005\u0006?\u0002!\t!\f\u0005\u0006C\u0002!\t!\f\u0005\u0006G\u0002!\t!\f\u0005\u0006K\u0002!\t!\f\u0005\u0006a\u0002!\t!\f\u0005\u0006q\u0002!\t!\f\u0005\u0006u\u0002!\t!\f\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011\u0001E\u0005\u00033A\u0011qd\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:CCN,'+Z9vKN$H+Z:u\u0003\u001d\u0019G.^:uKJ\u0004\"\u0001\b\u0014\u000e\u0003uQ!AH\u0010\u0002\tQ,7\u000f\u001e\u0006\u0003A\u0005\naaY8n[>t'BA\n#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dj\"aD\"mkN$XM]%ogR\fgnY3\u0002\rqJg.\u001b;?)\tQ3\u0006\u0005\u0002\u0018\u0001!)!D\u0001a\u00017\u0005\u0011E/Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3bi&\u001b\u0018J\\1dG\u0016\u001c8/\u001b2mK^CWM\u001c#jg\u0006\u0014G.\u001a3CsN#\u0018\r^5d\u0007>tg-[4\u0015\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012A!\u00168ji\"\"1!N\u001e=!\t1\u0014(D\u00018\u0015\tAT$A\u0002ba&L!AO\u001c\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNd\u0013!P\u0016\u0006}\u0005\u0013E)\u0012\t\u0003m}J!\u0001Q\u001c\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0003\r\u000bQe\u001a:pkBt3m\\8sI&t\u0017\r^8s]I,'-\u00197b]\u000e,g\u0006\u001d:pi>\u001cw\u000e\\:\u0002\u000bY\fG.^3\"\u0003\u0019\u000bqa\u00197bgNL7-A!uKN$8i\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG/S:J]\u0006\u001c7-Z:tS\ndWm\u00165f]\u001a+\u0017\r^;sK\u001ac\u0017m\u001a(pi\u0016s\u0017M\u00197fI\"\"A!N%K\u0003!1W-\u0019;ve\u0016\u001cH&A&,\u000b1{\u0005k\u0016-\u0011\u0005Yj\u0015B\u0001(8\u00059\u0019E.^:uKJ4U-\u0019;ve\u0016\fqAZ3biV\u0014X\rJ\u0001R\u0013\t\u00116+A\u0007H%>+\u0006k\u0018,F%NKuJ\u0014\u0006\u0003)V\u000bqAR3biV\u0014XM\u0003\u0002!-*\u0011\u0011#I\u0001\bm\u0016\u00148/[8o7\u0005\u0001\u0011A\u0012;fgR\u001cuN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$\u0018j]!dG\u0016\u001c8/\u001b2mK^CWM\u001c(fo\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018j]#oC\ndW\r\u001a\u0015\u0003\u000bU\nq\u0006^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR<\u0016\u000e\u001e5SK\u001e,H.\u0019:FqB\u0014Xm]:j_:D#AB\u001b\u0002mQ,7\u000f^\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;XSRD\u0017J\u001c<bY&$'+Z4vY\u0006\u0014X\t\u001f9sKN\u001c\u0018n\u001c8)\u0005\u001d)\u0014\u0001\u0007;fgR,U\u000e\u001d;z\u0007>t7/^7fe\u001e\u0013x.\u001e9JI\"\u0012\u0001\"N\u00010i\u0016\u001cHoQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r^,ji\",U\u000e\u001d;z'V\u00147o\u0019:jaRLwN\u001c\u0015\u0003\u0013U\nA\n^3tiJ+'n\\5oS:<7\u000b^1uS\u000elU-\u001c2fe\u001e+Go]!tg&<g.\\3oiN\u0014\u0015mY6XQ\u0016tg*Z<He>,\boQ8pe\u0012Lg.\u0019;pe&\u001bXI\\1cY\u0016$\u0007F\u0001\u00066\u0003A#Xm\u001d;Ti\u0006$\u0018nY'f[\n,'OU3n_Z,G-\u00114uKJ\u001cVm]:j_:$\u0016.\\3pkR,\u0005\u0010]5ss^CWM\u001c(fo\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018j]#oC\ndW\r\u001a\u0015\u0005\u0017UZt\r\f\u0002i[.*a(Q5EW\u0006\n!.A\u0011he>,\bOL2p]N,X.\u001a:/g\u0016\u001c8/[8o]QLW.Z8vi:j7/I\u0001m\u0003\u0011)\u0004\u0007M\u0019,\u000by\ne\u000eR6\"\u0003=\fQe\u001a:pkBt3m\u001c8tk6,'OL7j]:\u001aXm]:j_:tC/[7f_V$h&\\:\u0002aQ,7\u000f^+qI\u0006$XmQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r^\"p]\u001aLwmU;dG\u0016\u001c8OZ;mQ\u0011aQg\u000f:-\u0003M\\SAP!u\tZ\f\u0013!^\u0001%OJ|W\u000f\u001d\u0018d_:\u001cX/\\3s]!,\u0017M\u001d;cK\u0006$h&\u001b8uKJ4\u0018\r\u001c\u0018ng\u0006\nq/\u0001\u00036aA\u0002\u0014a\u0011;fgR\u001cuN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$h)Y5mkJ,\u0017JZ'f[\n,'/\u00133NSN\u001c\u0018N\\4G_J4VM]:j_:\u001c\u0018IY8wKBB#!D\u001b\u0002]Q,7\u000f^'f[\n,'/\u00133HK:,'/\u0019;fI>s7+\u001a:wKJ<\u0006.\u001a8Ba&4VM]:j_:L5\u000f\r\u0015\u0003\u001dUB\u0013\u0002A?\u0002\u0002\u0005\r1(a\u0004\u0011\u0005Yr\u0018BA@8\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003\u0015!\u0018\u0010]3tY\t\t)\u0001\n\u0002\u0002\b%!\u0011\u0011BA\u0006\u0003\u0015Y%+\u0011$U\u0015\r\tiaN\u0001\u0005)f\u0004X\r\f\u0003\u0002\u0012\u0005m1f\u0002 B\u0003'!\u0015qC\u0011\u0003\u0003+\tAd\u001c4gg\u0016$8O\f;pa&\u001cgF\\;n]A\f'\u000f^5uS>t7/\t\u0002\u0002\u001a\u0005\t\u0011gK\u0004?\u0003\u0006uA)a\u0006\"\u0005\u0005}\u0011\u0001I8gMN,Go\u001d\u0018u_BL7M\f:fa2L7-\u0019;j_:tc-Y2u_J\u0004")
public class ConsumerGroupHeartbeatRequestTest
extends GroupCoordinatorBaseRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic")})
    public void testConsumerGroupHeartbeatIsInaccessibleWhenDisabledByStaticConfig() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    @ClusterTest(features={@ClusterFeature(feature=Feature.GROUP_VERSION, version=0)})
    public void testConsumerGroupHeartbeatIsInaccessibleWhenFeatureFlagNotEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var7_3 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var18_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var17_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var18_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var18_6.data().memberId());
            Assertions.assertEquals((int)1, (int)var18_6.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var18_6.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var18_6.data().memberId()).setMemberEpoch(var18_6.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var18_6 = null;
            var13_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var18_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var17_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var18_6.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var18_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var18_6.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var18_6.data().assignment());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var18_6.data().memberId()).setMemberEpoch(-1)).build();
            var18_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var17_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
            Assertions.assertEquals((int)-1, (int)var18_6.data().memberEpoch());
        }
        finally {
            admin.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithRegularExpression() {
        admin = this.cluster.admin();
        try {
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("foo*").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var6_3 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var23_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var22_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var23_6.data().memberId());
            Assertions.assertEquals((int)1, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var23_6.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var23_6.data().memberId()).setMemberEpoch(var23_6.data().memberEpoch())).build();
            var24_8 = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var23_6 = null;
            var12_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var23_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var22_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var23_6.data().assignment();
                if (!(v0 != null ? v0.equals(var24_8) == false : var24_8 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)var24_8, (Object)var23_6.data().assignment());
            admin.deleteTopics((TopicCollection)TopicCollection.ofTopicIds((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicId, (List)Nil$.MODULE$)).asJava())).all().get();
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var23_6.data().memberId()).setMemberEpoch(var23_6.data().memberEpoch())).build();
            var24_8 = new ConsumerGroupHeartbeatResponseData.Assignment();
            var23_6 = null;
            var18_12 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var23_6 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var22_2, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v2 = var23_6.data().assignment();
                if (!(v2 != null ? v2.equals(var24_8) == false : var24_8 != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions revoked. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)var24_8, (Object)var23_6.data().assignment());
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithInvalidRegularExpression() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("[").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.INVALID_REGULAR_EXPRESSION.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Did not receive the expected error. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((short)Errors.INVALID_REGULAR_EXPRESSION.code(), (short)consumerGroupHeartbeatResponse.data().errorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testEmptyConsumerGroupId() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), true).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.INVALID_REQUEST.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Did not receive the expected error. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)consumerGroupHeartbeatResponse.data().errorCode());
            Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)consumerGroupHeartbeatResponse.data().errorMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithEmptySubscription() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Did not receive the expected successful response. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            consumerGroupHeartbeatResponse = null;
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)("Did not receive the expected successful response. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            instanceId = "instanceId";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var9_4 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var20_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var19_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Static member could not join the group successfully. Last response " + var20_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)1, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var20_7.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var20_7.data().memberId()).setMemberEpoch(var20_7.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var20_7 = null;
            var15_10 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var20_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var19_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var20_7.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Static member could not get partitions assigned. Last response " + var20_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)2, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var20_7.data().assignment());
            oldMemberId = var20_7.data().memberId();
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var20_7.data().memberId()).setMemberEpoch(-2)).build();
            var20_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var19_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
            Assertions.assertEquals((int)-2, (int)var20_7.data().memberEpoch());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var20_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var19_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)2, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var20_7.data().assignment());
            Assertions.assertNotEquals((Object)oldMemberId, (Object)var20_7.data().memberId());
        }
        finally {
            admin.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="5001"), @ClusterConfigProperty(key="group.consumer.min.session.timeout.ms", value="5001")})
    public void testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            instanceId = "instanceId";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var8_4 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var25_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var24_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var25_7.data().memberId());
            Assertions.assertEquals((int)1, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var25_7.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var25_7.data().memberId()).setMemberEpoch(var25_7.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var25_7 = null;
            var14_10 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var25_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var24_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var25_7.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var25_7.data().assignment());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var25_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var24_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
            Assertions.assertEquals((short)Errors.UNRELEASED_INSTANCE_ID.code(), (short)var25_7.data().errorCode());
            var20_13 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var25_7 = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)var24_3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v2 = var25_7.data().assignment();
                if (!(v2 != null ? v2.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not re-join the group successfully. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)4, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var25_7.data().assignment());
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.heartbeat.interval.ms", value="5000")})
    public void testUpdateConsumerGroupHeartbeatConfigSuccessful() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            int newHeartbeatIntervalMs = 10000;
            String instanceId = "instanceId";
            String consumerGroupId = "grp";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(consumerGroupId).setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)consumerGroupHeartbeatResponse.data().memberId());
            Assertions.assertEquals((int)1, (int)consumerGroupHeartbeatResponse.data().memberEpoch());
            Assertions.assertEquals((int)5000, (int)consumerGroupHeartbeatResponse.data().heartbeatIntervalMs());
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, consumerGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.heartbeat.interval.ms", Integer.toString(newHeartbeatIntervalMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(consumerGroupId).setInstanceId(instanceId).setMemberId(consumerGroupHeartbeatResponse.data().memberId()).setMemberEpoch(consumerGroupHeartbeatResponse.data().memberEpoch())).build();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code() && newHeartbeatIntervalMs == consumerGroupHeartbeatResponse.data().heartbeatIntervalMs())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)("Dynamic update consumer group config failed. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0() {
        try (Admin admin = this.cluster.admin();){
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!(((ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.INVALID_REQUEST.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Should fail due to invalid member id.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testMemberIdGeneratedOnServerWhenApiVersionIs0() {
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
        Admin admin = this.cluster.admin();
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build((short)0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((consumerGroupHeartbeatResponse = (ConsumerGroupHeartbeatResponse)this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class))).data().errorCode() == Errors.NONE.code())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Could not join the group successfully. Last response " + consumerGroupHeartbeatResponse + "."));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String memberId = consumerGroupHeartbeatResponse.data().memberId();
        Assertions.assertNotNull((Object)memberId);
        Assertions.assertFalse((boolean)memberId.isEmpty());
        admin.close();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1) {
        consumerGroupHeartbeatResponse$1.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$1) {
        consumerGroupHeartbeatResponse$1.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$1) : expectedAssignment$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$1) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2) {
        consumerGroupHeartbeatResponse$2.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$2(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ObjectRef expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            ConsumerGroupHeartbeatResponseData.Assignment assignment2 = (ConsumerGroupHeartbeatResponseData.Assignment)expectedAssignment$2.elem;
            if (!(assignment != null ? !assignment.equals(assignment2) : assignment2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$4(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ObjectRef expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            ConsumerGroupHeartbeatResponseData.Assignment assignment2 = (ConsumerGroupHeartbeatResponseData.Assignment)expectedAssignment$2.elem;
            if (!(assignment != null ? !assignment.equals(assignment2) : assignment2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$6(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not get partitions revoked. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithInvalidRegularExpression$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$3) {
        consumerGroupHeartbeatResponse$3.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$3, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.INVALID_REGULAR_EXPRESSION.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithInvalidRegularExpression$2(ObjectRef consumerGroupHeartbeatResponse$3) {
        return "Did not receive the expected error. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testEmptyConsumerGroupId$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$4, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$4) {
        consumerGroupHeartbeatResponse$4.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$4, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem).data().errorCode() == Errors.INVALID_REQUEST.code();
    }

    public static final /* synthetic */ String $anonfun$testEmptyConsumerGroupId$2(ObjectRef consumerGroupHeartbeatResponse$4) {
        return "Did not receive the expected error. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$5, ObjectRef consumerGroupHeartbeatRequest$5) {
        consumerGroupHeartbeatResponse$5.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$5.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$2(ObjectRef consumerGroupHeartbeatResponse$5) {
        return "Did not receive the expected successful response. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$5, ObjectRef consumerGroupHeartbeatRequest$5) {
        consumerGroupHeartbeatResponse$5.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$5.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$4(ObjectRef consumerGroupHeartbeatResponse$5) {
        return "Did not receive the expected successful response. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$6, ObjectRef consumerGroupHeartbeatRequest$6) {
        consumerGroupHeartbeatResponse$6.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$6.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$6) {
        return "Static member could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$6, ObjectRef consumerGroupHeartbeatRequest$6, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$6.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$6.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$6) {
        return "Static member could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$7, ObjectRef consumerGroupHeartbeatRequest$7) {
        consumerGroupHeartbeatResponse$7.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$7.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$7) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$7, ObjectRef consumerGroupHeartbeatRequest$7, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$4) {
        consumerGroupHeartbeatResponse$7.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$7.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$4) : expectedAssignment$4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$7) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$7, ObjectRef consumerGroupHeartbeatRequest$7, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$4) {
        consumerGroupHeartbeatResponse$7.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$7.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$4) : expectedAssignment$4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(ObjectRef consumerGroupHeartbeatResponse$7) {
        return "Could not re-join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$8, ObjectRef consumerGroupHeartbeatRequest$8) {
        consumerGroupHeartbeatResponse$8.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$8.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$2(ObjectRef consumerGroupHeartbeatResponse$8) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$8, ObjectRef consumerGroupHeartbeatRequest$8, int newHeartbeatIntervalMs$1) {
        consumerGroupHeartbeatResponse$8.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$8.elem), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem).data().errorCode() == Errors.NONE.code() && newHeartbeatIntervalMs$1 == ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem).data().heartbeatIntervalMs();
    }

    public static final /* synthetic */ String $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$4(ObjectRef consumerGroupHeartbeatResponse$8) {
        return "Dynamic update consumer group config failed. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$9, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$9) {
        consumerGroupHeartbeatResponse$9.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$9, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$9.elem).data().errorCode() == Errors.INVALID_REQUEST.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0$2() {
        return "Should fail due to invalid member id.";
    }

    public static final /* synthetic */ boolean $anonfun$testMemberIdGeneratedOnServerWhenApiVersionIs0$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$10, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$10) {
        consumerGroupHeartbeatResponse$10.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$10, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$10.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testMemberIdGeneratedOnServerWhenApiVersionIs0$2(ObjectRef consumerGroupHeartbeatResponse$10) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$10.elem + ".";
    }

    public ConsumerGroupHeartbeatRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

