/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterFeature;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.common.Feature;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT}, brokers=1, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005\t4AAB\u0004\u0001\u0019!A\u0011\u0003\u0001B\u0001B\u0003%!\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u0003C\u0001\u0011\u0005A\u0005C\u0003E\u0001\u0011\u0005AE\u0001\u0011D_:\u001cX/\\3s\u000fJ|W\u000f\u001d#fg\u000e\u0014\u0018NY3SKF,Xm\u001d;UKN$(B\u0001\u0005\n\u0003\u0019\u0019XM\u001d<fe*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u0005}9%o\\;q\u0007>|'\u000fZ5oCR|'OQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\bG2,8\u000f^3s!\t\u0019R$D\u0001\u0015\u0015\t)b#\u0001\u0003uKN$(BA\f\u0019\u0003\u0019\u0019w.\\7p]*\u0011!\"\u0007\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014x-\u0003\u0002\u001f)\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"A\u0004\u0001\t\u000bE\u0011\u0001\u0019\u0001\n\u0002eQ,7\u000f^\"p]N,X.\u001a:He>,\b\u000fR3tGJL'-Z,iK:4U-\u0019;ve\u00164E.Y4O_R,e.\u00192mK\u0012$\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0005+:LG\u000f\u000b\u0003\u0004YI\u001a\u0004CA\u00171\u001b\u0005q#BA\u0018\u0015\u0003\r\t\u0007/[\u0005\u0003c9\u00121b\u00117vgR,'\u000fV3ti\u0006Aa-Z1ukJ,7\u000fL\u00015W\u0015)\u0004(\u000f!B!\tic'\u0003\u00028]\tq1\t\\;ti\u0016\u0014h)Z1ukJ,\u0017a\u00024fCR,(/\u001a\u0013\u0002u%\u00111\bP\u0001\u000e\u000fJ{U\u000bU0W\u000bJ\u001b\u0016j\u0014(\u000b\u0005ur\u0014a\u0002$fCR,(/\u001a\u0006\u0003/}R!\u0001\u0003\r\u0002\u000fY,'o]5p]n\t\u0001!\u0001\u0019uKN$8i\u001c8tk6,'o\u0012:pkB$Um]2sS\n,w+\u001b;i\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0003\t1\nA\u0006^3ti\u000e{gn];nKJ<%o\\;q\t\u0016\u001c8M]5cK^KG\u000f['jOJ\fG/[8o\u001b\u0016l'-\u001a:)\u0005\u0015a\u0003\u0006\u0003\u0001H\u0015.\u000b&k\u0015+\u0011\u00055B\u0015BA%/\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003\u0015!\u0018\u0010]3tY\u0005aE%A'\n\u00059{\u0015!B&S\u0003\u001a#&B\u0001)/\u0003\u0011!\u0016\u0010]3\u0002\u000f\t\u0014xn[3sgv\t\u0011!\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u0012QkX\u0016\u0006-fSF,\u0018\t\u0003[]K!\u0001\u0017\u0018\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0003m\u000bAd\u001c4gg\u0016$8O\f;pa&\u001cgF\\;n]A\f'\u000f^5uS>t7/A\u0003wC2,X-I\u0001_\u0003\u0005\t4&\u0002,ZArk\u0016%A1\u0002A=4gm]3ug:\"x\u000e]5d]I,\u0007\u000f\\5dCRLwN\u001c\u0018gC\u000e$xN\u001d")
public class ConsumerGroupDescribeRequestTest
extends GroupCoordinatorBaseRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(features={@ClusterFeature(feature=Feature.GROUP_VERSION, version=0)})
    public void testConsumerGroupDescribeWhenFeatureFlagNotEnabled() {
        ConsumerGroupDescribeRequest consumerGroupDescribeRequest = new ConsumerGroupDescribeRequest.Builder(new ConsumerGroupDescribeRequestData().setGroupIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)Nil$.MODULE$))).asJava())).build(ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled()));
        ConsumerGroupDescribeResponse consumerGroupDescribeResponse = (ConsumerGroupDescribeResponse)this.connectAndReceive((AbstractRequest)consumerGroupDescribeRequest, ClassTag$.MODULE$.apply(ConsumerGroupDescribeResponse.class));
        ConsumerGroupDescribeResponseData expectedResponse = new ConsumerGroupDescribeResponseData();
        expectedResponse.groups().add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-1").setErrorCode(Errors.UNSUPPORTED_VERSION.code()));
        expectedResponse.groups().add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-2").setErrorCode(Errors.UNSUPPORTED_VERSION.code()));
        Assertions.assertEquals((Object)expectedResponse, (Object)consumerGroupDescribeResponse.data());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupDescribeWithNewGroupCoordinator() {
        this.createOffsetsTopic();
        try (Admin admin = this.cluster.admin();){
            Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            int timeoutMs = 300000;
            String clientId = "client-id";
            String clientHost = "/127.0.0.1";
            int authorizedOperationsInt = Utils.to32BitField((Set)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(AclEntry.supportedOperations((ResourceType)ResourceType.GROUP)).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)x$1.code()))).asJava());
            ObjectRef grp1Member1Response = ObjectRef.create(null);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void waitUntilTrue_pause;
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$2 = Uuid.randomUuid().toString();
                .colon.colon $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$4 = new .colon.colon((Object)"bar", (List)Nil$.MODULE$);
                List $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$5 = package$.MODULE$.List().empty();
                int $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$6 = this.consumerGroupHeartbeat$default$3();
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$7 = this.consumerGroupHeartbeat$default$4();
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$8 = this.consumerGroupHeartbeat$default$5();
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$9 = this.consumerGroupHeartbeat$default$7();
                Errors $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$10 = this.consumerGroupHeartbeat$default$10();
                short $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$11 = this.consumerGroupHeartbeat$default$11();
                grp1Member1Response.elem = this.consumerGroupHeartbeat("grp-1", $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$2, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$6, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$7, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$8, timeoutMs, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$9, (List<String>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$5, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$10, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2_x$11);
                Object var30_18 = null;
                Object var31_19 = null;
                Object var32_11 = null;
                Object var34_13 = null;
                Object var35_14 = null;
                Object var36_15 = null;
                Object var37_16 = null;
                if (((ConsumerGroupHeartbeatResponseData)grp1Member1Response.elem).errorCode() == Errors.NONE.code()) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponseData)grp1Member1Response.elem + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ObjectRef grp2Member1Response = ObjectRef.create(null);
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (true) {
                void waitUntilTrue_pause;
                .colon.colon $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$16 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
                List $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$17 = package$.MODULE$.List().empty();
                int $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$18 = this.consumerGroupHeartbeat$default$3();
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$19 = this.consumerGroupHeartbeat$default$4();
                String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$20 = this.consumerGroupHeartbeat$default$5();
                Errors $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$21 = this.consumerGroupHeartbeat$default$10();
                short $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$22 = this.consumerGroupHeartbeat$default$11();
                grp2Member1Response.elem = this.consumerGroupHeartbeat("grp-2", "member-1", $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$18, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$19, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$20, timeoutMs, "range", (List<String>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$16, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)$anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$17, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$21, $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4_x$22);
                Object var39_24 = null;
                Object var40_25 = null;
                Object var42_27 = null;
                Object var43_28 = null;
                Object var44_29 = null;
                if (((ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem).assignment() != null && !((ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem).assignment().topicPartitions().isEmpty()) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponseData)grp2Member1Response.elem + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            .colon.colon x$27 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
            List x$28 = package$.MODULE$.List().empty();
            int x$29 = this.consumerGroupHeartbeat$default$3();
            String x$30 = this.consumerGroupHeartbeat$default$4();
            String x$31 = this.consumerGroupHeartbeat$default$5();
            Errors x$32 = this.consumerGroupHeartbeat$default$10();
            short x$33 = this.consumerGroupHeartbeat$default$11();
            ConsumerGroupHeartbeatResponseData grp2Member2Response = this.consumerGroupHeartbeat("grp-2", "member-2", x$29, x$30, x$31, timeoutMs, "range", (List<String>)x$27, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$28, x$32, x$33);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.CONSUMER_GROUP_DESCRIBE.oldestVersion()), (int)ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
                .colon.colon expected = new .colon.colon((Object)new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-1").setGroupState(ConsumerGroupState.STABLE.toString()).setGroupEpoch(1).setAssignmentEpoch(1).setAssignorName("uniform").setAuthorizedOperations(authorizedOperationsInt).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"bar", (List)Nil$.MODULE$)).asJava()).setMemberType(version == 0 ? (byte)-1 : (byte)1), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp-2").setGroupState(ConsumerGroupState.RECONCILING.toString()).setGroupEpoch(grp2Member2Response.memberEpoch()).setAssignmentEpoch(grp2Member2Response.memberEpoch()).setAssignorName("range").setAuthorizedOperations(authorizedOperationsInt).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(grp2Member2Response.memberId()).setMemberEpoch(grp2Member2Response.memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setAssignment(new ConsumerGroupDescribeResponseData.Assignment()).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava())).setMemberType(version == 0 ? (byte)-1 : (byte)1), (List)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.Member().setMemberId(((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).memberEpoch()).setClientId(clientId).setClientHost(clientHost).setSubscribedTopicRegex("").setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), (List)Nil$.MODULE$)).asJava())).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava())).setMemberType(version == 0 ? (byte)-1 : (byte)1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$));
                List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)Nil$.MODULE$)), true, (short)version);
                Assertions.assertEquals((Object)expected, actual);
                List<ConsumerGroupDescribeResponseData.DescribedGroup> unknownGroupResponse = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)"grp-unknown", (List)Nil$.MODULE$), true, (short)version);
                Assertions.assertEquals((short)Errors.GROUP_ID_NOT_FOUND.code(), (short)((ConsumerGroupDescribeResponseData.DescribedGroup)unknownGroupResponse.head()).errorCode());
                List<ConsumerGroupDescribeResponseData.DescribedGroup> emptyGroupResponse = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$), true, (short)version);
                Assertions.assertEquals((short)Errors.INVALID_GROUP_ID.code(), (short)((ConsumerGroupDescribeResponseData.DescribedGroup)emptyGroupResponse.head()).errorCode());
            });
        }
    }

    @ClusterTest
    public void testConsumerGroupDescribeWithMigrationMember() {
        this.createOffsetsTopic();
        String topicName = "foo";
        this.createTopic(topicName, 3);
        String groupId = "grp";
        String memberId1 = (String)this.joinDynamicConsumerGroupWithOldProtocol(groupId, ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList(topicName), null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava()), (short)3).array(), ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))).map((Function1 & Serializable)p -> ConsumerGroupDescribeRequestTest.$anonfun$testConsumerGroupDescribeWithMigrationMember$1(topicName, BoxesRunTime.unboxToInt((Object)p)))).asJava()), (short)3).array(), this.joinDynamicConsumerGroupWithOldProtocol$default$4())._1();
        .colon.colon x$4 = new .colon.colon((Object)topicName, (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        String memberId2 = this.consumerGroupHeartbeat(groupId, "member-2", x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.NONE, x$11).memberId();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.CONSUMER_GROUP_DESCRIBE.oldestVersion()), (int)ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)groupId, (List)Nil$.MODULE$), true, (short)version);
            Assertions.assertEquals((int)1, (int)actual.size());
            ConsumerGroupDescribeResponseData.DescribedGroup group = (ConsumerGroupDescribeResponseData.DescribedGroup)actual.head();
            Option member1 = CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupDescribeRequestTest.$anonfun$testConsumerGroupDescribeWithMigrationMember$3(memberId1, x$2)));
            Assertions.assertFalse((boolean)member1.isEmpty());
            Assertions.assertEquals((byte)(version == 0 ? (byte)-1 : (byte)0), (byte)((ConsumerGroupDescribeResponseData.Member)member1.get()).memberType());
            Option member2 = CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupDescribeRequestTest.$anonfun$testConsumerGroupDescribeWithMigrationMember$4(memberId2, x$3)));
            Assertions.assertFalse((boolean)member2.isEmpty());
            Assertions.assertEquals((byte)(version == 0 ? (byte)-1 : (byte)1), (byte)((ConsumerGroupDescribeResponseData.Member)member2.get()).memberType());
        });
        this.leaveGroup(groupId, memberId1, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
        .colon.colon x$15 = new .colon.colon((Object)topicName, (List)Nil$.MODULE$);
        List x$16 = package$.MODULE$.List().empty();
        int x$18 = this.consumerGroupHeartbeat$default$3();
        String x$19 = this.consumerGroupHeartbeat$default$4();
        String x$20 = this.consumerGroupHeartbeat$default$5();
        String x$21 = this.consumerGroupHeartbeat$default$7();
        short x$22 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, memberId1, x$18, x$19, x$20, 300000, x$21, (List<String>)x$15, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$16, Errors.NONE, x$22);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.CONSUMER_GROUP_DESCRIBE.oldestVersion()), (int)ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = this.consumerGroupDescribe((List<String>)new .colon.colon((Object)groupId, (List)Nil$.MODULE$), true, (short)version);
            Assertions.assertEquals((int)1, (int)actual.size());
            ConsumerGroupDescribeResponseData.DescribedGroup group = (ConsumerGroupDescribeResponseData.DescribedGroup)actual.head();
            Option member1 = CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupDescribeRequestTest.$anonfun$testConsumerGroupDescribeWithMigrationMember$6(memberId1, x$4)));
            Assertions.assertFalse((boolean)member1.isEmpty());
            Assertions.assertEquals((byte)(version == 0 ? (byte)-1 : (byte)1), (byte)((ConsumerGroupDescribeResponseData.Member)member1.get()).memberType());
            Option member2 = CollectionConverters$.MODULE$.ListHasAsScala(group.members()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupDescribeRequestTest.$anonfun$testConsumerGroupDescribeWithMigrationMember$7(memberId2, x$5)));
            Assertions.assertFalse((boolean)member2.isEmpty());
            Assertions.assertEquals((byte)(version == 0 ? (byte)-1 : (byte)1), (byte)((ConsumerGroupDescribeResponseData.Member)member2.get()).memberType());
        });
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$2(ConsumerGroupDescribeRequestTest $this, ObjectRef grp1Member1Response$1, int timeoutMs$1) {
        String x$2 = Uuid.randomUuid().toString();
        .colon.colon x$4 = new .colon.colon((Object)"bar", (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$6 = $this.consumerGroupHeartbeat$default$3();
        String x$7 = $this.consumerGroupHeartbeat$default$4();
        String x$8 = $this.consumerGroupHeartbeat$default$5();
        String x$9 = $this.consumerGroupHeartbeat$default$7();
        Errors x$10 = $this.consumerGroupHeartbeat$default$10();
        short x$11 = $this.consumerGroupHeartbeat$default$11();
        grp1Member1Response$1.elem = $this.consumerGroupHeartbeat("grp-1", x$2, x$6, x$7, x$8, timeoutMs$1, x$9, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, x$10, x$11);
        return ((ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem).errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$3(ObjectRef grp1Member1Response$1) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponseData)grp1Member1Response$1.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$4(ConsumerGroupDescribeRequestTest $this, ObjectRef grp2Member1Response$1, int timeoutMs$1) {
        .colon.colon x$16 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$17 = package$.MODULE$.List().empty();
        int x$18 = $this.consumerGroupHeartbeat$default$3();
        String x$19 = $this.consumerGroupHeartbeat$default$4();
        String x$20 = $this.consumerGroupHeartbeat$default$5();
        Errors x$21 = $this.consumerGroupHeartbeat$default$10();
        short x$22 = $this.consumerGroupHeartbeat$default$11();
        grp2Member1Response$1.elem = $this.consumerGroupHeartbeat("grp-2", "member-1", x$18, x$19, x$20, timeoutMs$1, "range", (List<String>)x$16, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$17, x$21, x$22);
        return ((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).assignment() != null && !((ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem).assignment().topicPartitions().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupDescribeWithNewGroupCoordinator$5(ObjectRef grp2Member1Response$1) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponseData)grp2Member1Response$1.elem + ".";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testConsumerGroupDescribeWithMigrationMember$1(String topicName$1, int p) {
        return new TopicPartition(topicName$1, p);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithMigrationMember$3(String memberId1$1, ConsumerGroupDescribeResponseData.Member x$2) {
        String string = x$2.memberId();
        return !(string != null ? !string.equals(memberId1$1) : memberId1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithMigrationMember$4(String memberId2$1, ConsumerGroupDescribeResponseData.Member x$3) {
        String string = x$3.memberId();
        return !(string != null ? !string.equals(memberId2$1) : memberId2$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithMigrationMember$6(String memberId1$1, ConsumerGroupDescribeResponseData.Member x$4) {
        String string = x$4.memberId();
        return !(string != null ? !string.equals(memberId1$1) : memberId1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupDescribeWithMigrationMember$7(String memberId2$1, ConsumerGroupDescribeResponseData.Member x$5) {
        String string = x$5.memberId();
        return !(string != null ? !string.equals(memberId2$1) : memberId2$1 != null);
    }

    public ConsumerGroupDescribeRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

