/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001A\u0002\u0013E\u0001\bC\u0004F\u0001\u0001\u0007I\u0011\u0003$\t\r=\u0003\u0001\u0015)\u0003:\u0011\u0015\u0001\u0006\u0001\"\u00159\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u001d!\bA1A\u0005\nUDa\u0001 \u0001!\u0002\u00131\bbB?\u0001\u0005\u0004%I!\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0005\u0001A\u0003%\u00111\u0001\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0006\u0001A\u0003%\u00111\u0001\u0005\n\u00033\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0007\u0001A\u0003%\u00111\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tI\u0003\u0001C\u0001\u0003?Aq!!\f\u0001\t\u0003\ty\u0002C\u0004\u00022\u0001!\t!a\b\t\u000f\u0005U\u0002\u0001\"\u0001\u0002 !9\u0011\u0011\b\u0001\u0005\u0002\u0005}\u0001bBA\u001f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003\u0003\u0002A\u0011AA\u0010\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\"\u0001\t\u0013\t9\tC\u0005\u00022\u0002\t\n\u0011\"\u0003\u00024\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007\"CAo\u0001E\u0005I\u0011BAZ\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDqAa\n\u0001\t\u0013\u0011I\u0003C\u0004\u0003.\u0001!IAa\f\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!1\b\u0001\u0005\n\tu\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u00057\u0002A\u0011\u0002B/\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005K\u0012A%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AK\u0005\u0003g)\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\tYcH\u0003\u0002.\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5HA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003]!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u001dq5!!AA\u0002e\n1\u0001\u001f\u00132\u0003Q!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003tKR,\u0006\u000f\u0006\u0002H'\")AK\u0002a\u0001+\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0006\u000bQA[;oSRL!AX,\u0003\u0011Q+7\u000f^%oM>D#A\u00021\u0011\u0005Y\u000b\u0017B\u00012X\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR\u0011Qm\u001d\t\u0004M&\\W\"A4\u000b\u0005!L\u0015AC2pY2,7\r^5p]&\u0011!n\u001a\u0002\u0004'\u0016\f\bC\u00017r\u001b\u0005i'B\u00018p\u0003\u0011)H/\u001b7\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002+\b\u0001\u0004)\u0016aE:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001cX#\u0001<\u0011\u0007!;\u00180\u0003\u0002y\u0013\n)\u0011I\u001d:bsB\u0011\u0001J_\u0005\u0003w&\u0013AAQ=uK\u0006!2/\u00197uK\u0012\u0004\u0016m]:x_J$')\u001f;fg\u0002\n\u0011b]1mi\nKH/Z:\u0002\u0015M\fG\u000e\u001e\"zi\u0016\u001c\b%A\u0003vg\u0016\u0014\u0018'\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n=\fA\u0001\\1oO&!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013!B;tKJ\u001c\u0014AB;tKJ\u001c\u0004%A\u0006v].twn\u001e8Vg\u0016\u0014\u0018\u0001D;oW:|wO\\+tKJ\u0004\u0013\u0001\u0005;fgR\fE\u000e^3s\u001d>$\b.\u001b8h)\u00059\u0005f\u0001\u000b\u0002$A\u0019a+!\n\n\u0007\u0005\u001drK\u0001\u0003UKN$\u0018a\u0006;fgR\fE\u000e^3s'\u0006lW\r\u00165j]\u001e$v/[2fQ\r)\u00121E\u0001\u0013i\u0016\u001cH/\u00117uKJ,U\u000e\u001d;z+N,'\u000fK\u0002\u0017\u0003G\t\u0011\u0004^3ti\u0006cG/\u001a:V].twn\u001e8NK\u000eD\u0017M\\5t[\"\u001aq#a\t\u00023Q,7\u000f^!mi\u0016\u0014Hk\\8GK^LE/\u001a:bi&|gn\u001d\u0015\u00041\u0005\r\u0012A\u0007;fgR\fE\u000e^3s)>|W*\u00198z\u0013R,'/\u0019;j_:\u001c\bfA\r\u0002$\u0005\u0019C/Z:u\t\u0016dW\r^3T_6,G\u000f[5oORC\u0017\r\u001e#pKNtu\u000e^#ySN$\bf\u0001\u000e\u0002$\u0005!B/Z:u\u00032$XM]!oI\u0012+7o\u0019:jE\u0016D3aGA\u0012\u0003e!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o)>|Gj\\<\u0015\u0007\u001d\u000bI\u0005C\u0004\u0002Lq\u0001\r!!\u0014\u0002\rE,xN];n!\u0011\ty%!\u0018\u000f\t\u0005E\u0013\u0011\f\t\u0004\u0003'JUBAA+\u0015\r\t9FL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u0013*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyFC\u0002\u0002\\%C3\u0001HA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA53\u00061\u0001/\u0019:b[NLA!!\u001c\u0002h\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000fq\t\t(! \u0002\u0000A!\u00111OA=\u001b\t\t)H\u0003\u0003\u0002x\u0005\u001d\u0014\u0001\u00039s_ZLG-\u001a:\n\t\u0005m\u0014Q\u000f\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005\u0005\u0005\u0015EAAB\u00035Y'/\u00194u[%\u0013\u0005kX\u001a`i\u0005!3/\u001a8e\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\n\u0006]\u0015\u0011\u0015\t\u0005\u0003\u0017\u000b\u0019*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003!\u0011X-];fgR\u001c(B\u0001\u001f?\u0013\u0011\t)*!$\u0003C\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3\t\u000f\u0005eU\u00041\u0001\u0002\u001c\u00069!/Z9vKN$\b\u0003BAF\u0003;KA!a(\u0002\u000e\n\u0001\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\u0011%\t\u0019+\bI\u0001\u0002\u0004\t)+\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tY\u000bL\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ty+!+\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002]M,g\u000eZ!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003kSC!!*\u00028.\u0012\u0011\u0011\u0018\t\u0005\u0003w\u000b)-\u0004\u0002\u0002>*!\u0011qXAa\u0003%)hn\u00195fG.,GMC\u0002\u0002D&\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9-!0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0014tK:$G)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$HCBAg\u0003'\fY\u000e\u0005\u0003\u0002\f\u0006=\u0017\u0002BAi\u0003\u001b\u0013A\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a\u0005\b\u00033{\u0002\u0019AAk!\u0011\tY)a6\n\t\u0005e\u0017Q\u0012\u0002$\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\u0011%\t\u0019k\bI\u0001\u0002\u0004\t)+A\u0019tK:$G)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0002C\rDWmY6BY2,%O]8sg\u0006cG/\u001a:j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u000f\u001d\u000b\u0019Oa\u0005\u0003$!9\u0011Q]\u0011A\u0002\u0005\u001d\u0018A\u0004:fgVdGo\u001d+p\u0007\",7m\u001b\t\u0006Y\u0006%\u0018Q^\u0005\u0004\u0003Wl'\u0001\u0002'jgR\u0004B!a<\u0003\u000e9!\u0011\u0011\u001fB\u0004\u001d\u0011\t\u0019Pa\u0001\u000f\t\u0005U(\u0011\u0001\b\u0005\u0003o\fyP\u0004\u0003\u0002z\u0006uh\u0002BA*\u0003wL\u0011AQ\u0005\u0003\u0001\u0006K!!L \n\u0005qr\u0014\u0002\u0002B\u0003\u0003#\u000bq!\\3tg\u0006<W-\u0003\u0003\u0003\n\t-\u0011!J!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\u0011\u0011)!!%\n\t\t=!\u0011\u0003\u0002 \u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3tk2$(\u0002\u0002B\u0005\u0005\u0017AqA!\u0006\"\u0001\u0004\u00119\"A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)!!QDAI\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u0011\u00057\u0011a!\u0012:s_J\u001c\bb\u0002B\u0013C\u0001\u0007\u0011QJ\u0001\u000bG>tG/\u001a=u\u001bN<\u0017\u0001I2iK\u000e\\gj\\#se>\u00148/\u00117uKJLgnZ\"sK\u0012,g\u000e^5bYN$2a\u0012B\u0016\u0011\u001d\t)O\ta\u0001\u0003O\fad\u00195fG.,6/\u001a:BaB,\u0017M]:J]\u0006cG/\u001a:SKN,H\u000e^:\u0015\u000b\u001d\u0013\tDa\r\t\u000f\u0005\u00158\u00051\u0001\u0002h\"9!QG\u0012A\u0002\u00055\u0013\u0001B;tKJ\fq\u0005Z3tGJL'-Z!mY^KG\u000f\u001b(p)>\u0004H*\u001a<fY\u0016\u0013(o\u001c:D_:4\u0017N]7fIR\u0011\u0011QZ\u0001*G\",7m\u001b(p)>\u0004H*\u001a<fY\u0016\u0013(o\u001c:EKN\u001c'/\u001b2j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007\u001d\u0013y\u0004C\u0004\u0003B\u0015\u0002\r!!4\u0002\u001fI,7\u000f]8og\u0016$vn\u00115fG.\f!d\u00195fG.,6/\u001a:ICN$vo\\\"sK\u0012,g\u000e^5bYN$Ra\u0012B$\u00053Bq!!:'\u0001\u0004\u0011I\u0005E\u0003m\u0003S\u0014Y\u0005\u0005\u0003\u0003N\tMc\u0002BAy\u0005\u001fJAA!\u0015\u0003\f\u0005AC)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rR1uC&!!Q\u000bB,\u0005\t\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi*!!\u0011\u000bB\u0006\u0011\u001d\u0011)D\na\u0001\u0003\u001b\nAf\u00195fG.4uN]*j]\u001edWm\u00155bkE\u0012\u0014\n^3sCRLwN\\:9ce\u00124I]3eK:$\u0018.\u00197\u0015\u000b\u001d\u0013yF!\u0019\t\u000f\u0005\u0015x\u00051\u0001\u0003J!9!QG\u0014A\u0002\u00055\u0013!F2iK\u000e\\G)Z:de&\u0014WMR8s\u000bJ\u0014xN\u001d\u000b\b\u000f\n\u001d$\u0011\u000eB6\u0011\u001d\t)\u000f\u000ba\u0001\u0005\u0013BqA!\u000e)\u0001\u0004\ti\u0005C\u0004\u0003\u0016!\u0002\rAa\u0006")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latestTesting();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
            this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
        }
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Properties)controllerConfigs.head()).setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Properties)controllerConfigs.head()).setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        return controllerConfigs;
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @Test
    public void testAlterNothing() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testAlterSameThingTwice() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion1)).setUpsertions(Arrays.asList(upsertion2, upsertion2))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion2)).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterEmptyUser() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty)).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty, deletionEmpty)).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterUnknownMechanism() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionUnknown1, deletionValid1, deletionUnknown2)).setUpsertions(Arrays.asList(upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        CollectionConverters$.MODULE$.ListHasAsScala(results).asScala().foreach((Function1 & Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterTooFewIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testAlterTooManyIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testDeleteSomethingThatDoesNotExist() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterAndDescribe() {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        Assertions.assertEquals((Object)("AlterUserScramCredentialsRequestData(deletions=[ScramCredentialDeletion(name='" + this.user2() + "', mechanism=" + ScramMechanism.SCRAM_SHA_256.type() + ")], upsertions=[ScramCredentialUpsertion(name='" + this.user1() + "', mechanism=" + ScramMechanism.SCRAM_SHA_256.type() + ", iterations=4096, salt=[], saltedPassword=[])])"), (Object)request1_0.toString());
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results1_0.size());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.ListHasAsScala(results1_0).asScala().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(x$1))));
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        this.checkUserAppearsInAlterResults(results1_0, this.user2());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        Assertions.assertFalse((boolean)Predef$.MODULE$.wrapString(request1_1.toString()).contains((Object)this.saltBytes()));
        Assertions.assertFalse((boolean)Predef$.MODULE$.wrapString(request1_1.toString()).contains((Object)this.saltedPasswordBytes()));
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see 3 users");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see only 2 users");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$6(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see empty user");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionMetadataVersionTooLow))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IBP version");
        Assertions.assertEquals((Object)"The current metadata.version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$2)))).size(), (String)("Expected all '" + expectedError.name() + "' errors when altering credentials " + contextMsg));
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$3)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$4))), (String)("Expected result to contain '" + user + "'"));
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)("Expected result to contain '" + user + "' with 2 credentials: " + resultsToCheck));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)("Expected result to contain '" + user + "' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: " + resultsToCheck));
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)("Expected result to contain '" + user + "' with 1 credential: " + resultsToCheck));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)("Expected result to contain '" + user + "' with SCRAM_SHA_512/8192 credential: " + resultsToCheck));
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)("Expected result to contain '" + user + "' with a " + expectedError.name() + " error: " + resultsToCheck));
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == Errors.RESOURCE_NOT_FOUND.code();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$2(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$3() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$4(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$5() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$6(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$7() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        return x$3.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$4) {
        String string = x$4.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

