/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004Z\u0001\u0001\u0006Ia\u0013\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019\u0011\u0007\u0001)A\u00059\"91\r\u0001b\u0001\n\u0013!\u0007B\u00027\u0001A\u0003%Q\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\r]\u0004\u0001\u0015!\u0003p\u0011\u001dA\bA1A\u0005\n9Da!\u001f\u0001!\u0002\u0013y\u0007\"\u0002>\u0001\t\u0003Y\bBBA\u000b\u0001\u0011\u00051\u0010\u0003\u0004\u0002 \u0001!\ta\u001f\u0005\u0007\u0003S\u0001A\u0011A>\t\u000f\u0005}\u0001\u0001\"\u0001\u0002.\u00191\u0011q\b\u0001\u0005\u0003\u0003B\u0011BO\t\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005u\u0013C!A!\u0002\u0013\ty\u0006\u0003\u0004F#\u0011\u0005\u0011Q\r\u0005\n\u0003_\n\"\u0019!C\u0001\u0003cB\u0001B!\u000f\u0012A\u0003%\u00111\u000f\u0005\u0007\u0005w\tB\u0011I>\u0007\r\tu\u0002\u0001\u0002B \u0011%Q\u0004D!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002^a\u0011\t\u0011)A\u0005\u0003WCa!\u0012\r\u0005\u0002\t\u0005\u0003B\u0002B\u001e1\u0011\u00053\u0010C\u0004\u0003J\u0001!IAa\u0013\t\u0013\t]\u0003!%A\u0005\n\te\u0003b\u0002B/\u0001\u0011%!q\f\u0004\u0007\u0003\u000b\u0003A)a\"\t\u0015\u0005\u001d\u0006E!f\u0001\n\u0003\tI\u000b\u0003\u0006\u00022\u0002\u0012\t\u0012)A\u0005\u0003WC!\"a-!\u0005+\u0007I\u0011AA[\u0011)\t9\f\tB\tB\u0003%\u0011q\f\u0005\u0007\u000b\u0002\"\t!!/\t\u000f\u0005}\u0006\u0005\"\u0011\u0002B\"I\u00111\u001b\u0011\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u00037\u0004\u0013\u0013!C\u0001\u0003;D\u0011\"a=!#\u0003%\t!!>\t\u0013\u0005e\b%!A\u0005B\u0005m\b\"\u0003B\u0001A\u0005\u0005I\u0011AA[\u0011%\u0011\u0019\u0001IA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u0012\u0001\n\t\u0011\"\u0011\u0003\u0014!I!Q\u0004\u0011\u0002\u0002\u0013\u0005!q\u0004\u0005\n\u0005S\u0001\u0013\u0011!C!\u0005WA\u0011Ba\f!\u0003\u0003%\tE!\r\t\u0013\tM\u0002%!A\u0005B\tUr!\u0003B6\u0001\u0005\u0005\t\u0012\u0002B7\r%\t)\tAA\u0001\u0012\u0013\u0011y\u0007\u0003\u0004Fg\u0011\u0005!\u0011\u0011\u0005\n\u0003\u007f\u001b\u0014\u0011!C#\u0005\u0007C\u0011B!\"4\u0003\u0003%\tIa\"\t\u0013\t55'!A\u0005\u0002\n=%A\u0005'pO\u000e{gnY;se\u0016t7-\u001f+fgRT!AO\u001e\u0002\u00071|wMC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0011(\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t1\n\u0005\u0002M/6\tQJ\u0003\u0002O\u001f\u00069Q.\u001a;sS\u000e\u001c(B\u0001\u001eQ\u0015\t\t&+A\u0004ti>\u0014\u0018mZ3\u000b\u0005q\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W'\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051!/\u00198e_6,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0006\u000bA!\u001e;jY&\u0011\u0011M\u0018\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I1o\u00195fIVdWM]\u000b\u0002KB\u0011aM[\u0007\u0002O*\u0011q\f\u001b\u0006\u0003SJ\u000baa]3sm\u0016\u0014\u0018BA6h\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0019!X\u000e\u001d#jeV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006\u0011\u0011n\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005)1/\u001a;vaR\tA\u0010\u0005\u0002A{&\u0011a0\u0011\u0002\u0005+:LG\u000fK\u0002\r\u0003\u0003\u0001B!a\u0001\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0002ba&TA!a\u0003\u0002\u000e\u00059!.\u001e9ji\u0016\u0014(bAA\b+\u0006)!.\u001e8ji&!\u00111CA\u0003\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\tg\",H\u000fZ8x]\"\u001aQ\"!\u0007\u0011\t\u0005\r\u00111D\u0005\u0005\u0003;\t)AA\u0005BMR,'/R1dQ\u0006qB/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a\u0015\u0004\u001d\u0005\r\u0002\u0003BA\u0002\u0003KIA!a\n\u0002\u0006\t!A+Z:u\u0003I\"Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,GM\u0012:fcV,g\u000e^*fO6,g\u000e\u001e*pY2\u001c\bfA\b\u0002$Q\u0019A0a\f\t\ri\u0002\u0002\u0019AA\u0019!\u0011\t\u0019$a\u000f\u000e\u0005\u0005U\"b\u0001\u001e\u00028)\u0019\u0011\u0011\b)\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BA\u001f\u0003k\u0011!\"\u00168jM&,G\rT8h\u00051\u0019uN\\:v[\u0016\u0014H+Y:l'\u0015\t\u00121IA(!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%g\u0006!A.\u00198h\u0013\u0011\ti%a\u0012\u0003\r=\u0013'.Z2u!\u0015\t\t&!\u0017}\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013AC2p]\u000e,(O]3oi*\u0011ql]\u0005\u0005\u00037\n\u0019F\u0001\u0005DC2d\u0017M\u00197f\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\t\u0004\u0001\u0006\u0005\u0014bAA2\u0003\n\u0019\u0011J\u001c;\u0015\r\u0005\u001d\u00141NA7!\r\tI'E\u0007\u0002\u0001!1!\b\u0006a\u0001\u0003cAq!!\u0018\u0015\u0001\u0004\ty&A\bd_:\u001cX/\\3e\u0005\u0006$8\r[3t+\t\t\u0019\b\u0005\u0004\u0002v\u0005}\u00141Q\u0007\u0003\u0003oRA!!\u001f\u0002|\u00059Q.\u001e;bE2,'bAA?\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bcAA5A\taa)\u001a;dQ\u0016$')\u0019;dQN1\u0001ePAE\u0003\u001f\u00032\u0001QAF\u0013\r\ti)\u0011\u0002\b!J|G-^2u!\u0011\t\t*!)\u000f\t\u0005M\u0015Q\u0014\b\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015bAAP\u0003\u00069\u0001/Y2lC\u001e,\u0017\u0002BAR\u0003K\u0013AbU3sS\u0006d\u0017N_1cY\u0016T1!a(B\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0003\u0003W\u00032\u0001QAW\u0013\r\ty+\u0011\u0002\u0005\u0019>tw-A\u0006cCN,wJ\u001a4tKR\u0004\u0013!B3q_\u000eDWCAA0\u0003\u0019)\u0007o\\2iAQ1\u00111QA^\u0003{Cq!a*&\u0001\u0004\tY\u000bC\u0004\u00024\u0016\u0002\r!a\u0018\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a1\u0011\t\u0005\u0015\u0017Q\u001a\b\u0005\u0003\u000f\fI\rE\u0002\u0002\u0016\u0006K1!a3B\u0003\u0019\u0001&/\u001a3fM&!\u0011qZAi\u0005\u0019\u0019FO]5oO*\u0019\u00111Z!\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0007\u000b9.!7\t\u0013\u0005\u001dv\u0005%AA\u0002\u0005-\u0006\"CAZOA\u0005\t\u0019AA0\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a8+\t\u0005-\u0016\u0011]\u0016\u0003\u0003G\u0004B!!:\u0002p6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/A\u0005v]\u000eDWmY6fI*\u0019\u0011Q^!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0006\u001d(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA|U\u0011\ty&!9\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0010\u0005\u0003\u0002F\u0005}\u0018\u0002BAh\u0003\u000f\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\b\t5\u0001c\u0001!\u0003\n%\u0019!1B!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u00101\n\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0006\u0011\r\t]!\u0011\u0004B\u0004\u001b\t\tY(\u0003\u0003\u0003\u001c\u0005m$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\t\u0003(A\u0019\u0001Ia\t\n\u0007\t\u0015\u0012IA\u0004C_>dW-\u00198\t\u0013\t=a&!AA\u0002\t\u001d\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!@\u0003.!I!qB\u0018\u0002\u0002\u0003\u0007\u0011qL\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u0005\"q\u0007\u0005\n\u0005\u001f\t\u0014\u0011!a\u0001\u0005\u000f\t\u0001cY8ogVlW\r\u001a\"bi\u000eDWm\u001d\u0011\u0002\t\r\fG\u000e\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012$\u0016m]6\u0014\u000ba\t\u0019%a\u0014\u0015\r\t\r#Q\tB$!\r\tI\u0007\u0007\u0005\u0007um\u0001\r!!\r\t\u000f\u0005u3\u00041\u0001\u0002,\u0006I1M]3bi\u0016dun\u001a\u000b\u0005\u0003c\u0011i\u0005C\u0005\u0003Pu\u0001\n\u00111\u0001\u0003R\u000511m\u001c8gS\u001e\u0004B!a\r\u0003T%!!QKA\u001b\u0005%aunZ\"p]\u001aLw-A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\\)\"!\u0011KAq\u0003Q1\u0018\r\\5eCR,7i\u001c8tk6,G\rR1uCR)AP!\u0019\u0003d!1!h\ba\u0001\u0003cAq!a\u001c \u0001\u0004\u0011)\u0007\u0005\u0004\u0002\u0012\n\u001d\u00141Q\u0005\u0005\u0005S\n)K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u000311U\r^2iK\u0012\u0014\u0015\r^2i!\r\tIgM\n\u0006g\tE$Q\u0010\t\u000b\u0005g\u0012I(a+\u0002`\u0005\rUB\u0001B;\u0015\r\u00119(Q\u0001\beVtG/[7f\u0013\u0011\u0011YH!\u001e\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007E\u0002q\u0005\u007fJ1!a)r)\t\u0011i\u0007\u0006\u0002\u0002~\u0006)\u0011\r\u001d9msR1\u00111\u0011BE\u0005\u0017Cq!a*7\u0001\u0004\tY\u000bC\u0004\u00024Z\u0002\r!a\u0018\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0013BO!\u0015\u0001%1\u0013BL\u0013\r\u0011)*\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0001\u0013I*a+\u0002`%\u0019!1T!\u0003\rQ+\b\u000f\\33\u0011%\u0011yjNA\u0001\u0002\u0004\t\u0019)A\u0002yIA\u0002")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps);
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(UnifiedLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private UnifiedLog createLog(LogConfig config) {
        return UnifiedLog.create((File)this.logDir(), (LogConfig)config, (long)0L, (long)0L, (Scheduler)this.scheduler(), (BrokerTopicStats)this.brokerTopicStats(), (Time)Time.SYSTEM, (int)300000, (ProducerStateManagerConfig)new ProducerStateManagerConfig(86400000, false), (int)600000, (LogDirFailureChannel)new LogDirFailureChannel(10), (boolean)true, Optional.empty());
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties());
    }

    private void validateConsumedData(UnifiedLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().forEach(segment -> segment.log().batches().forEach(batch -> {
            if (iter.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError("Consumed batch " + consumedBatch + " does not match next expected batch in log " + batch, t);
                }
            }
        }));
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.read((long)fetchOffset.elem, (int)1, (FetchIsolation)FetchIsolation.HIGH_WATERMARK, (boolean)true).records.batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, UnifiedLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return "FetchedBatch(baseOffset=" + this.baseOffset() + ", epoch=" + this.epoch() + ")";
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer())) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (this.baseOffset() != fetchedBatch.baseOffset() || this.epoch() != fetchedBatch.epoch() || !fetchedBatch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset;
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch);
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = 2;
                        NoCompression x$5 = Compression.NONE;
                        long x$6 = -1L;
                        short x$7 = -1;
                        int x$8 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, (Compression)x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch), Integer.MAX_VALUE);
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, UnifiedLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

