/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.TreeMap;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.server.common.TransactionVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r4Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003BB\u0014\u0001A\u0003%A\u0005C\u0004)\u0001\t\u0007I\u0011A\u0015\t\r5\u0002\u0001\u0015!\u0003+\u0011\u001dq\u0003A1A\u0005\u0002=BaA\u0012\u0001!\u0002\u0013\u0001\u0004\"B$\u0001\t\u0003A\u0005\"B,\u0001\t\u0003A\u0005\"B-\u0001\t\u0003A\u0005\"B.\u0001\t\u0003A\u0005\"B/\u0001\t\u0003A\u0005\"B0\u0001\t\u0003A\u0005\"B1\u0001\t\u0003A%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!!\u0005\n\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003'Q\t1bY8pe\u0012Lg.\u0019;pe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002!\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012\u0001\n\t\u00033\u0015J!A\n\u000e\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012A\u000b\t\u00033-J!\u0001\f\u000e\u0003\u0007%sG/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012\u0001\r\t\u0004caZdB\u0001\u001a7!\t\u0019$$D\u00015\u0015\t)d#\u0001\u0004=e>|GOP\u0005\u0003oi\ta\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\r\u0019V\r\u001e\u0006\u0003oi\u0001\"\u0001\u0010#\u000e\u0003uR!AP \u0002\r\r|W.\\8o\u0015\t)\u0002I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#>\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\t\u0011\n\u0005\u0002\u001a\u0015&\u00111J\u0007\u0002\u0005+:LG\u000f\u000b\u0002\t\u001bB\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004CBL'B\u0001*T\u0003\u001dQW\u000f]5uKJT!\u0001\u0016\"\u0002\u000b),h.\u001b;\n\u0005Y{%\u0001\u0002+fgR\fqc\u001d5pk2$'+Z1e/JLG/Z'fgN\fw-Z:)\u0005%i\u0015a\u000f;fgR\u001cVM]5bY&TX\r\u0016:b]N\f7\r^5p]2{wMV1mk\u0016$v\u000eS5hQ\u0016\u001cHOT8o\r2,\u00070\u001b2mKZ+'o]5p]\"\u0012!\"T\u00012i\u0016\u001cHoU3sS\u0006d\u0017N_3Ue\u0006t7/Y2uS>tGj\\4WC2,X\rV8GY\u0016D\u0018N\u00197f-\u0016\u00148/[8oQ\tYQ*\u0001\u001auKN$H)Z:fe&\fG.\u001b>f\u0011&<\u0007.Z:u'V\u0004\bo\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8M_\u001e4\u0016\r\\;fQ\taQ*\u0001\u0015uKN$H)Z:fe&\fG.\u001b>f\rV$XO]3Ue\u0006t7/Y2uS>tGj\\4WC2,X\r\u000b\u0002\u000e\u001b\u0006IC/Z:u%\u0016\fG\r\u0016=o%\u0016\u001cwN\u001d3LKf\u001c\u0015M\u001c*fC\u0012,fn\u001b8po:lUm]:bO\u0016D#AD'")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final scala.collection.immutable.Set<TopicPartition> topicPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = new TransactionMetadata(transactionalId, producerId, -1L, -1L, this.producerEpoch(), -1, this.transactionTimeoutMs(), TransactionState.EMPTY, (Set)Set$.MODULE$.empty(), 0L, 0L, TransactionVersion.TV_0);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions.assertThrows(IllegalStateException.class, () -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit(), TransactionVersion.TV_2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReadWriteMessages() {
        void withRecords_records;
        void withRecords_compression;
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)TransactionState.EMPTY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)TransactionState.ONGOING), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)TransactionState.PREPARE_COMMIT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)TransactionState.COMPLETE_COMMIT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)TransactionState.PREPARE_ABORT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)TransactionState.COMPLETE_ABORT)}));
        Seq txnRecords = ((IterableOnceOps)pidMappings.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long producerId;
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = new TransactionMetadata(transactionalId, producerId = x0$1._2$mcJ$sp(), -1L, -1L, this.producerEpoch(), -1, this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), (Set)Set$.MODULE$.empty(), 0L, 0L, TransactionVersion.TV_0);
                if (!txnMetadata.state().equals((Object)TransactionState.EMPTY)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
                byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
                byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit(), TransactionVersion.TV_2);
                return new SimpleRecord(keyBytes, valueBytes);
            }
            throw new MatchError(null);
        })).toSeq();
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var10_7 = null;
        noCompression = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        IntRef count = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)pidMappings.size(), (int)count.elem);
    }

    @Test
    public void testSerializeTransactionLogValueToHighestNonFlexibleVersion() {
        TxnTransitMetadata txnTransitMetadata = new TxnTransitMetadata(1L, 1L, 1L, 1, 1, 1000, TransactionState.COMPLETE_COMMIT, Collections.emptySet(), 500L, 500L, TransactionVersion.TV_0);
        ByteBuffer txnLogValueBuffer = ByteBuffer.wrap(TransactionLog$.MODULE$.valueToBytes(txnTransitMetadata, TransactionVersion.TV_0));
        Assertions.assertEquals((int)0, (int)txnLogValueBuffer.getShort());
    }

    @Test
    public void testSerializeTransactionLogValueToFlexibleVersion() {
        TxnTransitMetadata txnTransitMetadata = new TxnTransitMetadata(1L, 1L, 1L, 1, 1, 1000, TransactionState.COMPLETE_COMMIT, Collections.emptySet(), 500L, 500L, TransactionVersion.TV_2);
        ByteBuffer txnLogValueBuffer = ByteBuffer.wrap(TransactionLog$.MODULE$.valueToBytes(txnTransitMetadata, TransactionVersion.TV_2));
        Assertions.assertEquals((short)1, (short)txnLogValueBuffer.getShort());
    }

    @Test
    public void testDeserializeHighestSupportedTransactionLogValue() {
        TransactionLogValue.PartitionsSchema txnPartitions = new TransactionLogValue.PartitionsSchema().setTopic("topic").setPartitionIds(Collections.singletonList(Predef$.MODULE$.int2Integer(0)));
        TransactionLogValue txnLogValue = new TransactionLogValue().setProducerId(100L).setProducerEpoch((short)50).setTransactionStatus(TransactionState.COMPLETE_COMMIT.id()).setTransactionStartTimestampMs(750L).setTransactionLastUpdateTimestampMs(1000L).setTransactionTimeoutMs(500).setTransactionPartitions(Collections.singletonList(txnPartitions));
        ByteBuffer serialized = MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)txnLogValue);
        TransactionMetadata deserialized = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue("transactionId", serialized).get();
        Assertions.assertEquals((long)100L, (long)deserialized.producerId());
        Assertions.assertEquals((int)50, (int)deserialized.producerEpoch());
        Assertions.assertEquals((Object)TransactionState.COMPLETE_COMMIT, (Object)deserialized.state());
        Assertions.assertEquals((long)750L, (long)deserialized.txnStartTimestamp());
        Assertions.assertEquals((long)1000L, (long)deserialized.txnLastUpdateTimestamp());
        Assertions.assertEquals((int)500, (int)deserialized.txnTimeoutMs());
        Set actualTxnPartitions = deserialized.topicPartitions();
        Assertions.assertEquals((int)1, (int)actualTxnPartitions.size());
        Assertions.assertTrue((boolean)actualTxnPartitions.contains((Object)new TopicPartition("topic", 0)));
    }

    @Test
    public void testDeserializeFutureTransactionLogValue() {
        Schema futurePartitionsSchema = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, ""), new Field("partition_ids", (Type)new CompactArrayOf((Type)Type.INT32), ""), Field.TaggedFieldsSection.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)100), new Field("partition_foo", (Type)Type.STRING, ""), BoxesRunTime.boxToInteger((int)101), new Field("partition_foo", (Type)Type.INT32, "")})});
        Struct txnPartitions = new Struct(futurePartitionsSchema);
        txnPartitions.set("topic", (Object)"topic");
        txnPartitions.set("partition_ids", (Object)new Integer[]{1});
        TreeMap<Integer, Object> txnPartitionsTaggedFields = new TreeMap<Integer, Object>();
        txnPartitionsTaggedFields.put(Predef$.MODULE$.int2Integer(100), "foo");
        txnPartitionsTaggedFields.put(Predef$.MODULE$.int2Integer(101), BoxesRunTime.boxToInteger((int)4000));
        txnPartitions.set("_tagged_fields", txnPartitionsTaggedFields);
        Schema futureTransactionLogValueSchema = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, ""), new Field("producer_epoch", (Type)Type.INT16, ""), new Field("transaction_timeout_ms", (Type)Type.INT32, ""), new Field("transaction_status", (Type)Type.INT8, ""), new Field("transaction_partitions", (Type)CompactArrayOf.nullable((Type)futurePartitionsSchema), ""), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, ""), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)100), new Field("txn_foo", (Type)Type.STRING, ""), BoxesRunTime.boxToInteger((int)101), new Field("txn_bar", (Type)Type.INT32, "")})});
        Struct transactionLogValue = new Struct(futureTransactionLogValueSchema);
        transactionLogValue.set("producer_id", (Object)BoxesRunTime.boxToLong((long)1000L));
        transactionLogValue.set("producer_epoch", (Object)BoxesRunTime.boxToShort((short)((short)100)));
        transactionLogValue.set("transaction_timeout_ms", (Object)BoxesRunTime.boxToInteger((int)1000));
        transactionLogValue.set("transaction_status", (Object)BoxesRunTime.boxToByte((byte)TransactionState.COMPLETE_COMMIT.id()));
        transactionLogValue.set("transaction_partitions", (Object)new Struct[]{txnPartitions});
        transactionLogValue.set("transaction_last_update_timestamp_ms", (Object)BoxesRunTime.boxToLong((long)2000L));
        transactionLogValue.set("transaction_start_timestamp_ms", (Object)BoxesRunTime.boxToLong((long)3000L));
        TreeMap<Integer, Object> txnLogValueTaggedFields = new TreeMap<Integer, Object>();
        txnLogValueTaggedFields.put(Predef$.MODULE$.int2Integer(100), "foo");
        txnLogValueTaggedFields.put(Predef$.MODULE$.int2Integer(101), BoxesRunTime.boxToInteger((int)4000));
        transactionLogValue.set("_tagged_fields", txnLogValueTaggedFields);
        ByteBuffer buffer = ByteBuffer.allocate(transactionLogValue.sizeOf() + 2);
        buffer.put((byte)0);
        buffer.put((byte)1);
        transactionLogValue.writeTo(buffer);
        buffer.flip();
        buffer.getShort();
        TransactionLogValue value = new TransactionLogValue((Readable)new ByteBufferAccessor(buffer), (short)1);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(value.unknownTaggedFields()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.tag())));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TransactionLogValue.PartitionsSchema)value.transactionPartitions().get(0)).unknownTaggedFields()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.tag())));
        buffer.rewind();
        TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue("transaction-id", buffer).get();
        Assertions.assertEquals((long)1000L, (long)txnMetadata.producerId());
        Assertions.assertEquals((int)100, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1000L, (long)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)TransactionState.COMPLETE_COMMIT, (Object)txnMetadata.state());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 1)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)2000L, (long)txnMetadata.txnLastUpdateTimestamp());
        Assertions.assertEquals((long)3000L, (long)txnMetadata.txnStartTimestamp());
    }

    @Test
    public void testReadTxnRecordKeyCanReadUnknownMessage() {
        TransactionLogKey record = new TransactionLogKey();
        byte[] unknownRecord = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)record);
        Either either = TransactionLog$.MODULE$.readTxnRecordKey(ByteBuffer.wrap(unknownRecord));
        if (either instanceof Left) {
            short version = BoxesRunTime.unboxToShort((Object)((Left)either).value());
            Assertions.assertEquals((short)Short.MAX_VALUE, (short)version);
            return;
        }
        if (either instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected to read unknown message");
            return;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        Either either = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)("Unexpected record version: " + BoxesRunTime.unboxToShort((Object)((Left)either).value())));
            return;
        }
        if (either instanceof Right) {
            String transactionalId = (String)((Right)either).value();
            TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value()).get();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
            Assertions.assertEquals((short)$this.producerEpoch(), (short)txnMetadata.producerEpoch());
            Assertions.assertEquals((int)$this.transactionTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
            Assertions.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
            if (txnMetadata.state().equals((Object)TransactionState.EMPTY)) {
                Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
            } else {
                Assertions.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
            }
            ++count$1.elem;
            return;
        }
        throw new MatchError((Object)either);
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

