/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.test.api.Flaky;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\tEf\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002ABQA\r\u0001\u0005\u0002MBQA\u0019\u0001\u0005\n\rDQ\u0001 \u0001\u0005\u0002uDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a/\u0001\t\u0003\ti\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u001c\u0001!\tA!\b\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B \u0001\u0011\u0005!\u0011\t\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003\u0002\u0002!\tAa!\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\n)\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:UKN$(B\u0001\u0014(\u0003\r\t\u0007/\u001b\u0006\u0002Q\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001,!\taS&D\u0001&\u0013\tqSE\u0001\tCCN,7i\u001c8tk6,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\r\t\u0003Y\u0001\t1\u0002^3ti\"+\u0017\rZ3sgR\u0011AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG\u000fC\u0003<\u0005\u0001\u0007A(A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003{\u0011s!A\u0010\"\u0011\u0005}2T\"\u0001!\u000b\u0005\u0005K\u0013A\u0002\u001fs_>$h(\u0003\u0002Dm\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019e\u0007\u000b\u0003\u0003\u0011R+\u0006CA%S\u001b\u0005Q%BA&M\u0003\u0019\u0001\u0018M]1ng*\u0011QJT\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003'*\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003Y\u000bqd\u001f3jgBd\u0017-\u001f(b[\u0016lhf\u001a:pkB\u0004&o\u001c;pG>dWh\u001f\u0019~Q\u0011\u0011\u0001LX0\u0011\u0005ecV\"\u0001.\u000b\u0005mS\u0015\u0001\u00039s_ZLG-\u001a:\n\u0005uS&\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u00011\"\u0003\u0005\f\u0011eZ3u)\u0016\u001cHo\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\fq\u0004^3ti\"+\u0017\rZ3sgN+'/[1mSj,G)Z:fe&\fG.\u001b>f)\r!Dm\u001e\u0005\u0006K\u000e\u0001\rAZ\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bcA4pc6\t\u0001N\u0003\u0002jU\u0006i1/\u001a:jC2L'0\u0019;j_:T!a\u001b7\u0002\r\r|W.\\8o\u0015\tASN\u0003\u0002o!\u00061\u0011\r]1dQ\u0016L!\u0001\u001d5\u0003\u0015M+'/[1mSj,'\u000fE\u00026eRL!a\u001d\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005U*\u0018B\u0001<7\u0005\u0011\u0011\u0015\u0010^3\t\u000ba\u001c\u0001\u0019A=\u0002\u0019\u0011,7/\u001a:jC2L'0\u001a:\u0011\u0007\u001dT\u0018/\u0003\u0002|Q\naA)Z:fe&\fG.\u001b>fe\u0006\tC/Z:u\u0011\u0016\fG-\u001a:t'\u0016\u0014\u0018.\u00197ju\u0016\u0014H)Z:fe&\fG.\u001b>feR\u0011AG \u0005\u0006w\u0011\u0001\r\u0001\u0010\u0015\u0005\t!#V\u000bK\u0003\u00051z\u000b\u0019\u0001L\u0001a\u0003M!Xm\u001d;BkR|wJ\u001a4tKR\u0014Vm]3u)\r!\u0014\u0011\u0002\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0015\u0005\u000b!#V\u000bK\u0003\u00061z\u000by\u0001L\u0001a\u0003Q!Xm\u001d;He>,\boQ8ogVl\u0007\u000f^5p]R\u0019A'!\u0006\t\u000bm2\u0001\u0019\u0001\u001f)\t\u0019AE+\u0016\u0015\u0006\ras\u00161\u0004\u0017\u0002A\u0006\tB/Z:u!\u0006\u0014H/\u001b;j_:\u001chi\u001c:\u0015\u0007Q\n\t\u0003C\u0003<\u000f\u0001\u0007A\b\u000b\u0003\b\u0011R+\u0006&B\u0004Y=\u0006\u001dB&\u00011\u00027Q,7\u000f\u001e)beRLG/[8og\u001a{'/Q;u_\u000e\u0013X-\u0019;f)\r!\u0014Q\u0006\u0005\u0006w!\u0001\r\u0001\u0010\u0015\u0005\u0011!#V\u000bK\u0003\t1z\u000b\u0019\u0004L\u0001a\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN]%om\u0006d\u0017\u000e\u001a+pa&\u001cGc\u0001\u001b\u0002:!)1(\u0003a\u0001y!\"\u0011\u0002\u0013+VQ\u0015I\u0001LXA Y\u0005\u0001\u0017\u0001\u0003;fgR\u001cV-Z6\u0015\u0007Q\n)\u0005C\u0003<\u0015\u0001\u0007A\b\u000b\u0003\u000b\u0011R+\u0006&\u0002\u0006Y=\u0006-C&\u00011\u0002-M,g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hKN$R\u0001NA)\u00037Bq!a\u0015\f\u0001\u0004\t)&\u0001\u0006ok6\u0014VmY8sIN\u00042!NA,\u0013\r\tIF\u000e\u0002\u0004\u0013:$\bbBA/\u0017\u0001\u0007\u0011qL\u0001\u0003iB\u0004B!!\u0019\u0002d5\t!.C\u0002\u0002f)\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000euKN$\b+\u0019:uSRLwN\u001c)bkN,\u0017I\u001c3SKN,X.\u001a\u000b\u0004i\u0005-\u0004\"B\u001e\r\u0001\u0004a\u0004\u0006\u0002\u0007I)VCS\u0001\u0004-_\u0003cb\u0013\u0001Y\u0001\u0011i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN$2\u0001NA<\u0011\u0015YT\u00021\u0001=Q\u0011i\u0001\nV+)\u000b5Af,! -\u0003\u0001\f\u0011\u0005^3ti&sG/\u001a:dKB$xN]:XSRDwK]8oO.+\u0017PV1mk\u0016$2\u0001NAB\u0011\u0015Yd\u00021\u0001=Q\u0011q\u0001\nV+)\u000b9Af,!#-\u0003\u0001\f\u0011\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016$2\u0001NAH\u0011\u0015Yt\u00021\u0001=Q\u0011y\u0001\nV+)\u000b=Af,!&-\u0003\u0001\fA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u000b\u0004i\u0005m\u0005\"B\u001e\u0011\u0001\u0004a\u0004\u0006\u0002\tI)VCS\u0001\u0005-_\u0003Cc\u0013\u0001Y\u0001\u000fi\u0016\u001cH\u000fT5tiR{\u0007/[2t)\r!\u0014q\u0015\u0005\u0006wE\u0001\r\u0001\u0010\u0015\u0005#!#V\u000bK\u0003\u00121z\u000bi\u000bL\u0001a\u0003\u0015\"Xm\u001d;QCV\u001cXm\u0015;bi\u0016tu\u000e\u001e)sKN,'O^3e\u0005f\u0014VMY1mC:\u001cW\rF\u00025\u0003gCQa\u000f\nA\u0002qBCA\u0005%U+\"*!\u0003\u00170\u0002:2\n\u0001-A\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\u001cVOY:de&\u0014W\rF\u00025\u0003\u007fCQaO\nA\u0002qBCa\u0005%U+\"*1\u0003\u00170\u0002F2\n\u0001-\u0001\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bw-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,Gc\u0001\u001b\u0002L\")1\b\u0006a\u0001y!\"A\u0003\u0013+VQ\u0015!\u0002LXAiY\u0005\u0001\u0017\u0001\f;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0016\fG-T3ue&\u001c7o\u00117fC:,\u0006oV5uQ\u0006\u001b8/[4o)\r!\u0014q\u001b\u0005\u0006wU\u0001\r\u0001\u0010\u0015\u0005+!#V\u000bK\u0003\u00161z\u000bi\u000eL\u0001a\u0003-\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT1h\u001b\u0016$(/[2t\u00072,\u0017M\\+q/&$\b.Q:tS\u001etGc\u0001\u001b\u0002d\")1H\u0006a\u0001y!\"a\u0003\u0013+VQ\u00151\u0002LXAuY\u0005\u0001\u0017a\u000b;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001cx\u000b[3o%\u0016\fGmQ8n[&$H/\u001a3\u0015\u0007Q\ny\u000fC\u0003</\u0001\u0007A\b\u000b\u0003\u0018\u0011R+\u0006&B\fY=\u0006UH&\u00011\u0002]Q,7\u000f^)v_R\fW*\u001a;sS\u000e\u001chj\u001c;De\u0016\fG/\u001a3JM:{\u0017+^8uCN\u001cuN\u001c4jOV\u0014X\r\u001a\u000b\u0004i\u0005m\b\"B\u001e\u0019\u0001\u0004a\u0004\u0006\u0002\rI)VCS\u0001\u0007-_\u0005\u0003a\u0013\u0001Y\u0001\u001di\u0016\u001cHoQ8ogVl\u0017N\\4XSRDg*\u001e7m\u000fJ|W\u000f]%e)\r!$q\u0001\u0005\u0006we\u0001\r\u0001\u0010\u0015\u00053!#V\u000bK\u0003\u001a1z\u0013i\u0001L\u0001a\u0003\u001d\"Xm\u001d;Ok2dwI]8va&#gj\u001c;TkB\u0004xN\u001d;fI&37i\\7nSR$\u0018N\\4\u0015\u0007Q\u0012\u0019\u0002C\u0003<5\u0001\u0007A\b\u000b\u0003\u001b\u0011R+\u0006&\u0002\u000eY=\neA&\u00011\u0002qQ,7\u000f^*uCRL7mQ8ogVlWM\u001d#fi\u0016\u001cGo\u001d(foB\u000b'\u000f^5uS>t7I]3bi\u0016$\u0017I\u001a;feJ+7\u000f^1siR\u0019AGa\b\t\u000bmZ\u0002\u0019\u0001\u001f)\tmAE+\u0016\u0015\u00067as&Q\u0005\u0017\u0002A\u0006qA/Z:u\u000b:$wJ\u001a4tKR\u001cHc\u0001\u001b\u0003,!)1\b\ba\u0001y!\"A\u0004\u0013+VQ\u0015a\u0002L\u0018B\u0019Y\u0005\u0001\u0017!\r;fgR\u001cV-Z6UQJ|wo]%mY\u0016<\u0017\r\\*uCR,\u0017J\u001a)beRLG/[8og:{G/Q:tS\u001etW\r\u001a\u000b\u0004i\t]\u0002\"B\u001e\u001e\u0001\u0004a\u0004\u0006B\u000fI)VCS!\b-_\u0005{a\u0013\u0001Y\u0001\u0018i\u0016\u001cHOR3uG\"|eMZ:fiN4uN\u001d+j[\u0016$2\u0001\u000eB\"\u0011\u0015Yd\u00041\u0001=Q\u0011q\u0002\nV+)\u000byAfL!\u0013-\u0003\u0001\f1\u0004^3tiB{7/\u001b;j_:\u0014Vm\u001d9fGR\u001cH+[7f_V$Hc\u0001\u001b\u0003P!)1h\ba\u0001y!\"q\u0004\u0013+VQ\u0015y\u0002L\u0018B+Y\u0005\u0001\u0007FB\u0010\u0003Zy\u0013\u0019\u0007\u0005\u0003\u0003\\\t}SB\u0001B/\u0015\t1C*\u0003\u0003\u0003b\tu#a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002\u001f\u0005QB/Z:u!>\u001c\u0018\u000e^5p]J+7\u000f]3diN<\u0016m[3vaR\u0019AG!\u001b\t\u000bm\u0002\u0003\u0019\u0001\u001f)\t\u0001BE+\u0016\u0015\u0006Aas&q\u000e\u0017\u0002A\"2\u0001E!\u0017_\u0005G\nQ\u0006^3tiB{7/\u001b;j_:<\u0016\u000e\u001e5FeJ|'oQ8o]\u0016\u001cG/[8o%\u0016\u001c\b/Z2ug^\u000b7.Z;q)\r!$q\u000f\u0005\u0006w\u0005\u0002\r\u0001\u0010\u0015\u0005C!#V\u000bK\u0003\"1z\u0013i\bL\u0001aQ\u0019\t#\u0011\f0\u0003d\u0005yB/Z:u\u00072|7/\u001a'fCZ,7o\u0012:pkB|e.\u00138uKJ\u0014X\u000f\u001d;\u0015\u0007Q\u0012)\tC\u0003<E\u0001\u0007A\b\u000b\u0004#\u0005\u0013s&q\u0013\t\u0005\u0005\u0017\u0013\u0019*\u0004\u0002\u0003\u000e*\u0019aEa$\u000b\u0007\tE%.\u0001\u0003uKN$\u0018\u0002\u0002BK\u0005\u001b\u0013QA\u00127bWf\f#A!'\u0002\u0017-\u000beiS!.ca\u00024'\r\u0015\u0005E!#V\u000bK\u0003#1z\u0013y\nL\u0001a\u0003\u0001\"Xm\u001d;PM\u001a\u001cX\r\u001e*fY\u0006$X\rZ,iK:$\u0016.\\3pkRTVM]8\u0015\u0007Q\u0012)\u000bC\u0003<G\u0001\u0007A\b\u000b\u0003$\u0011R+\u0006&B\u0012Y=\n-F&\u00011)\r\u0001\u0011IF\u0018BX=\t\u0011\u0001\f")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testHeaders(String groupProtocol) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign(java.util.List.of(this.tp()));
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign(java.util.List.of(this.tp()));
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testHeadersSerializerDeserializer(String groupProtocol) {
        BaseConsumerTest.SerializerImpl extendedSerializer = new BaseConsumerTest.SerializerImpl();
        BaseConsumerTest.DeserializerImpl extendedDeserializer = new BaseConsumerTest.DeserializerImpl();
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testAutoOffsetReset(String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testGroupConsumption(String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(java.util.List.of(this.topic()));
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPartitionsFor(String groupProtocol) {
        int numParts = 2;
        this.createTopic("part-test", numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPartitionsForAutoCreate(String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testPartitionsForAutoCreate$1(consumer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out while awaiting non empty partitions.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPartitionsForInvalidTopic(String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSeek(String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign(java.util.List.of(this.tp()));
        consumer.seekToEnd(java.util.List.of(this.tp()));
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning(java.util.List.of(this.tp()));
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, x$4, x$6, x$7, x$8, x$9);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords(consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign(java.util.List.of(this.tp2()));
        consumer.seekToEnd(java.util.List.of(this.tp2()));
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning(java.util.List.of(this.tp2()));
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        TopicPartition x$13 = this.tp2();
        int x$14 = this.consumeAndVerifyRecords$default$4();
        long x$15 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$16 = this.consumeAndVerifyRecords$default$6();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$14, x$15, x$16, x$13, x$17, x$18);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$21 = (int)mid;
        int x$22 = (int)mid;
        TopicPartition x$24 = this.tp2();
        TimestampType x$25 = this.consumeAndVerifyRecords$default$6();
        int x$26 = this.consumeAndVerifyRecords$default$8();
        long x$27 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, x$21, x$22, mid, x$25, x$24, x$26, x$27);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)("value " + BoxesRunTime.unboxToInt((Object)i)).getBytes())));
        producer.close();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPartitionPauseAndResume(String groupProtocol) {
        java.util.List<TopicPartition> partitions = java.util.List.of(this.tp());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(partitions);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        consumer.pause(partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume(partitions);
        int x$14 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 5, x$14, startingTimestamp, x$15, x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testInterceptors(String groupProtocol) {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)), (Object)("value " + BoxesRunTime.unboxToInt((Object)i))))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign(java.util.List.of(this.tp()));
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)("key " + i), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)("value " + i + appendStr).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync(Map.of(this.tp(), new OffsetAndMetadata(2L)));
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed(Set.of(this.tp())).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed(Set.of(this.tp())).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testInterceptorsWithWrongKeyValue(String groupProtocol) {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign(java.util.List.of(this.tp()));
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testConsumeMessagesWithCreateTime(String groupProtocol) {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign(java.util.List.of(this.tp2()));
        TopicPartition x$12 = this.tp2();
        int x$14 = this.consumeAndVerifyRecords$default$4();
        long x$15 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$16 = this.consumeAndVerifyRecords$default$6();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$14, x$15, x$16, x$12, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testConsumeMessagesWithLogAppendTime(String groupProtocol) {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty("message.timestamp.type", "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5(), this.createTopic$default$6());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(tp1));
        int x$7 = this.consumeAndVerifyRecords$default$4();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$7, startTime, TimestampType.LOG_APPEND_TIME, tp1, x$8, x$9);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign(java.util.List.of(tp2));
        int x$16 = this.consumeAndVerifyRecords$default$4();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$16, startTime, TimestampType.LOG_APPEND_TIME, tp2, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testListTopics(String groupProtocol) {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic3, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPauseStateNotPreservedByRebalance(String groupProtocol) {
        if (groupProtocol.equalsIgnoreCase(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "100");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        }
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.subscribe(java.util.List.of(this.topic()));
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        consumer.pause(java.util.List.of(this.tp()));
        consumer.subscribe(java.util.List.of("topic2"));
        int x$14 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 0, 5, x$14, startingTimestamp, x$15, x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe(String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe(java.util.List.of(this.topic(), topic2), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)("The lead should be " + records.count()));
        consumer.subscribe(java.util.List.of(topic2), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithSubscribe(String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe(java.util.List.of(this.topic(), topic2), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)("The lag should be " + expectedLag));
        consumer.subscribe(java.util.List.of(topic2), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithAssign(String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)("The lead should be " + records.count()));
        consumer.assign(java.util.List.of(this.tp2()));
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithAssign(String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)("The lag should be " + expectedLag));
        consumer.assign(java.util.List.of(this.tp2()));
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName(this.tp().toString() + ".records-lag", "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsWhenReadCommitted(String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured(String groupProtocol) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(this.tp()));
        consumer.seek(this.tp(), 0L);
        int x$52 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$62 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$72 = this.consumeAndVerifyRecords$default$7();
        int x$82 = this.consumeAndVerifyRecords$default$8();
        long x$92 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$52, startingTimestamp, x$62, x$72, x$82, x$92);
        this.brokers().foreach((Function1 & Serializable)x$2 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$2, "byte-rate", QuotaType.PRODUCE, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$3 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$3, "throttle-time", QuotaType.PRODUCE, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$4 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$4, "byte-rate", QuotaType.FETCH, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$5 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$5, "throttle-time", QuotaType.FETCH, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$6 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$6, "request-time", QuotaType.REQUEST, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$7 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$7, "throttle-time", QuotaType.REQUEST, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$8 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$8, "request-time", QuotaType.REQUEST, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$9 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$9, "throttle-time", QuotaType.REQUEST, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testConsumingWithNullGroupId(String groupProtocol) {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        .colon.colon x$6 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        Consumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        .colon.colon x$10 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        Consumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(java.util.List.of(tp));
        consumer2.assign(java.util.List.of(tp));
        consumer3.assign(java.util.List.of(tp));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed(Set.of(tp)));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        Assertions.assertTrue((boolean)consumer1.assignment().isEmpty());
        Assertions.assertTrue((boolean)consumer2.assignment().isEmpty());
        Assertions.assertTrue((boolean)consumer3.assignment().isEmpty());
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testNullGroupIdNotSupportedIfCommitting(String groupProtocol) {
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        consumer1.assign(java.util.List.of(this.tp()));
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testStaticConsumerDetectsNewPartitionCreatedAfterRestart(String groupProtocol) {
        String foo = "foo";
        TopicPartition foo0 = new TopicPartition(foo, 0);
        TopicPartition foo1 = new TopicPartition(foo, 1);
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        admin.createTopics(java.util.List.of(new NewTopic(foo, 1, (short)1))).all().get();
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", "my-group-id");
        consumerConfig.put("group.instance.id", "my-instance-id");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer1 = this.createConsumer(x$2, x$3, consumerConfig, x$4);
        consumer1.subscribe(java.util.List.of(foo));
        this.awaitAssignment(consumer1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        consumer1.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer consumer2 = this.createConsumer(x$6, x$7, consumerConfig, x$8);
        consumer2.subscribe(java.util.List.of(foo));
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        admin.createPartitions(Map.of(foo, NewPartitions.increaseTo((int)2))).all().get();
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1}))));
        consumer2.close();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testEndOffsets(String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        int numRecords = 10000;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> PlaintextConsumerTest.$anonfun$testEndOffsets$1(this, startingTimestamp, producer, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(java.util.List.of(this.topic()));
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        Map endOffsets = consumer.endOffsets(Set.of(this.tp()));
        Assertions.assertEquals((long)numRecords, (Long)((Long)endOffsets.get(this.tp())));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSeekThrowsIllegalStateIfPartitionsNotAssigned(String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> consumer.seekToEnd(java.util.List.of(tp)));
        Assertions.assertEquals((Object)("No current assignment for partition " + tp), (Object)e.getMessage());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testFetchOffsetsForTime(String groupProtocol) {
        int numPartitions = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(this.topic(), part);
            this.sendRecords((KafkaProducer<byte[], byte[]>)producer, 100, tp, 0L, this.sendRecords$default$5());
            timestampsToSearch.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Map.of(new TopicPartition(this.topic(), 0), Predef$.MODULE$.long2Long(-1L))));
        Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTp0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 0));
        Assertions.assertEquals((long)0L, (long)timestampTp0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTp0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp0.leaderEpoch());
        OffsetAndTimestamp timestampTp1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 1));
        Assertions.assertEquals((long)20L, (long)timestampTp1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTp1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp1.leaderEpoch());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsTimeout(String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(topicPartition));
        Assertions.assertThrows(TimeoutException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsWakeup(String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(topicPartition));
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionWithErrorConnectionRespectsWakeup(String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:12345");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, properties, x$4);
        consumer.assign(java.util.List.of(topicPartition));
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(100L)));
    }

    /*
     * WARNING - void declaration
     */
    @Flaky(value="KAFKA-18031")
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testCloseLeavesGroupOnInterrupt(String groupProtocol) {
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe(java.util.List.of(this.topic()), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        try {
            Thread.currentThread().interrupt();
            Assertions.assertThrows(InterruptException.class, () -> consumer.close());
        }
        finally {
            Thread.interrupted();
        }
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
        ConsumerConfig config = new ConsumerConfig(this.consumerConfig());
        int leaveGroupTimeoutMs = Predef$.MODULE$.Integer2int(config.getInt("session.timeout.ms")) / 2;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = leaveGroupTimeoutMs;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testCloseLeavesGroupOnInterrupt$2(config, adminClient)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testCloseLeavesGroupOnInterrupt$3(leaveGroupTimeoutMs));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testOffsetRelatedWhenTimeoutZero(String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Map result1 = consumer.beginningOffsets(java.util.List.of(this.tp()), Duration.ZERO);
        Assertions.assertNotNull((Object)result1);
        Assertions.assertEquals((int)0, (int)result1.size());
        Map result2 = consumer.endOffsets(java.util.List.of(this.tp()), Duration.ZERO);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertEquals((int)0, (int)result2.size());
        Map result3 = consumer.offsetsForTimes(Map.of(this.tp(), Predef$.MODULE$.long2Long(0L)), Duration.ZERO);
        Assertions.assertNotNull((Object)result3);
        Assertions.assertEquals((int)1, (int)result3.size());
        Assertions.assertNull(result3.get(this.tp()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsForAutoCreate$1(Consumer consumer$1) {
        return !consumer$1.partitionsFor("non-exist-topic").isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionsForAutoCreate$2() {
        return "Timed out while awaiting non empty partitions.";
    }

    private static final void assertNoMetric$1(KafkaBroker broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)("Metric should not have been created " + metricName));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testEndOffsets$1(PlaintextConsumerTest $this, long startingTimestamp$1, KafkaProducer producer$2, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord($this.tp().topic(), Predef$.MODULE$.int2Integer($this.tp().partition()), Predef$.MODULE$.long2Long(timestamp), (Object)("key " + i).getBytes(), (Object)("value " + i).getBytes());
        producer$2.send(record);
        return record;
    }

    public static final /* synthetic */ boolean $anonfun$testCloseLeavesGroupOnInterrupt$2(ConsumerConfig config$1, Admin adminClient$1) {
        try {
            String groupId = config$1.getString("group.id");
            return ((ConsumerGroupDescription)((KafkaFuture)adminClient$1.describeConsumerGroups(java.util.List.of(groupId)).describedGroups().get(groupId)).get()).members().isEmpty();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException ? true : throwable instanceof InterruptedException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$testCloseLeavesGroupOnInterrupt$3(int leaveGroupTimeoutMs$1) {
        return "Consumer did not leave the consumer group within " + leaveGroupTimeoutMs$1 + " ms of close";
    }
}

