/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.security.JaasTestUtils;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B(\t\r\u0015\u0004\u0001\u0015!\u0003Q\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d\u0001\bA1A\u0005REDaa\u001f\u0001!\u0002\u0013\u0011\bb\u0002?\u0001\u0005\u0004%\t&\u001d\u0005\u0007{\u0002\u0001\u000b\u0011\u0002:\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!!0\u0001\t\u0013\ty\fC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\n\u0005_\u0002\u0011\u0013!C\u0005\u0005cBqAa#\u0001\t\u0013\u0011i\tC\u0004\u0003(\u0002!IA!+\t\u0013\tu\u0006!%A\u0005\n\tM\u0004b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011%\u0011y\rAI\u0001\n\u0013\u0011\t\u000eC\u0004\u0003V\u0002!IAa6\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!1\u001d\u0001\u0005\n\t\u0015(aC'fiJL7m\u001d+fgRT!a\n\u0015\u0002\u0007\u0005\u0004\u0018NC\u0001*\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u00171!\tic&D\u0001'\u0013\tycE\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0013'\u0003\u00023M\tI1+Y:m'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0002\"!\f\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003\u0005\u0003\"A\u0011'\u000e\u0003\rS!\u0001R#\u0002\u000f9,Go^8sW*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005%B%BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001eL!!T\"\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0003mC:<'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u0013aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\t1\fE\u0002]CBk\u0011!\u0018\u0006\u0003=~\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0001T\u0014AC2pY2,7\r^5p]&\u0011!-\u0018\u0002\u0005\u0019&\u001cH/\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\rlC\u001a\\\u0017mU3sm\u0016\u0014(*Y1t\u000b:$(/\u001f(b[\u0016\f\u0011d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7fA\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005CV$\bN\u0003\u0002n\u000b\u0006A1/Z2ve&$\u00180\u0003\u0002pU\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0003I\u00042!O:v\u0013\t!(H\u0001\u0003T_6,\u0007C\u0001<z\u001b\u00059(B\u0001=U\u0003\u0011)H/\u001b7\n\u0005i<(A\u0003)s_B,'\u000f^5fg\u0006)2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013\u0001F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7/A\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\t\u0005\u0005\u0011q\u0001\t\u0004s\u0005\r\u0011bAA\u0003u\t!QK\\5u\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u001b\tI\"\u0004\u0002\u0002\u0010)\u0019q%!\u0005\u000b\t\u0005M\u0011QC\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9BS\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\tyA\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0001\u0012q\u0004\t\u0005\u0003\u001b\t\t#\u0003\u0003\u0002$\u0005=!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u0006\u0002\u0002\u0002!\u001a\u0011#a\u000b\u0011\t\u00055\u0011QF\u0005\u0005\u0003_\tyAA\u0005BMR,'/R1dQ\u0006YA/Z:u\u001b\u0016$(/[2t)\u0011\t\t!!\u000e\t\u000f\u0005]\"\u00031\u0001\u0002:\u0005Q2/_:uK6\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIB\u0019\u0011(a\u000f\n\u0007\u0005u\"HA\u0004C_>dW-\u00198)\u000fI\t\t%!\u0014\u0002PA!\u00111IA%\u001b\t\t)E\u0003\u0003\u0002H\u0005E\u0011A\u00029be\u0006l7/\u0003\u0003\u0002L\u0005\u0015#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\t&\u0001\u0019uKN$X*\u001a;sS\u000e\u001c\be^5uQ\u0002\u001a\u0018p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eu\u0001Z\b' \u0015\b%\u0005U\u0013\u0011MA2!\u0011\t9&!\u0018\u000e\u0005\u0005e#\u0002BA.\u0003\u000b\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003?\nIFA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2\"\u0011QMA5C\t\t9'\u0001\u0003ueV,\u0017EAA6\u0003\u00151\u0017\r\\:f\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u0015\u0005\u0005\u0011\u0011OAH\u0003'\u000b9\nC\u0004\u0002tM\u0001\r!!\u001e\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002\"a\u001e\u0002\u0000\u0005\r\u00151Q\u0007\u0003\u0003sRA!a\u001d\u0002|)\u0019\u0011QP$\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011QA=\u00055Y\u0015MZ6b!J|G-^2feB)\u0011(!\"\u0002\n&\u0019\u0011q\u0011\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007e\nY)C\u0002\u0002\u000ej\u0012AAQ=uK\"1\u0011\u0011S\nA\u0002a\n!B\\;n%\u0016\u001cwN\u001d3t\u0011\u0019\t)j\u0005a\u0001q\u0005Q!/Z2pe\u0012\u001c\u0016N_3\t\u000f\u0005e5\u00031\u0001\u0002\u001c\u0006\u0011A\u000f\u001d\t\u0005\u0003;\u000by*D\u0001F\u0013\r\t\t+\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003u9WM\\3sCR,\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,G\u0003BA\u0001\u0003OCq!!'\u0015\u0001\u0004\tY*A\u0015wKJLg-_&bM.\f'+\u0019;f\u001b\u0016$(/[2t\u0011\u00064XmQ;nk2\fG/\u001b<f\u0007>,h\u000e\u001e\u000b\u0007\u0003\u0003\ti+a,\t\u000f\u0005MT\u00031\u0001\u0002v!9\u0011\u0011W\u000bA\u0002\u0005M\u0016\u0001C2p]N,X.\u001a:\u0011\u0011\u0005U\u0016\u0011XAB\u0003\u0007k!!a.\u000b\t\u0005E\u00161P\u0005\u0005\u0003w\u000b9L\u0001\u0005D_:\u001cX/\\3s\u0003i1XM]5gs\u000ec\u0017.\u001a8u-\u0016\u00148/[8o\u001b\u0016$(/[2t)\u0019\t\t!!1\u0002j\"9\u00111\u0019\fA\u0002\u0005\u0015\u0017aB7fiJL7m\u001d\u0019\u0005\u0003\u000f\f9\u000eE\u0004w\u0003\u0013\fi-a5\n\u0007\u0005-wOA\u0002NCB\u0004B!!(\u0002P&\u0019\u0011\u0011[#\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0003\u0002V\u0006]G\u0002\u0001\u0003\r\u00033\f\t-!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\n\u0014\u0003BAo\u0003G\u00042!OAp\u0013\r\t\tO\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\ti*!:\n\u0007\u0005\u001dXI\u0001\u0004NKR\u0014\u0018n\u0019\u0005\b\u0003W4\u0002\u0019AAw\u0003\u0019)g\u000e^5usB!\u0011q^A\u007f\u001d\u0011\t\t0!?\u0011\u0007\u0005M((\u0004\u0002\u0002v*\u0019\u0011q\u001f\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tYPO\u0001\u0007!J,G-\u001a4\n\u0007]\u000byPC\u0002\u0002|j\n\u0011E^3sS\u001aL(I]8lKJ\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e:jGN$B!!\u0001\u0003\u0006!9!qA\fA\u0002\t%\u0011AB:feZ,'\u000f\u0005\u0003\u0003\f\t=QB\u0001B\u0007\u0015\r\u00119\u0001K\u0005\u0005\u0005#\u0011iAA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018A\u0007<fe&4\u0017P\u0011:pW\u0016\u0014X*Z:tC\u001e,W*\u001a;sS\u000e\u001cH\u0003CA\u0001\u0005/\u0011IBa\u0007\t\u000f\t\u001d\u0001\u00041\u0001\u0003\n!1\u0011Q\u0013\rA\u0002aBq!!'\u0019\u0001\u0004\tY*\u0001\rwKJLg-\u001f\"s_.,'/\u0012:s_JlU\r\u001e:jGN$B!!\u0001\u0003\"!9!qA\rA\u0002\t%\u0011!\u0005<fe&4\u0017pS1gW\u0006lU\r\u001e:jGV!!q\u0005B\u0017))\u0011IC!\u0016\u0003X\t\r$Q\r\u000b\u0005\u0005W\u0011I\u0004\u0005\u0003\u0002V\n5Ba\u0002B\u00185\t\u0007!\u0011\u0007\u0002\u0002)F!\u0011Q\u001cB\u001a!\rI$QG\u0005\u0004\u0005oQ$aA!os\"9!1\b\u000eA\u0002\tu\u0012A\u0002<fe&4\u0017\u0010E\u0004:\u0005\u007f\u0011\u0019Ea\u000b\n\u0007\t\u0005#HA\u0005Gk:\u001cG/[8ocA1!Q\tB(\u0003GtAAa\u0012\u0003L9!\u00111\u001fB%\u0013\u0005Y\u0014b\u0001B'u\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B)\u0005'\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005\u001bR\u0004bBA'5\u0001\u0007\u0011Q\u001e\u0005\b\u0003\u0007T\u0002\u0019\u0001B-a\u0011\u0011YFa\u0018\u0011\u000fY\fI-!4\u0003^A!\u0011Q\u001bB0\t1\u0011\tGa\u0016\u0002\u0002\u0003\u0005)\u0011AAn\u0005\ryFE\r\u0005\b\u0003WT\u0002\u0019AAw\u0011%\u00119G\u0007I\u0001\u0002\u0004\u0011I'A\u0003he>,\b\u000fE\u0003:\u0005W\ni/C\u0002\u0003ni\u0012aa\u00149uS>t\u0017a\u0007<fe&4\u0017pS1gW\u0006lU\r\u001e:jG\u0012\"WMZ1vYR$C'\u0006\u0003\u0003t\t%UC\u0001B;U\u0011\u0011IGa\u001e,\u0005\te\u0004\u0003\u0002B>\u0005\u000bk!A! \u000b\t\t}$\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa!;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\u0013iHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$qAa\f\u001c\u0005\u0004\u0011\t$A\nnCb\\\u0015MZ6b\u001b\u0016$(/[2WC2,X\r\u0006\u0006\u0003\u0010\nU%q\u0013BR\u0005K\u00032!\u000fBI\u0013\r\u0011\u0019J\u000f\u0002\u0007\t>,(\r\\3\t\u000f\u00055C\u00041\u0001\u0002n\"9\u00111\u0019\u000fA\u0002\te\u0005\u0007\u0002BN\u0005?\u0003rA^Ae\u0003\u001b\u0014i\n\u0005\u0003\u0002V\n}E\u0001\u0004BQ\u0005/\u000b\t\u0011!A\u0003\u0002\u0005m'aA0%g!9\u00111\u001e\u000fA\u0002\u00055\bb\u0002B49\u0001\u0007!\u0011N\u0001\u001am\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001c'+Z2pe\u0012,G\r\u0006\u0006\u0002\u0002\t-&Q\u0016B]\u0005wCq!!\u0014\u001e\u0001\u0004\ti\u000fC\u0004\u0002Dv\u0001\rAa,1\t\tE&Q\u0017\t\bm\u0006%\u0017Q\u001aBZ!\u0011\t)N!.\u0005\u0019\t]&QVA\u0001\u0002\u0003\u0015\t!a7\u0003\u0007}#C\u0007C\u0004\u0002lv\u0001\r!!<\t\u0013\t\u001dT\u0004%AA\u0002\t%\u0014a\t<fe&4\u0017pS1gW\u0006lU\r\u001e:jGJ+7m\u001c:eK\u0012$C-\u001a4bk2$H\u0005N\u0001\u0012s\u0006lW.\u001a:NKR\u0014\u0018n\u0019,bYV,G\u0003\u0002B\u001a\u0005\u0007Dq!!\u0014 \u0001\u0004\ti/\u0001\u000ewKJLg-_-b[6,'/T3ue&\u001c'+Z2pe\u0012,G\r\u0006\u0004\u0003\u0010\n%'1\u001a\u0005\b\u0003\u001b\u0002\u0003\u0019AAw\u0011%\u0011Y\u0004\tI\u0001\u0002\u0004\u0011i\rE\u0004:\u0005\u007f\u0011y)!\u000f\u0002IY,'/\u001b4z3\u0006lW.\u001a:NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uII*\"Aa5+\t\t5'qO\u0001\u0017m\u0016\u0014\u0018NZ=O_J+\u0017/^3ti6+GO]5dgR!\u0011\u0011\u0001Bm\u0011\u001d\u0011YN\ta\u0001\u0003[\fA\"\u001a:s_JlUm]:bO\u0016\fqD\u001a:p[:\u000bW.\u001a+p\u0005J|7.\u001a:U_BL7m\u0015;biNl%)Z1o)\u0011\tiO!9\t\u000f\u000553\u00051\u0001\u0002n\u0006Qb/\u001a:jMf\u0014V-\\8uKN#xN]1hK6+GO]5dgR!\u0011\u0011\u0001Bt\u0011\u001d\u0011I\u000f\na\u0001\u0003s\tAc\u001d5pk2$7i\u001c8uC&tW*\u001a;sS\u000e\u001c\b")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, kafkaServerEntryName);
    }

    @Override
    public String jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$(this, adminClient, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("testMetrics") && testInfo.getDisplayName().endsWith("true")) {
            this.serverConfig().setProperty("remote.log.storage.system.enable", "true");
            this.serverConfig().setProperty("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
            this.serverConfig().setProperty("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        }
        this.consumerConfig().put("group.protocol", "classic");
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @ParameterizedTest(name="testMetrics with systemRemoteStorageEnabled: {0}")
    @CsvSource(value={"true", "false"})
    public void testMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "mytopic";
        ListenerName x$4 = this.interBrokerListenerName();
        Properties x$5 = this.adminClientConfig();
        Properties x$6 = this.createTopic$default$4();
        this.createTopic(topic, 1, 1, x$6, x$4, x$5);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        ByteArraySerializer x$8 = this.createProducer$default$1();
        ByteArraySerializer x$9 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$8, x$9, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(java.util.List.of(tp));
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaBroker server = (KafkaBroker)this.brokers().head();
        this.verifyBrokerMessageMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics(server);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
        this.verifyRemoteStorageMetrics(systemRemoteStorageEnabled);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaBroker server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageMetrics(KafkaBroker server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(requestMetricsPrefix + ",name=RequestBytes,request=Produce", this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(requestMetricsPrefix + ",name=TemporaryMemoryBytes,request=Produce", this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)("Unexpected temporary memory size requestBytes " + requestBytes + " tempBytes " + tempBytes));
        this.verifyYammerMetricRecorded(requestMetricsPrefix + ",name=RequestBytes,request=Fetch", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = requestMetricsPrefix + ",name=TemporaryMemoryBytes,request=Fetch";
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageMetrics$1(verifyYammerMetricRecorded_metricValue), (String)("Broker metric not recorded correctly for " + verifyYammerMetricRecorded_name + " value " + verifyYammerMetricRecorded_metricValue));
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(requestMetricsPrefix + ",name=RequestBytes,request=Metadata", this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerErrorMetrics(KafkaBroker server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(errorMetricPrefix + ",request=Metadata,error=NONE", this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(errorMetricPrefix + ",request=Metadata,error=INVALID_TOPIC_EXCEPTION", this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 14 ? 1 : 0) != 0, (String)("Too many error metrics " + currentErrorMetricCount));
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(errorMetricPrefix + ",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION", this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)("Metric not found " + name));
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)("Metric not found " + name));
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)(entity + " metric not recorded correctly for " + name + " value " + value));
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("Unable to find broker metric " + name + ": allMetrics: " + allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName()))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)("Unexpected broker metric of class " + var4_4.getClass()));
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)("Broker metric not recorded correctly for " + name + " value " + metricValue));
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)(errorMessage + ": " + metrics.keys()));
    }

    private String fromNameToBrokerTopicStatsMBean(String name) {
        return "kafka.server:type=BrokerTopicMetrics,name=" + name;
    }

    private void verifyRemoteStorageMetrics(boolean shouldContainMetrics) {
        List metrics = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(RemoteStorageMetrics.allMetrics()).asScala().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$1(name)))).toList();
        Set aggregatedBrokerTopicStats = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        List aggregatedBrokerTopicMetrics = ((IterableOnceOps)aggregatedBrokerTopicStats.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$3(this, name)))).toList();
        if (shouldContainMetrics) {
            Assertions.assertEquals((int)RemoteStorageMetrics.allMetrics().size(), (int)metrics.size(), (String)("Only " + metrics + " appear in the metrics"));
            Assertions.assertEquals((int)aggregatedBrokerTopicStats.size(), (int)aggregatedBrokerTopicMetrics.size(), (String)("Only " + aggregatedBrokerTopicMetrics + " appear in the metrics"));
            return;
        }
        Assertions.assertEquals((int)0, (int)metrics.size(), (String)(metrics + " should not appear in the metrics"));
        Assertions.assertEquals((int)0, (int)aggregatedBrokerTopicMetrics.size(), (String)(aggregatedBrokerTopicMetrics + " should not appear in the metrics"));
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)("No cumulative count/time metric for rate metric " + rateMetricName));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)(entity$1 + " metric not recorded " + name$1));
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)(entity$1 + " metric " + name$1 + " should be a non-empty String"));
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)("Metric not found " + name));
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageMetrics$1(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$2(com.yammer.metrics.core.MetricName name$4, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals(name$4.getMBeanName());
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$1(com.yammer.metrics.core.MetricName name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().exists((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$2(name, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$4(MetricsTest $this, String name$5, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals($this.fromNameToBrokerTopicStatsMBean(name$5));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$3(MetricsTest $this, String name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().exists((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$4($this, name, metric)));
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = this.listenerName().value().toLowerCase(Locale.ROOT) + ".KafkaServer";
        this.serverConfig().setProperty("auto.create.topics.enable", "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

