/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!IQ\u0007\u0001a\u0001\u0002\u0004%\tA\u000e\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\u0002\rC\u0011\"\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u001c\t\u000f)\u0003\u0001\u0019!C\u0001\u0017\"9q\n\u0001a\u0001\n\u0003\u0001\u0006B\u0002*\u0001A\u0003&A\nC\u0004T\u0001\u0001\u0007I\u0011\u0001\u001c\t\u000fQ\u0003\u0001\u0019!C\u0001+\"1q\u000b\u0001Q!\n]Bq\u0001\u0017\u0001A\u0002\u0013\u0005a\u0007C\u0004Z\u0001\u0001\u0007I\u0011\u0001.\t\rq\u0003\u0001\u0015)\u00038\u0011\u0015i\u0006\u0001\"\u0015,\u0011\u0015q\u0006\u0001\"\u0015`\u0011\u0015\u0001\b\u0001\"\u0015r\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u000e\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0005M\u0011V-\\8uKR{\u0007/[2DeV$G+Z:u\u0015\tYB$A\u0003bI6LgNC\u0001\u001e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rb\u0012aA1qS&\u0011QE\t\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u00121!\u00138u\u00039qW/\u001c)beRLG/[8og\u0002\nAC\\;n%\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018!\u00068v[J+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u000ei\u0016\u001cH\u000fV8qS\u000et\u0015-\\3\u0016\u0003]\u0002\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e/\u001b\u0005Y$B\u0001\u001f\u001f\u0003\u0019a$o\\8u}%\u0011aHL\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?]\u0005\tB/Z:u)>\u0004\u0018n\u0019(b[\u0016|F%Z9\u0015\u0005\u0011;\u0005CA\u0017F\u0013\t1eF\u0001\u0003V]&$\bb\u0002%\b\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014A\u0004;fgR$v\u000e]5d\u001d\u0006lW\rI\u0001\u0018gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012,\u0012\u0001\u0014\t\u0003[5K!A\u0014\u0018\u0003\u000f\t{w\u000e\\3b]\u0006Y2/_:SK6|G/Z*u_J\fw-Z#oC\ndW\rZ0%KF$\"\u0001R)\t\u000f!S\u0011\u0011!a\u0001\u0019\u0006A2/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u0011\u0002/M$xN]1hK6\u000bg.Y4fe\u000ec\u0017m]:OC6,\u0017aG:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7f?\u0012*\u0017\u000f\u0006\u0002E-\"9\u0001*DA\u0001\u0002\u00049\u0014\u0001G:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7fA\u0005AR.\u001a;bI\u0006$\u0018-T1oC\u001e,'o\u00117bgNt\u0015-\\3\u000295,G/\u00193bi\u0006l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lWm\u0018\u0013fcR\u0011Ai\u0017\u0005\b\u0011B\t\t\u00111\u00018\u0003eiW\r^1eCR\fW*\u00198bO\u0016\u00148\t\\1tg:\u000bW.\u001a\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0005\u0011\u0003\u0007\"B1\u0014\u0001\u0004\u0011\u0017!\u00029s_B\u001c\bcA2gQ6\tAM\u0003\u0002f]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d$'aA*fcB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'A\u0003)s_B,'\u000f^5fg\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u0002ce\")1\u000f\u0006a\u0001i\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002v{6\taO\u0003\u0002$o*\u0011\u00010_\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ80A\u0003kk:LGOC\u0001}\u0003\ry'oZ\u0005\u0003}Z\u0014\u0001\u0002V3ti&sgm\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004\t\u0006\r\u0001BBA\u0003+\u0001\u0007A/\u0001\u0003j]\u001a|\u0007fA\u000b\u0002\nA\u0019Q/a\u0003\n\u0007\u00055aO\u0001\u0006CK\u001a|'/Z#bG\"\fq\b^3ti\u000ecWo\u001d;fe^KG-\u001a#jg\u0006\u0014G.Z7f]R|e\rV5fe\u0016$7\u000b^8sC\u001e,w+\u001b;i\u000b:\f'\r\\3e)&,'/\u001a3U_BL7\rF\u0001EQ\r1\u0012Q\u0003\t\u0004k\u0006]\u0011bAA\rm\n!A+Z:u\u0003-#Xm\u001d;DYV\u001cH/\u001a:XSRDw.\u001e;US\u0016\u0014X\rZ*u_J\fw-Z*uCJ$8oU;dG\u0016\u001c8OZ;mYfLe\rV8qS\u000e<\u0016\u000e\u001e5US\u0016\u0014\u0018N\\4ESN\f'\r\\3eQ\r9\u0012QC\u0001\u000e_Z,'O]5eKB\u0013x\u000e]:\u0015\u0003!Ds\u0001AA\u0013\u0003W\ti\u0003E\u0002v\u0003OI1!!\u000bw\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        this.testTopicName_$eq(((Method)info.getTestMethod().get()).getName() + "-" + Random$.MODULE$.alphanumeric().take(10).mkString());
    }

    @Test
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
        Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
        this.faultHandler().setIgnore(true);
    }

    @Test
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

