/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u0013&\u0001)BQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005BYBq!\u0010\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004?\u0001\u0001\u0006Ia\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"9!\n\u0001b\u0001\n\u0003Y\u0005BB,\u0001A\u0003%A\nC\u0004Y\u0001\t\u0007I\u0011\u0001!\t\re\u0003\u0001\u0015!\u0003B\u0011\u001dQ\u0006A1A\u0005\u0002-Caa\u0017\u0001!\u0002\u0013a\u0005b\u0002/\u0001\u0005\u0004%\t\u0001\u0011\u0005\u0007;\u0002\u0001\u000b\u0011B!\t\u000fy\u0003!\u0019!C\u0001\u0017\"1q\f\u0001Q\u0001\n1Cq\u0001\u0019\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004b\u0001\u0001\u0006I!\u0011\u0005\bE\u0002\u0011\r\u0011\"\u0001L\u0011\u0019\u0019\u0007\u0001)A\u0005\u0019\"9A\r\u0001b\u0001\n\u0003\u0001\u0005BB3\u0001A\u0003%\u0011\tC\u0004g\u0001\t\u0007I\u0011A&\t\r\u001d\u0004\u0001\u0015!\u0003M\u0011%1\u0003\u00011AA\u0002\u0013\u0005\u0001\u000eC\u0005v\u0001\u0001\u0007\t\u0019!C\u0001m\"IA\u0010\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\u0006{\u0002!\tE \u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\tY\u0003\u0001C\u0001\u0003CAq!a\f\u0001\t\u0003\t\t\u0003C\u0004\u00024\u0001!\t!!\t\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\"!9\u00111\b\u0001\u0005\u0002\u0005\u0005\u0002bBA \u0001\u0011\u0005\u0011\u0011\u0005\u0002\u0012\u0003\u0012$\u0007+\u0019:uSRLwN\\:UKN$(B\u0001\u0014(\u0003\u0015\tG-\\5o\u0015\u0005A\u0013!B6bM.\f7\u0001A\n\u0003\u0001-\u0002\"\u0001L\u0018\u000e\u00035R!AL\u0014\u0002\rM,'O^3s\u0013\t\u0001TFA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\tQ%A\u0006ce>\\WM]\"pk:$X#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u0007%sG/A\u0006qCJ$\u0018\u000e^5p]&#\u0017\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013A\u0002;pa&\u001c\u0017'F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0011i>\u0004\u0018nY\u0019BgNLwM\\7f]R,\u0012\u0001\u0014\t\u0005\u001bJ;D+D\u0001O\u0015\ty\u0005+A\u0005j[6,H/\u00192mK*\u0011\u0011+O\u0001\u000bG>dG.Z2uS>t\u0017BA*O\u0005\ri\u0015\r\u001d\t\u0004\u001bV;\u0014B\u0001,O\u0005\r\u0019V-]\u0001\u0012i>\u0004\u0018nY\u0019BgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002!Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001c''Q:tS\u001etW.\u001a8uA\u00051Ao\u001c9jGN\nq\u0001^8qS\u000e\u001c\u0004%\u0001\tu_BL7mM!tg&<g.\\3oi\u0006\tBo\u001c9jGN\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[25\u0003\u001d!x\u000e]5di\u0001\n\u0001\u0003^8qS\u000e$\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[25\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7-N\u0001\bi>\u0004\u0018nY\u001b!\u0003A!x\u000e]5dk\u0005\u001b8/[4o[\u0016tG/A\tu_BL7-N!tg&<g.\\3oi\u0002*\u0012!\u001b\t\u0003UNl\u0011a\u001b\u0006\u0003M1T!!\u001c8\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001f\u001c\u0006\u0003aF\fa!\u00199bG\",'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uW\n)\u0011\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0003oj\u0004\"\u0001\u000f=\n\u0005eL$\u0001B+oSRDqa\u001f\u000e\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\na!\u00193nS:\u0004\u0013!B:fiV\u0003HCA<\u0000\u0011\u001d\t\t\u0001\ba\u0001\u0003\u0007\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u000b\t\u0019\"\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001b\ty!A\u0004kkBLG/\u001a:\u000b\u0007\u0005E\u0011/A\u0003kk:LG/\u0003\u0003\u0002\u0016\u0005\u001d!\u0001\u0003+fgRLeNZ8)\u0007q\tI\u0002\u0005\u0003\u0002\u0006\u0005m\u0011\u0002BA\u000f\u0003\u000f\u0011!BQ3g_J,W)Y2i\u0003U!Xm\u001d;Xe>twMU3qY&\u001c\u0017mQ8v]R$\u0012a\u001e\u0015\u0004;\u0005\u0015\u0002\u0003BA\u0003\u0003OIA!!\u000b\u0002\b\t!A+Z:u\u0003\r\"Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]NLen\u0011:fCR,Gk\u001c9jGND3AHA\u0013\u0003\u001d\"Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]NLen\u0011:fCR,\u0007+\u0019:uSRLwN\\:)\u0007}\t)#A\fuKN$\u0018J\\2sK6,g\u000e\u001e)beRLG/[8og\"\u001a\u0001%!\n\u0002=Q,7\u000f^'b]V\fG.Q:tS\u001etW.\u001a8u\u001f\u001a\u0014V\r\u001d7jG\u0006\u001c\bfA\u0011\u0002&\u0005qB/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\fE\u000e\\*feZ,'o\u001d\u0015\u0004E\u0005\u0015\u0012A\t;fgR\u0014V\r\u001d7jG\u0006\u0004F.Y2f[\u0016tG\u000fU1si&\fGnU3sm\u0016\u00148\u000fK\u0002$\u0003K\u0001")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private Admin admin;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        this.createTopicWithAssignment(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment(), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment(), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment(), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment(), this.createTopicWithAssignment$default$3());
        this.admin_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
    }

    @Test
    public void testWrongReplicaCount() {
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)2, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause().getClass());
    }

    @Test
    public void testMissingPartitionsInCreateTopics() {
        HashMap<Integer, java.util.List<Integer>> topic6Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic6Placements.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic6Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        HashMap<Integer, java.util.List<Integer>> topic7Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic7Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic7Placements.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        java.util.Map futures = this.admin().createTopics(Arrays.asList(new NewTopic("new-topic6", topic6Placements), new NewTopic("new-topic7", topic7Placements))).values();
        Throwable topic6Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic6")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic6Cause.getClass());
        Assertions.assertTrue((boolean)topic6Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)("Unexpected error message: " + topic6Cause.getMessage()));
        Throwable topic7Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic7")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic7Cause.getClass());
        Assertions.assertTrue((boolean)topic7Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)("Unexpected error message: " + topic7Cause.getMessage()));
    }

    @Test
    public void testMissingPartitionsInCreatePartitions() {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, cause.getClass());
        Assertions.assertTrue((boolean)cause.getMessage().contains("Attempted to add 2 additional partition(s), but only 1 assignment(s) were specified."), (String)("Unexpected error message: " + cause.getMessage()));
    }

    @Test
    public void testIncrementPartitions() {
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        LeaderAndIsr partition1Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        Assertions.assertEquals((int)leader1, (int)partition1Metadata.leader());
        LeaderAndIsr partition2Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        Assertions.assertEquals((int)leader2, (int)partition2Metadata.leader());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Buffer partitionMetadata = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().toSet());
    }

    @Test
    public void testReplicaPlacementAllServers() {
        this.admin().createPartitions(Collections.singletonMap(this.topic3(), NewPartitions.increaseTo((int)7))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 2, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 3, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 4, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 5, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 6, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Assertions.assertEquals((int)7, (int)topicMetadata.partitionMetadata().size());
        CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testReplicaPlacementAllServers$1(partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testReplicaPlacementPartialServers$1(partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ void $anonfun$testReplicaPlacementAllServers$1(MetadataResponse.PartitionMetadata partition) {
        scala.collection.immutable.Set replicas = CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet();
        Assertions.assertEquals((int)4, (int)replicas.size(), (String)("Partition " + partition.partition() + " should have 4 replicas"));
        Assertions.assertTrue((boolean)replicas.subsetOf((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))), (String)"Replicas should only include brokers 0-3");
        Assertions.assertTrue((boolean)partition.leaderId.isPresent(), (String)("Partition " + partition.partition() + " should have a leader"));
        Assertions.assertTrue((boolean)replicas.contains(partition.leaderId.get()), (String)"Leader should be one of the replicas");
    }

    public static final /* synthetic */ void $anonfun$testReplicaPlacementPartialServers$1(MetadataResponse.PartitionMetadata partition) {
        scala.collection.immutable.Set replicas = CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet();
        Assertions.assertEquals((int)2, (int)replicas.size(), (String)("Partition " + partition.partition() + " should have 2 replicas"));
        Assertions.assertTrue((boolean)replicas.subsetOf((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))), (String)"Replicas should only include brokers 0-3");
        Assertions.assertTrue((boolean)partition.leaderId.isPresent(), (String)("Partition " + partition.partition() + " should have a leader"));
        Assertions.assertTrue((boolean)replicas.contains(partition.leaderId.get()), (String)"Leader should be one of the replicas");
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

