/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005u4AAF\f\u00015!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)q\u0007\u0001C\u0001M!)A\b\u0001C\u0001M!)\u0011\t\u0001C\u0001M!)1\t\u0001C\u0001M!)Q\t\u0001C\u0001M!)q\t\u0001C\u0001M!)\u0011\n\u0001C\u0001M!)1\n\u0001C\u0001M!)Q\n\u0001C\u0001M!)q\n\u0001C\u0001M!)\u0011\u000b\u0001C\u0001M!)1\u000b\u0001C\u0001M!)Q\u000b\u0001C\u0005-\")\u0011\r\u0001C\u0001M!)1\r\u0001C\u0001M!)Q\r\u0001C\u0001M!)q\r\u0001C\u0001M!)\u0011\u000e\u0001C\u0001U\")a\u000f\u0001C\u0001o\ny1*\u00194lC\u000e{gNZ5h)\u0016\u001cHOC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tq#A\u0003tKR,\u0006\u000fF\u0001(!\ta\u0002&\u0003\u0002*;\t!QK\\5uQ\t\u00111\u0006\u0005\u0002-k5\tQF\u0003\u0002/_\u0005\u0019\u0011\r]5\u000b\u0005A\n\u0014a\u00026va&$XM\u001d\u0006\u0003eM\nQA[;oSRT\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c.\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u00121!\u000f\t\u0003YiJ!aO\u0017\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\b;fgR\u0014%o\\6feJ+\u0017/^5sK\u0012\u0004&o\u001c9feRLWm\u001d\u0015\u0003\ty\u0002\"\u0001L \n\u0005\u0001k#\u0001\u0002+fgR\f\u0001\u0005^3ti\u000e{g\u000e\u001e:pY2,'OU3rk&\u0014X\r\u001a)s_B,'\u000f^5fg\"\u0012QAP\u0001\u001bi\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d\u0015\u0003\ry\n\u0011\u0006^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON\fE\u000f\u00165f\u000b:$\u0007FA\u0004?\u0003\u0015\"Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4t\u001d>t\u0017I]4t\u001f:d\u0017\u0010\u000b\u0002\t}\u0005iC/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg\u0006#H\u000b[3CK\u001e<\u0017N\\4)\u0005%q\u0014A\b;fgR\u0014%o\\6feJ{G.\u001a(pI\u0016LEMV1mS\u0012\fG/[8oQ\tQa(\u0001\u0012uKN$8i\u001c8ue>dG.\u001a:S_2,gj\u001c3f\u0013\u00124\u0016\r\\5eCRLwN\u001c\u0015\u0003\u0017y\n\u0001\u0005^3ti\u000e{WNY5oK\u0012\u0014v\u000e\\3O_\u0012,\u0017\n\u001a,bY&$\u0017\r^5p]\"\u0012ABP\u0001\u0018i\u0016\u001cH/S:L%\u00064GoQ8nE&tW\rZ'pI\u0016D#!\u0004 \u0002]Q,7\u000f^'vgR\u001cuN\u001c;bS:\fVo\u001c:v[Z{G/\u001a:t\u0013\u001a,6/\u001b8h!J|7-Z:t%>dWm\u001d\u0015\u0003\u001dy\n\u0001c]3u\u0019&\u001cH/\u001a8feB\u0013x\u000e]:\u0015\u0005\u001d:\u0006\"\u0002-\u0010\u0001\u0004I\u0016!\u00029s_B\u001c\bC\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u0006;fgR\\\u0015MZ6b'Nd\u0007+Y:to>\u0014Hm\u001d\u0015\u0003!y\n\u0001\u0005^3ti.\u000bgm[1Tg2\u0004\u0016m]:x_J$7oV5uQNKXNY8mg\"\u0012\u0011CP\u0001\"i\u0016\u001cHoQ8o]\u0016\u001cG/[8og6\u000b\u0007PU3bkRDWj\u001d#fM\u0006,H\u000e\u001e\u0015\u0003%y\n!\u0005^3ti\u000e{gN\\3di&|gn]'bqJ+\u0017-\u001e;i\u001bN,\u0005\u0010\u001d7jG&$\bFA\n?\u0003Q\u0001(/\u001a9be\u0016$UMZ1vYR\u001cuN\u001c4jOR\t1\u000e\u0005\u0002mg:\u0011Q.\u001d\t\u0003]vi\u0011a\u001c\u0006\u0003af\ta\u0001\u0010:p_Rt\u0014B\u0001:\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Il\u0012!\u00049sKB\f'/Z\"p]\u001aLw\r\u0006\u0002lq\")\u00110\u0006a\u0001u\u0006)A.\u001b8fgB\u0019Ad_6\n\u0005ql\"!B!se\u0006L\b")
public class KafkaConfigTest {
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((status, x$1) -> {
            throw new FatalExitError(status);
        });
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testBrokerRequiredProperties() {
        Properties properties = new Properties();
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Missing required configuration \"process.roles\" which has no default value.");
        properties.put("process.roles", "broker");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Missing required configuration \"node.id\" which has no default value.");
        properties.put("node.id", BoxesRunTime.boxToInteger((int)-1));
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Invalid value -1 for configuration node.id: Value must be at least 0");
        properties.put("node.id", BoxesRunTime.boxToInteger((int)0));
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "If using process.roles, either controller.quorum.bootstrap.servers must contain the set of bootstrap controllers or controller.quorum.voters must contain a parseable set of controllers.");
        properties.put("controller.quorum.bootstrap.servers", "localhost:9092");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "requirement failed: controller.listener.names must contain at least one value when running KRaft with just the broker role");
        properties.put("controller.listener.names", "CONTROLLER");
        KafkaConfig$.MODULE$.fromProps(properties);
    }

    @Test
    public void testControllerRequiredProperties() {
        Properties properties = new Properties();
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Missing required configuration \"process.roles\" which has no default value.");
        properties.put("process.roles", "controller");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Missing required configuration \"node.id\" which has no default value.");
        properties.put("node.id", BoxesRunTime.boxToInteger((int)-1));
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "Invalid value -1 for configuration node.id: Value must be at least 0");
        properties.put("node.id", BoxesRunTime.boxToInteger((int)0));
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "If using process.roles, either controller.quorum.bootstrap.servers must contain the set of bootstrap controllers or controller.quorum.voters must contain a parseable set of controllers.");
        properties.put("controller.quorum.bootstrap.servers", "localhost:9092");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "requirement failed: The listeners config must only contain KRaft controller listeners from controller.listener.names when process.roles=controller");
        properties.put("listeners", "CONTROLLER://:9092");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "No security protocol defined for listener CONTROLLER");
        properties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(properties, "requirement failed: The listeners config must only contain KRaft controller listeners from controller.listener.names when process.roles=controller");
        properties.put("controller.listener.names", "CONTROLLER");
        KafkaConfig$.MODULE$.fromProps(properties);
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((int)1, (int)config1.nodeId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "node.id=2"}));
        Assertions.assertEquals((int)2, (int)config2.nodeId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"}));
        Assertions.assertEquals((int)1, (int)config3.nodeId());
        Assertions.assertEquals(List.of("compact"), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "node.id=2"}));
        Assertions.assertEquals((int)2, (int)config4.nodeId());
        Assertions.assertEquals(List.of("compact", "delete"), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testCombinedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testIsKRaftCombinedMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftCombinedMode());
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("If using process.roles, either controller.quorum.bootstrap.servers\n      |must contain the set of bootstrap controllers or controller.quorum.voters must contain a\n      |parseable set of controllers.")).replace("\n", " "));
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty("process.roles").contains("broker");
        boolean hasControllerRole = props.getProperty("process.roles").contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        props.setProperty("controller.listener.names", "SASL_PLAINTEXT");
        if (hasBrokerRole && hasControllerRole) {
            props.setProperty("listeners", brokerListener + "," + controllerListener);
        } else if (hasControllerRole) {
            props.setProperty("listeners", controllerListener);
        } else if (hasBrokerRole) {
            props.setProperty("listeners", brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty("inter.broker.listener.name", "PLAINTEXT");
            props.setProperty("advertised.listeners", "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.key").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.certificate.chain").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.certificates").toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword("ssl.truststore.password").value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword("ssl.keystore.key").value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword("ssl.keystore.certificate.chain").value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword("ssl.truststore.certificates").value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=" + password, "--override", "ssl.key.password=" + password, "--override", "ssl.truststore.password=" + password}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.truststore.password").value());
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "sasl_ssl.oauthbearer.connections.max.reauth.ms=" + expected}));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"node.id=1", "process.roles=controller", "controller.listener.names=CONTROLLER", "controller.quorum.voters=1@localhost:9093,2@localhost:9093", "listeners=CONTROLLER://:9093", "advertised.listeners=CONTROLLER://127.0.0.1:9093"});
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils.tempFile((String)"kafkatest", (String)".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                KafkaConfigTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }
}

