/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.junit.jupiter.api.Assertions;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ClusterTestDefaults(types={Type.KRAFT})
@ScalaSignature(bytes="\u0006\u0005!4Aa\u0002\u0005\u0001\u001f!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003%\u0001\u0011\u0005Q\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u00036\u0001\u0011\u0005!\u0006C\u0003:\u0001\u0011%!\bC\u0003O\u0001\u0011%qJ\u0001\u0010BY2|7-\u0019;f!J|G-^2fe&#7OU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005-a\u0011!B6bM.\f'\"A\u0007\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\tA\"%D\u0001\u001a\u0015\tQ2$\u0001\u0003uKN$(B\u0001\u000f\u001e\u0003\u0019\u0019w.\\7p]*\u00111B\b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014x-\u0003\u0002$3\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003M!\u0002\"a\n\u0001\u000e\u0003!AQA\u0006\u0002A\u0002]\tq\u0005^3ti\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u00148/\u00133TK:$Hk\\\"p]R\u0014x\u000e\u001c7feR\t1\u0006\u0005\u0002\u0012Y%\u0011QF\u0005\u0002\u0005+:LG\u000f\u000b\u0002\u0004_A\u0011\u0001gM\u0007\u0002c)\u0011!'G\u0001\u0004CBL\u0017B\u0001\u001b2\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002UQ,7\u000f^!mY>\u001c\u0017\r^3Qe>$WoY3sg&#7+\u001a8u)>tuN\\\"p]R\u0014x\u000e\u001c7fe\"\"AaL\u001c9\u0003-\u0019wN\u001c;s_2dWM]:\u001e\u0003\r\t\u0011e]3oI\u0006sGMU3dK&4X-\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIN$2aO!J!\tat(D\u0001>\u0015\tq4$\u0001\u0005sKF,Xm\u001d;t\u0013\t\u0001UHA\u000eBY2|7-\u0019;f!J|G-^2fe&#7OU3ta>t7/\u001a\u0005\u0006\u0005\u0016\u0001\raQ\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\u0013\u0019S\u0011aC\u0005\u0003\u0011\u0016\u0013AB\u0011:pW\u0016\u00148+\u001a:wKJDQAS\u0003A\u0002-\u000b\u0001cY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0011\u0005\u0011c\u0015BA'F\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/A\td_:tWm\u0019;B]\u0012\u0014VmY3jm\u0016$2a\u000f)Y\u0011\u0015\tf\u00011\u0001S\u0003Y\u0019wN\u001c;s_2dWM]*pG.,GoU3sm\u0016\u0014\bCA*W\u001b\u0005!&BA+G\u0003\u001dqW\r^<pe.L!a\u0016+\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\t\u000be3\u0001\u0019\u0001.\u0002\u000fI,\u0017/^3tiB\u0011AhW\u0005\u00039v\u0012!$\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIN\u0014V-];fgRDC\u0001\u00010bEB\u0011\u0001gX\u0005\u0003AF\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miN\fQ\u0001^=qKNd\u0013a\u0019\u0013\u0002I&\u0011QMZ\u0001\u0006\u0017J\u000be\t\u0016\u0006\u0003OF\nA\u0001V=qK\u0002")
public class AllocateProducerIdsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testAllocateProducersIdSentToController() {
        BrokerServer sourceBroker = (BrokerServer)this.cluster.brokers().values().stream().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = this.cluster.controllers().values().stream().filter(x$1 -> x$1.config().nodeId() == controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NONE, (Object)allocateResponse.error());
        Assertions.assertEquals((int)1000, (int)allocateResponse.data().producerIdLen());
        Assertions.assertTrue((allocateResponse.data().producerIdStart() >= 0L ? 1 : 0) != 0);
    }

    @ClusterTest(controllers=3)
    public void testAllocateProducersIdSentToNonController() {
        BrokerServer sourceBroker = (BrokerServer)this.cluster.brokers().values().stream().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = this.cluster.controllers().values().stream().filter(x$2 -> x$2.config().nodeId() != controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)allocateResponse.data().errorCode()));
    }

    private AllocateProducerIdsResponse sendAndReceiveAllocateProducerIds(BrokerServer sourceBroker, ControllerServer controllerServer) {
        AllocateProducerIdsRequest allocateRequest = (AllocateProducerIdsRequest)new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(sourceBroker.config().brokerId()).setBrokerEpoch(sourceBroker.lifecycleManager().brokerEpoch())).build();
        return this.connectAndReceive(controllerServer.socketServer(), allocateRequest);
    }

    private AllocateProducerIdsResponse connectAndReceive(SocketServer controllerSocketServer, AllocateProducerIdsRequest request) {
        return (AllocateProducerIdsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controllerSocketServer, (ListenerName)this.cluster.controllerListenerName().get(), ClassTag$.MODULE$.apply(AllocateProducerIdsResponse.class));
    }

    public AllocateProducerIdsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

