/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u001d3AAC\u0006\u0001!!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0016\u0001A\u0003%\u0001\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u0003>\u0001\u0011\u0005A\u0006C\u0003@\u0001\u0011\u0005A\u0006C\u0003B\u0001\u0011\u0005A\u0006C\u0003D\u0001\u0011\u0005A\u0006C\u0003F\u0001\u0011\u0005AFA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003\u00195\tQ!\u001e;jYNT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011c\u0006\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aIR\"A\u0006\n\u0005iY!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"\u0001\u0007\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#\u0001\u0011\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013!\u0002:fO\u0016D(BA\u0013'\u0003\u0011)H/\u001b7\u000b\u0003\u001d\nAA[1wC&\u0011\u0011F\t\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u0001.!\t\u0011b&\u0003\u00020'\t!QK\\5uQ\t!\u0011\u0007\u0005\u00023w5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qe\nQA[;oSRT\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f4\u0005\u0011!Vm\u001d;\u0002\u001bQ,7\u000f\u001e*fC\u0012\u0014\u0015\u0010^3tQ\t)\u0011'A\u0004uKN$\u0018IY:)\u0005\u0019\t\u0014A\u0003;fgRLe\u000eT8dW\"\u0012q!M\u0001\u001ci\u0016\u001cH/\u0016:m'\u00064WMQ1tKZ\"TI\\2pI\u0016,V+\u0013#)\u0005!\t\u0014\u0001\u0007;fgR<UM\\3sCR,W+^5e\u0003N\u0014\u0015m]37i!\u0012\u0011\"\r")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        ObjectRef loggedMessage = ObjectRef.create((Object)None$.MODULE$);
        Logging testLogging = new Logging(null, loggedMessage){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final ObjectRef loggedMessage$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.INFO));
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.DEBUG));
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.WARN));
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.ERROR));
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.TRACE));
            }
            {
                this.loggedMessage$1 = loggedMessage$1;
            }
        };
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.TRACE);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.TRACE)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.DEBUG);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.DEBUG)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.INFO);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.INFO)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.WARN);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.WARN)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.ERROR);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.ERROR)), (Object)((Option)loggedMessage.elem));
    }

    @Test
    public void testReadBytes() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assertions.assertEquals((int)0, (int)Utils.abs((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)-1));
        Assertions.assertEquals((int)0, (int)Utils.abs((int)0));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testInLock() {
        int n;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            n = CoreUtilsTest.$anonfun$testInLock$1(lock);
        }
        finally {
            lock.unlock();
        }
        int result = n;
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertFalse((boolean)lock.isLocked(), (String)"Should be unlocked");
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assertions.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assertions.assertEquals((int)clusterId1.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assertions.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assertions.assertEquals((int)clusterId2.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assertions.assertEquals((int)clusterId.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assertions.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ int $anonfun$testInLock$1(ReentrantLock lock$1) {
        Assertions.assertTrue((boolean)lock$1.isHeldByCurrentThread(), (String)"Should be in lock");
        return 2;
    }
}

