/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005\tMd\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015CQ\u0001\u0013\u0001\u0005\n%CqA\u0015\u0001C\u0002\u0013\u00051\u000b\u0003\u0004e\u0001\u0001\u0006I\u0001\u0016\u0005\u0006K\u0002!\tA\u001a\u0005\u0006k\u0002!\tA\u001a\u0005\u0006o\u0002!\tA\u001a\u0005\u0006s\u0002!\tA\u001a\u0005\u0006w\u0002!\tA\u001a\u0005\u0006{\u0002!\tA\u001a\u0005\u0006\u007f\u0002!\tA\u001a\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000bAq!a\u0002\u0001A\u0003%!\nC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\u0006!9\u00111\u0002\u0001!\u0002\u0013Q\u0005bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\n\u0003C\u0002\u0011\u0013!C\u0005\u0003GB\u0011\"!\u001f\u0001#\u0003%I!a\u001f\t\r\u0005}\u0004\u0001\"\u0001g\u0011\u0019\t\u0019\t\u0001C\u0001M\"1\u0011q\u0011\u0001\u0005\u0002\u0019Da!a#\u0001\t\u00031\u0007BBAH\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0014\u0002!\tA\u001a\u0005\u0007\u0003/\u0003A\u0011\u00014\t\r\u0005m\u0005\u0001\"\u0001g\u0011\u0019\ty\n\u0001C\u0001M\"1\u00111\u0015\u0001\u0005\u0002\u0019Da!a*\u0001\t\u00031\u0007BBAV\u0001\u0011\u0005a\rC\u0004\u00020\u0002!\t!!-\t\r\u0005m\u0007\u0001\"\u0001g\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\u0004\u0001!\tA!\u0002\t\r\t=\u0001\u0001\"\u0001g\u0011\u0019\u0011\u0019\u0002\u0001C\u0001M\"1!q\u0003\u0001\u0005\u0002\u0019DqAa\u0007\u0001\t\u0013\u0011i\u0002\u0003\u0004\u0003&\u0001!\tA\u001a\u0005\u0007\u0005S\u0001A\u0011\u00014\t\r\t5\u0002\u0001\"\u0001g\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAaAa\u000f\u0001\t\u00031\u0007B\u0002B \u0001\u0011\u0005a\r\u0003\u0004\u0003D\u0001!\tA\u001a\u0005\u0007\u0005\u000f\u0002A\u0011\u00014\t\r\t-\u0003\u0001\"\u0001g\u0011\u0019\u0011y\u0005\u0001C\u0001M\"1!1\u000b\u0001\u0005\u0002\u0019DaAa\u0016\u0001\t\u00031\u0007B\u0002B.\u0001\u0011\u0005a\r\u0003\u0004\u0003`\u0001!\tA\u001a\u0005\u0007\u0005G\u0002A\u0011\u00014\u0003\u001fM#xN]1hKR{w\u000e\u001c+fgRT!!\u000f\u001e\u0002\u000bQ|w\u000e\\:\u000b\u0003m\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0011\u0005\u001d\u0003Q\"\u0001\u001d\u000219,woU3mM6\u000bg.Y4fIB\u0013x\u000e]3si&,7\u000fF\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003vi&d'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003=!Xm\u001d;j]\u001e4U-\u0019;ve\u0016\u001cX#\u0001+\u0011\u0007-+v+\u0003\u0002W\u0019\n!A*[:u!\tA&-D\u0001Z\u0015\tQ6,\u0001\u0004d_6lwN\u001c\u0006\u00039v\u000baa]3sm\u0016\u0014(BA\u001e_\u0015\ty\u0006-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0006\u0019qN]4\n\u0005\rL&a\u0002$fCR,(/Z\u0001\u0011i\u0016\u001cH/\u001b8h\r\u0016\fG/\u001e:fg\u0002\n!\u0004^3ti\u000e{gNZ5h)>dun\u001a#je\u0016\u001cGo\u001c:jKN$\u0012a\u001a\t\u0003\u007f!L!!\u001b!\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000b-\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u0007\u0005\u0004\u0018N\u0003\u0002qc\u00069!.\u001e9ji\u0016\u0014(B\u0001:a\u0003\u0015QWO\\5u\u0013\t!XN\u0001\u0003UKN$\u0018\u0001\u000b;fgR\u001cuN\u001c4jOR{Gj\\4ESJ,7\r^8sS\u0016\u001cx+\u001b;i\u001b\u0016$\u0018\rT8h\t&\u0014\bF\u0001\u0004l\u0003}!Xm\u001d;J]\u001a|7i\\7nC:$wJ\\#naRLH)\u001b:fGR|'/\u001f\u0015\u0003\u000f-\f\u0011\u0005^3ti&sgm\\\"p[6\fg\u000eZ(o\u001b&\u001c8/\u001b8h\t&\u0014Xm\u0019;pefD#\u0001C6\u0002AQ,7\u000f^%oM>\u001cu.\\7b]\u0012|e\u000eR5sK\u000e$xN]=Bg\u001aKG.\u001a\u0015\u0003\u0013-\fq\u0005^3ti&sgm\\,ji\"l\u0015n]7bi\u000eDW\r\u001a'fO\u0006\u001c\u0017pS1gW\u0006\u001cuN\u001c4jO\"\u0012!b[\u0001\"i\u0016\u001cH/\u00138g_^KG\u000f['jg6\fGo\u00195fI.\u0013\u0016M\u001a;D_:4\u0017n\u001a\u0015\u0003\u0017-\fQ\u0004Z3gCVdGo\u0015;bi&\u001c\u0017+^8sk6\u0004&o\u001c9feRLWm]\u000b\u0002\u0015\u0006qB-\u001a4bk2$8\u000b^1uS\u000e\fVo\u001c:v[B\u0013x\u000e]3si&,7\u000fI\u0001\u001fI\u00164\u0017-\u001e7u\tft\u0017-\\5d#V|'/^7Qe>\u0004XM\u001d;jKN\fq\u0004Z3gCVdG\u000fR=oC6L7-U;peVl\u0007K]8qKJ$\u0018.Z:!\u0003A\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\u0006\u0006\u0002\u0012\u0005]\u0011qEA\u0016\u0003/\u00022aPA\n\u0013\r\t)\u0002\u0011\u0002\u0004\u0013:$\bbBA\r!\u0001\u0007\u00111D\u0001\u0007gR\u0014X-Y7\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tO\u0003\tIw.\u0003\u0003\u0002&\u0005}!!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007\u0003S\u0001\u0002\u0019\u0001&\u0002\u0015A\u0014x\u000e]3si&,7\u000fC\u0005\u0002.A\u0001\n\u00111\u0001\u00020\u0005qQ\r\u001f;sC\u0006\u0013x-^7f]R\u001c\bCBA\u0019\u0003\u0003\n9E\u0004\u0003\u00024\u0005ub\u0002BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eB(\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0019\u0011q\b!\u0002\u000fA\f7m[1hK&!\u00111IA#\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u007f\u0001\u0005\u0003BA%\u0003#rA!a\u0013\u0002NA\u0019\u0011Q\u0007!\n\u0007\u0005=\u0003)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\n)F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f\u0002\u0005\"CA-!A\u0005\t\u0019AA.\u0003=IwM\\8sK\u001a{'/\\1ui\u0016$\u0007cA \u0002^%\u0019\u0011q\f!\u0003\u000f\t{w\u000e\\3b]\u0006Q\"/\u001e8G_Jl\u0017\r^\"p[6\fg\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\r\u0016\u0005\u0003_\t9g\u000b\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!C;oG\",7m[3e\u0015\r\t\u0019\bQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA<\u0003[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tiH\u000b\u0003\u0002\\\u0005\u001d\u0014A\f;fgR4uN]7biN+8mY3fINLe-\u00117m\t&\u0014Xm\u0019;pe&,7/\u0011:f\u0003Z\f\u0017\u000e\\1cY\u0016D#aE6\u0002eQ,7\u000f\u001e$pe6\fGoU;dG\u0016,Gm]%g\u0003RdU-Y:u\u001f:,G)\u001b:fGR|'/_%t\u0003Z\f\u0017\u000e\\1cY\u0016D#\u0001F6\u0002CQ,7\u000f\u001e$pe6\fGOR1jYN|e.\u00117sK\u0006$\u0017PR8s[\u0006$H/\u001a3)\u0005UY\u0017a\u0005;fgRLuM\\8sK\u001a{'/\\1ui\u0016$\u0007F\u0001\fl\u00035\"Xm\u001d;G_Jl\u0017\r\u001e$bS2\u001c\u0018JZ!mY\u0012K'/Z2u_JLWm]!sKVs\u0017M^1jY\u0006\u0014G.\u001a\u0015\u0003/-\fA\u0004^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g\u000e\u000b\u0002\u0019W\u0006)C/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>t\u0017i\u001d$fCR,(/\u001a\u0015\u00033-\fA\u0004^3ti\u001a{'/\\1u/&$\b.\u00138wC2LGMR3biV\u0014X\r\u000b\u0002\u001bW\u00061C/Z:u\r>\u0014X.\u0019;XSRD\u0017J\u001c<bY&$7JU1giZ+'o]5p]2+g/\u001a7)\u0005mY\u0017a\u000b;fgR4uN]7bi^KG\u000f\u001b*fY\u0016\f7/\u001a,feNLwN\\!oI.\u0013\u0016M\u001a;WKJ\u001c\u0018n\u001c8)\u0005qY\u0017\u0001\u000e;fgR4uN]7bi^KG\u000f\u001b*fY\u0016\f7/\u001a,feNLwN\u001c#fM\u0006,H\u000e^!oIJ+G.Z1tKZ+'o]5p]\"\u0012Qd[\u0001*i\u0016\u001cHOR8s[\u0006$x+\u001b;i'R\fg\u000eZ1m_:,g\t\\1h\u001f:\u0014%o\\6fe\u001a\u000b\u0017\u000e\\:)\u0005yY\u0017\u0001\b;fgR4uN]7bi^KG\u000f[*uC:$\u0017\r\\8oK\u001ac\u0017m\u001a\u000b\u0004O\u0006M\u0006bBA[?\u0001\u0007\u00111L\u0001\u0017g\u0016$8J]1giZ+'o]5p]\u001a+\u0017\r^;sK\"\u001aq$!/\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0p\u0003\u0019\u0001\u0018M]1ng&!\u00111YA_\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b?\u0005\u001d\u00171[Ak!\u0011\tI-a4\u000e\u0005\u0005-'\u0002BAg\u0003{\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003#\fYMA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005]\u0017\u0011\\\r\u0002\u0001e\t\u0011!\u0001\u001euKN$hi\u001c:nCR<\u0016\u000e\u001e5Ti\u0006tG-\u00197p]\u00164E.Y4B]\u0012Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<g)Y5mg\"\u0012\u0001e[\u0001%i\u0016\u001cHOR8s[\u0006$x+\u001b;i\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148O\u00127bOR\u0019q-a9\t\u000f\u0005U\u0016\u00051\u0001\u0002\\!\u001a\u0011%!/)\u000f\u0005\n9-a5\u0002j2\"\u0011q[Am\u0003\u001d#Xm\u001d;G_Jl\u0017\r^,ji\"|W\u000f^*uCRL7-U;peVlg)Y5mg^KG\u000f[8vi&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o](o\u0007>tGO]8mY\u0016\u0014HcA4\u0002p\"9\u0011\u0011\u001f\u0012A\u0002\u0005\u001d\u0013\u0001\u00049s_\u000e,7o\u001d*pY\u0016\u001c\bf\u0001\u0012\u0002:\":!%a2\u0002x\u0006e\u0018aB:ue&twm\u001d\u0017\u0005\u0003w\fy0\t\u0002\u0002~\u0006Q1m\u001c8ue>dG.\u001a:\"\u0005\t\u0005\u0011!\u00052s_.,'\u000fL2p]R\u0014x\u000e\u001c7fe\u00061D/Z:u\r>\u0014X.\u0019;XSRDgj\\%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN\u001cVoY2fK\u0012\u001cxJ\\\"p]R\u0014x\u000e\u001c7feR\u0019qMa\u0002\t\u000f\u0005U6\u00051\u0001\u0002\\!\u001a1%!/)\u000f\r\n9-a5\u0003\u000e1\"\u0011q[Am\u0003q\"Xm\u001d;G_Jl\u0017\r^,ji\"tu.\u00138ji&\fGnQ8oiJ|G\u000e\\3sg\u001ac\u0017mZ!oIN#\u0018M\u001c3bY>tWM\u00127bO\u001a\u000b\u0017\u000e\\:)\u0005\u0011Z\u0017\u0001\u0012;fgR4uN]7bi^KG\u000f\u001b(p\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148O\u00127bO\u0006sG-\u00138ji&\fGnQ8oiJ|G\u000e\\3sg\u001ac\u0017m\u001a$bS2\u001c\bFA\u0013l\u0003\u0019#Xm\u001d;G_Jl\u0017\r^,ji\"|W\u000f^*uCRL7-U;peVl7+^2dK\u0016$7oV5uQ>,H/\u00138ji&\fGnQ8oiJ|G\u000e\\3sg>s'I]8lKJD#AJ6\u00021I,hNV3sg&|g.T1qa&twmQ8n[\u0006tG\r\u0006\u0004\u0002\u0012\t}!\u0011\u0005\u0005\b\u000339\u0003\u0019AA\u000e\u0011\u001d\u0011\u0019c\na\u0001\u0003\u000f\naB]3mK\u0006\u001cXMV3sg&|g.A\u0015uKN$h+\u001a:tS>tW*\u00199qS:<w+\u001b;i-\u0006d\u0017\u000e\u001a*fY\u0016\f7/\u001a,feNLwN\u001c\u0015\u0003Q-\fa\u0005^3tiZ+'o]5p]6\u000b\u0007\u000f]5oO^KG\u000f\u001b(p%\u0016dW-Y:f-\u0016\u00148/[8oQ\tI3.A\u0016uKN$h+\u001a:tS>tW*\u00199qS:<w+\u001b;i\u0013:4\u0018\r\\5e%\u0016dW-Y:f-\u0016\u00148/[8oQ\tQ3.A\u000fsk:4U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3t\u0007>lW.\u00198e)\u0019\t\tB!\u000e\u00038!9\u0011\u0011D\u0016A\u0002\u0005m\u0001b\u0002B\u001dW\u0001\u0007\u0011qF\u0001\tM\u0016\fG/\u001e:fg\u0006qB/Z:u)\u0016\u001cH/\u001b8h\r\u0016\fG/\u001e:f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u0015\u0003Y-\fq\u0004^3ti6+H\u000e^5qY\u00164U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3tQ\ti3.A\u001duKN$\b*\u00198eY\u00164U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3t\r>\u0014h)Z1ukJ,w+\u001b;i\u001d>$U\r]3oI\u0016t7-[3tQ\tq3.\u0001\u0018uKN$\b*\u00198eY\u00164U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3t\r>\u0014XK\\6o_^tg)Z1ukJ,\u0007FA\u0018l\u0003\u0001#Xm\u001d;IC:$G.\u001a$fCR,(/\u001a#fa\u0016tG-\u001a8dS\u0016\u001chi\u001c:GK\u0006$XO]3XSRDWK\\6o_^tg)Z1ukJ,g+\u001a:tS>t\u0007F\u0001\u0019l\u0003Q\"Xm\u001d;IC:$G.\u001a$fCR,(/\u001a#fa\u0016tG-\u001a8dS\u0016\u001chi\u001c:J]Z\fG.\u001b3WKJ\u001c\u0018n\u001c8G_Jl\u0017\r\u001e\u0015\u0003c-\f\u0011\u0004^3ti\n{w\u000e^:ue\u0006\u00048k\u0019:b[J+7m\u001c:eg\"\u0012!g[\u0001\"i\u0016\u001cHoU2sC6\u0014VmY8sIN|E\u000e\u001a*fY\u0016\f7/\u001a,feNLwN\u001c\u0015\u0003g-\fQ\u0003^3tiB\u000b'o]3OC6,\u0017I\u001c3MKZ,G\u000e\u000b\u00025W\u0006\tC/Z:u!\u0006\u00148/\u001a(b[\u0016\fe\u000e\u001a'fm\u0016dw+\u001b;i\u001d>,\u0015/^1mg\"\u0012Qg[\u0001\"i\u0016\u001cH\u000fU1sg\u0016t\u0015-\\3B]\u0012dUM^3m/&$\bNT8Ok6\u0014WM\u001d\u0015\u0003m-Ds\u0001\u0001B5\u0005_\u0012\t\bE\u0002m\u0005WJ1A!\u001cn\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u000b")
public class StorageToolTest {
    private final java.util.List<Feature> testingFeatures = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])Feature.FEATURES).toList()).asJava();
    private final Properties defaultStaticQuorumProperties = new Properties();
    private final Properties defaultDynamicQuorumProperties;

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.put("controller.listener.names", "CONTROLLER");
        properties.put("listeners", "CONTROLLER://:9092");
        return properties;
    }

    public java.util.List<Feature> testingFeatures() {
        return this.testingFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound problem:\n  " + tempDir.toString() + " is not formatted.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found problem:\n  " + tempDir.toString() + " does not exist\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found problem:\n  " + tempFile.toString() + " is not a directory\n\n"), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedKRaftConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    public Properties defaultStaticQuorumProperties() {
        return this.defaultStaticQuorumProperties;
    }

    public Properties defaultDynamicQuorumProperties() {
        return this.defaultDynamicQuorumProperties;
    }

    private int runFormatCommand(ByteArrayOutputStream stream, Properties properties, scala.collection.immutable.Seq<String> extraArguments, boolean ignoreFormatted) {
        int n;
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            String configPathString = new File(tempDir.getAbsolutePath(), "format.props").toString();
            PropertiesUtils.writePropertiesFile((Properties)properties, (String)configPathString, (boolean)true);
            ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ"}));
            if (ignoreFormatted) {
                arguments.$plus$eq((Object)"--ignore-formatted");
            }
            arguments.$plus$eq((Object)"--config");
            arguments.$plus$eq((Object)configPathString);
            extraArguments.foreach((Function1 & Serializable)x$1 -> (ListBuffer)arguments.$plus$eq(x$1));
            n = StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
        }
        finally {
            Utils.delete((File)tempDir);
        }
        return n;
    }

    private scala.collection.immutable.Seq<String> runFormatCommand$default$3() {
        return Nil$.MODULE$;
    }

    private boolean runFormatCommand$default$4() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
        ((IterableOnceOps)availableDirs.tail()).foreach((Function1 & Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(stream, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils.tempDirectory(null, null);
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDir1 + "," + unavailableDir1);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertFalse((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting log directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatFailsOnAlreadyFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertTrue((boolean)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream2, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false)).getMessage().contains("already formatted. Use --ignore-formatted to ignore this directory and format the others"));
    }

    @Test
    public void testIgnoreFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, true));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File unavailableDir2 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", unavailableDir1 + "," + unavailableDir2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false)).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.8-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersionAsFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"metadata.version=20", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithInvalidFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Unsupported feature: non.existent.feature. Supported features are: eligible.leader.replicas.version, group.version, kraft.version, transaction.version", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"non.existent.feature=20", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @Test
    public void testFormatWithInvalidKRaftVersionLevel() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"No feature:kraft.version with feature level 999", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=999", (List)new .colon.colon((Object)"--standalone", (List)Nil$.MODULE$))), false)).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersionAndKRaftVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.7-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersionDefaultAndReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.6-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.6-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithStandaloneFlagOnBrokerFails() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        Assertions.assertEquals((Object)"You can only use --standalone on a controller.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithStandaloneFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithStandaloneFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialControllersFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @ParameterizedTest
    @ValueSource(strings={"controller", "broker,controller"})
    public void testFormatWithoutStaticQuorumFailsWithoutInitialControllersOnController(String processRoles) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        if (processRoles.contains("broker")) {
            properties.setProperty("listeners", "PLAINTEXT://:9092,CONTROLLER://:9093");
            properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092,CONTROLLER://127.0.0.1:9093");
        }
        properties.setProperty("process.roles", processRoles);
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithNoInitialControllersSucceedsOnController(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--no-initial-controllers"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndStandaloneFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--standalone"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --standalone/-s: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --initial-controllers/-I: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithoutStaticQuorumSucceedsWithoutInitialControllersOnBroker() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("listeners", "PLAINTEXT://:9092");
        properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    private int runVersionMappingCommand(ByteArrayOutputStream stream, String releaseVersion) {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version-mapping"}));
        if (releaseVersion != null) {
            arguments.$plus$eq((Object)"--release-version");
            arguments.$plus$eq((Object)releaseVersion);
        }
        return StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
    }

    @Test
    public void testVersionMappingWithValidReleaseVersion() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runVersionMappingCommand(stream, MetadataVersion.MINIMUM_VERSION.toString()));
        String output = stream.toString();
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        Assertions.assertTrue((boolean)output.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + output));
        CollectionConverters$.MODULE$.ListHasAsScala(Feature.PRODUCTION_FEATURES).asScala().foreach((Function1 & Serializable)feature -> {
            StorageToolTest.$anonfun$testVersionMappingWithValidReleaseVersion$1(metadataVersion, output, feature);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testVersionMappingWithNoReleaseVersion() {
        new Properties().putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runVersionMappingCommand(stream, null));
        String output = stream.toString();
        MetadataVersion metadataVersion = MetadataVersion.latestProduction();
        Assertions.assertTrue((boolean)output.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + output));
        CollectionConverters$.MODULE$.ListHasAsScala(Feature.PRODUCTION_FEATURES).asScala().foreach((Function1 & Serializable)feature -> {
            StorageToolTest.$anonfun$testVersionMappingWithNoReleaseVersion$1(metadataVersion, output, feature);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testVersionMappingWithInvalidReleaseVersion() {
        new Properties().putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runVersionMappingCommand(stream, "2.9-IV2"));
        Assertions.assertEquals((Object)("Unknown release version '2.9-IV2'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version()), (Object)exception.getMessage());
        TerseFailure exception2 = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runVersionMappingCommand(stream, "invalid"));
        Assertions.assertEquals((Object)("Unknown release version 'invalid'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version()), (Object)exception2.getMessage());
    }

    private int runFeatureDependenciesCommand(ByteArrayOutputStream stream, scala.collection.immutable.Seq<String> features) {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"feature-dependencies"}));
        features.foreach((Function1 & Serializable)feature -> {
            arguments.$plus$eq((Object)"--feature");
            return (ListBuffer)arguments.$plus$eq(feature);
        });
        return StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
    }

    @Test
    public void testTestingFeatureDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"feature-dependencies", "--feature", "test.feature.version=2"});
        StorageTool$.MODULE$.runFeatureDependenciesCommand(namespace, new PrintStream(stream), this.testingFeatures());
        String output = stream.toString().trim();
        System.out.println(output);
        MetadataVersion latestTestingVersion = MetadataVersion.latestTesting();
        String latestTestingVersionString = "metadata.version=" + latestTestingVersion.featureLevel() + " (" + latestTestingVersion.version() + ")";
        Assertions.assertEquals((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("test.feature.version=2 requires:\n         |    " + latestTestingVersionString + "\n         |")).trim(), (Object)output);
    }

    @Test
    public void testMultipleFeatureDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        .colon.colon features = new .colon.colon((Object)"transaction.version=2", (List)new .colon.colon((Object)"group.version=1", (List)Nil$.MODULE$));
        Assertions.assertEquals((int)0, (int)this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)features));
        String output = stream.toString().trim();
        System.out.println(output);
        Assertions.assertEquals((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("transaction.version=2 has no dependencies.\n         |group.version=1 has no dependencies.\n         |")).trim(), (Object)output);
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithNoDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"metadata.version=17", (List)Nil$.MODULE$)));
        String output = stream.toString().trim();
        Assertions.assertEquals((Object)"metadata.version=17 (3.7-IV2) has no dependencies.", (Object)output);
    }

    @Test
    public void testHandleFeatureDependenciesForUnknownFeature() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"unknown.feature.version=1", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Unknown feature: unknown.feature.version", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithUnknownFeatureVersion() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"transaction.version=1000", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Feature level 1000 is not supported for feature transaction.version", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForInvalidVersionFormat() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"metadata.version=invalid", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Invalid version format: invalid for feature metadata.version", (Object)exception.getMessage());
    }

    @Test
    public void testBootstrapScramRecords() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(((File)availableDirs.head()).toString()).read();
        List scramRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(bootstrapMetadata.records()).asScala().filter((Function1 & Serializable)apiMessageAndVersion -> BoxesRunTime.boxToBoolean((boolean)StorageToolTest.$anonfun$testBootstrapScramRecords$1(apiMessageAndVersion)))).map((Function1 & Serializable)apiMessageAndVersion -> (UserScramCredentialRecord)apiMessageAndVersion.message())).toList();
        Assertions.assertEquals((int)2, (int)scramRecords.size());
        Assertions.assertEquals((Object)"alice", (Object)((UserScramCredentialRecord)scramRecords.head()).name());
        Assertions.assertEquals((Object)"bob", (Object)((UserScramCredentialRecord)scramRecords.last()).name());
    }

    @Test
    public void testScramRecordsOldReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.4", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((Object)"SCRAM is only supported in metadata.version 3.5-IV2 or later.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)56))), (Object)StorageTool$.MODULE$.parseNameAndLevel("foo.bar=56"));
    }

    @Test
    public void testParseNameAndLevelWithNoEquals() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version5: equals sign not found.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version5")).getMessage());
    }

    @Test
    public void testParseNameAndLevelWithNoNumber() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version=foo: unable to parse foo as a short.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version=foo")).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(ByteArrayOutputStream stream$1, File dir) {
        Assertions.assertTrue((boolean)stream$1.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting data directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dir}))), (String)("Failed to find content in output: " + stream$1.toString()));
    }

    public static final /* synthetic */ void $anonfun$testVersionMappingWithValidReleaseVersion$1(MetadataVersion metadataVersion$1, String output$1, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$1);
        Assertions.assertTrue((boolean)output$1.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + output$1));
    }

    public static final /* synthetic */ void $anonfun$testVersionMappingWithNoReleaseVersion$1(MetadataVersion metadataVersion$2, String output$2, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$2);
        Assertions.assertTrue((boolean)output$2.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + output$2));
    }

    public static final /* synthetic */ boolean $anonfun$testBootstrapScramRecords$1(ApiMessageAndVersion apiMessageAndVersion) {
        return apiMessageAndVersion.message() instanceof UserScramCredentialRecord;
    }

    public StorageToolTest() {
        this.defaultStaticQuorumProperties().setProperty("process.roles", "broker");
        this.defaultStaticQuorumProperties().setProperty("node.id", "0");
        this.defaultStaticQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultStaticQuorumProperties().setProperty("controller.quorum.voters", "100@localhost:9093");
        this.defaultDynamicQuorumProperties = new Properties();
        this.defaultDynamicQuorumProperties().setProperty("process.roles", "controller");
        this.defaultDynamicQuorumProperties().setProperty("node.id", "0");
        this.defaultDynamicQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultDynamicQuorumProperties().setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        this.defaultDynamicQuorumProperties().setProperty("listeners", "CONTROLLER://:9093");
        this.defaultDynamicQuorumProperties().setProperty("advertised.listeners", "CONTROLLER://127.0.0.1:9093");
        this.defaultDynamicQuorumProperties().setProperty("unstable.api.versions.enable", "true");
        this.defaultDynamicQuorumProperties().setProperty("unstable.feature.versions.enable", "true");
    }
}

