/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.ReplicaManager;
import kafka.server.share.SharePartition;
import kafka.server.share.SharePartitionManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedStateEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.apache.kafka.server.share.acknowledge.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.persister.NoOpShareStatePersister;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.ReadShareGroupStateParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateResult;
import org.apache.kafka.server.share.persister.TopicData;
import org.apache.kafka.server.share.persister.WriteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.WriteShareGroupStateResult;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class SharePartitionTest {
    private static final String ACQUISITION_LOCK_NEVER_GOT_RELEASED = "Acquisition lock never got released.";
    private static final String GROUP_ID = "test-group";
    private static final int MAX_DELIVERY_COUNT = 5;
    private static final TopicIdPartition TOPIC_ID_PARTITION = new TopicIdPartition(Uuid.randomUuid(), 0, "test-topic");
    private static final String MEMBER_ID = "member-1";
    private static Timer mockTimer;
    private static final Time MOCK_TIME;
    private static final short MAX_IN_FLIGHT_MESSAGES = 200;
    private static final int ACQUISITION_LOCK_TIMEOUT_MS = 100;
    private static final int DEFAULT_MAX_WAIT_ACQUISITION_LOCK_TIMEOUT_MS = 300;
    private static final int MAX_FETCH_RECORDS = Integer.MAX_VALUE;

    @BeforeEach
    public void setUp() {
        mockTimer = new SystemTimerReaper("share-group-lock-timeout-test-reaper", (Timer)new SystemTimer("share-group-lock-test-timeout"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        mockTimer.close();
    }

    @Test
    public void testRecordStateValidateTransition() {
        Assertions.assertThrows(NullPointerException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(null));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ARCHIVED));
    }

    @Test
    public void testRecordStateForId() {
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)SharePartition.RecordState.forId((byte)0));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)SharePartition.RecordState.forId((byte)1));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)SharePartition.RecordState.forId((byte)2));
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)SharePartition.RecordState.forId((byte)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharePartition.RecordState.forId((byte)5));
    }

    @Test
    public void testMaybeInitialize() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        Assertions.assertNotNull(sharePartition.cachedState().get(11L));
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertEquals((long)15L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).batchState());
        Assertions.assertEquals((int)3, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).offsetState());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsEarliest() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.EARLIEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-2L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsLatest() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.LATEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsByDuration() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        ShareGroupAutoOffsetResetStrategy resetStrategy = (ShareGroupAutoOffsetResetStrategy)Mockito.mock(ShareGroupAutoOffsetResetStrategy.class);
        long expectedTimestamp = MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L);
        Mockito.when((Object)resetStrategy.type()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.StrategyType.BY_DURATION);
        Mockito.when((Object)resetStrategy.timestamp()).thenReturn((Object)expectedTimestamp);
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)resetStrategy);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L), 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)expectedTimestamp), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigNotPresent() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.empty());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForLatestTimestampThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.empty());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForEarliestTimestampThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.EARLIEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-2L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForByDurationThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        ShareGroupAutoOffsetResetStrategy resetStrategy = (ShareGroupAutoOffsetResetStrategy)Mockito.mock(ShareGroupAutoOffsetResetStrategy.class);
        long expectedTimestamp = MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L);
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)resetStrategy);
        Mockito.when((Object)resetStrategy.type()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.StrategyType.BY_DURATION);
        Mockito.when((Object)resetStrategy.timestamp()).thenReturn((Object)expectedTimestamp);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)expectedTimestamp), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeSharePartitionAgain() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)1))).readState((ReadShareGroupStateParameters)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaybeInitializeSharePartitionAgainConcurrentRequests() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList results = new ArrayList(10);
        try {
            for (int i = 0; i < 10; ++i) {
                executorService.submit(() -> results.add(sharePartition.maybeInitialize()));
            }
        }
        finally {
            if (!executorService.awaitTermination(30L, TimeUnit.MILLISECONDS)) {
                executorService.shutdown();
            }
        }
        Assertions.assertTrue((boolean)results.stream().allMatch(CompletableFuture::isDone));
        Assertions.assertFalse((boolean)results.stream().allMatch(CompletableFuture::isCompletedExceptionally));
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)1))).readState((ReadShareGroupStateParameters)Mockito.any());
    }

    @Test
    public void testMaybeInitializeWithEmptyStateBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)5, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeInitializeWithErrorPartitionResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.NOT_COORDINATOR.code(), (String)Errors.NOT_COORDINATOR.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (String)Errors.COORDINATOR_NOT_AVAILABLE.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.COORDINATOR_LOAD_IN_PROGRESS.code(), (String)Errors.COORDINATOR_LOAD_IN_PROGRESS.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, GroupIdNotFoundException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, UnknownTopicOrPartitionException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.FENCED_STATE_EPOCH.code(), (String)Errors.FENCED_STATE_EPOCH.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, FencedStateEpochException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.FENCED_LEADER_EPOCH.code(), (String)Errors.FENCED_LEADER_EPOCH.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, NotLeaderOrFollowerException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.UNKNOWN_SERVER_ERROR.code(), (String)Errors.UNKNOWN_SERVER_ERROR.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, UnknownServerException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidStartOffsetStateBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)6L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidTopicIdResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(Uuid.randomUuid(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidPartitionResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)1, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNoOpShareStatePersister() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNullResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(null));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNullTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(null);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithEmptyTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.emptyList());
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithReadException() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new RuntimeException("Read exception")));
        SharePartition sharePartition1 = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition1.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, RuntimeException.class);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition1.partitionState());
        persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Read exception")});
        SharePartition sharePartition2 = SharePartitionBuilder.builder().withPersister(persister).build();
        Assertions.assertThrows(RuntimeException.class, () -> ((SharePartition)sharePartition2).maybeInitialize());
    }

    @Test
    public void testAcquireSingleRecord() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(1);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 1);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)1L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testAcquireMultipleRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).firstOffset());
        Assertions.assertEquals((long)14L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquireWithMaxFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 10, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(0L, 4L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        records = this.memoryRecords(25);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 10, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 20);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(5L, 24L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).firstOffset());
        Assertions.assertEquals((long)24L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testAcquireWithMultipleBatchesAndMaxFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        this.memoryRecordsBuilder(buffer, 5, 10L).close();
        this.memoryRecordsBuilder(buffer, 15, 15L).close();
        this.memoryRecordsBuilder(buffer, 15, 30L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 10, new FetchPartitionData(Errors.NONE, 20L, 10L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 20);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(10L, 29L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).firstOffset());
        Assertions.assertEquals((long)29L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquireMultipleRecordsWithOverlapAndNewBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 0L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        records = this.memoryRecords(10, 0L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(this.memoryRecords(5, 5L), 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testAcquireSameBatchAgain() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        MemoryRecords subsetRecords = this.memoryRecords(2, 10L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)subsetRecords, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquireWithEmptyFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetInitialState() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithCachedStateAcquired() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithFindAndCachedStateEmpty() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.findNextFetchOffset(true);
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithFindAndCachedState() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.findNextFetchOffset(true);
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testCanAcquireRecordsWithEmptyCache() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(1).build();
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsWithCachedDataAndLimitNotReached() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(6).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsWithCachedDataAndLimitReached() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(1).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testMaybeAcquireAndReleaseFetchLock() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).build();
        sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock());
        Assertions.assertFalse((boolean)sharePartition.maybeAcquireFetchLock());
        sharePartition.releaseFetchLock();
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock());
    }

    @Test
    public void testAcknowledgeSingleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(1, 0L);
        MemoryRecords records2 = this.memoryRecords(1, 1L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 10L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 1);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 10L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 1);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(1L, 1L, Collections.singletonList((byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)2L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).offsetState());
    }

    @Test
    public void testAcknowledgeMultipleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(10, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 10);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 14L, Collections.singletonList((byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testAcknowledgeMultipleRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(5, 10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 9);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 6L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 18L, Arrays.asList((byte)2, (byte)2, (byte)2, (byte)2, (byte)2, (byte)0, (byte)0, (byte)0, (byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcknowledgeMultipleSubsetRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 11);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 18L, Arrays.asList((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcknowledgeOutOfRangeCachedData() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 15L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(20L, 25L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRequestException.class);
    }

    @Test
    public void testAcknowledgeOutOfRangeCachedDataFirstBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 0L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        records = this.memoryRecords(5, 20L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        List<ShareAcknowledgementBatch> acknowledgeBatches = Arrays.asList(new ShareAcknowledgementBatch(0L, 10L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(20L, 24L, Collections.singletonList((byte)1)));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, acknowledgeBatches);
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRequestException.class);
        records = this.memoryRecords(6, 5L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 6);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, acknowledgeBatches);
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
    }

    @Test
    public void testAcknowledgeWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        CompletableFuture ackResult = sharePartition.acknowledge("member-2", Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
    }

    @Test
    public void testAcknowledgeWhenOffsetNotAcquired() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 8L, Collections.singletonList((byte)3))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 8L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
    }

    @Test
    public void testAcknowledgeRollbackWithFullBatchError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 15L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(15L, 19L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(15L, 19L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcknowledgeRollbackWithSubsetError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 15L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(15L, 19L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(16L, 19L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcquireReleasedRecord() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(12L, 13L, Collections.singletonList((byte)2))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(12L, 13L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testAcquireReleasedRecordMultipleBatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 23L);
        MemoryRecords records4 = this.memoryRecords(5, 28L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records3, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)28L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records4, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records4, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)33L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(12L, 30L, Collections.singletonList((byte)2))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchMemberId());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(28L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(29L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(30L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(31L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(32L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 3);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(12L, 14L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records3, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        MemoryRecords subsetRecords = this.memoryRecords(2, 17L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)subsetRecords, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(17L, 18L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        subsetRecords = this.memoryRecords(1, 28L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)subsetRecords, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 1);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(28L, 28L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false)), 3);
        List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords = this.expectedAcquiredRecords(15L, 16L, 2);
        expectedAcquiredRecords.addAll(this.expectedAcquiredRecords(19L, 19L, 2));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecords.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)29L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testAcquisitionLockForAcquiringSingleRecord() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(1), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null && sharePartition.timer().size() == 0, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockForAcquiringMultipleRecords() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockForAcquiringMultipleRecordsWithOverlapAndNewBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockForAcquiringSameBatchAgain() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingSingleRecordBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 10L, 0L, (Records)this.memoryRecords(1, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 0L, Collections.singletonList((byte)2))));
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleRecordBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 14L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleRecordBatchWithGapOffsets() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(5, 10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        MemoryRecords records3 = this.memoryRecords(2, 1L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 18L, Collections.singletonList((byte)1))));
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 1L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testAcquisitionLockForAcquiringSubsetBatchAgain() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(8, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && sharePartition.cachedState().size() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 3L, (Records)this.memoryRecords(3, 12L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleSubsetRecordBatchWithGapOffsets() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 18L, Arrays.asList((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap1 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap1.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap2 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap2.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap1.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState()) && expectedOffsetStateMap2.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockTimeoutCauseMaxDeliveryCountExceed() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.ARCHIVED && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 2 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockTimeoutCauseSPSOMoveForward() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(5, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(0L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(1L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
    }

    @Test
    public void testAcquisitionLockTimeoutCauseSPSOMoveForwardAndClearCachedState() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 3L, 0L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.cachedState().isEmpty() && sharePartition.nextFetchOffset() == 10L, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcknowledgeAfterAcquisitionLockTimeout() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockAfterDifferentAcknowledges() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 6L, Collections.singletonList((byte)2))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(8L, 9L, Collections.singletonList((byte)1))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockOnBatchWithWriteShareGroupStateFailure() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && sharePartition.cachedState().size() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockOnOffsetWithWriteShareGroupStateFailure() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(6, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(8L, 9L, Collections.singletonList((byte)1))));
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.cachedState().size() == 1 && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testReleaseSingleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 10L, 0L, (Records)this.memoryRecords(1, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testReleaseMultipleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testReleaseMultipleAcknowledgedRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records0 = this.memoryRecords(5, 0L);
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecords records2 = this.memoryRecords(9, 10L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records0, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 18L, Collections.singletonList((byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcknowledgedMultipleSubsetRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 18L, Arrays.asList((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(1, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(10L, 18L, Arrays.asList((byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsWithAnotherMemberAndSubsetAcknowledged() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(10L, 18L, Arrays.asList((byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        sharePartition.acknowledge("member-2", Collections.singletonList(new ShareAcknowledgementBatch(5L, 5L, Collections.singletonList((byte)1))));
        releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)6L, (long)sharePartition.nextFetchOffset());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsForEmptyCachedData() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testReleaseAcquiredRecordsAfterDifferentAcknowledges() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 6L, Collections.singletonList((byte)2))));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(8L, 9L, Collections.singletonList((byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetAfterReleaseAcquiredRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)this.memoryRecords(10, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)2))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetAfterReleaseAcquiredRecordsSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 50L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(Arrays.asList(new ShareAcknowledgementBatch(13L, 16L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(17L, 19L, Collections.singletonList((byte)3)), new ShareAcknowledgementBatch(20L, 24L, Collections.singletonList((byte)2)))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetCacheCleared() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 50L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(Arrays.asList(new ShareAcknowledgementBatch(10L, 12L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(13L, 16L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(17L, 19L, Collections.singletonList((byte)3)), new ShareAcknowledgementBatch(20L, 24L, Collections.singletonList((byte)2)))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testReleaseAcquiredRecordsSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)this.memoryRecords(7, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 7L, Collections.singletonList((byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testReleaseBatchWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertTrue((boolean)releaseResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)releaseResult, GroupIdNotFoundException.class);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
    }

    @Test
    public void testReleaseOffsetWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(6, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(8L, 9L, Collections.singletonList((byte)1))));
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertTrue((boolean)releaseResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)releaseResult, GroupIdNotFoundException.class);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).memberId());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).memberId());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).memberId());
    }

    @Test
    public void testAcquisitionLockOnReleasingMultipleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockOnReleasingAcknowledgedMultipleSubsetRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(2, 10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(6L, 18L, Arrays.asList((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testLsoMovementOnInitializationSharePartition() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.updateCacheAndOffsets(0L);
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        sharePartition.updateCacheAndOffsets(5L);
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.endOffset());
    }

    @Test
    public void testLsoMovementForArchivingBatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 12L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 17L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 22L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 27L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 32L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(2L, 6L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(12L, 16L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(22L, 26L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(27L, 31L, Collections.singletonList((byte)3))));
        sharePartition.updateCacheAndOffsets(20L);
        Assertions.assertEquals((long)22L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)36L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)6, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementForArchivingOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(4L, 8L, Collections.singletonList((byte)1))));
        sharePartition.updateCacheAndOffsets(5L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartAndEndBatchesNotFullMatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        sharePartition.updateCacheAndOffsets(8L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)8L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatchesPostAcceptAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(7L, 8L, Collections.singletonList((byte)1))));
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatchesPostReleaseAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(7L, 8L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementToEndOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(7L, 8L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementToEndOffsetWhereEndOffsetIsAvailable() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(7L, 8L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(11L, 11L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)11L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementAheadOfEndOffsetPostAcknowledgment() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(7L, 8L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(12L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementAheadOfEndOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 7L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(14L);
        Assertions.assertEquals((long)14L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
    }

    @Test
    public void testLsoMovementWithGapsInCachedStateMap() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 2L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records3, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(18L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
    }

    @Test
    public void testLsoMovementWithGapsInCachedStateMapAndAcknowledgedBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 2L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testLsoMovementPostGapsInAcknowledgments() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = this.memoryRecordsBuilder(5, 10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 6L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 18L, Arrays.asList((byte)2, (byte)2, (byte)2, (byte)2, (byte)2, (byte)0, (byte)0, (byte)0, (byte)2))));
        sharePartition.updateCacheAndOffsets(18L);
        Assertions.assertEquals((long)18L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 20L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 25L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 30L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 35L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(6L, 7L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(8L, 8L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(25L, 29L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(35L, 37L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(24L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)39L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)7, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(22L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(23L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(24L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(35L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(36L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(37L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(38L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(39L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(35L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovementToStartOfBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovementToMiddleOfBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovement() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 20L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 25L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 30L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 35L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(6L, 7L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(8L, 8L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(25L, 29L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(35L, 37L, Collections.singletonList((byte)2))));
        sharePartition.updateCacheAndOffsets(24L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)39L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)7, (int)sharePartition.cachedState().size());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap1 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap1.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap2 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap2.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(22L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(23L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(24L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap3 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap3.put(35L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(36L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(37L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(38L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(39L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().equals(expectedOffsetStateMap1) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState().equals(expectedOffsetStateMap2) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(35L)).offsetState().equals(expectedOffsetStateMap3);
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovementToStartOfBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        TestUtils.waitForCondition(() -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.ARCHIVED && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovementToMiddleOfBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().equals(expectedOffsetStateMap) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.ARCHIVED;
        }, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
    }

    @Test
    public void testScheduleAcquisitionLockTimeoutValueFromGroupConfig() {
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        int expectedDurationMs = 500;
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareRecordLockDurationMs()).thenReturn((Object)expectedDurationMs);
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withGroupConfigManager(groupConfigManager).build();
        SharePartition.AcquisitionLockTimerTask timerTask = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)2))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig)).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs, (long)timerTask.delayMs);
    }

    @Test
    public void testScheduleAcquisitionLockTimeoutValueUpdatesSuccessfully() {
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        int expectedDurationMs1 = 500;
        int expectedDurationMs2 = 1000;
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareRecordLockDurationMs()).thenReturn((Object)expectedDurationMs1).thenReturn((Object)expectedDurationMs2);
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withGroupConfigManager(groupConfigManager).build();
        SharePartition.AcquisitionLockTimerTask timerTask1 = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)2))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig)).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs1, (long)timerTask1.delayMs);
        SharePartition.AcquisitionLockTimerTask timerTask2 = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)4))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig, (VerificationMode)Mockito.times((int)2))).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs2, (long)timerTask2.delayMs);
    }

    @Test
    public void testAcknowledgeBatchAndOffsetPostLsoMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(12L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(2L, 6L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)2))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchAcquisitionLockTimeoutTask());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcknowledgeBatchPostLsoMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 20L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(14L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(2L, 14L, Collections.singletonList((byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testLsoMovementThenAcquisitionLockTimeoutThenAcknowledge() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchAcquisitionLockTimeoutTask());
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 7L && sharePartition.cachedState().isEmpty() && sharePartition.startOffset() == 7L && sharePartition.endOffset() == 7L, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(2L, 14L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementThenAcquisitionLockTimeoutThenAcknowledgeBatchLastOffsetAheadOfStartOffsetBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(2, 1L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.updateCacheAndOffsets(3L);
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 3L && sharePartition.cachedState().isEmpty() && sharePartition.startOffset() == 3L && sharePartition.endOffset() == 3L, (long)300L, () -> ACQUISITION_LOCK_NEVER_GOT_RELEASED);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(2, 3L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(3, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)8L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(1L, 7L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testWriteShareGroupStateWithNullResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(null));
        CompletableFuture result = sharePartition.writeShareGroupState(Collections.emptyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
    }

    @Test
    public void testWriteShareGroupStateWithNullTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(null);
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, IllegalStateException.class);
    }

    @Test
    public void testWriteShareGroupStateWithInvalidTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.emptyList());
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Arrays.asList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.emptyList()), new TopicData(Uuid.randomUuid(), Collections.emptyList())));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.emptyList())));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(Uuid.randomUuid(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Arrays.asList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message()), PartitionFactory.newPartitionErrorData((int)1, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)1, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
    }

    @Test
    public void testWriteShareGroupStateWithWriteException() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition1 = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new RuntimeException("Write exception")));
        CompletableFuture writeResult = sharePartition1.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)writeResult, IllegalStateException.class);
        persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition2 = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Write exception")});
        Assertions.assertThrows(RuntimeException.class, () -> sharePartition2.writeShareGroupState(ArgumentMatchers.anyList()));
    }

    @Test
    public void testWriteShareGroupState() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertNull(result.join());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
    }

    @Test
    public void testWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NOT_COORDINATOR.code(), (String)Errors.NOT_COORDINATOR.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (String)Errors.COORDINATOR_NOT_AVAILABLE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.COORDINATOR_LOAD_IN_PROGRESS.code(), (String)Errors.COORDINATOR_LOAD_IN_PROGRESS.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, CoordinatorNotAvailableException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, GroupIdNotFoundException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, UnknownTopicOrPartitionException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.FENCED_STATE_EPOCH.code(), (String)Errors.FENCED_STATE_EPOCH.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, FencedStateEpochException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.FENCED_LEADER_EPOCH.code(), (String)Errors.FENCED_LEADER_EPOCH.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, NotLeaderOrFollowerException.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_SERVER_ERROR.code(), (String)Errors.UNKNOWN_SERVER_ERROR.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)result, UnknownServerException.class);
    }

    @Test
    public void testWriteShareGroupStateWithNoOpShareStatePersister() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        List<PersisterStateBatch> stateBatches = Arrays.asList(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3));
        CompletableFuture result = sharePartition.writeShareGroupState(stateBatches);
        Assertions.assertNull(result.join());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeAccept() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(250, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 249L, Collections.singletonList((byte)1))));
        Assertions.assertEquals((long)250L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeReject() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(250, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 249L, Collections.singletonList((byte)3))));
        Assertions.assertEquals((long)250L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeRelease() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(250, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 249L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsFromBeginningForBatchSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 12L, Collections.singletonList((byte)1))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(12L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(13L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)13L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsFromBeginningForEntireBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 14L, Collections.singletonList((byte)3))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsInBetween() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)3))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAllRecordsInCachedStateAreAcknowledged() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 29L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)30L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateMultipleAcquisitionsAndAcknowledgements() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(20, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(20, 20L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(20, 40L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 19L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)20L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)59L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)60L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(20, 60L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(20L, 49L, Collections.singletonList((byte)1))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(40L)).offsetState().get(49L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(40L)).offsetState().get(50L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(60L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)50L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)79L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)80L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(100, 80L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(50L, 179L, Collections.singletonList((byte)3))));
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)180L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)180L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)180L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(20, 180L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(180L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)180L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)199L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)200L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testCanAcquireRecordsReturnsTrue() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(150, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
    }

    @Test
    public void testCanAcquireRecordsChangeResponsePostAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(150, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(100, 150L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 249L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
    }

    @Test
    public void testCanAcquireRecordsAfterReleaseAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(150, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(100, 150L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 89L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsAfterArchiveAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(150, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(100, 150L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 89L, Collections.singletonList((byte)3))));
        Assertions.assertEquals((long)90L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsAfterAcceptAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(150, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(100, 150L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 89L, Collections.singletonList((byte)1))));
        Assertions.assertEquals((long)90L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testAcknowledgeBatchWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 14L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, UnknownTopicOrPartitionException.class);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
    }

    @Test
    public void testAcknowledgeOffsetWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(6, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(8L, 10L, Collections.singletonList((byte)3))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).memberId());
    }

    @Test
    public void testAcknowledgeSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)this.memoryRecords(7, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 7L, Collections.singletonList((byte)1))));
        CompletableFuture ackResult = sharePartition.acknowledge("member-2", Collections.singletonList(new ShareAcknowledgementBatch(9L, 11L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
    }

    @Test
    public void testAcknowledgeWithAnotherMemberRollbackBatchError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(15L, 19L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
    }

    @Test
    public void testAcknowledgeWithAnotherMemberRollbackSubsetError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 15L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(10L, 14L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(16L, 18L, Collections.singletonList((byte)1))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)ackResult, InvalidRecordStateException.class);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(10, 5L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 14L, Collections.singletonList((byte)2))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(5L, 14L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(Arrays.asList(new ShareAcknowledgementBatch(10L, 12L, Collections.singletonList((byte)1)), new ShareAcknowledgementBatch(13L, 16L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(17L, 19L, Collections.singletonList((byte)1)))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(13L, 16L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetAndCachedStateNotCleared() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 0L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(Collections.singletonList(new ShareAcknowledgementBatch(0L, 1L, Collections.singletonList((byte)2)))));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 40L, 3L, (Records)this.memoryRecords(2, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(0L, 4L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)2L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(0L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(1L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testNextFetchOffsetPostAcquireAndAcknowledgeFunctionality() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(10, 0L);
        String memberId1 = "memberId-1";
        String memberId2 = "memberId-2";
        sharePartition.acquire(memberId1, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId2, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(10, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId1, Collections.singletonList(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2))));
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId1, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithMultipleConsumers() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(3, 0L);
        String memberId1 = MEMBER_ID;
        String memberId2 = "member-2";
        sharePartition.acquire(memberId1, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId1, Collections.singletonList(new ShareAcknowledgementBatch(0L, 2L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId2, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(2, 3L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId1, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId2, Collections.singletonList(new ShareAcknowledgementBatch(3L, 4L, Collections.singletonList((byte)2))));
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNumberOfWriteCallsOnUpdates() {
        SharePartition sharePartition = (SharePartition)Mockito.spy((Object)SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 10L, 0L, (Records)this.memoryRecords(5, 2L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Collections.singletonList(new ShareAcknowledgementBatch(2L, 6L, Collections.singletonList((byte)1))));
        ((SharePartition)Mockito.verify((Object)sharePartition, (VerificationMode)Mockito.times((int)1))).writeShareGroupState(ArgumentMatchers.anyList());
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        ((SharePartition)Mockito.verify((Object)sharePartition, (VerificationMode)Mockito.times((int)1))).writeShareGroupState(ArgumentMatchers.anyList());
    }

    @Test
    public void testReacquireSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)this.memoryRecords(12, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acknowledge(MEMBER_ID, Arrays.asList(new ShareAcknowledgementBatch(5L, 11L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(12L, 13L, Collections.singletonList((byte)0)), new ShareAcknowledgementBatch(14L, 15L, Collections.singletonList((byte)2)), new ShareAcknowledgementBatch(17L, 20L, Collections.singletonList((byte)2))));
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire("member-2", Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 30L, 0L, (Records)this.memoryRecords(7, 10L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((long)17L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testMaybeInitializeWhenReadStateRpcReturnsZeroAvailableRecords() {
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        for (int i = 0; i < 500; ++i) {
            stateBatches.add(new PersisterStateBatch(234L + (long)i, 234L + (long)i, SharePartition.RecordState.ACKNOWLEDGED.id, 1));
        }
        stateBatches.add(new PersisterStateBatch(232L, 232L, SharePartition.RecordState.ARCHIVED.id, 1));
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)232L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), stateBatches)))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)734L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)734L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)734L, (long)sharePartition.endOffset());
    }

    @Test
    public void testAcquireWithWriteShareGroupStateDelay() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        CompletableFuture<WriteShareGroupStateResult> future = new CompletableFuture<WriteShareGroupStateResult>();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(future);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(5, 5L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        ArrayList<ShareAcknowledgementBatch> acknowledgementBatches = new ArrayList<ShareAcknowledgementBatch>();
        acknowledgementBatches.add(new ShareAcknowledgementBatch(2L, 3L, Collections.singletonList((byte)2)));
        acknowledgementBatches.add(new ShareAcknowledgementBatch(5L, 9L, Collections.singletonList((byte)2)));
        sharePartition.acknowledge(MEMBER_ID, acknowledgementBatches);
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        future.complete(writeShareGroupStateResult);
        sharePartition.acquire(MEMBER_ID, Integer.MAX_VALUE, new FetchPartitionData(Errors.NONE, 20L, 0L, (Records)this.memoryRecords(15, 0L), Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    private List<ShareFetchResponseData.AcquiredRecords> fetchAcquiredRecords(ShareAcquiredRecords shareAcquiredRecords, int expectedOffsetCount) {
        Assertions.assertNotNull((Object)shareAcquiredRecords);
        Assertions.assertEquals((int)expectedOffsetCount, (int)shareAcquiredRecords.count());
        return shareAcquiredRecords.acquiredRecords();
    }

    private MemoryRecords memoryRecords(int numOfRecords) {
        return this.memoryRecords(numOfRecords, 0L);
    }

    private MemoryRecords memoryRecords(int numOfRecords, long startOffset) {
        return this.memoryRecordsBuilder(numOfRecords, startOffset).build();
    }

    private MemoryRecordsBuilder memoryRecordsBuilder(int numOfRecords, long startOffset) {
        return this.memoryRecordsBuilder(ByteBuffer.allocate(1024), numOfRecords, startOffset);
    }

    private MemoryRecordsBuilder memoryRecordsBuilder(ByteBuffer buffer, int numOfRecords, long startOffset) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)startOffset, (int)2);
        for (int i = 0; i < numOfRecords; ++i) {
            builder.appendWithOffset(startOffset + (long)i, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        }
        return builder;
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord(long baseOffset, long lastOffset, int deliveryCount) {
        return Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(baseOffset).setLastOffset(lastOffset).setDeliveryCount((short)deliveryCount));
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords(MemoryRecords memoryRecords, int deliveryCount) {
        ArrayList<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        memoryRecords.batches().forEach(batch -> acquiredRecordsList.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(batch.baseOffset()).setLastOffset(batch.lastOffset()).setDeliveryCount((short)deliveryCount)));
        return acquiredRecordsList;
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords(long baseOffset, long lastOffset, int deliveryCount) {
        ArrayList<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        for (long i = baseOffset; i <= lastOffset; ++i) {
            acquiredRecordsList.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(i).setLastOffset(i).setDeliveryCount((short)deliveryCount));
        }
        return acquiredRecordsList;
    }

    public void mockPersisterReadStateMethod(Persister persister) {
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(Collections.singletonList(new TopicData(TOPIC_ID_PARTITION.topicId(), Collections.singletonList(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)0L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), Collections.emptyList())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
    }

    static {
        MOCK_TIME = new MockTime();
    }

    private static class SharePartitionBuilder {
        private int defaultAcquisitionLockTimeoutMs = 30000;
        private int maxDeliveryCount = 5;
        private int maxInflightMessages = 200;
        private Persister persister = new NoOpShareStatePersister();
        private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        private GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        private SharePartition.SharePartitionState state = SharePartition.SharePartitionState.EMPTY;

        private SharePartitionBuilder() {
        }

        private SharePartitionBuilder withMaxInflightMessages(int maxInflightMessages) {
            this.maxInflightMessages = maxInflightMessages;
            return this;
        }

        private SharePartitionBuilder withPersister(Persister persister) {
            this.persister = persister;
            return this;
        }

        private SharePartitionBuilder withDefaultAcquisitionLockTimeoutMs(int acquisitionLockTimeoutMs) {
            this.defaultAcquisitionLockTimeoutMs = acquisitionLockTimeoutMs;
            return this;
        }

        private SharePartitionBuilder withMaxDeliveryCount(int maxDeliveryCount) {
            this.maxDeliveryCount = maxDeliveryCount;
            return this;
        }

        private SharePartitionBuilder withReplicaManager(ReplicaManager replicaManager) {
            this.replicaManager = replicaManager;
            return this;
        }

        private SharePartitionBuilder withGroupConfigManager(GroupConfigManager groupConfigManager) {
            this.groupConfigManager = groupConfigManager;
            return this;
        }

        private SharePartitionBuilder withState(SharePartition.SharePartitionState state) {
            this.state = state;
            return this;
        }

        public static SharePartitionBuilder builder() {
            return new SharePartitionBuilder();
        }

        public SharePartition build() {
            return new SharePartition(SharePartitionTest.GROUP_ID, TOPIC_ID_PARTITION, 0, this.maxInflightMessages, this.maxDeliveryCount, this.defaultAcquisitionLockTimeoutMs, mockTimer, MOCK_TIME, this.persister, this.replicaManager, this.groupConfigManager, this.state, (SharePartitionManager.SharePartitionListener)Mockito.mock(SharePartitionManager.SharePartitionListener.class));
        }
    }
}

