/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.ClusterTests;
import org.apache.kafka.common.test.api.Type;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=1200L)
@ClusterTestDefaults(types={Type.KRAFT}, brokers=1, serverProperties={@ClusterConfigProperty(key="group.share.persister.class.name", value="")})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0011%a\u0001\u0002\u0016,\u0001AB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\b\u000f\u0002\u0011\r\u0011\"\u0004I\u0011\u0019Y\u0005\u0001)A\u0007\u0013\"9A\n\u0001b\u0001\n\u001bi\u0005B\u0002)\u0001A\u00035a\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003e\u0001\u0011\u0005!\u000bC\u0003x\u0001\u0011\u0005!\u000bC\u0003{\u0001\u0011\u0005!\u000b\u0003\u0004\u0002D\u0001!\tA\u0015\u0005\u0007\u0003#\u0002A\u0011\u0001*\t\r\u0005}\u0003\u0001\"\u0001S\u0011\u0019\ty\u0007\u0001C\u0001%\"1\u0011Q\u0010\u0001\u0005\u0002ICa!a#\u0001\t\u0003\u0011\u0006BBAM\u0001\u0011\u0005!\u000b\u0003\u0004\u0002(\u0002!\tA\u0015\u0005\u0007\u0003k\u0003A\u0011\u0001*\t\r\u0005\r\u0007\u0001\"\u0001S\u0011\u0019\tY\u000e\u0001C\u0001%\"1\u0011\u0011\u001e\u0001\u0005\u0002ICa!a>\u0001\t\u0003\u0011\u0006B\u0002B\u0003\u0001\u0011\u0005!\u000b\u0003\u0004\u0003\u0014\u0001!\tA\u0015\u0005\u0007\u0005C\u0001A\u0011\u0001*\t\r\t=\u0002\u0001\"\u0001S\u0011\u0019\u0011i\u0004\u0001C\u0001%\"1!1\n\u0001\u0005\u0002ICaA!\u0017\u0001\t\u0003\u0011\u0006B\u0002B4\u0001\u0011\u0005!\u000b\u0003\u0004\u0003v\u0001!\tA\u0015\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u0017Dqaa\b\u0001\t\u0013\u0019\t\u0003C\u0004\u00046\u0001!Iaa\u000e\t\u000f\r%\u0003\u0001\"\u0003\u0004L!I1q\u0013\u0001\u0012\u0002\u0013%1\u0011\u0014\u0005\n\u0007_\u0003\u0011\u0013!C\u0005\u00073C\u0011b!-\u0001#\u0003%Ia!'\t\u000f\rM\u0006\u0001\"\u0003\u00046\n\u00013\u000b[1sK\u001a+Go\u00195BG.twn\u001e7fI\u001e,'+Z9vKN$H+Z:u\u0015\taS&\u0001\u0004tKJ4XM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u00114'D\u0001,\u0013\t!4FA\u0010He>,\boQ8pe\u0012Lg.\u0019;pe\n\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fqa\u00197vgR,'\u000f\u0005\u00028\u00036\t\u0001H\u0003\u0002:u\u0005!A/Z:u\u0015\tYD(\u0001\u0004d_6lwN\u001c\u0006\u0003]uR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!\t\u000f\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!\u0012$\u0011\u0005I\u0002\u0001\"B\u001b\u0003\u0001\u00041\u0014aE'B1~\u0003\u0016I\u0015+J)&{ej\u0018\"Z)\u0016\u001bV#A%\u0010\u0003)k\"a\n\t\u0002)5\u000b\u0005l\u0018)B%RKE+S(O?\nKF+R*!\u0003-i\u0015\tW0X\u0003&#v,T*\u0016\u00039{\u0011aT\u000f\u0003'!\rA\"T!Y?^\u000b\u0015\nV0N'\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n!QK\\5uQ\t9!\f\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006\u0019\u0011\r]5\u000b\u0005}\u0003\u0017a\u00026va&$XM\u001d\u0006\u0003C~\nQA[;oSRL!a\u0019/\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u000e;fgR\u001c\u0006.\u0019:f\r\u0016$8\r\u001b*fcV,7\u000f^%t\u0013:\f5mY3tg&\u0014G.Z,iK:\u001cuN\u001c4jON$\u0015n]1cY\u0016$\u0007\u0006\u0002\u0005gW2\u0004\"aZ5\u000e\u0003!T!!\u0018\u001d\n\u0005)D'aC\"mkN$XM\u001d+fgR\f\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u00035\\SA\\9siV\u0004\"aZ8\n\u0005AD'!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018%A:\u00029Ut7\u000f^1cY\u0016t\u0013\r]5/m\u0016\u00148/[8og:*g.\u00192mK\u0006)a/\u00197vK\u0006\na/\u0001\u0003ueV,\u0017\u0001\u0010;fgR\u001c\u0006.\u0019:f\u0003\u000e\\gn\\<mK\u0012<WMU3rk\u0016\u001cH/S:J]\u0006\u001b7-Z:tS\ndWm\u00165f]\u000e{gNZ5hg\u0012K7/\u00192mK\u0012DC!\u00034ls2\nQ.A\u0014uKN$8\u000b[1sK\u001a+Go\u00195SKF,Xm\u001d;U_:{g\u000eT3bI\u0016\u0014(+\u001a9mS\u000e\f\u0007\u0006\u0002\u0006}i~\u0004\"aZ?\n\u0005yD'\u0001D\"mkN$XM\u001d+fgR\u001cH\u0006BA\u0001\u0003SY\u0003BZ6\u0002\u0004\u0005\u0015\u0012q\u0005\u0017\t\u0003\u000b\ty!!\u0006\u0002 -:a.]A\u0004i\u0006-\u0011EAA\u0005\u0003\u0015:'o\\;q]\r|wN\u001d3j]\u0006$xN\u001d\u0018sK\n\fG.\u00198dK:\u0002(o\u001c;pG>d7/\t\u0002\u0002\u000e\u000512\r\\1tg&\u001cGfY8ogVlWM\u001d\u0017tQ\u0006\u0014Xm\u000b\u0004oc\u0006EA/^\u0011\u0003\u0003'\t!c\u001a:pkBt3\u000f[1sK:*g.\u00192mK.:a.]A\fi\u0006m\u0011EAA\r\u0003qygMZ:fiNtCo\u001c9jG:rW/\u001c\u0018qCJ$\u0018\u000e^5p]N\f#!!\b\u0002\u0003EZsA\\9\u0002\"Q\fY\"\t\u0002\u0002$\u0005\u0001sN\u001a4tKR\u001ch\u0006^8qS\u000et#/\u001a9mS\u000e\fG/[8o]\u0019\f7\r^8s\u0003\u001d\u0011'o\\6feNl\u0012AA\u0016\tM.\fY#!\n\u0002(1z\u0011QAA\b\u0003+\ty\"!\f\u00028\u0005uRnK\u0004oc\u0006=B/a\r\"\u0005\u0005E\u0012\u0001I4s_V\u0004hf\u001d5be\u0016t\u0003/\u001a:tSN$XM\u001d\u0018dY\u0006\u001c8O\f8b[\u0016\f#!!\u000e\u0002{=\u0014xML1qC\u000eDWML6bM.\fgf]3sm\u0016\u0014hf\u001d5be\u0016t\u0003/\u001a:tSN$XM\u001d\u0018EK\u001a\fW\u000f\u001c;Ti\u0006$X\rU3sg&\u001cH/\u001a:,\u000f9\f\u0018\u0011\b;\u0002\u001c\u0005\u0012\u00111H\u00011g\"\f'/\u001a\u0018d_>\u0014H-\u001b8bi>\u0014hf\u001d;bi\u0016tCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:,\u000f9\f\u0018q\b;\u0002\u001c\u0005\u0012\u0011\u0011I\u0001-g\"\f'/\u001a\u0018d_>\u0014H-\u001b8bi>\u0014hf\u001d;bi\u0016tCo\u001c9jG:rW/\u001c\u0018qCJ$\u0018\u000e^5p]N\fA\u0004^3tiNC\u0017M]3GKR\u001c\u0007NU3rk\u0016\u001cHoU;dG\u0016\u001c8\u000fK\u0003\fyR\f9\u0005\f\u0003\u0002J\u000553\u0006\u00024l\u0003\u0017b\u0003\"!\u0002\u0002\u0010\u0005U\u0011qD\u0016\u0005M.\fy\u0005L\b\u0002\u0006\u0005=\u0011QCA\u0010\u0003[\t9$!\u0010n\u00039\"Xm\u001d;TQ\u0006\u0014XMR3uG\"\u0014V-];fgR\u001cVoY2fgNlU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u000b1aH/!\u0016-\t\u0005]\u00131L\u0016\u0005M.\fI\u0006\f\u0005\u0002\u0006\u0005=\u0011QCA\u0010W\u001117.!\u0018-\u001f\u0005\u0015\u0011qBA\u000b\u0003?\ti#a\u000e\u0002>5\fQ\b^3tiNC\u0017M]3GKR\u001c\u0007NU3rk\u0016\u001cHoU;dG\u0016\u001c8/T;mi&\u0004H.\u001a)beRLG/[8og6+H\u000e^5qY\u0016\u0014%o\\6feNDS!\u0004?u\u0003GbC!!\u001a\u0002l-Bam[A4\u0003K\tI\u0007\f\u0005\u0002\u0006\u0005=\u0011QCA\u0010;\u0005\u00191\u0006\u00034l\u0003[\n)#!\u001b-\u001f\u0005\u0015\u0011qBA\u000b\u0003?\ti#a\u000e\u0002>5\f\u0001\u0006^3tiNC\u0017M]3BG.twn\u001e7fI\u001e,'+Z9vKN$8+^2dKN\u001c\u0018iY2faRDSA\u0004?u\u0003gbC!!\u001e\u0002z-\"am[A<Y!\t)!a\u0004\u0002\u0016\u0005}1\u0006\u00024l\u0003wbs\"!\u0002\u0002\u0010\u0005U\u0011qDA\u0017\u0003o\ti$\\\u0001'i\u0016\u001cHo\u00155be\u00164U\r^2i%\u0016\fX/Z:u!&<w-\u001f2bG.,G-Q2dKB$\b&B\b}i\u0006\u0005E\u0006BAB\u0003\u000f[CAZ6\u0002\u00062B\u0011QAA\b\u0003+\tyb\u000b\u0003gW\u0006%EfDA\u0003\u0003\u001f\t)\"a\b\u0002.\u0005]\u0012QH7\u0002SQ,7\u000f^*iCJ,\u0017iY6o_^dW\rZ4f%\u0016\fX/Z:u'V\u001c7-Z:t%\u0016dW-Y:fQ\u0015\u0001B\u0010^AHY\u0011\t\t*!&,\t\u0019\\\u00171\u0013\u0017\t\u0003\u000b\ty!!\u0006\u0002 -\"am[ALY=\t)!a\u0004\u0002\u0016\u0005}\u0011QFA\u001c\u0003{i\u0017a\n;fgR\u001c\u0006.\u0019:f\r\u0016$8\r\u001b*fcV,7\u000f\u001e)jO\u001eL(-Y2lK\u0012\u0014V\r\\3bg\u0016DS!\u0005?u\u0003;cC!a(\u0002$.\"am[AQY!\t)!a\u0004\u0002\u0016\u0005}1\u0006\u00024l\u0003Kcs\"!\u0002\u0002\u0010\u0005U\u0011qDA\u0017\u0003o\ti$\\\u0001)i\u0016\u001cHo\u00155be\u0016\f5m\u001b8po2,GmZ3SKF,Xm\u001d;Tk\u000e\u001cWm]:SK*,7\r\u001e\u0015\u0006%q$\u00181\u0016\u0017\u0005\u0003[\u000b\tl\u000b\u0003gW\u0006=F\u0006CA\u0003\u0003\u001f\t)\"a\b,\t\u0019\\\u00171\u0017\u0017\u0010\u0003\u000b\ty!!\u0006\u0002 \u00055\u0012qGA\u001f[\u00061C/Z:u'\"\f'/\u001a$fi\u000eD'+Z9vKN$\b+[4hs\n\f7m[3e%\u0016TWm\u0019;)\u000bMaH/!/-\t\u0005m\u0016qX\u0016\u0005M.\fi\f\f\u0005\u0002\u0006\u0005=\u0011QCA\u0010W\u001117.!1-\u001f\u0005\u0015\u0011qBA\u000b\u0003?\ti#a\u000e\u0002>5\fa\u0007^3tiNC\u0017M]3BG.twn\u001e7fI\u001e,'+Z9vKN$X*\u0019=EK2Lg/\u001a:z\u0003R$X-\u001c9u\u000bbD\u0017-^:uK\u0012DS\u0001\u0006?u\u0003\u000fdC!!3\u0002X.\"am[AfY)\t)!a\u0004\u0002\u0016\u0005}\u0011QZ\u0016\b]F\fy\r^AjC\t\t\t.\u0001\u0011he>,\bOL:iCJ,g\u0006Z3mSZ,'/\u001f\u0018d_VtGO\f7j[&$\u0018EAAk\u0003\u0005\u00114\u0006\u00024l\u00033d\u0013#!\u0002\u0002\u0010\u0005U\u0011qDA\u0017\u0003o\ti$\\Ag\u0003=\"Xm\u001d;TQ\u0006\u0014XMR3uG\"\u0014%o\\6feJ+7\u000f]3diN\u0004\u0016M\u001d;ji&|gn]*ju\u0016d\u0015.\\5uQ\u0015)B\u0010^ApY\u0011\t\t/!:,\t\u0019\\\u00171\u001d\u0017\t\u0003\u000b\ty!!\u0006\u0002 -\"am[AtY=\t)!a\u0004\u0002\u0016\u0005}\u0011QFA\u001c\u0003{i\u0017A\u0010;fgR\u001c\u0006.\u0019:f\r\u0016$8\r\u001b*fcV,7\u000f^*vG\u000e,7o\u001d4vYNC\u0017M]5oO\n+Go^3f]6+H\u000e^5qY\u0016\u001cuN\\:v[\u0016\u00148\u000fK\u0003\u0017yR\fi\u000f\f\u0003\u0002p\u0006M8\u0006\u00024l\u0003cd\u0003\"!\u0002\u0002\u0010\u0005U\u0011qD\u0016\u0005M.\f)\u0010L\b\u0002\u0006\u0005=\u0011QCA\u0010\u0003[\t9$!\u0010n\u0003%#Xm\u001d;TQ\u0006\u0014XMR3uG\"\u0014V-];fgRtun\u00155be&twMQ3uo\u0016,g.T;mi&\u0004H.Z\"p]N,X.\u001a:t\rJ|W\u000eR5gM\u0016\u0014XM\u001c;He>,\bo\u001d\u0015\u0006/q$\u00181 \u0017\u0005\u0003{\u0014\ta\u000b\u0003gW\u0006}H\u0006CA\u0003\u0003\u001f\t)\"a\b,\t\u0019\\'1\u0001\u0017\u0010\u0003\u000b\ty!!\u0006\u0002 \u00055\u0012qGA\u001f[\u0006\u0019C/Z:u'\"\f'/Z*fgNLwN\\\"m_N,w+\u001b;i'\"\f'/\u001a$fi\u000eD\u0007&\u0002\r}i\n%A\u0006\u0002B\u0006\u0005\u001fYCAZ6\u0003\u000e1B\u0011QAA\b\u0003+\tyb\u000b\u0003gW\nEAfDA\u0003\u0003\u001f\t)\"a\b\u0002.\u0005]\u0012QH7\u0002SQ,7\u000f^*iCJ,7+Z:tS>t7\t\\8tK^KG\u000f[*iCJ,\u0017iY6o_^dW\rZ4fQ\u0015IB\u0010\u001eB\fY\u0011\u0011IB!\b,\t\u0019\\'1\u0004\u0017\t\u0003\u000b\ty!!\u0006\u0002 -\"am\u001bB\u0010Y=\t)!a\u0004\u0002\u0016\u0005}\u0011QFA\u001c\u0003{i\u0017A\f;fgR\u001c\u0006.\u0019:f\r\u0016$8\r[%oSRL\u0017\r\\#q_\u000eDw+\u001b;i\u0003\u000e\\gn\\<mK\u0012<W-\\3oiNDSA\u0007?u\u0005KaCAa\n\u0003,-\"am\u001bB\u0015Y!\t)!a\u0004\u0002\u0016\u0005}1\u0006\u00024l\u0005[as\"!\u0002\u0002\u0010\u0005U\u0011qDA\u0017\u0003o\ti$\\\u0001(i\u0016\u001cHo\u00155be\u0016\f5m\u001b8po2,GmZ3J]&$\u0018.\u00197SKF,Xm\u001d;FeJ|'\u000fK\u0003\u001cyR\u0014\u0019\u0004\f\u0003\u00036\te2\u0006\u00024l\u0005oa\u0003\"!\u0002\u0002\u0010\u0005U\u0011qD\u0016\u0005M.\u0014Y\u0004L\b\u0002\u0006\u0005=\u0011QCA\u0010\u0003[\t9$!\u0010n\u00035\"Xm\u001d;TQ\u0006\u0014XMR3uG\"\u0014V-];fgRLeN^1mS\u0012\u001c\u0006.\u0019:f'\u0016\u001c8/[8o\u000bB|7\r\u001b\u0015\u00069q$(\u0011\t\u0017\u0005\u0005\u0007\u00129e\u000b\u0003gW\n\u0015C\u0006CA\u0003\u0003\u001f\t)\"a\b,\t\u0019\\'\u0011\n\u0017\u0010\u0003\u000b\ty!!\u0006\u0002 \u00055\u0012qGA\u001f[\u0006\u0019D/Z:u'\"\f'/Z!dW:|w\u000f\\3eO\u0016\u0014V-];fgRLeN^1mS\u0012\u001c\u0006.\u0019:f'\u0016\u001c8/[8o\u000bB|7\r\u001b\u0015\u0006;q$(q\n\u0017\u0005\u0005#\u0012)f\u000b\u0003gW\nMC\u0006CA\u0003\u0003\u001f\t)\"a\b,\t\u0019\\'q\u000b\u0017\u0010\u0003\u000b\ty!!\u0006\u0002 \u00055\u0012qGA\u001f[\u0006IC/Z:u'\"\f'/\u001a$fi\u000eD'+Z9vKN$8\u000b[1sKN+7o]5p]:{GOR8v]\u0012DSA\b?u\u0005;bCAa\u0018\u0003d-\"am\u001bB1Y!\t)!a\u0004\u0002\u0016\u0005}1\u0006\u00024l\u0005Kbs\"!\u0002\u0002\u0010\u0005U\u0011qDA\u0017\u0003o\ti$\\\u00010i\u0016\u001cHo\u00155be\u0016\f5m\u001b8po2,GmZ3SKF,Xm\u001d;TQ\u0006\u0014XmU3tg&|gNT8u\r>,h\u000e\u001a\u0015\u0006?q$(1\u000e\u0017\u0005\u0005[\u0012\th\u000b\u0003gW\n=D\u0006CA\u0003\u0003\u001f\t)\"a\b,\t\u0019\\'1\u000f\u0017\u0010\u0003\u000b\ty!!\u0006\u0002 \u00055\u0012qGA\u001f[\u0006QC/Z:u'\"\f'/\u001a$fi\u000eD'+Z9vKN$hi\u001c:hKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b&\u0002\u0011}i\neD\u0006\u0002B>\u0005\u007fZCAZ6\u0003~1B\u0011QAA\b\u0003+\tyb\u000b\u0003gW\n\u0005EfDA\u0003\u0003\u001f\t)\"a\b\u0002.\u0005]\u0012QH7\u00025M,g\u000e\u001a$jeN$8\u000b[1sK\u001a+Go\u00195SKF,Xm\u001d;\u0015\u000fM\u00139Ia%\u0003.\"9!\u0011R\u0011A\u0002\t-\u0015\u0001C7f[\n,'/\u00133\u0011\t\t5%qR\u0007\u0002u%\u0019!\u0011\u0013\u001e\u0003\tU+\u0018\u000e\u001a\u0005\b\u0005+\u000b\u0003\u0019\u0001BL\u0003\u001d9'o\\;q\u0013\u0012\u0004BA!'\u0003(:!!1\u0014BR!\r\u0011i*V\u0007\u0003\u0005?S1A!)0\u0003\u0019a$o\\8u}%\u0019!QU+\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011IKa+\u0003\rM#(/\u001b8h\u0015\r\u0011)+\u0016\u0005\b\u0005_\u000b\u0003\u0019\u0001BY\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005g\u0013iLa1\u000f\t\tU&\u0011\u0018\b\u0005\u0005;\u00139,C\u0001W\u0013\r\u0011Y,V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yL!1\u0003\u0007M+\u0017OC\u0002\u0003<V\u0003BA!$\u0003F&\u0019!q\u0019\u001e\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017aF3ya\u0016\u001cG/\u001a3BGF,\u0018N]3e%\u0016\u001cwN\u001d3t)!\u0011ima\u0001\u0004\u0010\rM\u0001C\u0002Bh\u00053\u0014i.\u0004\u0002\u0003R*!!1\u001bBk\u0003\u0011)H/\u001b7\u000b\u0005\t]\u0017\u0001\u00026bm\u0006LAAa7\u0003R\n!A*[:u!\u0011\u0011yN!@\u000f\t\t\u0005(q\u001f\b\u0005\u0005G\u0014\u0019P\u0004\u0003\u0003f\nEh\u0002\u0002Bt\u0005_tAA!;\u0003n:!!Q\u0014Bv\u0013\u0005\u0001\u0015B\u0001 @\u0013\tqS(\u0003\u0002<y%\u0019!Q\u001f\u001e\u0002\u000f5,7o]1hK&!!\u0011 B~\u0003Y\u0019\u0006.\u0019:f\r\u0016$8\r\u001b*fgB|gn]3ECR\f'b\u0001B{u%!!q`B\u0001\u0005=\t5-];je\u0016$'+Z2pe\u0012\u001c(\u0002\u0002B}\u0005wDqa!\u0002#\u0001\u0004\u00199!\u0001\u0007gSJ\u001cHo\u00144gg\u0016$8\u000f\u0005\u0004\u0003P\ne7\u0011\u0002\t\u0004)\u000e-\u0011bAB\u0007+\n!Aj\u001c8h\u0011\u001d\u0019\tB\ta\u0001\u0007\u000f\t1\u0002\\1ti>3gm]3ug\"91Q\u0003\u0012A\u0002\r]\u0011A\u00043fY&4XM]=D_VtGo\u001d\t\u0007\u0005\u001f\u0014In!\u0007\u0011\u0007Q\u001bY\"C\u0002\u0004\u001eU\u00131!\u00138u\u0003y\u0019w.\u001c9be\u00164U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>t7\u000fF\u0003T\u0007G\u0019\t\u0004C\u0004\u0004&\r\u0002\raa\n\u0002!\u0015D\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0007\u0003BB\u0015\u0007[qAaa\u000b\u0003x6\u0011!1`\u0005\u0005\u0007_\u0019\tAA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0007g\u0019\u0003\u0019AB\u0014\u00039\t7\r^;bYJ+7\u000f]8og\u0016\fAeY8na\u0006\u0014X-Q2l]><H.\u001a3hKJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006'\u000ee2q\t\u0005\b\u0007K!\u0003\u0019AB\u001e!\u0011\u0019ida\u0011\u000f\t\r-2qH\u0005\u0005\u0007\u0003\u0012Y0\u0001\u000fTQ\u0006\u0014X-Q2l]><H.\u001a3hKJ+7\u000f]8og\u0016$\u0015\r^1\n\t\r=2Q\t\u0006\u0005\u0007\u0003\u0012Y\u0010C\u0004\u00044\u0011\u0002\raa\u000f\u0002/\r\u0014X-\u0019;f'\"\f'/\u001a$fi\u000eD'+Z9vKN$H\u0003FB'\u00073\u001aYf!\u001a\u0004j\r54\u0011OBF\u0007\u001f\u001b\u0019\n\u0005\u0003\u0004P\rUSBAB)\u0015\r\u0019\u0019FO\u0001\te\u0016\fX/Z:ug&!1qKB)\u0005E\u0019\u0006.\u0019:f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0005++\u0003\u0019\u0001BL\u0011\u001d\u0019i&\na\u0001\u0007?\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0007\u001f\u001a\t'\u0003\u0003\u0004d\rE#\u0001F*iCJ,'+Z9vKN$X*\u001a;bI\u0006$\u0018\rC\u0004\u0004h\u0015\u0002\ra!\u0007\u0002#5\f\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fC\u0004\u0004l\u0015\u0002\rA!-\u0002\tM,g\u000e\u001a\u0005\b\u0007_*\u0003\u0019\u0001BY\u0003\u00191wN]4fi\"911O\u0013A\u0002\rU\u0014aE1dW:|w\u000f\\3eO\u0016lWM\u001c;t\u001b\u0006\u0004\b\u0003\u0003BM\u0007o\u0012\u0019ma\u001f\n\t\re$1\u0016\u0002\u0004\u001b\u0006\u0004\bC\u0002Bh\u00053\u001ci\b\u0005\u0003\u0004\u0000\r\u0015e\u0002BB\u0016\u0007\u0003KAaa!\u0003|\u0006)2\u000b[1sK\u001a+Go\u00195SKF,Xm\u001d;ECR\f\u0017\u0002BBD\u0007\u0013\u0013A#Q2l]><H.\u001a3hK6,g\u000e\u001e\"bi\u000eD'\u0002BBB\u0005wD\u0011b!$&!\u0003\u0005\ra!\u0007\u0002\u00135\f\u0007pV1ji6\u001b\b\"CBIKA\u0005\t\u0019AB\r\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\"CBKKA\u0005\t\u0019AB\r\u0003!i\u0017\r\u001f\"zi\u0016\u001c\u0018!I2sK\u0006$Xm\u00155be\u00164U\r^2i%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012:TCABNU\u0011\u0019Ib!(,\u0005\r}\u0005\u0003BBQ\u0007Wk!aa)\u000b\t\r\u00156qU\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!+V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007[\u001b\u0019KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011e\u0019:fCR,7\u000b[1sK\u001a+Go\u00195SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIa\n\u0011e\u0019:fCR,7\u000b[1sK\u001a+Go\u00195SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIe\nQd\u0019:fCR,7\u000b[1sK\u0006\u001b7N\\8xY\u0016$w-\u001a*fcV,7\u000f\u001e\u000b\t\u0007o\u001bila0\u0004BB!1qJB]\u0013\u0011\u0019Yl!\u0015\u0003/MC\u0017M]3BG.twn\u001e7fI\u001e,'+Z9vKN$\bb\u0002BKS\u0001\u0007!q\u0013\u0005\b\u0007;J\u0003\u0019AB0\u0011\u001d\u0019\u0019(\u000ba\u0001\u0007\u0007\u0004\u0002B!'\u0004x\t\r7Q\u0019\t\u0007\u0005\u001f\u0014Ina2\u0011\t\r%7q\u001a\b\u0005\u0007W\u0019Y-\u0003\u0003\u0004N\nm\u0018aG*iCJ,\u0017iY6o_^dW\rZ4f%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0004\b\u000eE'\u0002BBg\u0005wDc\u0001ABki\u000em\u0007cA.\u0004X&\u00191\u0011\u001c/\u0003\u000fQKW.Z8viz\u0011A\u0001-\u0015\u000f\u0001\r}7Q]Bt\u0003K\u0019\u0019p[B{!\r97\u0011]\u0005\u0004\u0007GD'aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001c\u0018!\u0002;za\u0016\u001cHFABuI\t\u0019Y/\u0003\u0003\u0004n\u000e=\u0018!B&S\u0003\u001a#&bAByQ\u0006!A+\u001f9f;\u0005\tAFAB|W\u001dq\u0017/a\fu\u0007s\f#aa?\u0002\u0001!2\u0001aa@u\t\u000b\u00012a\u0017C\u0001\u0013\r!\u0019\u0001\u0018\u0002\u0004)\u0006<\u0017E\u0001C\u0004\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class ShareFetchAcknowledgeRequestTest
extends GroupCoordinatorBaseRequestTest {
    private final int MAX_PARTITION_BYTES() {
        return 10000;
    }

    private final int MAX_WAIT_MS() {
        return 5000;
    }

    @AfterEach
    public void tearDown() {
        this.closeProducer();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})
    public void testShareFetchRequestIsInAccessibleWhenConfigsDisabled() {
        String groupId = "group";
        ShareRequestMetadata metadata = new ShareRequestMetadata(Uuid.randomUuid(), 0);
        .colon.colon send = new .colon.colon((Object)new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic1", 0)), (List)new .colon.colon((Object)new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic1", 1)), (List)Nil$.MODULE$));
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponse shareFetchResponse = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)shareFetchResponse.data().errorCode());
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})
    public void testShareAcknowledgeRequestIsInAccessibleWhenConfigsDisabled() {
        String groupId = "group";
        ShareRequestMetadata metadata = new ShareRequestMetadata(Uuid.randomUuid(), 0);
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty());
        ShareAcknowledgeResponse shareAcknowledgeResponse = (ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class));
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)shareAcknowledgeResponse.data().errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}, brokers=2), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")}, brokers=2)})
    public void testShareFetchRequestToNonLeaderReplica() {
        String groupId = "group";
        ShareRequestMetadata metadata = new ShareRequestMetadata(Uuid.randomUuid(), 0);
        String topic = "topic";
        int partition = 0;
        scala.collection.immutable.Map<TopicIdPartition, Object> partitionToLeader = this.createTopicAndReturnLeaders(topic, this.createTopicAndReturnLeaders$default$2(), this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$1 -> x$1.swap())).asJava();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)topicIdPartition));
        Option nonReplicaOpt = this.getBrokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestToNonLeaderReplica$2(leader, x$2)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, nonReplicaId, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).responseData(topicNames).get(topicIdPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((int)leader, (int)partitionData.currentLeader().leaderId());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestSuccess() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestSuccessMultiplePartitions() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, new TopicPartition(topic, 0));
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, new TopicPartition(topic, 1));
        TopicIdPartition topicIdPartition3 = new TopicIdPartition(topicId, new TopicPartition(topic, 2));
        .colon.colon send = new .colon.colon((Object)topicIdPartition1, (List)new .colon.colon((Object)topicIdPartition2, (List)new .colon.colon((Object)topicIdPartition3, (List)Nil$.MODULE$)));
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition1, 10);
        this.produceData(topicIdPartition2, 10);
        this.produceData(topicIdPartition3, 10);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ObjectRef responses = ObjectRef.create((Object)Nil$.MODULE$);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ShareFetchResponseData $anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)$anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData.errorCode());
            Assertions.assertEquals((int)1, (int)$anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData.responses().size());
            if (((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData.responses().get(0)).partitions().size() > 0) {
                Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData.responses().get(0)).topicId());
                ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestSuccessMultiplePartitions$1_shareFetchResponseData.responses().get(0)).partitions()).foreach((Function1 & Serializable)partitionData -> {
                    ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestSuccessMultiplePartitions$2(responses$1, partitionData);
                    return BoxedUnit.UNIT;
                });
            }
            Object var22_16 = null;
            if (((scala.collection.immutable.Seq)responses.elem).size() == 3) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Share fetch request failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ShareFetchResponseData.PartitionData expectedPartitionData1 = new ShareFetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData expectedPartitionData2 = new ShareFetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData expectedPartitionData3 = new ShareFetchResponseData.PartitionData().setPartitionIndex(2).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ((scala.collection.immutable.Seq)responses.elem).foreach((Function1 & Serializable)partitionData -> {
            ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestSuccessMultiplePartitions$4(this, expectedPartitionData1, expectedPartitionData2, expectedPartitionData3, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}, brokers=3), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")}, brokers=3)})
    public void testShareFetchRequestSuccessMultiplePartitionsMultipleBrokers() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        scala.collection.immutable.Map<TopicIdPartition, Object> partitionToLeaders = this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, new TopicPartition(topic, 0));
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, new TopicPartition(topic, 1));
        TopicIdPartition topicIdPartition3 = new TopicIdPartition(topicId, new TopicPartition(topic, 2));
        int leader1 = BoxesRunTime.unboxToInt((Object)partitionToLeaders.apply((Object)topicIdPartition1));
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeaders.apply((Object)topicIdPartition2));
        int leader3 = BoxesRunTime.unboxToInt((Object)partitionToLeaders.apply((Object)topicIdPartition3));
        .colon.colon send1 = new .colon.colon((Object)topicIdPartition1, (List)Nil$.MODULE$);
        .colon.colon send2 = new .colon.colon((Object)topicIdPartition2, (List)Nil$.MODULE$);
        .colon.colon send3 = new .colon.colon((Object)topicIdPartition3, (List)Nil$.MODULE$);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, 0);
        scala.collection.immutable.Map acknowledgementsMap = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest1 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchRequest shareFetchRequest2 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchRequest shareFetchRequest3 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send3, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponse cfr_ignored_0 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest1, leader1, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse cfr_ignored_1 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest2, leader2, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse cfr_ignored_2 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest3, leader3, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        this.initProducer();
        this.produceData(topicIdPartition1, 10);
        this.produceData(topicIdPartition2, 10);
        this.produceData(topicIdPartition3, 10);
        shareFetchRequest1 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        shareFetchRequest2 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        shareFetchRequest3 = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send3, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponse shareFetchResponse1 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest1, leader1, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse2 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest2, leader2, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse3 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest3, leader3, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponseData shareFetchResponseData1 = shareFetchResponse1.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData1.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData1.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData1 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData2 = shareFetchResponse2.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData2.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData2.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData2 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData3 = shareFetchResponse3.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData3.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData3.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData3 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().get(0);
        ShareFetchResponseData.PartitionData expectedPartitionData1 = new ShareFetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData expectedPartitionData2 = new ShareFetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData expectedPartitionData3 = new ShareFetchResponseData.PartitionData().setPartitionIndex(2).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        this.compareFetchResponsePartitions(expectedPartitionData1, partitionData1);
        this.compareFetchResponsePartitions(expectedPartitionData2, partitionData2);
        this.compareFetchResponsePartitions(expectedPartitionData3, partitionData3);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeRequestSuccessAccept() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        ShareAcknowledgeResponseData.PartitionData expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.PartitionData acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestPiggybackedAccept() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        acknowledgementsMapForFetch = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)20L)), Collections.singletonList(BoxesRunTime.boxToLong((long)29L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeRequestSuccessRelease() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)2))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        ShareAcknowledgeResponseData.PartitionData expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.PartitionData acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)2))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestPiggybackedRelease() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int n = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata shareRequestMetadata = new ShareRequestMetadata(memberId, n);
        scala.collection.immutable.Map map = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, shareRequestMetadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)map, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 10L}))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{9L, 19L}))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1}))).asJava()));
        ArrayList acquiredRecords = new ArrayList();
        boolean bl = false;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            n = ShareRequestMetadata.nextEpoch((int)n);
            shareRequestMetadata = new ShareRequestMetadata(memberId, n);
            if (bl) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)2))), (List)Nil$.MODULE$)).asJava())}));
                bl = true;
            }
            shareFetchRequest = this.createShareFetchRequest(groupId, shareRequestMetadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)map, 5000, 0, Integer.MAX_VALUE);
            shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
            Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
            Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
            if (((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size() > 0) {
                acquiredRecords.addAll(((ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0)).acquiredRecords());
            }
            if (acquiredRecords.size() == 2) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Share fetch request failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((expectedFetchPartitionData.acquiredRecords().containsAll(acquiredRecords) && acquiredRecords.containsAll(expectedFetchPartitionData.acquiredRecords()) ? 1 : 0) != 0);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeRequestSuccessReject() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)3))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        ShareAcknowledgeResponseData.PartitionData expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.PartitionData acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestPiggybackedReject() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        acknowledgementsMapForFetch = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)3))), (List)Nil$.MODULE$)).asJava())}));
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)20L)), Collections.singletonList(BoxesRunTime.boxToLong((long)29L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.delivery.count.limit", value="2")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true"), @ClusterConfigProperty(key="group.share.delivery.count.limit", value="2")})})
    public void testShareAcknowledgeRequestMaxDeliveryAttemptExhausted() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)2))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        ShareAcknowledgeResponseData.PartitionData expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.PartitionData acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)2))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)2))), (List)Nil$.MODULE$)).asJava())}));
        shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchBrokerRespectsPartitionsSizeLimit() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        this.produceData(topicIdPartition, "large message 1", new String(new byte[3333]));
        this.produceData(topicIdPartition, "large message 2", new String(new byte[3333]));
        this.produceData(topicIdPartition, "large message 3", new String(new byte[3333]));
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)11L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestSuccessfulSharingBetweenMultipleConsumers() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        Uuid memberId1 = Uuid.randomUuid();
        Uuid memberId2 = Uuid.randomUuid();
        Uuid memberId3 = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10000);
        ShareRequestMetadata metadata1 = new ShareRequestMetadata(memberId1, 0);
        scala.collection.immutable.Map acknowledgementsMap1 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest1 = this.createShareFetchRequest(groupId, metadata1, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap1, 5000, 0, Integer.MAX_VALUE);
        ShareRequestMetadata metadata2 = new ShareRequestMetadata(memberId2, 0);
        scala.collection.immutable.Map acknowledgementsMap2 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest2 = this.createShareFetchRequest(groupId, metadata2, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap2, 5000, 0, Integer.MAX_VALUE);
        ShareRequestMetadata metadata3 = new ShareRequestMetadata(memberId3, 0);
        scala.collection.immutable.Map acknowledgementsMap3 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest3 = this.createShareFetchRequest(groupId, metadata3, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap3, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponse shareFetchResponse1 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest1, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse2 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest2, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse3 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest3, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponseData shareFetchResponseData1 = shareFetchResponse1.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData1.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData1.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData1 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData2 = shareFetchResponse2.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData2.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData2.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData2 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData3 = shareFetchResponse3.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData3.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData3.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData3 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().get(0);
        Assertions.assertTrue((((ShareFetchResponseData.AcquiredRecords)partitionData1.acquiredRecords().get(0)).lastOffset() < ((ShareFetchResponseData.AcquiredRecords)partitionData2.acquiredRecords().get(0)).firstOffset() ? 1 : 0) != 0);
        Assertions.assertTrue((((ShareFetchResponseData.AcquiredRecords)partitionData2.acquiredRecords().get(0)).lastOffset() < ((ShareFetchResponseData.AcquiredRecords)partitionData3.acquiredRecords().get(0)).firstOffset() ? 1 : 0) != 0);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestNoSharingBetweenMultipleConsumersFromDifferentGroups() {
        String groupId1 = "group1";
        String groupId2 = "group2";
        String groupId3 = "group3";
        Uuid memberId1 = Uuid.randomUuid();
        Uuid memberId2 = Uuid.randomUuid();
        Uuid memberId3 = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId1, groupId1, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.sendFirstShareFetchRequest(memberId2, groupId2, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.sendFirstShareFetchRequest(memberId3, groupId3, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        ShareRequestMetadata metadata1 = new ShareRequestMetadata(memberId1, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap1 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest1 = this.createShareFetchRequest(groupId1, metadata1, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap1, 5000, 0, Integer.MAX_VALUE);
        ShareRequestMetadata metadata2 = new ShareRequestMetadata(memberId2, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap2 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest2 = this.createShareFetchRequest(groupId2, metadata2, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap2, 5000, 0, Integer.MAX_VALUE);
        ShareRequestMetadata metadata3 = new ShareRequestMetadata(memberId3, ShareRequestMetadata.nextEpoch((int)0));
        scala.collection.immutable.Map acknowledgementsMap3 = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest3 = this.createShareFetchRequest(groupId3, metadata3, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap3, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponse shareFetchResponse1 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest1, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse2 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest2, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponse shareFetchResponse3 = (ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest3, ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        ShareFetchResponseData shareFetchResponseData1 = shareFetchResponse1.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData1.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData1.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData1 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData1.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData2 = shareFetchResponse2.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData2.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData2.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData2 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData2.responses().get(0)).partitions().get(0);
        ShareFetchResponseData shareFetchResponseData3 = shareFetchResponse3.data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData3.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData3.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData partitionData3 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData3.responses().get(0)).partitions().get(0);
        Assertions.assertEquals((Object)partitionData1.acquiredRecords(), this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        Assertions.assertEquals((Object)partitionData2.acquiredRecords(), this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        Assertions.assertEquals((Object)partitionData3.acquiredRecords(), this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareSessionCloseWithShareFetch() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, this.createTopicAndReturnLeaders$default$2(), this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        acknowledgementsMapForFetch = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = -1;
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map cfr_ignored_0 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(10L).setLastOffset(19L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        acknowledgementsMapForFetch = null;
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 0, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)0, (int)shareFetchResponseData.responses().size());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareSessionCloseWithShareAcknowledge() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, this.createTopicAndReturnLeaders$default$2(), this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForFetch = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        this.produceData(topicIdPartition, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        acknowledgementsMapForFetch = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMapForFetch, 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        expectedFetchPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        fetchPartitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedFetchPartitionData, fetchPartitionData);
        shareSessionEpoch = -1;
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMapForAcknowledge = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(10L).setLastOffset(19L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMapForAcknowledge);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareAcknowledgeResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareAcknowledgeResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().size());
        ShareAcknowledgeResponseData.PartitionData expectedAcknowledgePartitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.PartitionData acknowledgePartitionData = (ShareAcknowledgeResponseData.PartitionData)((ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse)shareAcknowledgeResponseData.responses().get(0)).partitions().get(0);
        this.compareAcknowledgeResponsePartitions(expectedAcknowledgePartitionData, acknowledgePartitionData);
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchInitialEpochWithAcknowledgements() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, 0);
        scala.collection.immutable.Map acknowledgementsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)shareFetchResponseData.errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeInitialRequestError() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, 0);
        scala.collection.immutable.Map acknowledgementsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMap);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.INVALID_SHARE_SESSION_EPOCH.code(), (short)shareAcknowledgeResponseData.errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestInvalidShareSessionEpoch() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)ShareRequestMetadata.nextEpoch((int)shareSessionEpoch));
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.INVALID_SHARE_SESSION_EPOCH.code(), (short)shareFetchResponseData.errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeRequestInvalidShareSessionEpoch() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)ShareRequestMetadata.nextEpoch((int)shareSessionEpoch));
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMap);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.INVALID_SHARE_SESSION_EPOCH.code(), (short)shareAcknowledgeResponseData.errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestShareSessionNotFound() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        Uuid wrongMemberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(wrongMemberId, shareSessionEpoch);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.SHARE_SESSION_NOT_FOUND.code(), (short)shareFetchResponseData.errorCode());
    }

    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareAcknowledgeRequestShareSessionNotFound() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        Uuid wrongMemberId = Uuid.randomUuid();
        String topic = "topic";
        int partition = 0;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topic, partition));
        .colon.colon send = new .colon.colon((Object)topicIdPartition, (List)Nil$.MODULE$);
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)0L)), Collections.singletonList(BoxesRunTime.boxToLong((long)9L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(wrongMemberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareAcknowledgeRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)1))), (List)Nil$.MODULE$)).asJava())}));
        ShareAcknowledgeRequest shareAcknowledgeRequest = this.createShareAcknowledgeRequest(groupId, metadata, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>>)acknowledgementsMap);
        ShareAcknowledgeResponseData shareAcknowledgeResponseData = ((ShareAcknowledgeResponse)this.connectAndReceive((AbstractRequest)shareAcknowledgeRequest, ClassTag$.MODULE$.apply(ShareAcknowledgeResponse.class))).data();
        Assertions.assertEquals((short)Errors.SHARE_SESSION_NOT_FOUND.code(), (short)shareAcknowledgeResponseData.errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")}), @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,share"), @ClusterConfigProperty(key="group.share.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.share.persister.class.name", value="org.apache.kafka.server.share.persister.DefaultStatePersister"), @ClusterConfigProperty(key="share.coordinator.state.topic.replication.factor", value="1"), @ClusterConfigProperty(key="share.coordinator.state.topic.num.partitions", value="1"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})})
    public void testShareFetchRequestForgetTopicPartitions() {
        String groupId = "group";
        Uuid memberId = Uuid.randomUuid();
        String topic = "topic1";
        int partition1 = 0;
        int partition2 = 1;
        this.createTopicAndReturnLeaders(topic, 3, this.createTopicAndReturnLeaders$default$3(), this.createTopicAndReturnLeaders$default$4());
        Uuid topicId = (Uuid)CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava().get(topic);
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, new TopicPartition(topic, partition1));
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, new TopicPartition(topic, partition2));
        .colon.colon send = new .colon.colon((Object)topicIdPartition1, (List)new .colon.colon((Object)topicIdPartition2, (List)Nil$.MODULE$));
        this.sendFirstShareFetchRequest(memberId, groupId, (scala.collection.immutable.Seq<TopicIdPartition>)send);
        this.initProducer();
        this.produceData(topicIdPartition1, 10);
        this.produceData(topicIdPartition2, 10);
        int shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)0);
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        scala.collection.immutable.Map acknowledgementsMap = Predef$.MODULE$.Map().empty();
        ShareFetchRequest shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ObjectRef responses = ObjectRef.create((Object)Nil$.MODULE$);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ShareFetchResponseData $anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)$anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData.errorCode());
            Assertions.assertEquals((int)1, (int)$anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData.responses().size());
            if (((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData.responses().get(0)).partitions().size() > 0) {
                Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData.responses().get(0)).topicId());
                ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(((ShareFetchResponseData.ShareFetchableTopicResponse)$anonfun$testShareFetchRequestForgetTopicPartitions$1_shareFetchResponseData.responses().get(0)).partitions()).foreach((Function1 & Serializable)partitionData -> {
                    ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestForgetTopicPartitions$2(responses$2, partitionData);
                    return BoxedUnit.UNIT;
                });
            }
            Object var24_18 = null;
            if (((scala.collection.immutable.Seq)responses.elem).size() == 2) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Share fetch request failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceData(topicIdPartition1, 10);
        this.produceData(topicIdPartition2, 10);
        shareSessionEpoch = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch);
        metadata = new ShareRequestMetadata(memberId, shareSessionEpoch);
        .colon.colon forget = new .colon.colon((Object)topicIdPartition1, (List)Nil$.MODULE$);
        shareFetchRequest = this.createShareFetchRequest(groupId, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TopicIdPartition>)forget, (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)acknowledgementsMap, 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        Assertions.assertEquals((Object)topicId, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size());
        ShareFetchResponseData.PartitionData expectedPartitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition2).setErrorCode(Errors.NONE.code()).setAcknowledgeErrorCode(Errors.NONE.code()).setAcquiredRecords(this.expectedAcquiredRecords(Collections.singletonList(BoxesRunTime.boxToLong((long)10L)), Collections.singletonList(BoxesRunTime.boxToLong((long)19L)), Collections.singletonList(BoxesRunTime.boxToInteger((int)1))));
        ShareFetchResponseData.PartitionData partitionData2 = (ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().get(0);
        this.compareFetchResponsePartitions(expectedPartitionData, partitionData2);
    }

    /*
     * WARNING - void declaration
     */
    private void sendFirstShareFetchRequest(Uuid memberId, String groupId, scala.collection.immutable.Seq<TopicIdPartition> topicIdPartitions) {
        HashSet partitions = new HashSet();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ShareFetchAcknowledgeRequestTest.$anonfun$sendFirstShareFetchRequest$1(this, memberId, groupId, topicIdPartitions, partitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Share fetch request failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private java.util.List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords(java.util.List<Object> firstOffsets, java.util.List<Object> lastOffsets, java.util.List<Object> deliveryCounts) {
        ArrayList<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(firstOffsets).indices().foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> acquiredRecordsList.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(BoxesRunTime.unboxToLong(firstOffsets.get(i))).setLastOffset(BoxesRunTime.unboxToLong(lastOffsets.get(i))).setDeliveryCount((short)BoxesRunTime.unboxToInt(deliveryCounts.get(i)))));
        return acquiredRecordsList;
    }

    private void compareFetchResponsePartitions(ShareFetchResponseData.PartitionData expectedResponse, ShareFetchResponseData.PartitionData actualResponse) {
        Assertions.assertEquals((int)expectedResponse.partitionIndex(), (int)actualResponse.partitionIndex());
        Assertions.assertEquals((short)expectedResponse.errorCode(), (short)actualResponse.errorCode());
        Assertions.assertEquals((short)expectedResponse.errorCode(), (short)actualResponse.errorCode());
        Assertions.assertEquals((short)expectedResponse.acknowledgeErrorCode(), (short)actualResponse.acknowledgeErrorCode());
        Assertions.assertEquals((Object)expectedResponse.acquiredRecords(), (Object)actualResponse.acquiredRecords());
    }

    private void compareAcknowledgeResponsePartitions(ShareAcknowledgeResponseData.PartitionData expectedResponse, ShareAcknowledgeResponseData.PartitionData actualResponse) {
        Assertions.assertEquals((int)expectedResponse.partitionIndex(), (int)actualResponse.partitionIndex());
        Assertions.assertEquals((short)expectedResponse.errorCode(), (short)actualResponse.errorCode());
    }

    private ShareFetchRequest createShareFetchRequest(String groupId, ShareRequestMetadata metadata, int maxPartitionBytes, scala.collection.immutable.Seq<TopicIdPartition> send, scala.collection.immutable.Seq<TopicIdPartition> forget, scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>> acknowledgementsMap, int maxWaitMs, int minBytes, int maxBytes) {
        return (ShareFetchRequest)ShareFetchRequest.Builder.forConsumer((String)groupId, (ShareRequestMetadata)metadata, (int)maxWaitMs, (int)minBytes, (int)maxBytes, (int)maxPartitionBytes, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(send).asJava(), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(forget).asJava(), (Map)CollectionConverters$.MODULE$.MapHasAsJava(acknowledgementsMap).asJava()).build();
    }

    private int createShareFetchRequest$default$7() {
        return 5000;
    }

    private int createShareFetchRequest$default$8() {
        return 0;
    }

    private int createShareFetchRequest$default$9() {
        return Integer.MAX_VALUE;
    }

    private ShareAcknowledgeRequest createShareAcknowledgeRequest(String groupId, ShareRequestMetadata metadata, scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgementsMap) {
        return (ShareAcknowledgeRequest)ShareAcknowledgeRequest.Builder.forConsumer((String)groupId, (ShareRequestMetadata)metadata, (Map)CollectionConverters$.MODULE$.MapHasAsJava(acknowledgementsMap).asJava()).build();
    }

    public static final /* synthetic */ boolean $anonfun$testShareFetchRequestToNonLeaderReplica$2(int leader$1, KafkaBroker x$2) {
        return x$2.config().brokerId() != leader$1;
    }

    public static final /* synthetic */ void $anonfun$testShareFetchRequestSuccessMultiplePartitions$2(ObjectRef responses$1, ShareFetchResponseData.PartitionData partitionData) {
        if (!partitionData.acquiredRecords().isEmpty()) {
            responses$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)responses$1.elem).$colon$plus((Object)partitionData);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testShareFetchRequestSuccessMultiplePartitions$1(ShareFetchAcknowledgeRequestTest $this, ShareFetchRequest shareFetchRequest$1, Uuid topicId$1, ObjectRef responses$1) {
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)$this.connectAndReceive((AbstractRequest)shareFetchRequest$1, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        if (((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size() > 0) {
            Assertions.assertEquals((Object)topicId$1, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
            ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions()).foreach((Function1 & Serializable)partitionData -> {
                ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestSuccessMultiplePartitions$2(responses$1, partitionData);
                return BoxedUnit.UNIT;
            });
        }
        return ((scala.collection.immutable.Seq)responses$1.elem).size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testShareFetchRequestSuccessMultiplePartitions$3() {
        return "Share fetch request failed";
    }

    public static final /* synthetic */ void $anonfun$testShareFetchRequestSuccessMultiplePartitions$4(ShareFetchAcknowledgeRequestTest $this, ShareFetchResponseData.PartitionData expectedPartitionData1$1, ShareFetchResponseData.PartitionData expectedPartitionData2$1, ShareFetchResponseData.PartitionData expectedPartitionData3$1, ShareFetchResponseData.PartitionData partitionData) {
        int n = partitionData.partitionIndex();
        switch (n) {
            case 0: {
                $this.compareFetchResponsePartitions(expectedPartitionData1$1, partitionData);
                return;
            }
            case 1: {
                $this.compareFetchResponsePartitions(expectedPartitionData2$1, partitionData);
                return;
            }
            case 2: {
                $this.compareFetchResponsePartitions(expectedPartitionData3$1, partitionData);
                return;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ boolean $anonfun$testShareFetchRequestPiggybackedRelease$1(ShareFetchAcknowledgeRequestTest $this, IntRef shareSessionEpoch$1, ObjectRef metadata$1, Uuid memberId$1, BooleanRef releaseAcknowledgementSent$1, ObjectRef acknowledgementsMapForFetch$1, TopicIdPartition topicIdPartition$1, ObjectRef shareFetchRequest$2, String groupId$1, scala.collection.immutable.Seq send$1, ObjectRef shareFetchResponse$1, ObjectRef shareFetchResponseData$1, Uuid topicId$2, java.util.List acquiredRecords$1) {
        shareSessionEpoch$1.elem = ShareRequestMetadata.nextEpoch((int)shareSessionEpoch$1.elem);
        metadata$1.elem = new ShareRequestMetadata(memberId$1, shareSessionEpoch$1.elem);
        if (releaseAcknowledgementSent$1.elem) {
            acknowledgementsMapForFetch$1.elem = Predef$.MODULE$.Map().empty();
        } else {
            acknowledgementsMapForFetch$1.elem = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition$1), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ShareFetchRequestData.AcknowledgementBatch().setFirstOffset(0L).setLastOffset(9L).setAcknowledgeTypes(Collections.singletonList(Predef$.MODULE$.byte2Byte((byte)2))), (List)Nil$.MODULE$)).asJava())}));
            releaseAcknowledgementSent$1.elem = true;
        }
        shareFetchRequest$2.elem = $this.createShareFetchRequest(groupId$1, (ShareRequestMetadata)metadata$1.elem, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)send$1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)((scala.collection.immutable.Map)acknowledgementsMapForFetch$1.elem), 5000, 0, Integer.MAX_VALUE);
        shareFetchResponse$1.elem = (ShareFetchResponse)$this.connectAndReceive((AbstractRequest)((ShareFetchRequest)shareFetchRequest$2.elem), ClassTag$.MODULE$.apply(ShareFetchResponse.class));
        shareFetchResponseData$1.elem = ((ShareFetchResponse)shareFetchResponse$1.elem).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData)shareFetchResponseData$1.elem).errorCode());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData)shareFetchResponseData$1.elem).responses().size());
        Assertions.assertEquals((Object)topicId$2, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)((ShareFetchResponseData)shareFetchResponseData$1.elem).responses().get(0)).topicId());
        if (((ShareFetchResponseData.ShareFetchableTopicResponse)((ShareFetchResponseData)shareFetchResponseData$1.elem).responses().get(0)).partitions().size() > 0) {
            acquiredRecords$1.addAll(((ShareFetchResponseData.PartitionData)((ShareFetchResponseData.ShareFetchableTopicResponse)((ShareFetchResponseData)shareFetchResponseData$1.elem).responses().get(0)).partitions().get(0)).acquiredRecords());
        }
        return acquiredRecords$1.size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testShareFetchRequestPiggybackedRelease$2() {
        return "Share fetch request failed";
    }

    public static final /* synthetic */ void $anonfun$testShareFetchRequestForgetTopicPartitions$2(ObjectRef responses$2, ShareFetchResponseData.PartitionData partitionData) {
        if (!partitionData.acquiredRecords().isEmpty()) {
            responses$2.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)responses$2.elem).$colon$plus((Object)partitionData);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testShareFetchRequestForgetTopicPartitions$1(ShareFetchAcknowledgeRequestTest $this, ObjectRef shareFetchRequest$3, Uuid topicId$3, ObjectRef responses$2) {
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)$this.connectAndReceive((AbstractRequest)((ShareFetchRequest)shareFetchRequest$3.elem), ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        Assertions.assertEquals((int)1, (int)shareFetchResponseData.responses().size());
        if (((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions().size() > 0) {
            Assertions.assertEquals((Object)topicId$3, (Object)((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).topicId());
            ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(((ShareFetchResponseData.ShareFetchableTopicResponse)shareFetchResponseData.responses().get(0)).partitions()).foreach((Function1 & Serializable)partitionData -> {
                ShareFetchAcknowledgeRequestTest.$anonfun$testShareFetchRequestForgetTopicPartitions$2(responses$2, partitionData);
                return BoxedUnit.UNIT;
            });
        }
        return ((scala.collection.immutable.Seq)responses$2.elem).size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testShareFetchRequestForgetTopicPartitions$3() {
        return "Share fetch request failed";
    }

    public static final /* synthetic */ void $anonfun$sendFirstShareFetchRequest$2(Set partitions$1, ShareFetchResponseData.ShareFetchableTopicResponse response) {
        if (!response.partitions().isEmpty()) {
            response.partitions().forEach(partitionData -> partitions$1.add(Predef$.MODULE$.int2Integer(partitionData.partitionIndex())));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendFirstShareFetchRequest$1(ShareFetchAcknowledgeRequestTest $this, Uuid memberId$2, String groupId$2, scala.collection.immutable.Seq topicIdPartitions$1, Set partitions$1) {
        ShareRequestMetadata metadata = new ShareRequestMetadata(memberId$2, 0);
        ShareFetchRequest shareFetchRequest = $this.createShareFetchRequest(groupId$2, metadata, 10000, (scala.collection.immutable.Seq<TopicIdPartition>)topicIdPartitions$1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Map<TopicIdPartition, java.util.List<ShareFetchRequestData.AcknowledgementBatch>>)Predef$.MODULE$.Map().empty(), 5000, 0, Integer.MAX_VALUE);
        ShareFetchResponseData shareFetchResponseData = ((ShareFetchResponse)$this.connectAndReceive((AbstractRequest)shareFetchRequest, ClassTag$.MODULE$.apply(ShareFetchResponse.class))).data();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shareFetchResponseData.errorCode());
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(shareFetchResponseData.responses()).foreach((Function1 & Serializable)response -> {
            ShareFetchAcknowledgeRequestTest.$anonfun$sendFirstShareFetchRequest$2(partitions$1, response);
            return BoxedUnit.UNIT;
        });
        return partitions$1.size() == topicIdPartitions$1.size();
    }

    public static final /* synthetic */ String $anonfun$sendFirstShareFetchRequest$4() {
        return "Share fetch request failed";
    }

    public ShareFetchAcknowledgeRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

