/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.server.BaseRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.ProduceRequestTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001C\u0002\u0013\u0005q\u0004\u0003\u00047\u0001\u0001\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006E\u0002!Ia\u0019\u0005\u0006q\u0002!\t!\u001f\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u001d9\u0011QN\t\t\u0002\u0005=dA\u0002\t\u0012\u0011\u0003\t\t\b\u0003\u0004\u001c\u001b\u0011\u0005\u0011\u0011\u0010\u0005\b\u00033iA\u0011AA>\u0005I\u0001&o\u001c3vG\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aIR\"A\t\n\u0005i\t\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\r\u0001\u00035iW\r\u001e:jGN\\U-_*fiV\t\u0001\u0005E\u0002\"Q)j\u0011A\t\u0006\u0003G\u0011\nq!\\;uC\ndWM\u0003\u0002&M\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0012\u0003\u0007M+G\u000f\u0005\u0002,i5\tAF\u0003\u0002.]\u0005!1m\u001c:f\u0015\ty\u0003'A\u0004nKR\u0014\u0018nY:\u000b\u0005E\u0012\u0014AB=b[6,'OC\u00014\u0003\r\u0019w.\\\u0005\u0003k1\u0012!\"T3ue&\u001cg*Y7f\u00039iW\r\u001e:jGN\\U-_*fi\u0002\n\u0001\u0004^3tiNKW\u000e\u001d7f!J|G-^2f%\u0016\fX/Z:u)\tIT\b\u0005\u0002;w5\ta%\u0003\u0002=M\t!QK\\5u\u0011\u0015qD\u00011\u0001@\u0003\u0019\tXo\u001c:v[B\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"A\u0011\u0014\u000e\u0003\rS!\u0001R\u000b\u0002\rq\u0012xn\u001c;?\u0013\t1e%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$'Q\t!1\n\u0005\u0002M+6\tQJ\u0003\u0002O\u001f\u00061\u0001/\u0019:b[NT!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!kU\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002)\u0006\u0019qN]4\n\u0005Yk%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"\"A\u0001\u00170`!\tIF,D\u0001[\u0015\tYV*\u0001\u0005qe>4\u0018\u000eZ3s\u0013\ti&LA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0002A\u0006\n\u0011-A\u0003le\u00064G/\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g\u000eV8MK\u0006$WM\u001d\u000b\u0004I*4\b\u0003\u0002!fO\u001eL!AZ%\u0003\u00075\u000b\u0007\u000f\u0005\u0002;Q&\u0011\u0011N\n\u0002\u0004\u0013:$\b\"B6\u0006\u0001\u0004a\u0017!B1e[&t\u0007CA7u\u001b\u0005q'BA6p\u0015\t\u0001\u0018/A\u0004dY&,g\u000e^:\u000b\u0005Q\u0011(BA:T\u0003\u0019\t\u0007/Y2iK&\u0011QO\u001c\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\u0006o\u0016\u0001\raP\u0001\u0006i>\u0004\u0018nY\u0001 i\u0016\u001cH\u000f\u0015:pIV\u001cWmV5uQ&sg/\u00197jIRKW.Z:uC6\u0004HcA\u001d{y\")1P\u0002a\u0001\u007f\u00051R.Z:tC\u001e,G+[7f'R\fW\u000e]\"p]\u001aLw\rC\u0003~\r\u0001\u0007a0A\bsK\u000e|'\u000f\u001a+j[\u0016\u001cH/Y7q!\tQt0C\u0002\u0002\u0002\u0019\u0012A\u0001T8oO\"2aaSA\u0003\u0003\u000f\tAA\\1nK\u0006\u0012\u0011\u0011B\u0001\rcV|'/^7>WJ\fg\r\u001e\u0015\b\r\u00055\u00111CA\u000b!\rI\u0016qB\u0005\u0004\u0003#Q&\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA\fC\t\tI\"A\fuS6,7\u000f^1na\u000e{gNZ5h!J|g/\u001b3fe\u00069B/Z:u!J|G-^2f)>tuN\u001c*fa2L7-\u0019\u000b\u0004s\u0005}\u0001\"\u0002 \b\u0001\u0004y\u0004FA\u0004LQ\u00159\u0001LXA\u0013Y\u0005\u0001\u0017!J2sK\u0006$X\rV8qS\u000e\fe\u000e\u001a$j]\u0012\u0004\u0016M\u001d;ji&|gnV5uQ2+\u0017\rZ3s)\u0011\tY#!\r\u0011\u000bi\nicZ4\n\u0007\u0005=bE\u0001\u0004UkBdWM\r\u0005\u0006o\"\u0001\raP\u0001\u001di\u0016\u001cHoQ8seV\u0004H\u000f\u0014>5!J|G-^2f%\u0016\fX/Z:u)\rI\u0014q\u0007\u0005\u0006}%\u0001\ra\u0010\u0015\u0003\u0013-CS!\u0003-_\u0003{a\u0013\u0001Y\u0001\u0017i\u0016\u001cHOW*U\tB\u0013x\u000eZ;dKJ+\u0017/^3tiR\u0019\u0011(a\u0011\t\u000byR\u0001\u0019A )\u0005)Y\u0005&\u0002\u0006Y=\u0006%C&\u00011\u0002%M,g\u000e\u001a)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003\u001f\ny&a\u0019\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005A!/Z9vKN$8OC\u0002\u0002ZE\faaY8n[>t\u0017\u0002BA/\u0003'\u0012q\u0002\u0015:pIV\u001cWMU3ta>t7/\u001a\u0005\u0007\u0003CZ\u0001\u0019A4\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!!\u001a\f\u0001\u0004\t9'A\u0004sKF,Xm\u001d;\u0011\t\u0005E\u0013\u0011N\u0005\u0005\u0003W\n\u0019F\u0001\bQe>$WoY3SKF,Xm\u001d;\u0002%A\u0013x\u000eZ;dKJ+\u0017/^3tiR+7\u000f\u001e\t\u000315\u00192!DA:!\rQ\u0014QO\u0005\u0004\u0003o2#AB!osJ+g\r\u0006\u0002\u0002pU\u0011\u0011Q\u0010\t\u0007\u0003\u007f\ni)!%\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000baa\u001d;sK\u0006l'\u0002BAD\u0003\u0013\u000bA!\u001e;jY*\u0011\u00111R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0006\u0005%AB*ue\u0016\fW\u000eE\u0002Z\u0003'K1!!&[\u0005%\t%oZ;nK:$8\u000f")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public static Stream<Arguments> timestampConfigProvider() {
        return ProduceRequestTest$.MODULE$.timestampConfigProvider();
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSimpleProduceRequest(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        void var4_4;
        void var3_3;
        void withRecords_records2;
        void withRecords_timestampType2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var5_6 = null;
        simpleRecordArray = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2), 0L, (int)var3_3, (int)var4_4);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())};
        GzipCompression withRecords_compression2 = new GzipCompression.Builder().build();
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var7_11 = null;
        simpleRecordArray2 = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1L, (int)var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<Object, Object> getPartitionToLeader(Admin admin, String topic) {
        TopicDescription topicDescription;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((topicDescription = (TopicDescription)((java.util.Map)admin.describeTopics(Arrays.asList(topic)).allTopicNames().get(10L, TimeUnit.MINUTES)).get(topic)) != null)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProduceRequestTest.$anonfun$getPartitionToLeader$2(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.partition())), (Object)BoxesRunTime.boxToInteger((int)p.leader().id())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @ParameterizedTest(name="quorum=kraft")
    @MethodSource(value={"timestampConfigProvider"})
    public void testProduceWithInvalidTimestamp(String messageTimeStampConfig, long recordTimestamp) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(messageTimeStampConfig, "1000");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic, x$3, x$4, 1, 1, (Map<Object, Seq<Object>>)x$8, topicConfig);
        int leader = BoxesRunTime.unboxToInt((Object)this.getPartitionToLeader(admin, topic).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, recordTimestamp, (Compression)new GzipCompression.Builder().build());
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = CollectionConverters$.MODULE$.ListHasAsScala(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$2(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testProduceToNonReplica(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic, this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int leader = BoxesRunTime.unboxToInt((Object)this.getPartitionToLeader(admin, topic).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$2)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var14_9 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)this.createTopic(topic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("No leader elected for topic " + topic));
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCorruptLz4ProduceRequest(String quorum) {
        void var4_4;
        void var3_3;
        void withRecords_records;
        void withRecords_timestampType;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Int$.MODULE$.int2long(timestamp), "key".getBytes(), "value".getBytes())};
        Lz4Compression withRecords_compression = new Lz4Compression.Builder().build();
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_7 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var3_3);
        ProduceResponse produceResponse = this.sendProduceRequest((int)var4_4, (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$4))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount("InvalidMessageCrcRecordsPerSec") > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testZSTDProduceRequest(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, x$4, topicConfig, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        ZstdCompression withRecords_compression = new ZstdCompression.Builder().build();
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var17_11 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse1.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse1.partitionResponses()).asScala().head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
        Assertions.assertEquals((short)ApiKeys.PRODUCE.latestVersion(), (short)produceRequest.version());
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionToLeader$1(Admin admin$1, String topic$1, ObjectRef topicDescription$1) {
        java.util.Map topicMap = (java.util.Map)admin$1.describeTopics(Arrays.asList(topic$1)).allTopicNames().get(10L, TimeUnit.MINUTES);
        topicDescription$1.elem = (TopicDescription)topicMap.get(topic$1);
        return (TopicDescription)topicDescription$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$getPartitionToLeader$2(String topic$1) {
        return "Timed out waiting to describe topic " + topic$1;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, Compression codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$2(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaBroker x$2) {
        return x$2.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$4) {
        return x$4.getMBeanName().endsWith("InvalidMessageCrcRecordsPerSec");
    }
}

