/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.OptionalInt;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u0012%\u0001%B\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00037\u0011!Q\u0004A!b\u0001\n\u0003Y\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\r\u0003!Q1A\u0005\u0002mB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005y!Aa\t\u0001B\u0001B\u0003%q\tC\u0003K\u0001\u0011\u00051\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\r-\u0004\u0001\u0015!\u0003V\u0011\u001da\u0007\u00011A\u0005\n5Dq!\u001d\u0001A\u0002\u0013%!\u000f\u0003\u0004y\u0001\u0001\u0006KA\u001c\u0005\u0006s\u0002!\tA\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t)\b\u0001C!\u0003oBq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005v!CAVI\u0005\u0005\t\u0012AAW\r!\u0019C%!A\t\u0002\u0005=\u0006B\u0002&\u001e\t\u0003\t9\fC\u0005\u0002:v\t\n\u0011\"\u0001\u0002<\"I\u0011\u0011[\u000f\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003'l\u0012\u0013!C\u0001\u0003wC\u0011\"!6\u001e#\u0003%\t!a6\u0003#5{7m\u001b$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002&M\u000511/\u001a:wKJT\u0011aJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0006\u0005\u0002,Y5\tA%\u0003\u0002.I\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017AC7pG.dU-\u00193feV\t\u0001\u0007\u0005\u0002,c%\u0011!\u0007\n\u0002\u0013\u001b>\u001c7\u000eT3bI\u0016\u0014XI\u001c3Q_&tG/A\u0006n_\u000e\\G*Z1eKJ\u0004\u0013\u0001F7pG.$\u0016.\u001a:Ti\u0006$X-T1dQ&tW-F\u00017!\tYs'\u0003\u00029I\t!Rj\\2l)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016\fQ#\\8dWRKWM]*uCR,W*Y2iS:,\u0007%A\u0005sKBd\u0017nY1JIV\tA\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0002J]R\f!B]3qY&\u001c\u0017-\u00133!\u0003!aW-\u00193fe&#\u0017!\u00037fC\u0012,'/\u00133!\u000391W\r^2i\u0005\u0006\u001c7n\u00144g\u001bN\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005-B\u0015BA%%\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0004=S:LGO\u0010\u000b\b\u00196su\nU)S!\tY\u0003\u0001C\u0003/\u0017\u0001\u0007\u0001\u0007C\u00035\u0017\u0001\u0007a\u0007C\u0004;\u0017A\u0005\t\u0019\u0001\u001f\t\u000f\r[\u0001\u0013!a\u0001y!9Qi\u0003I\u0001\u0002\u0004a\u0004b\u0002$\f!\u0003\u0005\raR\u0001\u0017e\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgV\tQ\u000b\u0005\u0003W7vCW\"A,\u000b\u0005aK\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00035z\n!bY8mY\u0016\u001cG/[8o\u0013\tavKA\u0002NCB\u0004\"A\u00184\u000e\u0003}S!\u0001Y1\u0002\r\r|W.\\8o\u0015\t9#M\u0003\u0002dI\u00061\u0011\r]1dQ\u0016T\u0011!Z\u0001\u0004_J<\u0017BA4`\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aK5\n\u0005)$#A\u0004)beRLG/[8o'R\fG/Z\u0001\u0018e\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002\n!\u0003\\1uKN$X\t]8dQ\u0012+g-Y;miV\ta\u000eE\u0002>_rJ!\u0001\u001d \u0003\r=\u0003H/[8o\u0003Ya\u0017\r^3ti\u0016\u0003xn\u00195EK\u001a\fW\u000f\u001c;`I\u0015\fHCA:w!\tiD/\u0003\u0002v}\t!QK\\5u\u0011\u001d9x\"!AA\u00029\f1\u0001\u001f\u00132\u0003Ma\u0017\r^3ti\u0016\u0003xn\u00195EK\u001a\fW\u000f\u001c;!\u0003=\u0019X\r\u001e*fa2L7-Y*uCR,GcA:|{\")A0\u0005a\u0001;\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u0002@\u0012\u0001\u0004A\u0017!B:uCR,\u0017!\u0006:fa2L7-\u0019)beRLG/[8o'R\fG/\u001a\u000b\u0004Q\u0006\r\u0001\"\u0002?\u0013\u0001\u0004i\u0016!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002\n\u0005E\u0011q\u0004\t\u0006\u0003\u0017\ti!X\u0007\u00023&\u0019\u0011qB-\u0003\u0007M+G\u000fC\u0004\u0002\u0014M\u0001\r!!\u0006\u0002%%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$Xm\u001d\t\b\u0003\u0017\t9\"XA\r\u0013\ta\u0016\fE\u0002,\u00037I1!!\b%\u0005EIe.\u001b;jC24U\r^2i'R\fG/\u001a\u0005\b\u0003C\u0019\u0002\u0019AA\u0012\u0003=1wN]2f)J,hnY1uS>t\u0007cA\u001f\u0002&%\u0019\u0011q\u0005 \u0003\u000f\t{w\u000e\\3b]\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"!\f\u0002D\u0005\u0015\u0013q\n\t\u0005{=\fy\u0003\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u00071|wM\u0003\u0003\u0002:\u0005m\u0012!C5oi\u0016\u0014h.\u00197t\u0015\r\ti$Y\u0001\bgR|'/Y4f\u0013\u0011\t\t%a\r\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u0015aH\u00031\u0001^\u0011\u001d\t9\u0005\u0006a\u0001\u0003\u0013\n1BZ3uG\"|eMZ:fiB\u0019Q(a\u0013\n\u0007\u00055cH\u0001\u0003M_:<\u0007bBA))\u0001\u0007\u00111K\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\u0005U\u0013qK\u0007\u0002\u0001%\u0019\u0011\u0011\f\u0017\u0003\u0013\u0019+Go\u00195ECR\f\u0017\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u000bM\fy&!\u0019\t\u000bq,\u0002\u0019A/\t\u000f\u0005\rT\u00031\u0001\u0002f\u0005yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002,\u0003OJ1!!\u001b%\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\u000bM\fy'!\u001d\t\u000bq4\u0002\u0019A/\t\u000f\u0005Md\u00031\u0001\u0002J\u00051qN\u001a4tKR\f1\u0002\\1uKN$X\t]8dQR\u0019a.!\u001f\t\u000bq<\u0002\u0019A/\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011\u0011JA@\u0011\u0015a\b\u00041\u0001^\u00031awnZ#oI>3gm]3u)\u0011\tI%!\"\t\u000bqL\u0002\u0019A/\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0002\f\u0006e\u00151\u0014\t\u0005{=\fi\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\u0001\u00171\u0013\u0006\u0003K\u0005LA!a&\u0002\u0012\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\"\u0002?\u001b\u0001\u0004i\u0006BBAO5\u0001\u0007A(A\u0003fa>\u001c\u0007.\u0001\fwKJLg-\u001f'bgR4U\r^2iK\u0012,\u0005o\\2i)\u0015\u0019\u00181UAT\u0011\u0019\t)k\u0007a\u0001;\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\u0007\u0003S[\u0002\u0019\u00018\u0002\u001b\u0015D\b/Z2uK\u0012,\u0005o\\2i\u0003EiunY6GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0003Wu\u00192!HAY!\ri\u00141W\u0005\u0004\u0003ks$AB!osJ+g\r\u0006\u0002\u0002.\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!0+\u0007q\nyl\u000b\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017!C;oG\",7m[3e\u0015\r\tYMP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAh\u0003\u000b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TCAAmU\r9\u0015q\u0018")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Option<Object> latestEpochDefault;

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static int $lessinit$greater$default$5() {
        return 0;
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Option<Object> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Option<Object> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unknown partition " + topicPartition);
        });
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq((Option<Object>)(forceTruncation ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)0))));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.leader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            throw new IllegalStateException("processPartitionData should not be called for a partition with a diverging epoch.");
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException("Offset mismatch for partition " + topicPartition + ": fetched offset = " + fetchOffset + ", log end offset = " + state.logEndOffset() + ".");
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef shallowOffsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create((Object)OptionalInt.empty());
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, shallowOffsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(fetchOffset, lastOffset.elem, (OptionalInt)lastEpoch.elem, maxTimestamp.elem, shallowOffsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordValidationStats.EMPTY, CompressionType.NONE, FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        if (state.rlmEnabled()) {
            state.localLogStartOffset_$eq(offset);
        } else {
            state.logStartOffset_$eq(offset);
        }
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).log().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionLeaderEpoch())).orElse((Function0 & Serializable)() -> this.latestEpochDefault());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.leader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef shallowOffsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            shallowOffsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = OptionalInt.of(batch.partitionLeaderEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, int fetchBackOffMs, FailedPartitions failedPartitions) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$7 = new BrokerTopicStats();
        boolean x$8 = true;
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, (TierStateMachine)mockTierStateMachine, fetchBackOffMs, x$8, x$7);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        mockTierStateMachine.setFetcher(this);
    }
}

