/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0003Y\u0003B\u0002\u001c\u0001A\u0003%A\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r\u0005\u0003\u0001\u0015!\u0003:\u0011\u001d\u0011\u0005A1A\u0005\n-Baa\u0011\u0001!\u0002\u0013a\u0003b\u0002#\u0001\u0005\u0004%\te\u000b\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u0017\t\u000b\u0019\u0003A\u0011I$\t\u000bq\u0003A\u0011A/\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011Q\u0014\u0001\u0005\u0002\u0005}%!\u0005'pO\u0012K'OR1jYV\u0014X\rV3ti*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005H\u0001\u0004CBL\u0017BA\u0013#\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdFA\u0002J]R\fa\u0002\u001d:pIV\u001cWM]\"pk:$\b%A\u0007d_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u000fG>t7/^7fe\u000e{WO\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0019A\f'\u000f^5uS>tg*^7\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0003-awn\u001a#je\u000e{WO\u001c;\u0002\u00191|w\rR5s\u0007>,h\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005![\u0005CA\u0017J\u0013\tQeF\u0001\u0003V]&$\b\"\u0002'\u000f\u0001\u0004i\u0015\u0001\u0003;fgRLeNZ8\u0011\u000593V\"A(\u000b\u0005\r\u0002&BA)S\u0003\u001dQW\u000f]5uKJT!a\u0015+\u0002\u000b),h.\u001b;\u000b\u0003U\u000b1a\u001c:h\u0013\t9vJ\u0001\u0005UKN$\u0018J\u001c4pQ\tq\u0011\f\u0005\u0002O5&\u00111l\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\n;fgR\u0004&o\u001c3vG\u0016,%O]8s\rJ|WNR1jYV\u0014Xm\u00148M_\u001e\u0014v\u000e\u001c7\u0015\u0007!s&\u000eC\u0003`\u001f\u0001\u0007\u0001-\u0001\u0004rk>\u0014X/\u001c\t\u0003C\"t!A\u00194\u0011\u0005\rtS\"\u00013\u000b\u0005\u0015t\u0012A\u0002\u001fs_>$h(\u0003\u0002h]\u00051\u0001K]3eK\u001aL!\u0001Q5\u000b\u0005\u001dt\u0003\"B6\u0010\u0001\u0004\u0001\u0017!D4s_V\u0004\bK]8u_\u000e|G\u000e\u000b\u0003\u0010[N$\bC\u00018r\u001b\u0005y'B\u00019Q\u0003\u0019\u0001\u0018M]1ng&\u0011!o\u001c\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!^\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u0011yq/ @\u0011\u0005a\\X\"A=\u000b\u0005i|\u0017\u0001\u00039s_ZLG-\u001a:\n\u0005qL(\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A@\"\u0005\u0005\u0005\u0011AK4fiR+7\u000f^)v_J,X.\u00118e\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\fE\u000e\\\u0001\u001ei\u0016\u001cH\u000fT8h\t&\u0014hj\u001c;jM&\u001c\u0017\r^5p]RKW.Z8viR)\u0001*a\u0002\u0002\n!)q\f\u0005a\u0001A\")1\u000e\u0005a\u0001A\"\"\u0001#\\:uQ\u0015\u0001r/`A\bY\u0005y\u0018\u0001\b;fgRLu*\u0012=dKB$\u0018n\u001c8EkJLgn\u001a'pOJ{G\u000e\u001c\u000b\u0006\u0011\u0006U\u0011q\u0003\u0005\u0006?F\u0001\r\u0001\u0019\u0005\u0006WF\u0001\r\u0001\u0019\u0015\u0005#5\u001cH\u000fK\u0003\u0012ov\fi\u0002L\u0001\u0000\u0003\u001d\"Xm\u001d;Qe>$WoY3FeJ|'O\u0012:p[\u001a\u000b\u0017\u000e\\;sK>s7\t[3dWB|\u0017N\u001c;\u0015\u000b!\u000b\u0019#!\n\t\u000b}\u0013\u0002\u0019\u00011\t\u000b-\u0014\u0002\u0019\u00011)\tIi7\u000f\u001e\u0015\u0006%]l\u00181\u0006\u0017\u0002\u007f\u0006yB/Z:u\u0013>+\u0005pY3qi&|g\u000eR;sS:<7\t[3dWB|\u0017N\u001c;\u0015\u000b!\u000b\t$a\r\t\u000b}\u001b\u0002\u0019\u00011\t\u000b-\u001c\u0002\u0019\u00011)\tMi7\u000f\u001e\u0015\u0006']l\u0018\u0011\b\u0017\u0002\u007f\u0006!D/Z:u%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193BMR,'\u000fT8h\t&\u0014h)Y5mkJ,wJ\u001c$pY2|w/\u001a:\u0015\u000b!\u000by$!\u0011\t\u000b}#\u0002\u0019\u00011\t\u000b-$\u0002\u0019\u00011)\tQi7\u000f\u001e\u0015\u0006)]l\u0018q\t\u0017\u0002\u007f\u0006QC/Z:u!J|G-^2f\u000bJ\u0014xN]:Ge>lGj\\4ESJ4\u0015-\u001b7ve\u0016|e\u000eT3bI\u0016\u0014Hc\u0001%\u0002N!9\u0011qJ\u000bA\u0002\u0005E\u0013a\u00034bS2,(/\u001a+za\u0016\u0004B!a\u0015\u0002f9!\u0011QKA0\u001d\u0011\t9&a\u0017\u000f\u0007\r\fI&C\u0001\u001e\u0013\r\ti\u0006H\u0001\u0006kRLGn]\u0005\u0005\u0003C\n\u0019'A\u0005UKN$X\u000b^5mg*\u0019\u0011Q\f\u000f\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0012\u0019><G)\u001b:GC&dWO]3UsB,'\u0002BA1\u0003G\nQ\u0005^3tiB\u0013x\u000eZ;dK\u00063G/\u001a:M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u000b!\u000by'!\u001d\t\u000f\u0005=c\u00031\u0001\u0002R!)qL\u0006a\u0001A\u0006i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003I\u0003o\nI\bC\u00038/\u0001\u0007\u0001\rC\u0004\u0002|]\u0001\r!! \u0002\u0011\r|gn];nKJ\u0004\u0002\"a \u0002\u000e\u0006E\u0015\u0011S\u0007\u0003\u0003\u0003SA!a\u001f\u0002\u0004*!\u0011QQAD\u0003\u001d\u0019G.[3oiNT1!HAE\u0015\r\tY\tV\u0001\u0007CB\f7\r[3\n\t\u0005=\u0015\u0011\u0011\u0002\t\u0007>t7/^7feB)Q&a%\u0002\u0018&\u0019\u0011Q\u0013\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\nI*C\u0002\u0002\u001c:\u0012AAQ=uK\u0006\u00112-Y;tK2{w\rR5s\r\u0006LG.\u001e:f)!\t\t+!,\u00020\u0006e\u0006\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001dV(\u0001\u0002j_&!\u00111VAS\u0005\u00111\u0015\u000e\\3\t\u000f\u0005=\u0003\u00041\u0001\u0002R!9\u0011\u0011\u0017\rA\u0002\u0005M\u0016\u0001\u00047fC\u0012,'O\u0011:pW\u0016\u0014\bcA\u0015\u00026&\u0019\u0011q\u0017\u000e\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u0005\b\u0003wC\u0002\u0019AA_\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-a\"\u0002\r\r|W.\\8o\u0013\u0011\t9-!1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.ensureConsistentKRaftMetadata();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testProduceErrorFromFailureOnLogRoll(String quorum, String groupProtocol) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testLogDirNotificationTimeout(String quorum, String groupProtocol) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$1(x$1))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$2(leaderServerId, x$2))).get();
        this.controllerServer().shutdown();
        this.controllerServer().awaitShutdown();
        this.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, leaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$3(leaderServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$4(leaderServer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leaderServer.awaitShutdown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testIOExceptionDuringLogRoll(String quorum, String groupProtocol) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Roll$.MODULE$, quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testProduceErrorFromFailureOnCheckpoint(String quorum, String groupProtocol) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testIOExceptionDuringCheckpoint(String quorum, String groupProtocol) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$, quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower(String quorum, String groupProtocol) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$3))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$4))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != leaderServerId).get());
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$7))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable)i -> leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable)x$8 -> x$8.leaderLogIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assertions.assertEquals((int)this.brokerCount(), (int)((Partition)leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$9))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$10))).get();
        this.causeLogDirFailure(failureType, leaderServer, partition);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(record).get(6000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((e.getCause() instanceof KafkaStorageException || e.getCause() instanceof NotLeaderOrFollowerException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType, String quorum) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int originalLeaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$11))).get()).leader().id();
        KafkaBroker originalLeaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(originalLeaderServerId, x$12))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, 15000L);
        File failedLogDir = this.causeLogDirFailure(failureType, originalLeaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, originalLeaderServerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected new leader for the partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(this, originalLeaderServerId, failedLogDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Expected to find an offline log dir");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private void subscribeAndWaitForAssignment(String topic, Consumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected non-empty assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public File causeLogDirFailure(TestUtils.LogDirFailureType failureType, KafkaBroker leaderBroker, TopicPartition partition) {
        File logDir = leaderBroker.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
        Files.createFile(logDir.toPath(), new FileAttribute[0]);
        Assertions.assertTrue((boolean)logDir.isFile());
        TestUtils.LogDirFailureType logDirFailureType = failureType;
        TestUtils$Roll$ testUtils$Roll$ = TestUtils$Roll$.MODULE$;
        if (logDirFailureType != null && logDirFailureType.equals(testUtils$Roll$)) {
            Assertions.assertThrows(KafkaStorageException.class, () -> {
                UnifiedLog qual$1 = (UnifiedLog)leaderBroker.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
            });
        } else {
            TestUtils.LogDirFailureType logDirFailureType2 = failureType;
            TestUtils$Checkpoint$ testUtils$Checkpoint$ = TestUtils$Checkpoint$.MODULE$;
            if (logDirFailureType2 != null && logDirFailureType2.equals(testUtils$Checkpoint$)) {
                leaderBroker.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$causeLogDirFailure$3(leaderBroker, logDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected log directory offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)leaderBroker.replicaManager().localLog(partition).isEmpty());
        return logDir;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$1(PartitionInfo x$1) {
        return x$1.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$2(int leaderServerId$1, KafkaBroker x$2) {
        return x$2.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$3(KafkaBroker leaderServer$1) {
        BrokerState brokerState = leaderServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testLogDirNotificationTimeout$4(KafkaBroker leaderServer$1) {
        return "Expected broker to be in NOT_RUNNING state but was " + leaderServer$1.brokerState();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$3) {
        return x$3.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$2, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaBroker x$7) {
        return x$7.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assertions.assertFalse((boolean)thread.isShutdownComplete(), (String)"ReplicaFetcherThread should still be working if its partition count > 0");
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$9) {
        return x$9.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$3, KafkaBroker x$10) {
        return x$10.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$11) {
        return x$11.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int originalLeaderServerId$1, KafkaBroker x$12) {
        return x$12.config().brokerId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$13) {
        return x$13.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$2, ProducerRecord record$2, int originalLeaderServerId$1) {
        producer$2.send(record$2);
        return ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer$2.partitionsFor($this.topic())).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$13))).get()).leader().id() != originalLeaderServerId$1;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$7(int originalLeaderServerId$1, KafkaBroker x$14) {
        return x$14.config().nodeId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$9(File failedLogDir$1, BrokerServer x$16) {
        return x$16.logDirFailureChannel().hasOfflineLogDir(((Object)failedLogDir$1.toPath()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(LogDirFailureTest $this, int originalLeaderServerId$1, File failedLogDir$1) {
        Option brokerWithDirFail = $this.brokers().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$7(originalLeaderServerId$1, x$14))).map((Function1 & Serializable)x$15 -> (BrokerServer)x$15);
        return brokerWithDirFail.exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$9(failedLogDir$1, x$16))) && brokerWithDirFail.exists((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])broker.replicaManager().metadataCache().getClusterMetadata(broker.clusterId(), broker.config().interBrokerListenerName()).partition(new TopicPartition($this.topic(), 0)).offlineReplicas()), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Object)BoxesRunTime.boxToInteger((int)originalLeaderServerId$1))));
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$12() {
        return "Expected to find an offline log dir";
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(Consumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$3(KafkaBroker leaderBroker$1, File logDir$1) {
        return !leaderBroker$1.logManager().isLogDirOnline(logDir$1.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$4() {
        return "Expected log directory offline";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty("replica.high.watermark.checkpoint.interval.ms", "60000");
        this.serverConfig().setProperty("num.replica.fetchers", "1");
        this.serverConfig().setProperty("log.dir.failure.timeout.ms", "5000");
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
    }
}

