/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumImplementation;
import kafka.server.SharedServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\n\u0014\u0001aA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001BC\u0002\u0013\u0005!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003,\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011i\u0002!Q1A\u0005\u0002mB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t+\u0002\u0011)\u0019!C\u0001-\"A!\r\u0001B\u0001B\u0003%q\u000b\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001e\u0011!Y\u0007A!A!\u0002\u0013)\u0007\u0002\u00037\u0001\u0005\u000b\u0007I\u0011A7\t\u0011i\u0004!\u0011!Q\u0001\n9DQa\u001f\u0001\u0005\u0002qDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002F\u0001!\t%a\u0012\u00033-\u0013\u0016M\u001a;Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\u001c\u0006\u0003)U\taa]3sm\u0016\u0014(\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013%D\u0001\u0014\u0013\t\u00113C\u0001\u000bRk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\u0011G>tGO]8mY\u0016\u00148+\u001a:wKJ,\u0012!\n\t\u0003A\u0019J!aJ\n\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018!E2p]R\u0014x\u000e\u001c7feN+'O^3sA\u0005\u0019b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssV\t1\u0006\u0005\u0002!Y%\u0011Qf\u0005\u0002\u0014\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u0001\u0015M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/\u001f\u0011\u0002\u00175,G/\u00193bi\u0006$\u0015N]\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0003S>T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t!a)\u001b7f\u00031iW\r^1eCR\fG)\u001b:!\u0003q\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016,\u0012\u0001\u0010\t\u0004{\t#U\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011)N\u0001\u0005kRLG.\u0003\u0002D}\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u00153\u0005JT\u0007\u0002\u0001&\u0011q\t\u0011\u0002\u0004\u001b\u0006\u0004\bCA%M\u001b\u0005Q%BA&6\u0003\u0011a\u0017M\\4\n\u00055S%aB%oi\u0016<WM\u001d\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#V\n1A\\3u\u0013\t\u0019\u0006KA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\fQdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X\rI\u0001\nG2,8\u000f^3s\u0013\u0012,\u0012a\u0016\t\u00031~s!!W/\u0011\u0005i[R\"A.\u000b\u0005q;\u0012A\u0002\u001fs_>$h(\u0003\u0002_7\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq6$\u0001\u0006dYV\u001cH/\u001a:JI\u0002\n1\u0001\\8h+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015\u0016\u0003\u0015)H/\u001b7t\u0013\tQwMA\u0004M_\u001e<\u0017N\\4\u0002\t1|w\rI\u0001\rM\u0006,H\u000e\u001e%b]\u0012dWM]\u000b\u0002]B\u0011q\u000e_\u0007\u0002a*\u0011\u0011O]\u0001\u0006M\u0006,H\u000e\u001e\u0006\u0003)MT!A\u0006;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003sB\u0014ABR1vYRD\u0015M\u001c3mKJ\fQBZ1vYRD\u0015M\u001c3mKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0007~}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011\u0002\t\u0003A\u0001AQaI\bA\u0002\u0015BQ!K\bA\u0002-BQaL\bA\u0002EBQAO\bA\u0002qBQ!V\bA\u0002]CQaY\bA\u0002\u0015DQ\u0001\\\bA\u00029\fAb\u0019:fCR,'I]8lKJ$\"\"a\u0004\u0002\u0016\u0005}\u0011\u0011GA\u001e!\r\u0001\u0013\u0011C\u0005\u0004\u0003'\u0019\"aC&bM.\f'I]8lKJDq!a\u0006\u0011\u0001\u0004\tI\"\u0001\u0004d_:4\u0017n\u001a\t\u0004A\u0005m\u0011bAA\u000f'\tY1*\u00194lC\u000e{gNZ5h\u0011%\t\t\u0003\u0005I\u0001\u0002\u0004\t\u0019#\u0001\u0003uS6,\u0007\u0003BA\u0013\u0003[i!!a\n\u000b\u0007!\fICC\u0002\u0002,M\faaY8n[>t\u0017\u0002BA\u0018\u0003O\u0011A\u0001V5nK\"I\u00111\u0007\t\u0011\u0002\u0003\u0007\u0011QG\u0001\bgR\f'\u000f^;q!\rQ\u0012qG\u0005\u0004\u0003sY\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{\u0001\u0002\u0013!a\u0001\u0003\u007f\t\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\ti\t\teV\u0005\u0004\u0003\u0007Z\"AB(qi&|g.\u0001\u0005tQV$Hm\\<o)\t\tI\u0005E\u0002\u001b\u0003\u0017J1!!\u0014\u001c\u0005\u0011)f.\u001b;")
public class KRaftQuorumImplementation
implements QuorumImplementation {
    private final ControllerServer controllerServer;
    private final FaultHandlerFactory faultHandlerFactory;
    private final File metadataDir;
    private final CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final String clusterId;
    private final Logging log;
    private final FaultHandler faultHandler;

    @Override
    public Time createBroker$default$2() {
        return QuorumImplementation.createBroker$default$2$(this);
    }

    @Override
    public boolean createBroker$default$3() {
        return QuorumImplementation.createBroker$default$3$(this);
    }

    @Override
    public Option<String> createBroker$default$4() {
        return QuorumImplementation.createBroker$default$4$(this);
    }

    public ControllerServer controllerServer() {
        return this.controllerServer;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public File metadataDir() {
        return this.metadataDir;
    }

    public CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Logging log() {
        return this.log;
    }

    public FaultHandler faultHandler() {
        return this.faultHandler;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addLogDirs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(config.logDirs()).asJava());
        loader.addMetadataLogDir(config.metadataLogDir());
        MetaPropertiesEnsemble ensemble = loader.load();
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(ensemble);
        ensemble.emptyLogDirs().forEach(logDir -> copier.setLogDirProps(logDir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(this.clusterId()).setNodeId(config.nodeId()).setDirectoryId(DirectoryId.random()).build()));
        copier.setPreWriteHandler((logDir, x$1, x$2) -> Files.createDirectories(Paths.get(logDir, new String[0]), new FileAttribute[0]));
        copier.writeLogDirChanges();
        MetaPropertiesEnsemble metaPropertiesEnsemble = copier.copy();
        metaPropertiesEnsemble.verify(Optional.of(this.clusterId()), OptionalInt.of(config.nodeId()), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, time, new Metrics(), this.controllerQuorumVotersFuture(), this.controllerQuorumVotersFuture().get().values(), this.faultHandlerFactory(), ServerSocketFactory.INSTANCE);
        ObjectRef broker = ObjectRef.create(null);
        try {
            broker.elem = new BrokerServer(sharedServer);
            if (startup) {
                ((BrokerServer)broker.elem).startup();
            }
            return (BrokerServer)broker.elem;
        }
        catch (Throwable e) {
            if ((BrokerServer)broker.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((BrokerServer)broker$1.elem).shutdown(), this.log(), Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForBroker(), this.log(), Level.WARN);
            throw e;
        }
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.controllerServer().shutdown(), this.log(), Level.WARN);
    }

    public KRaftQuorumImplementation(ControllerServer controllerServer, FaultHandlerFactory faultHandlerFactory, File metadataDir, CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, String clusterId, Logging log, FaultHandler faultHandler) {
        this.controllerServer = controllerServer;
        this.faultHandlerFactory = faultHandlerFactory;
        this.metadataDir = metadataDir;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.clusterId = clusterId;
        this.log = log;
        this.faultHandler = faultHandler;
    }
}

