/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\u0005\u000b\u0001=A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\u0006\u0005\u0006E\u0001!\ta\t\u0005\u0006M\u0001!\ta\n\u0005\u0006!\u0002!\ta\n\u0005\u00061\u0002!Ia\n\u0005\u00063\u0002!IA\u0017\u0005\u0006o\u0002!I\u0001\u001f\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0005QQu.\u001b8He>,\bOU3rk\u0016\u001cH\u000fV3ti*\u00111\u0002D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0015%\u00111C\u0003\u0002 \u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014\u0015m]3SKF,Xm\u001d;UKN$\u0018aB2mkN$XM\u001d\t\u0003-\u0001j\u0011a\u0006\u0006\u00031e\tA\u0001^3ti*\u0011!dG\u0001\u0007G>lWn\u001c8\u000b\u00055a\"BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!I\f\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001\u0013&!\t\t\u0002\u0001C\u0003\u0015\u0005\u0001\u0007Q#A uKN$(j\\5o\u000fJ|W\u000f],ji\"|E\u000eZ\"p]N,X.\u001a:He>,\b\u000f\u0015:pi>\u001cw\u000e\\!oI:+wo\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0015\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012A!\u00168ji\"21aL\u001b7yu\u0002\"\u0001M\u001a\u000e\u0003ER!AM\f\u0002\u0007\u0005\u0004\u0018.\u0003\u00025c\tY1\t\\;ti\u0016\u0014H+Z:u\u0003\u0015!\u0018\u0010]3tY\u00059D%\u0001\u001d\n\u0005eR\u0014!B&S\u0003\u001a#&BA\u001e2\u0003\u0011!\u0016\u0010]3\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHf\u0001 I\u0017.*qHQ\"F\rB\u0011\u0001\u0007Q\u0005\u0003\u0003F\u0012Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013\u0001R\u0001\u001d_\u001a47/\u001a;t]Q|\u0007/[2/]Vlg\u0006]1si&$\u0018n\u001c8t\u0003\u00151\u0018\r\\;fC\u00059\u0015!A\u0019,\u000b}\u0012\u0015*\u0012$\"\u0003)\u000b\u0001e\u001c4gg\u0016$8O\f;pa&\u001cgF]3qY&\u001c\u0017\r^5p]:2\u0017m\u0019;pe.*qH\u0011'F\u001d\u0006\nQ*\u0001\u0011he>,\bOL5oSRL\u0017\r\u001c\u0018sK\n\fG.\u00198dK:\"W\r\\1z]5\u001c\u0018%A(\u0002\tE\u0002\u0004\u0007M\u0001@i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9XSRDw\n\u001c3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d)s_R|7m\u001c7B]\u0012|E\u000eZ$s_V\u00048i\\8sI&t\u0017\r^8sQ\u0011!q\u0006\u0010*-\tMs\u0004jS\u0016\u0006\u007f\t#VIV\u0011\u0002+\u0006arM]8va:\u001awn\u001c:eS:\fGo\u001c:/]\u0016<h&\u001a8bE2,\u0017%A,\u0002\u000b\u0019\fGn]3\u0002\u001bQ,7\u000f\u001e&pS:<%o\\;q\u0003U!Xm\u001d;GK:\u001cW\rZ*uCRL7m\u0012:pkB$Ra\u00174iUJ\u0004\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010+\u001b\u0005y&B\u00011\u000f\u0003\u0019a$o\\8u}%\u0011!MK\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002cU!)qM\u0002a\u00017\u0006qA.Z1eKJlU-\u001c2fe&#\u0007\"B5\u0007\u0001\u0004Y\u0016\u0001\u00054pY2|w/\u001a:NK6\u0014WM]%e\u0011\u0015Yg\u00011\u0001m\u0003!iW\r^1eCR\f\u0007cA\u0015n_&\u0011aN\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003SAL!!\u001d\u0016\u0003\t\tKH/\u001a\u0005\u0006g\u001a\u0001\r\u0001^\u0001\bm\u0016\u00148/[8o!\tIS/\u0003\u0002wU\t\u0019\u0011J\u001c;\u0002\u00139|'/\\1mSj,GCA=\u0000!\tQX0D\u0001|\u0015\ta\u0018$A\u0004nKN\u001c\u0018mZ3\n\u0005y\\(!\u0006&pS:<%o\\;q%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0007\u0003\u00039\u0001\u0019A=\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0002CY,'/\u001b4z\u0015>Lgn\u0012:pkB\u0014Vm\u001d9p]N,G)\u0019;b\u000bF,\u0018\r\\:\u0015\u000b!\n9!a\u0003\t\r\u0005%\u0001\u00021\u0001z\u0003!)\u0007\u0010]3di\u0016$\u0007BBA\u0007\u0011\u0001\u0007\u00110\u0001\u0004bGR,\u0018\r\u001c")
public class JoinGroupRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
    public void testJoinGroupWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testJoinGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
    public void testJoinGroupWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testJoinGroup();
    }

    private void testJoinGroup() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.JOIN_GROUP.oldestVersion()), (int)ApiKeys.JOIN_GROUP.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            byte[] metadata = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
            short x$3 = (short)version;
            String x$4 = this.sendJoinRequest$default$2();
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            JoinGroupResponseData joinLeaderResponseData = this.sendJoinRequest("grp", x$4, x$5, x$6, x$7, metadata, x$3);
            String leaderMemberId = joinLeaderResponseData.memberId();
            if (version >= 4) {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.MEMBER_ID_REQUIRED.code()).setMemberId(leaderMemberId).setProtocolName(version >= 7 ? null : ""), joinLeaderResponseData);
            } else {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setLeader(leaderMemberId).setMemberId(leaderMemberId).setProtocolName("consumer-range").setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), joinLeaderResponseData);
            }
            if (version >= 4) {
                short x$11 = (short)version;
                String x$12 = this.sendJoinRequest$default$3();
                String x$13 = this.sendJoinRequest$default$4();
                String x$14 = this.sendJoinRequest$default$5();
                JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest("grp", leaderMemberId, x$12, x$13, x$14, metadata, x$11);
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setMemberId(leaderMemberId).setProtocolName("consumer-range").setProtocolType(version >= 7 ? "consumer" : null).setLeader(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), rejoinLeaderResponseData);
            }
            .colon.colon x$18 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment(new byte[]{1}), (List)Nil$.MODULE$);
            byte[] x$19 = new byte[]{1};
            String x$20 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$21 = this.verifySyncGroupWithOldProtocol$default$5();
            String x$22 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$23 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$24 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$25 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", leaderMemberId, 1, x$20, x$21, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$18, x$22, x$23, x$19, x$24, x$25);
            short x$28 = (short)version;
            String x$29 = this.sendJoinRequest$default$3();
            String x$30 = this.sendJoinRequest$default$4();
            String x$31 = this.sendJoinRequest$default$5();
            byte[] x$32 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setMemberId("member-id-unknown").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest("grp", "member-id-unknown", x$29, x$30, x$31, x$32, x$28));
            short x$35 = (short)version;
            String x$36 = this.sendJoinRequest$default$2();
            String x$37 = this.sendJoinRequest$default$3();
            String x$38 = this.sendJoinRequest$default$5();
            byte[] x$39 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest("grp", x$36, x$37, "connect", x$38, x$39, x$35));
            ObjectRef joinFollowerResponseData = ObjectRef.create(null);
            if (version == 4) {
                short x$42 = (short)version;
                String x$43 = this.sendJoinRequest$default$2();
                String x$44 = this.sendJoinRequest$default$3();
                String x$45 = this.sendJoinRequest$default$4();
                String x$46 = this.sendJoinRequest$default$5();
                joinFollowerResponseData.elem = this.sendJoinRequest("grp", x$43, x$44, x$45, x$46, metadata, x$42);
            }
            Future joinFollowerFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                String x$48 = version != 4 ? "" : ((JoinGroupResponseData)joinFollowerResponseData$1.elem).memberId();
                String x$49 = version >= 5 ? "group-instance-id" : null;
                short x$51 = (short)version;
                String x$52 = this.sendJoinRequest$default$4();
                String x$53 = this.sendJoinRequest$default$5();
                return this.sendJoinRequest("grp", x$48, x$49, x$52, x$53, metadata, x$51);
            }, ExecutionContext.Implicits$.MODULE$.global());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!JoinGroupRequestTest.$anonfun$testJoinGroup$3(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"The group is not in PREPARING_REBALANCE state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            short x$57 = (short)version;
            String x$58 = this.sendJoinRequest$default$3();
            String x$59 = this.sendJoinRequest$default$4();
            String x$60 = this.sendJoinRequest$default$5();
            JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest("grp", leaderMemberId, x$58, x$59, x$60, metadata, x$57);
            JoinGroupResponseData joinFollowerFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)joinFollowerFuture, (Duration)Duration$.MODULE$.Inf());
            String followerMemberId = joinFollowerFutureResponseData.memberId();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), joinFollowerFutureResponseData);
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(followerMemberId).setGroupInstanceId(version >= 5 ? "group-instance-id" : null).setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderResponseData);
            int x$63 = rejoinLeaderResponseData.generationId();
            .colon.colon x$64 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment(new byte[]{1}), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerMemberId).setAssignment(new byte[]{2}), (List)Nil$.MODULE$));
            byte[] x$65 = new byte[]{1};
            String x$66 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$67 = this.verifySyncGroupWithOldProtocol$default$5();
            String x$68 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$69 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$70 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$71 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", leaderMemberId, x$63, x$66, x$67, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$64, x$68, x$69, x$65, x$70, x$71);
            int x$74 = joinFollowerFutureResponseData.generationId();
            byte[] x$75 = new byte[]{2};
            String x$76 = this.verifySyncGroupWithOldProtocol$default$4();
            String x$77 = this.verifySyncGroupWithOldProtocol$default$5();
            List<SyncGroupRequestData.SyncGroupRequestAssignment> x$78 = this.verifySyncGroupWithOldProtocol$default$6();
            String x$79 = this.verifySyncGroupWithOldProtocol$default$7();
            String x$80 = this.verifySyncGroupWithOldProtocol$default$8();
            Errors x$81 = this.verifySyncGroupWithOldProtocol$default$10();
            short x$82 = this.verifySyncGroupWithOldProtocol$default$11();
            this.verifySyncGroupWithOldProtocol("grp", followerMemberId, x$74, x$76, x$77, x$78, x$79, x$80, x$75, x$81, x$82);
            String x$84 = version >= 5 ? "group-instance-id" : null;
            short x$87 = (short)version;
            String x$88 = this.sendJoinRequest$default$4();
            String x$89 = this.sendJoinRequest$default$5();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), this.sendJoinRequest("grp", followerMemberId, x$84, x$88, x$89, metadata, x$87));
            if (version >= 5) {
                followerMemberId = this.testFencedStaticGroup(leaderMemberId, followerMemberId, metadata, version);
            }
            this.leaveGroup("grp", leaderMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp", followerMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.deleteGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), (List<Errors>)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
        });
    }

    /*
     * WARNING - void declaration
     */
    private String testFencedStaticGroup(String leaderMemberId, String followerMemberId, byte[] metadata, int version) {
        Future rejoinLeaderFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            short x$4 = (short)version;
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            return this.sendJoinRequest("grp", leaderMemberId, x$5, x$6, x$7, metadata, x$4);
        }, ExecutionContext.Implicits$.MODULE$.global());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group is not in PREPARING_REBALANCE state.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        short x$11 = (short)version;
        String x$12 = this.sendJoinRequest$default$2();
        String x$13 = this.sendJoinRequest$default$4();
        String x$14 = this.sendJoinRequest$default$5();
        JoinGroupResponseData joinNewFollowerResponseData = this.sendJoinRequest("grp", x$12, "group-instance-id", x$13, x$14, metadata, x$11);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group is not in COMPLETING_REBALANCE state.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        short x$19 = (short)version;
        String x$20 = this.sendJoinRequest$default$4();
        String x$21 = this.sendJoinRequest$default$5();
        JoinGroupResponseData rejoinFollowerResponseData = this.sendJoinRequest("grp", followerMemberId, "group-instance-id", x$20, x$21, metadata, x$19);
        JoinGroupResponseData rejoinLeaderFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)rejoinLeaderFuture, (Duration)Duration$.MODULE$.Inf());
        String newFollowerMemberId = joinNewFollowerResponseData.memberId();
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(newFollowerMemberId).setGroupInstanceId("group-instance-id").setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderFutureResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(newFollowerMemberId), joinNewFollowerResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setProtocolName(version >= 7 ? null : "").setMemberId(followerMemberId).setErrorCode(Errors.FENCED_INSTANCE_ID.code()), rejoinFollowerResponseData);
        return newFollowerMemberId;
    }

    private JoinGroupResponseData normalize(JoinGroupResponseData responseData) {
        JoinGroupResponseData newResponseData = responseData.duplicate();
        Collections.sort(newResponseData.members(), (m1, m2) -> m1.memberId().compareTo(m2.memberId()));
        return newResponseData;
    }

    private void verifyJoinGroupResponseDataEquals(JoinGroupResponseData expected, JoinGroupResponseData actual) {
        Assertions.assertEquals((Object)this.normalize(expected), (Object)this.normalize(actual));
    }

    public static final /* synthetic */ boolean $anonfun$testJoinGroup$3(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testJoinGroup$4() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$2(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$3() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$4(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.COMPLETING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$5() {
        return "The group is not in COMPLETING_REBALANCE state.";
    }

    public JoinGroupRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

