/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0005\u000b\u0001=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0005BaAQ!\u000b\u0001\u0005B)BQ!\u0010\u0001\u0005\u0002yBQA\u0018\u0001\u0005\u0002}CQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001b\u0001\u0005\n1D\u0011\"!\u0005\u0001#\u0003%I!a\u0005\u00035\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$Vm\u001d;\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0006\n\u0005MQ!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u00051\u0002CA\t\u0001\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA!\u001e;jY*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00033-BQ\u0001L\u0002A\u00025\n\u0001\u0002^3ti&sgm\u001c\t\u0003]]j\u0011a\f\u0006\u0003aE\n1!\u00199j\u0015\t\u00114'A\u0004kkBLG/\u001a:\u000b\u0005Q*\u0014!\u00026v]&$(\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029_\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0004uA\u0011afO\u0005\u0003y=\u0012!BQ3g_J,W)Y2i\u0003y\"Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u\u0013:\u001cG.\u001e3j]\u001e\u001cE.^:uKJ\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8ogR\u0011\u0011d\u0010\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\u0007cV|'/^7\u0011\u0005\tKeBA\"H!\t!5$D\u0001F\u0015\t1e\"\u0001\u0004=e>|GOP\u0005\u0003\u0011n\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001j\u0007\u0015\u0003\t5\u0003\"AT)\u000e\u0003=S!\u0001U\u0019\u0002\rA\f'/Y7t\u0013\t\u0011vJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001\u0002+[7B\u0011Q\u000bW\u0007\u0002-*\u0011qkT\u0001\taJ|g/\u001b3fe&\u0011\u0011L\u0016\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003q\u000b\u0013!X\u0001\u0006WJ\fg\r^\u0001?i\u0016\u001cH\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f^#yG2,H-\u001b8h\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0016$w\n]3sCRLwN\\:\u0015\u0005e\u0001\u0007\"\u0002!\u0006\u0001\u0004\t\u0005FA\u0003NQ\u0011)AKW2-\u0003q\u000b!\u0004^3ti\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$\"!\u00074\t\u000b\u001d4\u0001\u0019\u00015\u0002E%t7\r\\;eK\u000ecWo\u001d;fe\u0006+H\u000f[8sSj,Gm\u00149fe\u0006$\u0018n\u001c8t!\tQ\u0012.\u0003\u0002k7\t9!i\\8mK\u0006t\u0017AG:f]R$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$HcA7y{B\u0011aN^\u0007\u0002_*\u0011\u0001/]\u0001\te\u0016\fX/Z:ug*\u0011!o]\u0001\u0007G>lWn\u001c8\u000b\u00055!(BA;6\u0003\u0019\t\u0007/Y2iK&\u0011qo\u001c\u0002\u0018\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+7\u000f]8og\u0016DQ!_\u0004A\u0002i\fqA]3rk\u0016\u001cH\u000f\u0005\u0002ow&\u0011Ap\u001c\u0002\u0017\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3ti\"9ap\u0002I\u0001\u0002\u0004y\u0018a\u00033fgRLg.\u0019;j_:\u0004RAGA\u0001\u0003\u000bI1!a\u0001\u001c\u0005\u0019y\u0005\u000f^5p]B!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f1\tqA\\3uo>\u00148.\u0003\u0003\u0002\u0010\u0005%!\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001J:f]R$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U!fA@\u0002\u0018-\u0012\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%)hn\u00195fG.,GMC\u0002\u0002$m\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9#!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty("offsets.topic.num.partitions", "1");
        properties.setProperty("default.replication.factor", "2");
        properties.setProperty("broker.rack", "rack/" + properties.getProperty("broker.id"));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(true);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((IterableOnceOps)this.brokers().map((Function1 & Serializable)server -> new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).toSet();
        String expectedClusterId = ((KafkaBroker)this.brokers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((Set)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER)).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)x$1.code()))).asJava()) : Integer.MIN_VALUE;
        this.ensureConsistentKRaftMetadata();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, (Option<SocketServer>)None$.MODULE$);
            Assertions.assertTrue((boolean)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).contains(describeClusterResponse.data().controllerId()));
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeClusterResponse.data().brokers()).asScala().toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }
}

