/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003\u001f\u0011\u00199\u0003\u0001)A\u0005?!)\u0001\u0006\u0001C\u0001S!)!\u000b\u0001C\u0001'\")\u0001\f\u0001C\u00013\")a\f\u0001C\u0005?\")A\u000e\u0001C\u0005[\")\u0001\u0010\u0001C\u0005s\")\u0001\u0010\u0001C\u0005\u007f\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA!\u0001\u0011%\u00111\t\u0002\u0019\t\u0016dW\r^3SK\u000e|'\u000fZ:SKF,Xm\u001d;UKN$(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u0019\u001b\u0005\u0001\u0012BA\r\u0011\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001d!\t9\u0002!\u0001\u0006U\u00136+u*\u0016+`\u001bN+\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0004\u0013:$\u0018a\u0003+J\u001b\u0016{U\u000bV0N'\u0002\nq$T#T'\u0006;UiU0Q%>#UkQ#E?B+%k\u0018)B%RKE+S(O\u0003\u0001jUiU*B\u000f\u0016\u001bv\f\u0015*P\tV\u001bU\tR0Q\u000bJ{\u0006+\u0011*U\u0013RKuJ\u0014\u0011\u00025Q,7\u000f\u001e#fY\u0016$XMU3d_J$7\u000fS1qaf\u001c\u0015m]3\u0015\u0005)j\u0003C\u0001\u0011,\u0013\ta\u0013E\u0001\u0003V]&$\b\"\u0002\u0018\u0007\u0001\u0004y\u0013AB9v_J,X\u000e\u0005\u00021o9\u0011\u0011'\u000e\t\u0003e\u0005j\u0011a\r\u0006\u0003iQ\ta\u0001\u0010:p_Rt\u0014B\u0001\u001c\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\n\u0003F\u0001\u0004<!\taT)D\u0001>\u0015\tqt(\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u0001\u0006\u000bqA[;qSR,'O\u0003\u0002C\u0007\u0006)!.\u001e8ji*\tA)A\u0002pe\u001eL!AR\u001f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0007\u0011:{\u0005CA%M\u001b\u0005Q%BA&>\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA'K\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\n\u0001+I\u0001R\u0003\u0015Y'/\u00194u\u00035\"Xm\u001d;FeJ|'o\u00165f]\u0012+G.\u001a;j]\u001e\u0014VmY8sIN<\u0016\u000e\u001e5J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u000b\u0003UQCQAL\u0004A\u0002=B#aB\u001e)\t\u001dAej\u0016\u0017\u0002!\u0006aC/Z:u\u000bJ\u0014xN],iK:$U\r\\3uS:<'+Z2pe\u0012\u001cx+\u001b;i\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u000b\u0003UiCQA\f\u0005A\u0002=B#\u0001C\u001e)\t!Ae*\u0018\u0017\u0002!\u0006I2M]3bi\u0016$v\u000e]5d\u0003:$7+\u001a8e%\u0016\u001cwN\u001d3t+\u0005\u0001\u0007\u0003\u0002\u0011bG~I!AY\u0011\u0003\rQ+\b\u000f\\33!\t!'.D\u0001f\u0015\t1w-\u0001\u0004d_6lwN\u001c\u0006\u0003'!T!![\"\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tYWM\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002W\r\u0014X-\u0019;f\t\u0016dW\r^3SK\u000e|'\u000fZ:SKF,Xm\u001d;G_J$v\u000e]5d!\u0006\u0014H/\u001b;j_:$2A\u001c;w!\ty'/D\u0001q\u0015\t\tX-\u0001\u0005sKF,Xm\u001d;t\u0013\t\u0019\bO\u0001\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e\u0005\u0006k*\u0001\raY\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u00159(\u00021\u0001 \u00039ygMZ:fiR{G)\u001a7fi\u0016\f\u0001d]3oI\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\fX/Z:u)\tQX\u0010\u0005\u0002pw&\u0011A\u0010\u001d\u0002\u0016\t\u0016dW\r^3SK\u000e|'\u000fZ:SKN\u0004xN\\:f\u0011\u0015q8\u00021\u0001o\u0003\u001d\u0011X-];fgR$RA_A\u0001\u0003\u0007AQA \u0007A\u00029Da!!\u0002\r\u0001\u0004y\u0012\u0001\u00037fC\u0012,'/\u00133\u0002\u0017A\u0014x\u000eZ;dK\u0012\u000bG/\u0019\u000b\u0007\u0003\u0017\t9#!\u0010\u0011\r\u00055\u00111CA\f\u001b\t\tyAC\u0002\u0002\u0012\u0005\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0004\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0011A\u0014x\u000eZ;dKJT1!!\th\u0003\u001d\u0019G.[3oiNLA!!\n\u0002\u001c\tq!+Z2pe\u0012lU\r^1eCR\f\u0007bBA\u0015\u001b\u0001\u0007\u00111F\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB)\u0011QFA\u001cG:!\u0011qFA\u001a\u001d\r\u0011\u0014\u0011G\u0005\u0002E%\u0019\u0011QG\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011HA\u001e\u0005!IE/\u001a:bE2,'bAA\u001bC!1\u0011qH\u0007A\u0002}\tqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\u0002=Y\fG.\u001b3bi\u0016dunZ*uCJ$xJ\u001a4tKR4uN\u001d+pa&\u001cG#\u0002\u0016\u0002F\u0005\u001d\u0003\"B;\u000f\u0001\u0004\u0019\u0007bBA%\u001d\u0001\u0007\u00111J\u0001\u0014Kb\u0004Xm\u0019;fIN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004A\u00055\u0013bAA(C\t!Aj\u001c8h\u0001")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final int TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private int TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteRecordsHappyCase(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)("Unexpected lowWatermark received: " + partitionResult.lowWatermark()));
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidOffset(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, 0L);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidTopic(String quorum) {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)("Unexpected error code received: " + Errors.forCode((short)partitionResult.errorCode()).name()));
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs(this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        scala.collection.immutable.Seq sendfutureList = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable)tp -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex))))).map((Function1 & Serializable)x$1 -> producer.send(x$1));
        producer.flush();
        scala.collection.immutable.Seq recordMetadataList = (scala.collection.immutable.Seq)sendfutureList.map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
        recordMetadataList.foreach((Function1 & Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((IterableOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return qual$1.getLog(topicPartition, x$2);
        })).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((UnifiedLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = tp$1 + "-" + messageIndex;
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)("key " + suffix), (Object)("value " + suffix));
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)("Invalid offset " + recordMetadata));
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 1000;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

