/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import kafka.server.DelayedRemoteListOffsets;
import kafka.server.DelayedRemoteListOffsetsMetrics$;
import kafka.server.ListOffsetsPartitionStatus$;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;
import org.apache.kafka.server.purgatory.TopicPartitionOperationKey;
import org.apache.kafka.server.util.timer.MockTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.AsyncOffsetReadFutureHolder;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003B\u0002\u0014\u0001A\u0003%1\u0005C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\rY\u0002\u0001\u0015!\u0003*\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013IT\u0001B\u001f\u0001\u0001yBq\u0001\u0014\u0001C\u0002\u0013\u0005Q\n\u0003\u0004W\u0001\u0001\u0006IA\u0014\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006O\u0002!\t\u0001\u0017\u0005\u0006Y\u0002!\t\u0001\u0017\u0005\u0006]\u0002!\t\u0001\u0017\u0005\u0006a\u0002!\t\u0001\u0017\u0002\u001d\t\u0016d\u0017-_3e%\u0016lw\u000e^3MSN$xJ\u001a4tKR\u001cH+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011!E\u0001\bI\u0016d\u0017-_'t+\u0005\u0019\u0003C\u0001\r%\u0013\t)\u0013DA\u0002J]R\f\u0001\u0002Z3mCfl5\u000fI\u0001\u0006i&lWM]\u000b\u0002SA\u0011!\u0006N\u0007\u0002W)\u0011q\u0005\f\u0006\u0003[9\nA!\u001e;jY*\u0011!c\f\u0006\u0003)AR!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO&\u0011Qg\u000b\u0002\n\u001b>\u001c7\u000eV5nKJ\fa\u0001^5nKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002sA\u0011\u0001EO\u0005\u0003wE\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0005\u0005!\u0006CA J\u001d\t\u0001u)D\u0001B\u0015\t\u00115)A\u0002m_\u001eT!\u0001R#\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001$0\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001S!\u0002%=3gm]3u%\u0016\u001cX\u000f\u001c;I_2$WM]\u0005\u0003\u0015.\u0013!CR5mKJ+7m\u001c:eg>\u0013XI\u001d:pe*\u0011\u0001*Q\u0001\naV\u0014x-\u0019;pef,\u0012A\u0014\t\u0004\u001fF\u001bV\"\u0001)\u000b\u00051s\u0013B\u0001*Q\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0005\u0001\"\u0016BA+\u0012\u0005a!U\r\\1zK\u0012\u0014V-\\8uK2K7\u000f^(gMN,Go]\u0001\u000baV\u0014x-\u0019;pef\u0004\u0013!C1gi\u0016\u0014X)Y2i)\u0005I\u0006C\u0001\r[\u0013\tY\u0016D\u0001\u0003V]&$\bFA\u0006^!\tqV-D\u0001`\u0015\t\u0001\u0017-A\u0002ba&T!AY2\u0002\u000f),\b/\u001b;fe*\u0011AMM\u0001\u0006UVt\u0017\u000e^\u0005\u0003M~\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002?Q,7\u000f\u001e*fgB|gn]3P]J+\u0017/^3ti\u0016C\b/\u001b:bi&|g\u000e\u000b\u0002\rSB\u0011aL[\u0005\u0003W~\u0013A\u0001V3ti\u0006)B/Z:u%\u0016\u001c\bo\u001c8tK>s7+^2dKN\u001c\bFA\u0007j\u0003i!Xm\u001d;SKN\u0004xN\\:f\u001f:\u0004\u0016M\u001d;jC2,%O]8sQ\tq\u0011.A!uKN$\b+\u0019:uS\u0006d'+Z:q_:\u001cXm\u00165f]:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:Fq\u000e,\u0007\u000f^5p]>swJ\\3QCJ$\u0018\u000e^5p]\"\u0012q\"\u001b")
public class DelayedRemoteListOffsetsTest {
    private final int delayMs;
    private final MockTimer timer = new MockTimer();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final DelayedOperationPurgatory<DelayedRemoteListOffsets> purgatory = new DelayedOperationPurgatory("test-purgatory", (Timer)this.timer(), 0, 10, true, true);

    public int delayMs() {
        return this.delayMs;
    }

    public MockTimer timer() {
        return this.timer;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public DelayedOperationPurgatory<DelayedRemoteListOffsets> purgatory() {
        return this.purgatory;
    }

    @AfterEach
    public void afterEach() {
        this.purgatory().shutdown();
    }

    @Test
    public void testResponseOnRequestExpiration() {
        IntRef numResponse = IntRef.create((int)0);
        Function1 & Serializable responseCallback = (Function1 & Serializable)response -> {
            response.foreach((Function1 & Serializable)topic -> {
                DelayedRemoteListOffsetsTest.$anonfun$testResponseOnRequestExpiration$2(numResponse$1, topic);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        IntRef cancelledCount = IntRef.create((int)0);
        CompletableFuture jobFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AsyncOffsetReadFutureHolder holder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        Mockito.when((Object)holder.taskFuture()).thenAnswer(x$1 -> new CompletableFuture());
        Mockito.when((Object)holder.jobFuture()).thenReturn((Object)jobFuture);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)jobFuture.cancel(ArgumentMatchers.anyBoolean()))).thenAnswer(x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteListOffsetsTest.$anonfun$testResponseOnRequestExpiration$5(cancelledCount, x$2)));
        Object[] objectArray = new Tuple2[3];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        Map statusByPartition = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        DelayedRemoteListOffsets delayedRemoteListOffsets = new DelayedRemoteListOffsets((long)this.delayMs(), 5, statusByPartition, this.replicaManager(), (Function1)responseCallback);
        List listOffsetsRequestKeys = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)statusByPartition.keys().map((Function1 & Serializable)x$3 -> new TopicPartitionOperationKey(x$3))).toList()).asJava();
        Assertions.assertEquals((long)0L, (long)DelayedRemoteListOffsetsMetrics$.MODULE$.aggregateExpirationMeter().count());
        Assertions.assertEquals((int)0, (int)DelayedRemoteListOffsetsMetrics$.MODULE$.partitionExpirationMeters().size());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)delayedRemoteListOffsets, listOffsetsRequestKeys);
        Thread.sleep(100L);
        Assertions.assertEquals((int)3, (int)listOffsetsRequestKeys.size());
        Assertions.assertEquals((int)listOffsetsRequestKeys.size(), (int)cancelledCount.elem);
        Assertions.assertEquals((int)listOffsetsRequestKeys.size(), (int)numResponse.elem);
        Assertions.assertEquals((long)listOffsetsRequestKeys.size(), (long)DelayedRemoteListOffsetsMetrics$.MODULE$.aggregateExpirationMeter().count());
        listOffsetsRequestKeys.forEach(key -> {
            TopicPartition tp = new TopicPartition(key.topic, key.partition);
            Assertions.assertEquals((long)1L, (long)((Meter)DelayedRemoteListOffsetsMetrics$.MODULE$.partitionExpirationMeters().get((Object)tp)).count());
        });
    }

    @Test
    public void testResponseOnSuccess() {
        IntRef numResponse = IntRef.create((int)0);
        Function1 & Serializable responseCallback = (Function1 & Serializable)response -> {
            response.foreach((Function1 & Serializable)topic -> {
                DelayedRemoteListOffsetsTest.$anonfun$testResponseOnSuccess$2(numResponse$2, topic);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 100L, Optional.of(Predef$.MODULE$.int2Integer(50)));
        CompletableFuture<OffsetResultHolder.FileRecordsOrError> taskFuture = new CompletableFuture<OffsetResultHolder.FileRecordsOrError>();
        taskFuture.complete(new OffsetResultHolder.FileRecordsOrError(Optional.empty(), Optional.of(timestampAndOffset)));
        IntRef cancelledCount = IntRef.create((int)0);
        CompletableFuture jobFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AsyncOffsetReadFutureHolder holder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        Mockito.when((Object)holder.taskFuture()).thenAnswer(x$4 -> taskFuture);
        Mockito.when((Object)holder.jobFuture()).thenReturn((Object)jobFuture);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)jobFuture.cancel(ArgumentMatchers.anyBoolean()))).thenAnswer(x$5 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteListOffsetsTest.$anonfun$testResponseOnSuccess$5(cancelledCount, x$5)));
        Object[] objectArray = new Tuple2[3];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        Map statusByPartition = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        DelayedRemoteListOffsets delayedRemoteListOffsets = new DelayedRemoteListOffsets((long)this.delayMs(), 5, statusByPartition, this.replicaManager(), (Function1)responseCallback);
        List listOffsetsRequestKeys = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)statusByPartition.keys().map((Function1 & Serializable)x$6 -> new TopicPartitionOperationKey(x$6))).toList()).asJava();
        this.purgatory().tryCompleteElseWatch((DelayedOperation)delayedRemoteListOffsets, listOffsetsRequestKeys);
        Assertions.assertEquals((int)0, (int)cancelledCount.elem);
        Assertions.assertEquals((int)listOffsetsRequestKeys.size(), (int)numResponse.elem);
    }

    @Test
    public void testResponseOnPartialError() {
        IntRef numResponse = IntRef.create((int)0);
        Function1 & Serializable responseCallback = (Function1 & Serializable)response -> {
            response.foreach((Function1 & Serializable)topic -> {
                DelayedRemoteListOffsetsTest.$anonfun$testResponseOnPartialError$2(numResponse$3, topic);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 100L, Optional.of(Predef$.MODULE$.int2Integer(50)));
        CompletableFuture<OffsetResultHolder.FileRecordsOrError> taskFuture = new CompletableFuture<OffsetResultHolder.FileRecordsOrError>();
        taskFuture.complete(new OffsetResultHolder.FileRecordsOrError(Optional.empty(), Optional.of(timestampAndOffset)));
        IntRef cancelledCount = IntRef.create((int)0);
        CompletableFuture jobFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AsyncOffsetReadFutureHolder holder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        Mockito.when((Object)holder.taskFuture()).thenAnswer(x$7 -> taskFuture);
        Mockito.when((Object)holder.jobFuture()).thenReturn((Object)jobFuture);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)jobFuture.cancel(ArgumentMatchers.anyBoolean()))).thenAnswer(x$8 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteListOffsetsTest.$anonfun$testResponseOnPartialError$5(cancelledCount, x$8)));
        AsyncOffsetReadFutureHolder errorFutureHolder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        CompletableFuture<OffsetResultHolder.FileRecordsOrError> errorTaskFuture = new CompletableFuture<OffsetResultHolder.FileRecordsOrError>();
        errorTaskFuture.complete(new OffsetResultHolder.FileRecordsOrError(Optional.of(new TimeoutException("Timed out!")), Optional.empty()));
        Mockito.when((Object)errorFutureHolder.taskFuture()).thenAnswer(x$9 -> errorTaskFuture);
        Mockito.when((Object)errorFutureHolder.jobFuture()).thenReturn((Object)jobFuture);
        Object[] objectArray = new Tuple2[3];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(errorFutureHolder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        Map statusByPartition = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        DelayedRemoteListOffsets delayedRemoteListOffsets = new DelayedRemoteListOffsets((long)this.delayMs(), 5, statusByPartition, this.replicaManager(), (Function1)responseCallback);
        List listOffsetsRequestKeys = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)statusByPartition.keys().map((Function1 & Serializable)x$10 -> new TopicPartitionOperationKey(x$10))).toList()).asJava();
        this.purgatory().tryCompleteElseWatch((DelayedOperation)delayedRemoteListOffsets, listOffsetsRequestKeys);
        Assertions.assertEquals((int)0, (int)cancelledCount.elem);
        Assertions.assertEquals((int)listOffsetsRequestKeys.size(), (int)numResponse.elem);
    }

    @Test
    public void testPartialResponseWhenNotLeaderOrFollowerExceptionOnOnePartition() {
        IntRef numResponse = IntRef.create((int)0);
        Function1 & Serializable responseCallback = (Function1 & Serializable)response -> {
            response.foreach((Function1 & Serializable)topic -> {
                DelayedRemoteListOffsetsTest.$anonfun$testPartialResponseWhenNotLeaderOrFollowerExceptionOnOnePartition$2(numResponse$4, topic);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 100L, Optional.of(Predef$.MODULE$.int2Integer(50)));
        CompletableFuture<OffsetResultHolder.FileRecordsOrError> taskFuture = new CompletableFuture<OffsetResultHolder.FileRecordsOrError>();
        taskFuture.complete(new OffsetResultHolder.FileRecordsOrError(Optional.empty(), Optional.of(timestampAndOffset)));
        IntRef cancelledCount = IntRef.create((int)0);
        CompletableFuture jobFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AsyncOffsetReadFutureHolder holder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        Mockito.when((Object)holder.taskFuture()).thenAnswer(x$11 -> taskFuture);
        Mockito.when((Object)holder.jobFuture()).thenReturn((Object)jobFuture);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)jobFuture.cancel(ArgumentMatchers.anyBoolean()))).thenAnswer(x$12 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteListOffsetsTest.$anonfun$testPartialResponseWhenNotLeaderOrFollowerExceptionOnOnePartition$5(cancelledCount, x$12)));
        Mockito.when((Object)this.replicaManager().getPartitionOrException(new TopicPartition("test1", 0))).thenThrow(new Throwable[]{new NotLeaderOrFollowerException("Not leader or follower!")});
        AsyncOffsetReadFutureHolder errorFutureHolder = (AsyncOffsetReadFutureHolder)Mockito.mock(AsyncOffsetReadFutureHolder.class);
        CompletableFuture errorTaskFuture = new CompletableFuture();
        Mockito.when((Object)errorFutureHolder.taskFuture()).thenAnswer(x$13 -> errorTaskFuture);
        Mockito.when((Object)errorFutureHolder.jobFuture()).thenReturn((Object)jobFuture);
        Object[] objectArray = new Tuple2[4];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(errorFutureHolder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 1)), (Object)ListOffsetsPartitionStatus$.MODULE$.apply((Option)None$.MODULE$, Optional.of(holder), (Option)None$.MODULE$, (Option)None$.MODULE$));
        Map statusByPartition = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        DelayedRemoteListOffsets delayedRemoteListOffsets = new DelayedRemoteListOffsets((long)this.delayMs(), 5, statusByPartition, this.replicaManager(), (Function1)responseCallback);
        List listOffsetsRequestKeys = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)statusByPartition.keys().map((Function1 & Serializable)x$14 -> new TopicPartitionOperationKey(x$14))).toList()).asJava();
        this.purgatory().tryCompleteElseWatch((DelayedOperation)delayedRemoteListOffsets, listOffsetsRequestKeys);
        Assertions.assertEquals((int)1, (int)cancelledCount.elem);
        Assertions.assertEquals((int)listOffsetsRequestKeys.size(), (int)numResponse.elem);
    }

    public static final /* synthetic */ void $anonfun$testResponseOnRequestExpiration$2(IntRef numResponse$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        topic.partitions().forEach(partition -> {
            Assertions.assertEquals((short)Errors.REQUEST_TIMED_OUT.code(), (short)partition.errorCode());
            Assertions.assertEquals((long)-1L, (long)partition.timestamp());
            Assertions.assertEquals((long)-1L, (long)partition.offset());
            Assertions.assertEquals((int)-1, (int)partition.leaderEpoch());
            ++numResponse$1.elem;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testResponseOnRequestExpiration$5(IntRef cancelledCount$1, InvocationOnMock x$2) {
        ++cancelledCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testResponseOnSuccess$2(IntRef numResponse$2, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        topic.partitions().forEach(partition -> {
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partition.errorCode());
            Assertions.assertEquals((long)100L, (long)partition.timestamp());
            Assertions.assertEquals((long)100L, (long)partition.offset());
            Assertions.assertEquals((int)50, (int)partition.leaderEpoch());
            ++numResponse$2.elem;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testResponseOnSuccess$5(IntRef cancelledCount$2, InvocationOnMock x$5) {
        ++cancelledCount$2.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testResponseOnPartialError$2(IntRef numResponse$3, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        topic.partitions().forEach(partition -> {
            if (topic.name().equals("test1")) {
                Assertions.assertEquals((short)Errors.UNKNOWN_SERVER_ERROR.code(), (short)partition.errorCode());
                Assertions.assertEquals((long)-1L, (long)partition.timestamp());
                Assertions.assertEquals((long)-1L, (long)partition.offset());
                Assertions.assertEquals((int)-1, (int)partition.leaderEpoch());
            } else {
                Assertions.assertEquals((short)Errors.NONE.code(), (short)partition.errorCode());
                Assertions.assertEquals((long)100L, (long)partition.timestamp());
                Assertions.assertEquals((long)100L, (long)partition.offset());
                Assertions.assertEquals((int)50, (int)partition.leaderEpoch());
            }
            ++numResponse$3.elem;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testResponseOnPartialError$5(IntRef cancelledCount$3, InvocationOnMock x$8) {
        ++cancelledCount$3.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testPartialResponseWhenNotLeaderOrFollowerExceptionOnOnePartition$2(IntRef numResponse$4, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        topic.partitions().forEach(partition -> {
            if (topic.name().equals("test1") && partition.partitionIndex() == 0) {
                Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partition.errorCode());
                Assertions.assertEquals((long)-1L, (long)partition.timestamp());
                Assertions.assertEquals((long)-1L, (long)partition.offset());
                Assertions.assertEquals((int)-1, (int)partition.leaderEpoch());
            } else {
                Assertions.assertEquals((short)Errors.NONE.code(), (short)partition.errorCode());
                Assertions.assertEquals((long)100L, (long)partition.timestamp());
                Assertions.assertEquals((long)100L, (long)partition.offset());
                Assertions.assertEquals((int)50, (int)partition.leaderEpoch());
            }
            ++numResponse$4.elem;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testPartialResponseWhenNotLeaderOrFollowerExceptionOnOnePartition$5(IntRef cancelledCount$4, InvocationOnMock x$12) {
        ++cancelledCount$4.elem;
        return true;
    }

    public DelayedRemoteListOffsetsTest() {
        this.delayMs = 10;
    }
}

