/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQ!\f\u0001\u0005B9Bqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003E\u0011\u0019i\u0005\u0001)A\u0005\u000b\")a\n\u0001C\u0001\u001f\")a\u000e\u0001C\u0001_\")A\u000f\u0001C\u0005k\"I\u0011Q\u0004\u0001\u0012\u0002\u0013%\u0011q\u0004\u0005\b\u0003k\u0001A\u0011BA\u001c\u0005E\nE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;O_R\fU\u000f\u001e5pe&TX\r\u001a+fgRT!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u00039I!a\u0006\b\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005U\u0001\u0011a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\ti2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\b\"\u0002\u0013\u0003\u0001\u0004)\u0013A\u00039s_B,'\u000f^5fgB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#A\u0003)s_B,'\u000f^5fg\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u00020kA\u0019\u0001gM\u0013\u000e\u0003ER!AM\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00025c\t\u00191+Z9\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u0011Q,7\u000f^%oM>\u0004\"\u0001O!\u000e\u0003eR!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 @\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\t)\u0016\u001cH/\u00138g_\u0006)Qo]3scU\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002IS\u0005!A.\u00198h\u0013\tQuI\u0001\u0004TiJLgnZ\u0001\u0007kN,'/\r\u0011\u0002\u000bU\u001cXM\u001d\u001a\u0002\rU\u001cXM\u001d\u001a!\u0003u!Xm\u001d;BYR,'OT8uQ&twMT8u\u0003V$\bn\u001c:ju\u0016$GCA\u000fQ\u0011\u0015\t\u0006\u00021\u0001S\u0003\u0019\tXo\u001c:v[B\u00111K\u0017\b\u0003)b\u0003\"!V\u0010\u000e\u0003YS!a\u0016\n\u0002\rq\u0012xn\u001c;?\u0013\tIv$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015nS!!W\u0010)\u0005!i\u0006C\u00010b\u001b\u0005y&B\u00011<\u0003\u0019\u0001\u0018M]1ng&\u0011!m\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006\u0002\u0005eU.\u0004\"!\u001a5\u000e\u0003\u0019T!aZ0\u0002\u0011A\u0014xN^5eKJL!!\u001b4\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0005a\u0017%A7\u0002\u000b-\u0014\u0018M\u001a;\u0002?Q,7\u000f^!mi\u0016\u00148k\\7fi\"Lgn\u001a(pi\u0006+H\u000f[8sSj,G\r\u0006\u0002\u001ea\")\u0011+\u0003a\u0001%\"\u0012\u0011\"\u0018\u0015\u0005\u0013\u0011T7\u000fL\u0001m\u0003\u0011\u001aXM\u001c3BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$H#\u0002<\u0002\u0004\u00055\u0001CA<\u0000\u001b\u0005A(BA={\u0003!\u0011X-];fgR\u001c(BA>}\u0003\u0019\u0019w.\\7p]*\u0011\u0011# \u0006\u0003}~\na!\u00199bG\",\u0017bAA\u0001q\n\t\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\"9\u0011Q\u0001\u0006A\u0002\u0005\u001d\u0011a\u0002:fcV,7\u000f\u001e\t\u0004o\u0006%\u0011bAA\u0006q\n\u0001\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\u0011%\tyA\u0003I\u0001\u0002\u0004\t\t\"\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002E\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tY\"!\u0006\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002]M,g\u000eZ!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003CQC!!\u0005\u0002$-\u0012\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%)hn\u00195fG.,GMC\u0002\u00020}\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0011dQ\u0016\u001c7.\u00117m\u000bJ\u0014xN]:BYR,'/\u001b8h\u0007J,G-\u001a8uS\u0006d7\u000fF\u0004\u001e\u0003s\tI'!\u001f\t\u000f\u0005mB\u00021\u0001\u0002>\u0005q!/Z:vYR\u001cHk\\\"iK\u000e\\\u0007#\u0002\u0014\u0002@\u0005\r\u0013bAA!O\t!A*[:u!\u0011\t)%a\u0019\u000f\t\u0005\u001d\u0013Q\f\b\u0005\u0003\u0013\nIF\u0004\u0003\u0002L\u0005]c\u0002BA'\u0003+rA!a\u0014\u0002T9\u0019Q+!\u0015\n\u0003\u0001K!A` \n\u0005Ei\u0018BA>}\u0013\r\tYF_\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty&!\u0019\u0002K\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f'bAA.u&!\u0011QMA4\u0005}\tE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN,H\u000e\u001e\u0006\u0005\u0003?\n\t\u0007C\u0004\u0002l1\u0001\r!!\u001c\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:u\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002x\u0005E$AB#se>\u00148\u000f\u0003\u0004\u0002|1\u0001\rAU\u0001\u000bG>tG/\u001a=u\u001bN<\u0007")
public class AlterUserScramCredentialsRequestNotAuthorizedTest
extends BaseRequestTest {
    private final String user1;
    private final String user2;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("controlled.shutdown.enable", "false");
        properties.put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        properties.put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Properties)controllerConfigs.head()).put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Properties)controllerConfigs.head()).put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
        return controllerConfigs;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterNothingNotAuthorized(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAlterSomethingNotAuthorized(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.CLUSTER_AUTHORIZATION_FAILED, "when not authorized");
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestNotAuthorizedTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)("Expected all '" + expectedError.name() + "' errors when altering credentials " + contextMsg));
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public AlterUserScramCredentialsRequestNotAuthorizedTest() {
        this.user1 = "user1";
        this.user2 = "user2";
    }
}

