/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.server.AddPartitionsToTxnManager;
import kafka.server.AddPartitionsToTxnManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.TransactionSupportedOperation;
import kafka.server.addPartition$;
import kafka.server.defaultError$;
import kafka.server.genericErrorSupported$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015b\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004]\u0001\u0001\u0006I!\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019\u0011\u0007\u0001)A\u0005?\"91\r\u0001b\u0001\n\u0013!\u0007B\u0002<\u0001A\u0003%Q\rC\u0004x\u0001\t\u0007I\u0011\u0002=\t\u000f\u0005\r\u0001\u0001)A\u0005s\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0011-\ty\u0001\u0001a\u0001\u0002\u0004%I!!\u0005\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0002\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"!\r\u0001A\u0003%\u00111\u0005\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kA\u0001\"a\u0014\u0001A\u0003%\u0011q\u0007\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0017\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0018\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0019\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003CA\u0001\"a\u001a\u0001A\u0003%\u00111\u0005\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003CA\u0001\"a\u001b\u0001A\u0003%\u00111\u0005\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003CA\u0001\"a\u001c\u0001A\u0003%\u00111\u0005\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003gB\u0001\"a \u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003gB\u0001\"a!\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"a$\u0001A\u0003%\u0011\u0011\u0012\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"a%\u0001A\u0003%\u0011\u0011\u0012\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"a&\u0001A\u0003%\u0011\u0011\u0012\u0005\n\u00033\u0003!\u0019!C\u0005\u00037C\u0001\"a)\u0001A\u0003%\u0011Q\u0014\u0005\n\u0003K\u0003!\u0019!C\u0005\u0003OC\u0001\"a,\u0001A\u0003%\u0011\u0011\u0016\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\tY\r\u0001C\u0001\u0003gCq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!Q\b\u0001\u0005\u0002\u0005M\u0006b\u0002B$\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u0017\u0002A\u0011AAZ\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#BqA!\u001a\u0001\t\u0013\u00119\u0007C\u0005\u0003\u0016\u0002\t\n\u0011\"\u0003\u0003\u0018\"I!Q\u0016\u0001\u0012\u0002\u0013%!q\u0016\u0005\n\u0005g\u0003\u0011\u0013!C\u0005\u0005kCqA!/\u0001\t\u0013\u0011Y\fC\u0005\u0003z\u0002\t\n\u0011\"\u0003\u0003|\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0003\u0001\u0011%1q\u0001\u0002\u001e\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RCh.T1oC\u001e,'\u000fV3ti*\u0011\u0001)Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A \u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\u0005\t\u0006C\u0001*[\u001b\u0005\u0019&B\u0001+V\u0003\u001d\u0019G.[3oiNT!A\u0011,\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\u0005\u00037N\u0013QBT3uo>\u00148n\u00117jK:$\u0018A\u00048fi^|'o[\"mS\u0016tG\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003}\u0003\"A\u00141\n\u0005\u0005|$!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0016\u0003\u0015\u0004BA\u00124ig&\u0011qm\u0012\u0002\n\rVt7\r^5p]F\u0002\"!\u001b9\u000f\u0005)t\u0007CA6H\u001b\u0005a'BA7D\u0003\u0019a$o\\8u}%\u0011qnR\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p\u000fB\u0011a\t^\u0005\u0003k\u001e\u00131!\u00138u\u00035\u0001\u0018M\u001d;ji&|gNR8sA\u0005!A/[7f+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0015)H/\u001b7t\u0015\tqX+\u0001\u0004d_6lwN\\\u0005\u0004\u0003\u0003Y(\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u00023\u0005$G\rU1si&$\u0018n\u001c8t)>$\u0006P\\'b]\u0006<WM]\u000b\u0003\u0003\u0013\u00012ATA\u0006\u0013\r\tia\u0010\u0002\u001a\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RCh.T1oC\u001e,'/A\u000fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)btW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007\u0019\u000b)\"C\u0002\u0002\u0018\u001d\u0013A!\u00168ji\"I\u00111D\u0006\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\n\u0014AG1eIB\u000b'\u000f^5uS>t7\u000fV8Uq:l\u0015M\\1hKJ\u0004\u0013!\u0002;pa&\u001cWCAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-C\u0002r\u0003O\ta\u0001^8qS\u000e\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005]\u0002CBA\u001d\u0003\u0007\n9%\u0004\u0002\u0002<)!\u0011QHA \u0003%IW.\\;uC\ndWMC\u0002\u0002B\u001d\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)%a\u000f\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0013\nY%D\u0001~\u0013\r\ti% \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0003o_\u0012,\u0007'\u0006\u0002\u0002VA!\u0011\u0011JA,\u0013\r\tI& \u0002\u0005\u001d>$W-\u0001\u0004o_\u0012,\u0007\u0007I\u0001\u0006]>$W-M\u0001\u0007]>$W-\r\u0011\u0002\u000b9|G-\u001a\u001a\u0002\r9|G-\u001a\u001a!\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017'A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u001a\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%eg\u0005\tBO]1og\u0006\u001cG/[8oC2LEm\r\u0011\u0002\u0017A\u0014x\u000eZ;dKJLE-M\u000b\u0003\u0003k\u00022ARA<\u0013\r\tIh\u0012\u0002\u0005\u0019>tw-\u0001\u0007qe>$WoY3s\u0013\u0012\f\u0004%A\u0006qe>$WoY3s\u0013\u0012\u0014\u0014\u0001\u00049s_\u0012,8-\u001a:JIJ\u0002\u0013a\u00039s_\u0012,8-\u001a:JIN\nA\u0002\u001d:pIV\u001cWM]%eg\u0001\n1$Y;uQ\u0016tG/[2bi&|g.\u0012:s_J\u0014Vm\u001d9p]N,WCAAE!\r\u0011\u00161R\u0005\u0004\u0003\u001b\u001b&AD\"mS\u0016tGOU3ta>t7/Z\u0001\u001dCV$\b.\u001a8uS\u000e\fG/[8o\u000bJ\u0014xN\u001d*fgB|gn]3!\u0003]1XM]:j_:l\u0015n]7bi\u000eD'+Z:q_:\u001cX-\u0001\rwKJ\u001c\u0018n\u001c8NSNl\u0017\r^2i%\u0016\u001c\bo\u001c8tK\u0002\nA\u0003Z5tG>tg.Z2uK\u0012\u0014Vm\u001d9p]N,\u0017!\u00063jg\u000e|gN\\3di\u0016$'+Z:q_:\u001cX\rI\u0001\u001eiJ\fgn]1di&|gnU;qa>\u0014H/\u001a3Pa\u0016\u0014\u0018\r^5p]V\u0011\u0011Q\u0014\b\u0004\u001d\u0006}\u0015bAAQ\u007f\u0005)r-\u001a8fe&\u001cWI\u001d:peN+\b\u000f]8si\u0016$\u0017A\b;sC:\u001c\u0018m\u0019;j_:\u001cV\u000f\u001d9peR,Gm\u00149fe\u0006$\u0018n\u001c8!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011\u0011\u0016\t\u0004\u001d\u0006-\u0016bAAW\u007f\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nQa]3ukB$\"!a\u0005)\u00075\n9\f\u0005\u0003\u0002:\u0006\u001dWBAA^\u0015\u0011\ti,a0\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002B\u0006\r\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003\u000bD\u0016!\u00026v]&$\u0018\u0002BAe\u0003w\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007f\u0001\u0018\u0002PB!\u0011\u0011XAi\u0013\u0011\t\u0019.a/\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!C:fi\u0016\u0013(o\u001c:t)\u0011\tI.!=\u0015\t\u0005M\u00111\u001c\u0005\b\u0003;|\u0003\u0019AAp\u00039\u0019\u0017\r\u001c7cC\u000e\\WI\u001d:peN\u0004r![Aq\u0003\u000f\n)/C\u0002\u0002dJ\u00141!T1q!\u0011\t9/!<\u000e\u0005\u0005%(bAAv{\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002p\u0006%(AB#se>\u00148\u000fC\u0004\u0002t>\u0002\r!!>\u0002\r\u0015\u0014(o\u001c:t!!\t90!@\u0002H\u0005\u0015XBAA}\u0015\u0011\tY0a\u0010\u0002\u000f5,H/\u00192mK&!\u00111]A}\u00039!Xm\u001d;BI\u0012$\u0006P\u001c#bi\u0006$B!a\u0005\u0003\u0004!9!Q\u0001\u0019A\u0002\t\u001d\u0011AD5t\u0003\u0012$\u0007+\u0019:uSRLwN\u001c\t\u0004\r\n%\u0011b\u0001B\u0006\u000f\n9!i\\8mK\u0006t\u0007f\u0001\u0019\u0003\u0010A!!\u0011\u0003B\f\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\u0005}\u0016A\u00029be\u0006l7/\u0003\u0003\u0003\u001a\tM!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":\u0001G!\b\u0003*\t-\u0002\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\t\t\r\"1C\u0001\taJ|g/\u001b3fe&!!q\u0005B\u0011\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCA!\f\u00030e\t\u0011!G\u0001\u0001\u0003Q!Xm\u001d;HK:,'/\u0019;f%\u0016\fX/Z:ugR!\u00111\u0003B\u001b\u0011\u001d\u0011)!\ra\u0001\u0005\u000fA3!\rB\bQ\u001d\t$Q\u0004B\u0015\u0005waCA!\f\u00030\u0005!C/Z:u)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;peJ+7o\u001c7vi&|g\u000eK\u00023\u0005\u0003\u0002B!!/\u0003D%!!QIA^\u0005\u0011!Vm\u001d;\u0002UQ,7\u000f^!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:D\u0015M\u001c3mKJ,%O]8s\u0011\u0006tG\r\\5oO\"\u001a1G!\u0011\u0002IQ,7\u000f^!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:l\u0015M\\1hKJlU\r\u001e:jGND3\u0001\u000eB!\u0003qiwnY6Ue\u0006t7/Y2uS>t7\u000b^1uK6+G/\u00193bi\u0006$\u0002\"a\u0005\u0003T\t]#1\f\u0005\u0007\u0005+*\u0004\u0019A:\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fq\"1!\u0011L\u001bA\u0002M\f\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\b\u0005;*\u0004\u0019\u0001B0\u0003)aW-\u00193fe:{G-\u001a\t\u0006\r\n\u0005\u0014QK\u0005\u0004\u0005G:%AB(qi&|g.\u0001\bdY&,g\u000e\u001e*fgB|gn]3\u0015\u0015\u0005%%\u0011\u000eB=\u0005\u000f\u0013\t\nC\u0004\u0003lY\u0002\rA!\u001c\u0002\u0011I,7\u000f]8og\u0016\u0004BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0004\u0005gj\u0018\u0001\u0003:fcV,7\u000f^:\n\t\t]$\u0011\u000f\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016D\u0011Ba\u001f7!\u0003\u0005\rA! \u0002\u001b\u0005,H\u000f[#yG\u0016\u0004H/[8o!\u0011\u0011yHa!\u000e\u0005\t\u0005%bAAz{&!!Q\u0011BA\u0005]\tU\u000f\u001e5f]RL7-\u0019;j_:,\u0005pY3qi&|g\u000eC\u0005\u0003\nZ\u0002\n\u00111\u0001\u0003\f\u0006\tR.[:nCR\u001c\u0007.\u0012=dKB$\u0018n\u001c8\u0011\t\t}$QR\u0005\u0005\u0005\u001f\u0013\tIA\u000eV]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\u001c\u0005\n\u0005'3\u0004\u0013!a\u0001\u0005\u000f\tA\u0002Z5tG>tg.Z2uK\u0012\f\u0001d\u00197jK:$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IJ\u000b\u0003\u0003~\tm5F\u0001BO!\u0011\u0011yJ!+\u000e\u0005\t\u0005&\u0002\u0002BR\u0005K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dv)\u0001\u0006b]:|G/\u0019;j_:LAAa+\u0003\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\rd\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$3'\u0006\u0002\u00032*\"!1\u0012BN\u0003a\u0019G.[3oiJ+7\u000f]8og\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005oSCAa\u0002\u0003\u001c\u0006yAO]1og\u0006\u001cG/[8o\t\u0006$\u0018\r\u0006\u0006\u0003>\n\r(q\u001dBv\u0005k\u0004BAa0\u0003^:!!\u0011\u0019Bl\u001d\u0011\u0011\u0019Ma5\u000f\t\t\u0015'\u0011\u001b\b\u0005\u0005\u000f\u0014yM\u0004\u0003\u0003J\n5gbA6\u0003L&\t\u0011,\u0003\u0002X1&\u0011!IV\u0005\u0003}VK1A!6~\u0003\u001diWm]:bO\u0016LAA!7\u0003\\\u0006i\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u\t\u0006$\u0018MC\u0002\u0003VvLAAa8\u0003b\ni\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o)J\fgn]1di&|gN\u0003\u0003\u0003Z\nm\u0007B\u0002Bsu\u0001\u0007\u0001.A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0011\u001d\u0011IO\u000fa\u0001\u0003k\n!\u0002\u001d:pIV\u001cWM]%e\u0011%\u0011iO\u000fI\u0001\u0002\u0004\u0011y/A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004\r\nE\u0018b\u0001Bz\u000f\n)1\u000b[8si\"9!q\u001f\u001eA\u0002\t\u001d\u0011A\u0003<fe&4\u0017p\u00148ms\u0006IBO]1og\u0006\u001cG/[8o\t\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iP\u000b\u0003\u0003p\nm\u0015a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\t\u0005M11\u0001\u0005\b\u0005Wb\u0004\u0019AAE\u000351XM]5gsJ+\u0017/^3tiRa\u00111CB\u0005\u0007\u001b\u0019ya!\u0005\u0004\u0014!911B\u001fA\u0002\u0005U\u0013aE3ya\u0016\u001cG/\u001a3EKN$\u0018N\\1uS>t\u0007B\u0002Bs{\u0001\u0007\u0001\u000eC\u0004\u0003jv\u0002\r!!\u001e\t\u000f\t]X\b1\u0001\u0003\b!91QC\u001fA\u0002\r]\u0011!\u0005:fcV,7\u000f^!oI\"\u000bg\u000e\u001a7feB!1\u0011DB\u0011\u001b\t\u0019YB\u0003\u0003\u0004\u001e\r}\u0011\u0001B;uS2T!\u0001Q+\n\t\r\r21\u0004\u0002\u001c%\u0016\fX/Z:u\u0003:$7i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:")
public class AddPartitionsToTxnManagerTest {
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final Function1<String, Object> partitionFor = (Function1)Mockito.mock(Function1.class);
    private final MockTime time = new MockTime();
    private AddPartitionsToTxnManager addPartitionsToTxnManager;
    private final String topic;
    private final List<TopicPartition> topicPartitions = new .colon.colon((Object)new TopicPartition(this.topic(), 1), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 2), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 3), (List)Nil$.MODULE$)));
    private final Node node0 = new Node(0, "host1", 0);
    private final Node node1 = new Node(1, "host2", 1);
    private final Node node2 = new Node(2, "host2", 2);
    private final String transactionalId1;
    private final String transactionalId2;
    private final String transactionalId3;
    private final long producerId1;
    private final long producerId2;
    private final long producerId3;
    private final ClientResponse authenticationErrorResponse;
    private final ClientResponse versionMismatchResponse;
    private final ClientResponse disconnectedResponse;
    private final genericErrorSupported$ transactionSupportedOperation;
    private final KafkaConfig config;

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Function1<String, Object> partitionFor() {
        return this.partitionFor;
    }

    private MockTime time() {
        return this.time;
    }

    private AddPartitionsToTxnManager addPartitionsToTxnManager() {
        return this.addPartitionsToTxnManager;
    }

    private void addPartitionsToTxnManager_$eq(AddPartitionsToTxnManager x$1) {
        this.addPartitionsToTxnManager = x$1;
    }

    private String topic() {
        return this.topic;
    }

    private List<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    private Node node0() {
        return this.node0;
    }

    private Node node1() {
        return this.node1;
    }

    private Node node2() {
        return this.node2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private String transactionalId3() {
        return this.transactionalId3;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private long producerId3() {
        return this.producerId3;
    }

    private ClientResponse authenticationErrorResponse() {
        return this.authenticationErrorResponse;
    }

    private ClientResponse versionMismatchResponse() {
        return this.versionMismatchResponse;
    }

    private ClientResponse disconnectedResponse() {
        return this.disconnectedResponse;
    }

    private genericErrorSupported$ transactionSupportedOperation() {
        return this.transactionSupportedOperation;
    }

    private KafkaConfig config() {
        return this.config;
    }

    @BeforeEach
    public void setup() {
        this.addPartitionsToTxnManager_$eq(new AddPartitionsToTxnManager(this.config(), this.networkClient(), this.metadataCache(), this.partitionFor(), (Time)this.time()));
    }

    @AfterEach
    public void teardown() {
        this.addPartitionsToTxnManager().shutdown();
    }

    private void setErrors(scala.collection.mutable.Map<TopicPartition, Errors> errors, scala.collection.immutable.Map<TopicPartition, Errors> callbackErrors) {
        callbackErrors.foreachEntry((Function2 & Serializable)(key, value) -> errors.put(key, value));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAddTxnData(boolean isAddPartition) {
        addPartition$ transactionSupportedOperation = isAddPartition ? addPartition$.MODULE$ : genericErrorSupported$.MODULE$;
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId1())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId2())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId3())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction3Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId3(), this.producerId3(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction3Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        scala.collection.mutable.Map transaction1RetryWithSameEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithNewerEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithOldEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithSameEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        Assertions.assertEquals((Object)this.topicPartitions().map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)Errors.NETWORK_EXCEPTION)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)transaction1Errors);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)1, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithNewerEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        scala.collection.immutable.Map expectedEpochErrors = this.topicPartitions().map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)Errors.INVALID_PRODUCER_EPOCH)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithSameEpochErrors);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithOldEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithOldEpochErrors);
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala().foreach((Function1 & Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testAddTxnData$9(this, isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGenerateRequests(boolean isAddPartition) {
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId1())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId2())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId3())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        this.mockTransactionStateMetadata(2, 2, (Option<Node>)new Some((Object)this.node2()));
        addPartition$ transactionSupportedOperation = isAddPartition ? addPartition$.MODULE$ : genericErrorSupported$.MODULE$;
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        Iterable requestsAndHandlers = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)2, (int)requestsAndHandlers.size());
        requestsAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$3(this, isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId3(), this.producerId3(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)transactionSupportedOperation);
        this.time().sleep(10L);
        Iterable requestsAndHandlers2 = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers2.size());
        requestsAndHandlers2.foreach((Function1 & Serializable)requestAndHandler -> {
            this.verifyRequest(this.node2(), this.transactionalId3(), this.producerId3(), !isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        ((RequestAndCompletionHandler)((IterableOps)requestsAndHandlers.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testGenerateRequests$7$adapted(kafka.server.AddPartitionsToTxnManagerTest org.apache.kafka.server.util.RequestAndCompletionHandler ), (Lorg/apache/kafka/server/util/RequestAndCompletionHandler;)Ljava/lang/Object;)((AddPartitionsToTxnManagerTest)this))).head()).handler.onComplete(this.authenticationErrorResponse());
        Iterable requestsAndHandlers3 = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers3.size());
        requestsAndHandlers3.foreach((Function1 & Serializable)requestAndHandler -> {
            this.verifyRequest(this.node1(), this.transactionalId2(), this.producerId2(), !isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTransactionCoordinatorResolution() {
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId1())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.metadataCache().getLeaderAndIsr("__transaction_state", 0)).thenReturn((Object)Option$.MODULE$.empty());
        this.checkError$1();
        this.mockTransactionStateMetadata(0, -1, (Option<Node>)Option$.MODULE$.empty());
        this.checkError$1();
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)Option$.MODULE$.empty());
        this.checkError$1();
    }

    @Test
    public void testAddPartitionsToTxnHandlerErrorHandling() {
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId1())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId2())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map expectedAuthErrors = this.topicPartitions().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)Errors.SASL_AUTHENTICATION_FAILED)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.authenticationErrorResponse());
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction2Errors);
        HashMap expectedVersionMismatchErrors = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.versionMismatchResponse());
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedDisconnectedErrors = this.topicPartitions().map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)Errors.NETWORK_EXCEPTION)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.disconnectedResponse());
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedTopLevelErrors = this.topicPartitions().map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), (Object)Errors.INVALID_TXN_STATE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AddPartitionsToTxnResponse topLevelErrorAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        boolean clientResponse_disconnected = false;
        ClientResponse topLevelErrorResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected, null, null, (AbstractResponse)topLevelErrorAddPartitionsResponse);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(topLevelErrorResponse);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map preConvertedTransaction1Errors = this.topicPartitions().map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), (Object)Errors.PRODUCER_FENCED)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransaction1Errors = this.topicPartitions().map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$9), (Object)Errors.INVALID_PRODUCER_EPOCH)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map preConvertedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Errors.NONE)}));
        scala.collection.immutable.Map expectedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE)}));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction1ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId1(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransaction1Errors).asJava());
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction2ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId2(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransaction2Errors).asJava());
        AddPartitionsToTxnResponse mixedErrorsAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)transaction1ErrorResponse, (List)new .colon.colon((Object)transaction2ErrorResponse, (List)Nil$.MODULE$)).iterator()).asJava())));
        boolean clientResponse_disconnected2 = false;
        ClientResponse mixedErrorsResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected2, null, null, (AbstractResponse)mixedErrorsAddPartitionsResponse);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedErrorsResponse);
        Assertions.assertEquals((Object)expectedTransaction1Errors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransaction2Errors, (Object)transaction2Errors);
        scala.collection.immutable.Map preConvertedTransactionAbortableErrorsTxn1 = this.topicPartitions().map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)Errors.TRANSACTION_ABORTABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map preConvertedTransactionAbortableErrorsTxn2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.TRANSACTION_ABORTABLE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Errors.NONE)}));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transactionAbortableErrorResponseTxn1 = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId1(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransactionAbortableErrorsTxn1).asJava());
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transactionAbortableErrorResponseTxn2 = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId2(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransactionAbortableErrorsTxn2).asJava());
        AddPartitionsToTxnResponse mixedErrorsAddPartitionsResponseAbortableError = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)transactionAbortableErrorResponseTxn1, (List)new .colon.colon((Object)transactionAbortableErrorResponseTxn2, (List)Nil$.MODULE$)).iterator()).asJava())));
        boolean clientResponse_disconnected3 = false;
        ClientResponse mixedAbortableErrorsResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected3, null, null, (AbstractResponse)mixedErrorsAddPartitionsResponseAbortableError);
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn1LowerVersion = this.topicPartitions().map((Function1 & Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$11), (Object)Errors.INVALID_TXN_STATE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn2LowerVersion = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE)}));
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn1HigherVersion = this.topicPartitions().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), (Object)Errors.TRANSACTION_ABORTABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn2HigherVersion = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.TRANSACTION_ABORTABLE)}));
        this.addTransactionsToVerifyRequestVersion$1((TransactionSupportedOperation)defaultError$.MODULE$, transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedAbortableErrorsResponse);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn1LowerVersion, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn2LowerVersion, (Object)transaction2Errors);
        this.addTransactionsToVerifyRequestVersion$1((TransactionSupportedOperation)genericErrorSupported$.MODULE$, transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedAbortableErrorsResponse);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn1HigherVersion, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn2HigherVersion, (Object)transaction2Errors);
    }

    @Test
    public void testAddPartitionsToTxnManagerMetrics() {
        long startTime = this.time().milliseconds();
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        LongRef maxVerificationTime = LongRef.create((long)0L);
        Meter mockVerificationFailureMeter = (Meter)Mockito.mock(Meter.class);
        Histogram mockVerificationTime = (Histogram)Mockito.mock(Histogram.class);
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId1())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)this.partitionFor().apply((Object)this.transactionalId2())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        mockVerificationTime.update(ArgumentMatchers.anyLong());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            long newTime = BoxesRunTime.unboxToLong((Object)invocation.getArgument(0));
            if (newTime > maxVerificationTime$1.elem) {
                maxVerificationTime$1.elem = newTime;
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        MockedConstruction mockMetricsGroupCtor = Mockito.mockConstruction(KafkaMetricsGroup.class, (mock, context) -> {
            Mockito.when((Object)mock.newMeter((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName()), ArgumentMatchers.anyString(), (TimeUnit)((Object)((Object)ArgumentMatchers.any(TimeUnit.class))))).thenReturn((Object)mockVerificationFailureMeter);
            Mockito.when((Object)mock.newHistogram((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName()))).thenReturn((Object)mockVerificationTime);
        });
        AddPartitionsToTxnManager addPartitionsManagerWithMockedMetrics = new AddPartitionsToTxnManager(this.config(), this.networkClient(), this.metadataCache(), this.partitionFor(), (Time)this.time());
        try {
            addPartitionsManagerWithMockedMetrics.addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
                this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
                return BoxedUnit.UNIT;
            }, (TransactionSupportedOperation)this.transactionSupportedOperation());
            addPartitionsManagerWithMockedMetrics.addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
                this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
                return BoxedUnit.UNIT;
            }, (TransactionSupportedOperation)this.transactionSupportedOperation());
            this.time().sleep(100L);
            Collection requestsAndHandlers = addPartitionsManagerWithMockedMetrics.generateRequests();
            IntRef requestsHandled = IntRef.create((int)0);
            requestsAndHandlers.forEach(requestAndCompletionHandler -> {
                this.time().sleep(100L);
                requestAndCompletionHandler.handler.onComplete(this.authenticationErrorResponse());
                ++requestsHandled$1.elem;
                ((Histogram)Mockito.verify((Object)mockVerificationTime, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).update(ArgumentMatchers.anyLong());
                Assertions.assertEquals((long)maxVerificationTime$1.elem, (long)(this.time().milliseconds() - startTime));
                ((Meter)Mockito.verify((Object)mockVerificationFailureMeter, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).mark(3L);
            });
            addPartitionsManagerWithMockedMetrics.shutdown();
            KafkaMetricsGroup mockMetricsGroup = (KafkaMetricsGroup)mockMetricsGroupCtor.constructed().get(0);
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newMeter((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName()), ArgumentMatchers.anyString(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newHistogram((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName()));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric(AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName());
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric(AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockMetricsGroup});
        }
        catch (Throwable throwable) {
            if (mockMetricsGroupCtor != null) {
                mockMetricsGroupCtor.close();
            }
            if (addPartitionsManagerWithMockedMetrics.isRunning()) {
                addPartitionsManagerWithMockedMetrics.shutdown();
            }
            throw throwable;
        }
        mockMetricsGroupCtor.close();
        if (addPartitionsManagerWithMockedMetrics.isRunning()) {
            addPartitionsManagerWithMockedMetrics.shutdown();
        }
    }

    private void mockTransactionStateMetadata(int partitionIndex, int leaderId, Option<Node> leaderNode) {
        Mockito.when((Object)this.metadataCache().getLeaderAndIsr("__transaction_state", partitionIndex)).thenReturn((Object)new Some((Object)new LeaderAndIsr(leaderId, Arrays.asList(Predef$.MODULE$.int2Integer(leaderId)))));
        if (leaderId != -1) {
            Mockito.when((Object)this.metadataCache().getAliveBrokerNode(leaderId, this.config().interBrokerListenerName())).thenReturn(leaderNode);
            return;
        }
    }

    private ClientResponse clientResponse(AbstractResponse response, AuthenticationException authException, UnsupportedVersionException mismatchException, boolean disconnected) {
        return new ClientResponse(null, null, null, 0L, 0L, disconnected, mismatchException, authException, response);
    }

    private AuthenticationException clientResponse$default$2() {
        return null;
    }

    private UnsupportedVersionException clientResponse$default$3() {
        return null;
    }

    private boolean clientResponse$default$4() {
        return false;
    }

    private AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction transactionData(String transactionalId, long producerId, short producerEpoch, boolean verifyOnly) {
        return new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setVerifyOnly(verifyOnly).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    private short transactionData$default$3() {
        return 0;
    }

    private void receiveResponse(ClientResponse response) {
        ((RequestAndCompletionHandler)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.addPartitionsToTxnManager().generateRequests()).asScala().head()).handler.onComplete(response);
    }

    private void verifyRequest(Node expectedDestination, String transactionalId, long producerId, boolean verifyOnly, RequestAndCompletionHandler requestAndHandler) {
        Assertions.assertEquals((long)this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
        Assertions.assertEquals((Object)expectedDestination, (Object)requestAndHandler.destination);
        short x$4 = 0;
        Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)CollectionConverters$.MODULE$.IteratorHasAsJava((Iterator)new .colon.colon((Object)this.transactionData((String)transactionalId, (long)producerId, (short)x$4, (boolean)verifyOnly), (List)Nil$.MODULE$).iterator()).asJava())).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
    }

    public static final /* synthetic */ void $anonfun$testAddTxnData$9(AddPartitionsToTxnManagerTest $this, boolean isAddPartition$1, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            Assertions.assertEquals((long)$this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
            String x$1 = $this.transactionalId3();
            long x$2 = $this.producerId3();
            boolean x$3 = !isAddPartition$1;
            short x$4 = 0;
            Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)CollectionConverters$.MODULE$.IteratorHasAsJava((Iterator)new .colon.colon((Object)$this.transactionData((String)x$1, (long)x$2, (short)x$4, (boolean)x$3), (List)new .colon.colon((Object)$this.transactionData((String)$this.transactionalId1(), (long)$this.producerId1(), (short)1, (boolean)(!isAddPartition$1 ? true : false)), (List)Nil$.MODULE$)).iterator()).asJava())).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), !isAddPartition$1, requestAndHandler);
    }

    public static final /* synthetic */ void $anonfun$testGenerateRequests$3(AddPartitionsToTxnManagerTest $this, boolean isAddPartition$2, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            $this.verifyRequest($this.node0(), $this.transactionalId1(), $this.producerId1(), !isAddPartition$2, requestAndHandler);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), !isAddPartition$2, requestAndHandler);
    }

    public static final /* synthetic */ boolean $anonfun$testGenerateRequests$7(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$4) {
        Node node = x$4.destination;
        Node node2 = $this.node1();
        return !(node != null ? !node.equals(node2) : node2 != null);
    }

    private final void checkError$1() {
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)this.transactionSupportedOperation());
        Assertions.assertEquals((Object)this.topicPartitions().map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Errors.COORDINATOR_NOT_AVAILABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)errors);
    }

    private final void addTransactionsToVerify$1(scala.collection.mutable.Map transaction1Errors$2, scala.collection.mutable.Map transaction2Errors$2) {
        transaction1Errors$2.clear();
        transaction2Errors$2.clear();
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)this.transactionSupportedOperation());
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, (TransactionSupportedOperation)this.transactionSupportedOperation());
    }

    private final void addTransactionsToVerifyRequestVersion$1(TransactionSupportedOperation operationExpected, scala.collection.mutable.Map transaction1Errors$2, scala.collection.mutable.Map transaction2Errors$2) {
        transaction1Errors$2.clear();
        transaction2Errors$2.clear();
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, operationExpected);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, this.topicPartitions(), (Function1 & Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        }, operationExpected);
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsToTxnManagerTest() {
        void clientResponse_disconnected;
        this.topic = "foo";
        this.transactionalId1 = "txn1";
        this.transactionalId2 = "txn2";
        this.transactionalId3 = "txn3";
        this.producerId1 = 0L;
        this.producerId2 = 1L;
        this.producerId3 = 2L;
        boolean bl = false;
        SaslAuthenticationException clientResponse_authException = new SaslAuthenticationException("");
        Object var3_2 = null;
        this.authenticationErrorResponse = new ClientResponse(null, null, null, 0L, 0L, (boolean)clientResponse_disconnected, null, (AuthenticationException)clientResponse_authException, null);
        UnsupportedVersionException x$2 = new UnsupportedVersionException("");
        boolean x$4 = false;
        this.versionMismatchResponse = new ClientResponse(null, null, null, 0L, 0L, x$4, x$2, null, null);
        boolean clientResponse_disconnected2 = true;
        this.disconnectedResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected2, null, null, null);
        this.transactionSupportedOperation = genericErrorSupported$.MODULE$;
        this.config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    }

    public static final /* synthetic */ Object $anonfun$testGenerateRequests$7$adapted(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$4) {
        return BoxesRunTime.boxToBoolean((boolean)AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$7($this, x$4));
    }
}

